This is Info file usegcc.i, produced by Makeinfo-1.50 from the input
file usegcc.texi.

START-INFO-DIR-ENTRY
* usegcc: (usegcc).			Using the GNU C compiler.
END-INFO-DIR-ENTRY

   This file documents the use of the GNU compiler.

   Copyright (C) 1988, 1989, 1992 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License" and "Boycott"
are included exactly as in the original, and provided that the entire
resulting derived work is distributed under the terms of a permission
notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License" and "Boycott", and this permission notice, may be included in
translations approved by the Free Software Foundation instead of in the
original English.


File: usegcc.i,  Node: Top,  Next: Contributors,  Prev: (DIR),  Up: (DIR)

Introduction
************

   This manual documents how to run and install the GNU C compiler, as
well as its new features and incompatibilities, and how to report bugs.
It corresponds to GNU CC version 2.2.

* Menu:

* Contributors::    People who have contributed to GNU CC.
* Invoking GCC::    Command options supported by `gcc'.
* Extensions::      GNU extensions to the C language.
* Trouble::         If you have trouble installing GNU CC.
* Bugs::            How, why and where to report bugs.
* Boycott::	    Protect your freedom--fight "look and feel".
* Index::	    Index of concepts and symbol names.


File: usegcc.i,  Node: Contributors,  Next: Invoking GCC,  Prev: Top,  Up: Top

Contributors to GNU CC
**********************

   In addition to Richard Stallman, several people have written parts
of GNU CC.

   * The idea of using RTL and some of the optimization ideas came from
     the program PO written at the University of Arizona by Jack
     Davidson and Christopher Fraser.  See "Register Allocation and
     Exhaustive Peephole Optimization", Software Practice and
     Experience 14 (9), Sept. 1984, 857-866.

   * Paul Rubin wrote most of the preprocessor.

   * Leonard Tower wrote parts of the parser, RTL generator, and RTL
     definitions, and of the Vax machine description.

   * Ted Lemon wrote parts of the RTL reader and printer.

   * Jim Wilson implemented loop strength reduction and some other loop
     optimizations.

   * Nobuyuki Hikichi of Software Research Associates, Tokyo,
     contributed the support for the Sony NEWS machine.

   * Charles LaBrec contributed the support for the Integrated Solutions
     68020 system.

   * Michael Tiemann of Cygnus Support wrote the support for inline
     functions and instruction scheduling.  Also the descriptions of
     the National Semiconductor 32000 series cpu, the SPARC cpu and
     part of the Motorola 88000 cpu.

   * Jan Stein of the Chalmers Computer Society provided support for
     Genix, as well as part of the 32000 machine description.

   * Randy Smith finished the Sun FPA support.

   * Robert Brown implemented the support for Encore 32000 systems.

   * David Kashtan of SRI adapted GNU CC to VMS.

   * Alex Crain provided changes for the 3b1.

   * Greg Satz and Chris Hanson assisted in making GNU CC work on HP-UX
     for the 9000 series 300.

   * William Schelter did most of the work on the Intel 80386 support.

   * Christopher Smith did the port for Convex machines.

   * Paul Petersen wrote the machine description for the Alliant FX/8.

   * Alain Lichnewsky ported GNU CC to the Mips cpu.

   * Devon Bowen, Dale Wiles and Kevin Zachmann ported GNU CC to the
     Tahoe.

   * Jonathan Stone wrote the machine description for the Pyramid
     computer.

   * Gary Miller ported GNU CC to Charles River Data Systems machines.

   * Richard Kenner of New York University wrote the machine
     descriptions for the AMD 29000, the IBM RT PC, and the IBM RS/6000
     as well as the support for instruction attributes.  He also made
     changes to better support RISC processors including changes to
     common subexpression elimination, strength reduction, function
     calling sequence handling, and condition code support, in addition
     to generalizing the code for frame pointer elimination.

   * Richard Kenner and Michael Tiemann jointly developed reorg.c, the
     delay slot scheduler.

   * Mike Meissner and Tom Wood of Data General finished the port to the
     Motorola 88000.

   * Masanobu Yuhara of Fujitsu Laboratories implemented the machine
     description for the Tron architecture (specifically, the Gmicro).

   * NeXT, Inc. donated the front end that supports the Objective C
     language.

   * James van Artsdalen wrote the code that makes efficient use of the
     Intel 80387 register stack.

   * Mike Meissner at the Open Software Foundation finished the port to
     the MIPS cpu, including adding ECOFF debug support.

   * Ron Guilmette implemented the protoize and unprotoize tools, the
     support for Dwarf symbolic debugging information, and much of the
     support for System V Release 4.  He has also worked heavily on the
     Intel 386 and 860 support.

   * Torbjorn Granlund of the Swedish Institute of Computer Science
     implemented multiply-by-constant optimization and better long long
     support, and improved leaf function register allocation.


File: usegcc.i,  Node: Invoking GCC,  Next: Extensions,  Prev: Contributors,  Up: Top

GNU CC Command Options
**********************

   When you invoke GNU CC, it normally does preprocessing, compilation,
assembly and linking.  The "overall options" allow you to stop this
process at an intermediate stage.  For example, the `-c' option says
not to run the linker.  Then the output consists of object files output
by the assembler.

   Other options are passed on to one stage of processing.  Some options
control the preprocessor and others the compiler itself.  Yet other
options control the assembler and linker; most of these are not
documented here, since you rarely need to use any of them.

   The `gcc' program accepts options and file names as operands.  Many
options have multiletter names; therefore multiple single-letter options
may *not* be grouped: `-dr' is very different from `-d -r'.

   You can mix options and other arguments.  For the most part, the
order you use doesn't matter.  Order does matter when you use several
options of the same kind; for example, if you specify `-L' more than
once, the directories are searched in the order specified.

   Many options have long names starting with `-f' or with `-W'--for
example, `-fforce-mem', `-fstrength-reduce', `-Wformat' and so on. 
Most of these have both positive and negative forms; the negative form
of `-ffoo' would be `-fno-foo'.  This manual documents only one of
these two forms, whichever one is not the default.

* Menu:

* Option Summary::	Brief list of all options, without explanations.
* Overall Options::     Controlling the kind of output:
                        an executable, object files, assembler files,
                        or preprocessed source.
* Dialect Options::     Controlling the variant of C language compiled.
* Warning Options::     How picky should the compiler be?
* Debugging Options::   Symbol tables, measurements, and debugging dumps.
* Optimize Options::    How much optimization?
* Preprocessor Options:: Controlling header files and macro definitions.
                         Also, getting dependency information for Make.
* Link Options::        Specifying libraries and so on.
* Directory Options::   Where to find header files and libraries.
                        Where to find the compiler executable files.
* Compiler Version::	Running an old version of GNU CC
* Code Gen Options::    Specifying conventions for function calls, data layout
                        and register usage.
* Environment Variables:: Env vars that affect GNU CC.


File: usegcc.i,  Node: Option Summary,  Next: Overall Options,  Up: Invoking GCC

Option Summary
==============

   Here is a summary of all the options, grouped by type.  Explanations
are in the following sections.

*Overall Options*
     *Note Options Controlling the Kind of Output: Overall Options.
          -c  -S  -E  -o FILE  -pipe  -v  -x LANGUAGE

*Language Options*
     *Note Options Controlling Dialect: Dialect Options.
          -ansi  -fcond-mismatch  -fno-asm  -fno-builtin
          -fsigned-bitfields  -fsigned-char
          -funsigned-bitfields  -funsigned-char
          -fwritable-strings  -traditional
          -traditional-cpp  -trigraphs

*Warning Options*
     *Note Options to Request or Suppress Warnings: Warning Options.
          -fsyntax-only  -pedantic  -pedantic-errors
          -w  -W  -Wall  -Waggregate-return
          -Wcast-align  -Wcast-qual  -Wcomment  -Wconversion
          -Werror  -Wformat  -Wid-clash-LEN  -Wimplicit
          -Wimport  -Winline -Wmissing-prototypes
          -Wnested-externs  -Wparentheses  -Wpointer-arith
          -Wredundant-decls  -Wreturn-type  -Wshadow
          -Wstrict-prototypes  -Wswitch  -Wtraditional
          -Wtrigraphs  -Wuninitialized  -Wunused
          -Wwrite-strings  -Wchar-subscripts

*Debugging Options*
     *Note Options for Debugging Your Program or GCC: Debugging Options.
          -dLETTERS  -fpretend-float
          -g  -gLEVEL  -save-temps

*Optimization Options*
     *Note Options that Control Optimization: Optimize Options.
          -fcaller-saves  -fcse-follow-jumps  -fcse-skip-blocks
          -fdelayed-branch   -fexpensive-optimizations
          -ffast-math  -ffloat-store  -fforce-addr
          -fforce-mem  -finline-functions
          -fkeep-inline-functions  -fno-defer-pop
          -fno-function-cse  -fno-inline  -fno-peephole
          -fomit-frame-pointer  -frerun-cse-after-loop
          -fschedule-insns  -fschedule-insns2
          -fstrength-reduce  -fthread-jumps
          -funroll-all-loops  -funroll-loops
          -O  -O2

*Preprocessor Options*
     *Note Options Controlling the Preprocessor: Preprocessor Options.
          -AASSERTION  -C  -dD  -dM  -dN
          -DMACRO[=DEFN]  -E  -H
          -include FILE  -imacros FILE
          -M  -MD  -MM  -MMD  -nostdinc
          -P  -trigraphs  -UMACRO  -undef

*Linker Options*
     *Note Options for Linking: Link Options.
          OBJECT-FILE-NAME
          -lLIBRARY  -nostdlib
          -static  -shared  -symbolic
          -Xlinker OPTION
          -u SYMBOL

*Directory Options*
     *Note Options for Directory Search: Directory Options.
          -BPREFIX  -IDIR  -I-  -LDIR

*Compiler Version*
     *Note Specifying Compiler Version: Compiler Version.
          -V VERSION

*Code Generation Options*
     *Note Options for Code Generation Conventions: Code Gen Options.
          -fcall-saved-REG  -fcall-used-REG  -ffixed-REG
          -finhibit-size-directive  -fno-common
          -fno-ident  -fpic
          -fshared-data  -fshort-enums  -fshort-double
          -fvolatile  -fverbose-asm


File: usegcc.i,  Node: Overall Options,  Next: Dialect Options,  Prev: Option Summary,  Up: Invoking GCC

Options Controlling the Kind of Output
======================================

   Compilation can involve up to four stages: preprocessing, compilation
proper, assembly and linking, always in that order.  The first three
stages apply to an individual source file, and end by producing an
object file; linking combines all the object files (those newly
compiled, and those specified as input) into an executable file.

   For any given input file, the file name suffix determines what kind
of compilation is done:

`FILE.c'
     C source code which must be preprocessed.

`FILE.i'
     C source code which should not be preprocessed.

`FILE.h'
     C header file (not to be compiled or linked).

`FILE.s'
     Assembler code.

`FILE.S'
     Assembler code which must be preprocessed.

`OTHER'
     An object file to be fed straight into linking. Any file name with
     no recognized suffix is treated this way.

   You can specify the input language explicitly with the `-x' option:

`-x LANGUAGE'
     Specify explicitly the LANGUAGE for the following input files
     (rather than choosing a default based on the file name suffix).
     This option applies to all following input files until the next
     `-x' option.  Possible values of LANGUAGE are `c', `c-header',
     `cpp-output', `assembler', and `assembler-with-cpp'.

`-x none'
     Turn off any specification of a language, so that subsequent files
     are handled according to their file name suffixes (as they are if
     `-x' has not been used at all).

   If you only want some of the stages of compilation, you can use `-x'
(or filename suffixes) to tell `gcc' where to start, and one of the
options `-c', `-S', or `-E' to say where `gcc' is to stop.  Note that
some combinations (for example, `-x cpp-output -E' instruct `gcc' to do
nothing at all.

`-c'
     Compile or assemble the source files, but do not link.  The linking
     stage simply is not done.  The ultimate output is in the form of an
     object file for each source file.

     By default, the object file name for a source file is made by
     replacing the suffix `.c', `.i', `.s', etc., with `.o'.

     Unrecognized input files, not requiring compilation or assembly,
     are ignored.

`-S'
     Stop after the stage of compilation proper; do not assemble.  The
     output is in the form of an assembler code file for each
     non-assembler input file specified.

     By default, the assembler file name for a source file is made by
     replacing the suffix `.c', `.i', etc., with `.s'.

     Input files that don't require compilation are ignored.

`-E'
     Stop after the preprocessing stage; do not run the compiler
     proper.  The output is in the form of preprocessed source code,
     which is sent to the standard output.

     Input files which don't require preprocessing are ignored.

`-o FILE'
     Place output in file FILE.  This applies regardless of whatever
     sort of output is being produced, whether it be an executable file,
     an object file, an assembler file or preprocessed C code.

     Since only one output file can be specified, it does not make
     sense to use `-o' when compiling more than one input file, unless
     you are producing an executable file as output.

     If `-o' is not specified, the default is to put an executable file
     in `a.out', the object file for `SOURCE.SUFFIX' in `SOURCE.o', its
     assembler file in `SOURCE.s', and all preprocessed C source on
     standard output.

`-v'
     Print (on standard error output) the commands executed to run the
     stages of compilation.  Also print the version number of the
     compiler driver program and of the preprocessor and the compiler
     proper.

`-pipe'
     Use pipes rather than temporary files for communication between the
     various stages of compilation.  This fails to work on some systems
     where the assembler is unable to read from a pipe; but the GNU
     assembler has no trouble.


File: usegcc.i,  Node: Dialect Options,  Next: Warning Options,  Prev: Overall Options,  Up: Invoking GCC

Options Controlling Dialect
===========================

   The following options control the dialect of C that the compiler
accepts:

`-ansi'
     Support all ANSI standard C programs.

     This turns off certain features of GNU C that are incompatible
     with ANSI C, such as the `asm', `inline' and `typeof' keywords, and
     predefined macros such as `unix' and `vax' that identify the type
     of system you are using.  It also enables the undesirable and
     rarely used ANSI trigraph feature, and disallows `$' as part of
     identifiers.

     The alternate keywords `__asm__', `__extension__', `__inline__'
     and `__typeof__' continue to work despite `-ansi'.  You would not
     want to use them in an ANSI C program, of course, but it useful to
     put them in header files that might be included in compilations
     done with `-ansi'.  Alternate predefined macros such as `__unix__'
     and `__vax__' are also available, with or without `-ansi'.

     The `-ansi' option does not cause non-ANSI programs to be rejected
     gratuitously.  For that, `-pedantic' is required in addition to
     `-ansi'.  *Note Warning Options::.

     The macro `__STRICT_ANSI__' is predefined when the `-ansi' option
     is used.  Some header files may notice this macro and refrain from
     declaring certain functions or defining certain macros that the
     ANSI standard doesn't call for; this is to avoid interfering with
     any programs that might use these names for other things.

     The functions `alloca', `abort', `exit', and `_exit' are not
     builtin functions when `-ansi' is used.

`-fno-asm'
     Do not recognize `asm', `inline' or `typeof' as a keyword.  These
     words may then be used as identifiers.  You can use `__asm__',
     `__inline__' and `__typeof__' instead. `-ansi' implies `-fno-asm'.

`-fno-builtin'
     Don't recognize built-in functions that do not begin with two
     leading underscores. Currently, the functions affected include
     `_exit', `abort', `abs', `alloca', `cos', `exit', `fabs', `labs',
     `memcmp', `memcpy', `sin', `sqrt', `strcmp', `strcpy', and
     `strlen'.

     The `-ansi' option prevents `alloca' and `_exit' from being
     builtin functions.

`-trigraphs'
     Support ANSI C trigraphs.  You don't want to know about this
     brain-damage.  The `-ansi' option implies `-trigraphs'.

`-traditional'
     Attempt to support some aspects of traditional C compilers.
     Specifically:

        * All `extern' declarations take effect globally even if they
          are written inside of a function definition.  This includes
          implicit declarations of functions.

        * The keywords `typeof', `inline', `signed', `const' and
          `volatile' are not recognized.  (You can still use the
          alternative keywords such as `__typeof__', `__inline__', and
          so on.)

        * Comparisons between pointers and integers are always allowed.

        * Integer types `unsigned short' and `unsigned char' promote to
          `unsigned int'.

        * Out-of-range floating point literals are not an error.

        * String "constants" are not necessarily constant; they are
          stored in writable space, and identical looking constants are
          allocated separately.  (This is the same as the effect of
          `-fwritable-strings'.)

        * All automatic variables not declared `register' are preserved
          by `longjmp'.  Ordinarily, GNU C follows ANSI C: automatic
          variables not declared `volatile' may be clobbered.

        * In the preprocessor, comments convert to nothing at all,
          rather than to a space.  This allows traditional token
          concatenation.

        * In the preprocessor, macro arguments are recognized within
          string constants in a macro definition (and their values are
          stringified, though without additional quote marks, when they
          appear in such a context).  The preprocessor always considers
          a string constant to end at a newline.

        * The predefined macro `__STDC__' is not defined when you use
          `-traditional', but `__GNUC__' is (since the GNU extensions
          which `__GNUC__' indicates are not affected by
          `-traditional').  If you need to write header files that work
          differently depending on whether `-traditional' is in use, by
          testing both of these predefined macros you can distinguish
          four situations: GNU C, traditional GNU C, other ANSI C
          compilers, and other old C compilers.

     You may wish to use `-fno-builtin' as well as `-traditional' if
     your program uses names that are normally GNU C builtin functions
     for other purposes of its own.

`-traditional-cpp'
     Attempt to support some aspects of traditional C preprocessors.
     This includes the last three items in the table immediately above,
     but none of the other effects of `-traditional'.

`-fcond-mismatch'
     Allow conditional expressions with mismatched types in the second
     and third arguments.  The value of such an expression is void.

`-funsigned-char'
     Let the type `char' be unsigned, like `unsigned char'.

     Each kind of machine has a default for what `char' should be.  It
     is either like `unsigned char' by default or like `signed char' by
     default.

     Ideally, a portable program should always use `signed char' or
     `unsigned char' when it depends on the signedness of an object.
     But many programs have been written to use plain `char' and expect
     it to be signed, or expect it to be unsigned, depending on the
     machines they were written for.  This option, and its inverse, let
     you make such a program work with the opposite default.

     The type `char' is always a distinct type from each of `signed
     char' or `unsigned char', even though its behavior is always just
     like one of those two.

`-fsigned-char'
     Let the type `char' be signed, like `signed char'.

     Note that this is equivalent to `-fno-unsigned-char', which is the
     negative form of `-funsigned-char'.  Likewise, `-fno-signed-char'
     is equivalent to `-funsigned-char'.

`-fsigned-bitfields'
`-funsigned-bitfields'
`-fno-signed-bitfields'
`-fno-unsigned-bitfields'
     These options control whether a bitfield is signed or unsigned,
     when the declaration does not use either `signed' or `unsigned'. 
     By default, such a bitfield is signed, because this is consistent:
     the basic integer types such as `int' are signed types.

     However, when `-traditional' is used, bitfields are all unsigned
     no matter what.

`-fwritable-strings'
     Store string constants in the writable data segment and don't
     uniquize them.  This is for compatibility with old programs which
     assume they can write into string constants.  `-traditional' also
     has this effect.

     Writing into string constants is a very bad idea; "constants"
     should be constant.


File: usegcc.i,  Node: Warning Options,  Next: Debugging Options,  Prev: Dialect Options,  Up: Invoking GCC

Options to Request or Suppress Warnings
=======================================

   Warnings are diagnostic messages that report constructions which are
not inherently erroneous but which are risky or suggest there may have
been an error.

   You can request many specific warnings with options beginning `-W',
for example `-Wimplicit' to request warnings on implicit declarations. 
Each of these specific warning options also has a negative form
beginning `-Wno-' to turn off warnings; for example, `-Wno-implicit'. 
This manual lists only one of the two forms, whichever is not the
default.

   These options control the amount and kinds of warnings produced by
GNU CC:

`-fsyntax-only'
     Check the code for syntax errors, but don't emit any output.

`-w'
     Inhibit all warning messages.

`-Wno_import'
     Inhibit warning messages about the use of `#import'.

`-pedantic'
     Issue all the warnings demanded by strict ANSI standard C; reject
     all programs that use forbidden extensions.

     Valid ANSI standard C programs should compile properly with or
     without this option (though a rare few will require `-ansi'). 
     However, without this option, certain GNU extensions and
     traditional C features are supported as well.  With this option,
     they are rejected.

     `-pedantic' does not cause warning messages for use of the
     alternate keywords whose names begin and end with `__'.  Pedantic
     warnings are also disabled in the expression that follows
     `__extension__'.  However, only system header files should use
     these escape routes; application programs should avoid them. *Note
     Alternate Keywords::.

     This option is not intended to be useful; it exists only to satisfy
     pedants who would otherwise claim that GNU CC fails to support the
     ANSI standard.

     Some users try to use `-pedantic' to check programs for strict ANSI
     C conformance.  They soon find that it does not do quite what they
     want: it finds some non-ANSI practices, but not all--only those
     for which ANSI C *requires* a diagnostic.

     A feature to report any failure to conform to ANSI C might be
     useful in some instances, but would require considerable
     additional work and would be quite different from `-pedantic'.  We
     recommend, rather, that users take advantage of the extensions of
     GNU C and disregard the limitations of other compilers.  Aside
     from certain supercomputers and obsolete small machines, there is
     less and less reason ever to use any other C compiler other than
     for bootstrapping GNU CC.

`-pedantic-errors'
     Like `-pedantic', except that errors are produced rather than
     warnings.

`-W'
     Print extra warning messages for these events:

        * A nonvolatile automatic variable might be changed by a call to
          `longjmp'.  These warnings as well are possible only in
          optimizing compilation.

          The compiler sees only the calls to `setjmp'.  It cannot know
          where `longjmp' will be called; in fact, a signal handler
          could call it at any point in the code.  As a result, you may
          get a warning even when there is in fact no problem because
          `longjmp' cannot in fact be called at the place which would
          cause a problem.

        * A function can return either with or without a value. 
          (Falling off the end of the function body is considered
          returning without a value.)  For example, this function would
          evoke such a warning:

               foo (a)
               {
                 if (a > 0)
                   return a;
               }

        * An expression-statement contains no side effects.

        * An unsigned value is compared against zero with `>' or `<='.

`-Wimplicit'
     Warn whenever a function or parameter is implicitly declared.

`-Wreturn-type'
     Warn whenever a function is defined with a return-type that
     defaults to `int'.  Also warn about any `return' statement with no
     return-value in a function whose return-type is not `void'.

`-Wunused'
     Warn whenever a local variable is unused aside from its
     declaration, whenever a function is declared static but never
     defined, and whenever a statement computes a result that is
     explicitly not used.

`-Wswitch'
     Warn whenever a `switch' statement has an index of enumeral type
     and lacks a `case' for one or more of the named codes of that
     enumeration.  (The presence of a `default' label prevents this
     warning.)  `case' labels outside the enumeration range also
     provoke warnings when this option is used.

`-Wcomment'
     Warn whenever a comment-start sequence `/*' appears in a comment.

`-Wtrigraphs'
     Warn if any trigraphs are encountered (assuming they are enabled).

`-Wformat'
     Check calls to `printf' and `scanf', etc., to make sure that the
     arguments supplied have types appropriate to the format string
     specified.

`-Wchar-subscripts'
     Warn if an array subscript has type `char'.  This is a common cause
     of error, as programmers often forget that this type is signed on
     some machines.

`-Wuninitialized'
     An automatic variable is used without first being initialized.

     These warnings are possible only in optimizing compilation,
     because they require data flow information that is computed only
     when optimizing.  If you don't specify `-O', you simply won't get
     these warnings.

     These warnings occur only for variables that are candidates for
     register allocation.  Therefore, they do not occur for a variable
     that is declared `volatile', or whose address is taken, or whose
     size is other than 1, 2, 4 or 8 bytes.  Also, they do not occur for
     structures, unions or arrays, even when they are in registers.

     Note that there may be no warning about a variable that is used
     only to compute a value that itself is never used, because such
     computations may be deleted by data flow analysis before the
     warnings are printed.

     These warnings are made optional because GNU CC is not smart
     enough to see all the reasons why the code might be correct
     despite appearing to have an error.  Here is one example of how
     this can happen:

          {
            int x;
            switch (y)
              {
              case 1: x = 1;
                break;
              case 2: x = 4;
                break;
              case 3: x = 5;
              }
            foo (x);
          }

     If the value of `y' is always 1, 2 or 3, then `x' is always
     initialized, but GNU CC doesn't know this.  Here is another common
     case:

          {
            int save_y;
            if (change_y) save_y = y, y = new_y;
            ...
            if (change_y) y = save_y;
          }

     This has no bug because `save_y' is used only if it is set.

     Some spurious warnings can be avoided if you declare as `volatile'
     all the functions you use that never return. *Note Function
     Attributes::.

`-Wparentheses'
     Warn if parentheses are omitted in certain contexts.

`-Wall'
     All of the above `-W' options combined.  These are all the options
     which pertain to usage that we recommend avoiding and that we
     believe is easy to avoid, even in conjunction with macros.

   The remaining `-W...' options are not implied by `-Wall' because
they warn about constructions that we consider reasonable to use, on
occasion, in clean programs.

`-Wtraditional'
     Warn about certain constructs that behave differently in
     traditional and ANSI C.

        * Macro arguments occurring within string constants in the
          macro body. These would substitute the argument in
          traditional C, but are part of the constant in ANSI C.

        * A function declared external in one block and then used after
          the end of the block.

        * A `switch' statement has an operand of type `long'.

`-Wshadow'
     Warn whenever a local variable shadows another local variable.

`-Wid-clash-LEN'
     Warn whenever two distinct identifiers match in the first LEN
     characters.  This may help you prepare a program that will compile
     with certain obsolete, brain-damaged compilers.

`-Wpointer-arith'
     Warn about anything that depends on the "size of" a function type
     or of `void'.  GNU C assigns these types a size of 1, for
     convenience in calculations with `void *' pointers and pointers to
     functions.

`-Wcast-qual'
     Warn whenever a pointer is cast so as to remove a type qualifier
     from the target type.  For example, warn if a `const char *' is
     cast to an ordinary `char *'.

`-Wcast-align'
     Warn whenever a pointer is cast such that the required alignment
     of the target is increased.  For example, warn if a `char *' is
     cast to an `int *' on machines where integers can only be accessed
     at two- or four-byte boundaries.

`-Wwrite-strings'
     Give string constants the type `const char[LENGTH]' so that
     copying the address of one into a non-`const' `char *' pointer
     will get a warning.  These warnings will help you find at compile
     time code that can try to write into a string constant, but only
     if you have been very careful about using `const' in declarations
     and prototypes.  Otherwise, it will just be a nuisance; this is
     why we did not make `-Wall' request these warnings.

`-Wconversion'
     Warn if a prototype causes a type conversion that is different
     from what would happen to the same argument in the absence of a
     prototype.  This includes conversions of fixed point to floating
     and vice versa, and conversions changing the width or signedness
     of a fixed point argument except when the same as the default
     promotion.

`-Waggregate-return'
     Warn if any functions that return structures or unions are defined
     or called.  (In languages where you can return an array, this also
     elicits a warning.)

`-Wstrict-prototypes'
     Warn if a function is declared or defined without specifying the
     argument types.  (An old-style function definition is permitted
     without a warning if preceded by a declaration which specifies the
     argument types.)

`-Wmissing-prototypes'
     Warn if a global function is defined without a previous prototype
     declaration.  This warning is issued even if the definition itself
     provides a prototype.  The aim is to detect global functions that
     fail to be declared in header files.

`-Wredundant-decls'
     Warn if anything is declared more than once in the same scope,
     even in cases where multiple declaration is valid and changes
     nothing.

`-Wnested-externs'
     Warn if an `extern' declaration is encountered within an function.

`-Winline'
     Warn if a function can not be inlined, and either it was declared
     as inline, or else the `-finline-functions' option was given.

`-Werror'
     Make all warnings into errors.


File: usegcc.i,  Node: Debugging Options,  Next: Optimize Options,  Prev: Warning Options,  Up: Invoking GCC

Options for Debugging Your Program or GNU CC
============================================

   GNU CC has various special options that are used for debugging
either your program or GCC:

`-g'
     Produce debugging information in the object code.

     Unlike most other C compilers, GNU CC allows you to use `-g' with
     `-O'.  The shortcuts taken by optimized code may occasionally
     produce surprising results: some variables you declared may not
     exist at all; flow of control may briefly move where you did not
     expect it; some statements may not be executed because they
     compute constant results or their values were already at hand;
     some statements may execute in different places because they were
     moved out of loops.

     Nevertheless it proves possible to debug optimized output.  This
     makes it reasonable to use the optimizer for programs that might
     have bugs.

`-gLEVEL'
     Request debugging information and also use LEVEL to specify how
     much information.  The default level is 2.

     Level 1 produces minimal information, enough for making backtraces
     in parts of the program that you don't plan to debug.  This
     includes descriptions of functions and external variables, but no
     information about local variables and no line numbers.

     Level 3 includes extra information, such as all the macro
     definitions present in the program.  Some debuggers support macro
     expansion when you use `-g3'.

`-dLETTERS'
     Says to make debugging dumps during compilation at times specified
     by LETTERS.  This is used for debugging the compiler.  The file
     names for most of the dumps are made by appending a word to the
     source file name (e.g.  `foo.c.rtl' or `foo.c.jump').  Here are the
     possible letters for use in LETTERS, and their meanings:

    `M'
          Dump all macro definitions, at the end of preprocessing, and
          write no output.

    `N'
          Dump all macro names, at the end of preprocessing.

    `D'
          Dump all macro definitions, at the end of preprocessing, in
          addition to normal output.

    `y'
          Dump debugging information during parsing, to standard error.

    `r'
          Dump after RTL generation, to `FILE.rtl'.

    `x'
          Just generate RTL for a function instead of compiling it. 
          Usually used with `r'.

    `j'
          Dump after first jump optimization, to `FILE.jump'.

    `s'
          Dump after CSE (including the jump optimization that sometimes
          follows CSE), to `FILE.cse'.

    `L'
          Dump after loop optimization, to `FILE.loop'.

    `t'
          Dump after the second CSE pass (including the jump
          optimization that sometimes follows CSE), to `FILE.cse2'.

    `f'
          Dump after flow analysis, to `FILE.flow'.

    `c'
          Dump after instruction combination, to `FILE.combine'.

    `S'
          Dump after the first instruction scheduling pass, to
          `FILE.sched'.

    `l'
          Dump after local register allocation, to
          `FILE.lreg'.

    `g'
          Dump after global register allocation, to
          `FILE.greg'.

    `R'
          Dump after the second instruction scheduling pass, to
          `FILE.sched2'.

    `J'
          Dump after last jump optimization, to `FILE.jump2'.

    `d'
          Dump after delayed branch scheduling, to `FILE.dbr'.

    `k'
          Dump after conversion from registers to stack, to
          `FILE.stack'.

    `a'
          Produce all the dumps listed above.

    `m'
          Print statistics on memory usage, at the end of the run, to
          standard error.

    `p'
          Annotate the assembler output with a comment indicating which
          pattern and alternative was used.

`-fpretend-float'
     When running a cross-compiler, pretend that the target machine
     uses the same floating point format as the host machine.  This
     causes incorrect output of the actual floating constants, but the
     actual instruction sequence will probably be the same as GNU CC
     would make when running on the target machine.

`-save-temps'
     Store the usual "temporary" intermediate files permanently; place
     them in the current directory and name them based on the source
     file.  Thus, compiling `foo.c' with `-c -save-temps' would produce
     files `foo.i' and `foo.s', as well as `foo.o'.


File: usegcc.i,  Node: Optimize Options,  Next: Preprocessor Options,  Prev: Debugging Options,  Up: Invoking GCC

Options That Control Optimization
=================================

   These options control various sorts of optimizations:

`-O'
     Optimize.  Optimizing compilation takes somewhat more time, and a
     lot more memory for a large function.

     Without `-O', the compiler's goal is to reduce the cost of
     compilation and to make debugging produce the expected results.
     Statements are independent: if you stop the program with a
     breakpoint between statements, you can then assign a new value to
     any variable or change the program counter to any other statement
     in the function and get exactly the results you would expect from
     the source code.

     Without `-O', only variables declared `register' are allocated in
     registers.  The resulting compiled code is a little worse than
     produced by PCC without `-O'.

     With `-O', the compiler tries to reduce code size and execution
     time.

     When `-O' is specified, `-fthread-jumps' and `-fdelayed-branch'
     are turned on.  On some machines other flags may also be turned on.

`-O2'
     Optimize even more.  Nearly all supported optimizations that do not
     involve a space-speed tradeoff are performed.  As compared to `-O',
     this option increases both compilation time and the performance of
     the generated code.

     `-O2' turns on all `-fFLAG' options that enable more optimization,
     except for `-funroll-loops', `-funroll-all-loops' and
     `-fomit-frame-pointer'.

   Options of the form `-fFLAG' specify machine-independent flags. 
Most flags have both positive and negative forms; the negative form of
`-ffoo' would be `-fno-foo'.  In the table below, only one of the forms
is listed--the one which is not the default. You can figure out the
other form by either removing `no-' or adding it.

`-ffloat-store'
     Do not store floating point variables in registers.  This prevents
     undesirable excess precision on machines such as the 68000 where
     the floating registers (of the 68881) keep more precision than a
     `double' is supposed to have.

     For most programs, the excess precision does only good, but a few
     programs rely on the precise definition of IEEE floating point.
     Use `-ffloat-store' for such programs.

`-fno-defer-pop'
     Always pop the arguments to each function call as soon as that
     function returns.  For machines which must pop arguments after a
     function call, the compiler normally lets arguments accumulate on
     the stack for several function calls and pops them all at once.

`-fforce-mem'
     Force memory operands to be copied into registers before doing
     arithmetic on them.  This may produce better code by making all
     memory references potential common subexpressions.  When they are
     not common subexpressions, instruction combination should
     eliminate the separate register-load.  I am interested in hearing
     about the difference this makes.

`-fforce-addr'
     Force memory address constants to be copied into registers before
     doing arithmetic on them.  This may produce better code just as
     `-fforce-mem' may.  I am interested in hearing about the
     difference this makes.

`-fomit-frame-pointer'
     Don't keep the frame pointer in a register for functions that
     don't need one.  This avoids the instructions to save, set up and
     restore frame pointers; it also makes an extra register available
     in many functions.  *It also makes debugging impossible on some
     machines.*

     On some machines, such as the Vax, this flag has no effect, because
     the standard calling sequence automatically handles the frame
     pointer and nothing is saved by pretending it doesn't exist.  The
     machine-description macro `FRAME_POINTER_REQUIRED' controls
     whether a target machine supports this flag.  *Note Register
     Usage: (gcc.info)Registers.

`-fno-inline'
     Don't pay attention to the `inline' keyword.  Normally this option
     is used to keep the compiler from expanding any functions inline.
     Note that if you are not optimizing, no functions can be expanded
     inline.

`-finline-functions'
     Integrate all simple functions into their callers.  The compiler
     heuristically decides which functions are simple enough to be worth
     integrating in this way.

     If all calls to a given function are integrated, and the function
     is declared `static', then the function is normally not output as
     assembler code in its own right.

`-fkeep-inline-functions'
     Even if all calls to a given function are integrated, and the
     function is declared `static', nevertheless output a separate
     run-time callable version of the function.

`-fno-function-cse'
     Do not put function addresses in registers; make each instruction
     that calls a constant function contain the function's address
     explicitly.

     This option results in less efficient code, but some strange hacks
     that alter the assembler output may be confused by the
     optimizations performed when this option is not used.

`-ffast-math'
     This option allows GCC to violate some ANSI or IEEE
     rules/specifications in the interest of optimizing code for speed.
      For example, it allows the compiler to assume arguments to the
     `sqrt' function are non-negative numbers.

     This option should never be turned on by any `-O' option since it
     can result in incorrect output for programs which depend on an
     exact implementation of IEEE or ANSI rules/specifications for math
     functions.

   The following options control specific optimizations.  The `-O2'
option turns on all of these optimizations except `-funroll-loops' and
`-funroll-all-loops'.  The `-O' option usually turns on the
`-fthread-jumps' and `-fdelayed-branch' options, but specific machines
may change the default optimizations.

   You can use the following flags in the rare cases when "fine-tuning"
of optimizations to be performed is desired.

`-fstrength-reduce'
     Perform the optimizations of loop strength reduction and
     elimination of iteration variables.

`-fthread-jumps'
     Perform optimizations where we check to see if a jump branches to a
     location where another comparison subsumed by the first is found. 
     If so, the first branch is redirected to either the destination of
     the second branch or a point immediately following it, depending
     on whether the condition is known to be true or false.

`-fcse-follow-jumps'
     In common subexpression elimination, scan through jump instructions
     when the target of the jump is not reached by any other path.  For
     example, when CSE encounters an `if' statement with an `else'
     clause, CSE will follow the jump when the condition tested is
     false.

`-fcse-skip-blocks'
     This is similar to `-fcse-follow-jumps', but causes CSE to follow
     jumps which conditionally skip over blocks.  When CSE encounters a
     simple `if' statement with no else clause, `-fcse-skip-blocks'
     causes CSE to follow the jump around the body of the `if'.

`-frerun-cse-after-loop'
     Re-run common subexpression elimination after loop optimizations
     has been performed.

`-fexpensive-optimizations'
     Perform a number of minor optimizations that are relatively
     expensive.

`-fdelayed-branch'
     If supported for the target machine, attempt to reorder
     instructions to exploit instruction slots available after delayed
     branch instructions.

`-fschedule-insns'
     If supported for the target machine, attempt to reorder
     instructions to eliminate execution stalls due to required data
     being unavailable.  This helps machines that have slow floating
     point or memory load instructions by allowing other instructions
     to be issued until the result of the load or floating point
     instruction is required.

`-fschedule-insns2'
     Similar to `-fschedule-insns', but requests an additional pass of
     instruction scheduling after register allocation has been done. 
     This is especially useful on machines with a relatively small
     number of registers and where memory load instructions take more
     than one cycle.

`-fcaller-saves'
     Enable values to be allocated in registers that will be clobbered
     by function calls, by emitting extra instructions to save and
     restore the registers around such calls.  Such allocation is done
     only when it seems to result in better code than would otherwise
     be produced.

     This option is enabled by default on certain machines, usually
     those which have no call-preserved registers to use instead.

`-funroll-loops'
     Perform the optimization of loop unrolling.  This is only done for
     loops whose number of iterations can be determined at compile time
     or run time. `-funroll-loop' implies `-fstrength-reduce' and
     `-frerun-cse-after-loop'.

`-funroll-all-loops'
     Perform the optimization of loop unrolling.  This is done for all
     loops and usually makes programs run more slowly. 
     `-funroll-all-loops' implies `-fstrength-reduce' and
     `-frerun-cse-after-loop'.

`-fno-peephole'
     Disable any machine-specific peephole optimizations.


File: usegcc.i,  Node: Preprocessor Options,  Next: Link Options,  Prev: Optimize Options,  Up: Invoking GCC

Options Controlling the Preprocessor
====================================

   These options control the C preprocessor, which is run on each C
source file before actual compilation.

   If you use the `-E' option, nothing is done except preprocessing.
Some of these options make sense only together with `-E' because they
cause the preprocessor output to be unsuitable for actual compilation.

`-include FILE'
     Process FILE as input before processing the regular input file. In
     effect, the contents of FILE are compiled first.  Any `-D' and
     `-U' options on the command line are always processed before
     `-include FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-imacros FILE'
     Process FILE as input, discarding the resulting output, before
     processing the regular input file.  Because the output generated
     from FILE is discarded, the only effect of `-imacros FILE' is to
     make the macros defined in FILE available for use in the main
     input.

     Any `-D' and `-U' options on the command line are always processed
     before `-imacros FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-nostdinc'
     Do not search the standard system directories for header files. 
     Only the directories you have specified with `-I' options (and the
     current directory, if appropriate) are searched.  *Note Directory
     Options::, for information on `-I'.

     By using both `-nostdinc' and `-I-', you can limit the include-file
     search path to only those directories you specify explicitly.

`-undef'
     Do not predefine any nonstandard macros.  (Including architecture
     flags).

`-E'
     Run only the C preprocessor.  Preprocess all the C source files
     specified and output the results to standard output or to the
     specified output file.

`-C'
     Tell the preprocessor not to discard comments.  Used with the `-E'
     option.

`-P'
     Tell the preprocessor not to generate `#line' commands. Used with
     the `-E' option.

`-M'
     Tell the preprocessor to output a rule suitable for `make'
     describing the dependencies of each object file.  For each source
     file, the preprocessor outputs one `make'-rule whose target is the
     object file name for that source file and whose dependencies are
     all the files `#include'd in it.  This rule may be a single line
     or may be continued with `\'-newline if it is long.  The list of
     rules is printed on standard output instead of the preprocessed C
     program.

     `-M' implies `-E'.

     Another way to specify output of a `make' rule is by setting the
     environment variable `DEPENDENCIES_OUTPUT' (*note Environment
     Variables::.).

`-MM'
     Like `-M' but the output mentions only the user header files
     included with `#include "FILE"'.  System header files included
     with `#include <FILE>' are omitted.

`-MD'
     Like `-M' but the dependency information is written to files with
     names made by replacing `.o' with `.d' at the end of the output
     file names.  This is in addition to compiling the input files as
     specified--`-MD' does not inhibit ordinary compilation the way
     `-M' does.

     The Mach utility `md' can be used to merge the `.d' files into a
     single dependency file suitable for using with the `make' command.

`-MMD'
     Like `-MD' except mention only user header files, not system
     header files.

`-H'
     Print the name of each header file used, in addition to other
     normal activities.

`-AQUESTION(ANSWER)'
     Assert the answer ANSWER for QUESTION, in case it is tested with a
     preprocessor conditional such as `#if #QUESTION(ANSWER)'.  `-A-'
     disables the standard assertions that normally describe the target
     machine.

`-DMACRO'
     Define macro MACRO with the string `1' as its definition.

`-DMACRO=DEFN'
     Define macro MACRO as DEFN.  All instances of `-D' on the command
     line are processed before any `-U' options.

`-UMACRO'
     Undefine macro MACRO.  `-U' options are evaluated after all `-D'
     options, but before any `-include' and `-imacros' options.

`-dM'
     Tell the preprocessor to output only a list of the macro
     definitions that are in effect at the end of preprocessing.  Used
     with the `-E' option.

`-dD'
     Tell the preprocessing to pass all macro definitions into the
     output, in their proper sequence in the rest of the output.

`-dN'
     Like `-dD' except that the macro arguments and contents are
     omitted. Only `#define NAME' is included in the output.

`-trigraphs'
     Support ANSI C trigraphs.  You don't want to know about this
     brain-damage.  The `-ansi' option also has this effect.


File: usegcc.i,  Node: Link Options,  Next: Directory Options,  Prev: Preprocessor Options,  Up: Invoking GCC

Options for Linking
===================

   These options come into play when the compiler links object files
into an executable output file.  They are meaningless if the compiler is
not doing a link step.

`OBJECT-FILE-NAME'
     A file name that does not end in a special recognized suffix is
     considered to name an object file or library.  (Object files are
     distinguished from libraries by the linker according to the file
     contents.)  If linking is done, these object files are used as
     input to the linker.

`-c'
`-S'
`-E'
     If any of these options is used, then the linker is not run, and
     object file names should not be used as arguments.  *Note Overall
     Options::.

`-lLIBRARY'
     Search the library named LIBRARY when linking.

     It makes a difference where in the command you write this option;
     the linker searches processes libraries and object files in the
     order they are specified.  Thus, `foo.o -lz bar.o' searches
     library `z' after file `foo.o' but before `bar.o'.  If `bar.o'
     refers to functions in `z', those functions may not be loaded.

     The linker searches a standard list of directories for the library,
     which is actually a file named `libLIBRARY.a'.  The linker then
     uses this file as if it had been specified precisely by name.

     The directories searched include several standard system
     directories plus any that you specify with `-L'.

     Normally the files found this way are library files--archive files
     whose members are object files.  The linker handles an archive
     file by scanning through it for members which define symbols that
     have so far been referenced but not defined.  But if the file that
     is found is an ordinary object file, it is linked in the usual
     fashion.  The only difference between using an `-l' option and
     specifying a file name is that `-l' surrounds LIBRARY with `lib'
     and `.a' and searches several directories.

`-nostdlib'
     Don't use the standard system libraries and startup files when
     linking. Only the files you specify will be passed to the linker.

`-static'
     On systems that support dynamic linking, this prevents linking
     with the shared libraries.  On other systems, this option has no
     effect.

`-shared'
     Produce a shared object which can then be linked with other
     objects to form an executable.  Only a few systems support this
     option.

`-symbolic'
     Bind references to global symbols when building a shared object. 
     Warn about any unresolved references (unless overridden by the
     link editor option `-Xlinker -z -Xlinker defs').  Only a few
     systems support this option.

`-Xlinker OPTION'
     Pass OPTION as an option to the linker.  You can use this to
     supply system-specific linker options which GNU CC does not know
     how to recognize.

     If you want to pass an option that takes an argument, you must use
     `-Xlinker' twice, once for the option and once for the argument.
     For example, to pass `-assert definitions', you must write
     `-Xlinker -assert -Xlinker definitions'.  It does not work to write
     `-Xlinker "-assert definitions"', because this passes the entire
     string as a single argument, which is not what the linker expects.

`-u SYMBOL'
     Pretend the symbol SYMBOL is undefined, to force linking of
     library modules to define it.  You can use `-u' multiple times with
     different symbols to force loading of additional library modules.


File: usegcc.i,  Node: Directory Options,  Next: Compiler Version,  Prev: Link Options,  Up: Invoking GCC

Options for Directory Search
============================

   These options specify directories to search for header files, for
libraries and for parts of the compiler:

`-IDIR'
     Append directory DIR to the list of directories searched for
     include files.

`-I-'
     Any directories you specify with `-I' options before the `-I-'
     option are searched only for the case of `#include "FILE"'; they
     are not searched for `#include <FILE>'.

     If additional directories are specified with `-I' options after
     the `-I-', these directories are searched for all `#include'
     directives.  (Ordinarily *all* `-I' directories are used this way.)

     In addition, the `-I-' option inhibits the use of the current
     directory (where the current input file came from) as the first
     search directory for `#include "FILE"'.  There is no way to
     override this effect of `-I-'.  With `-I.' you can specify
     searching the directory which was current when the compiler was
     invoked.  That is not exactly the same as what the preprocessor
     does by default, but it is often satisfactory.

     `-I-' does not inhibit the use of the standard system directories
     for header files.  Thus, `-I-' and `-nostdinc' are independent.

`-LDIR'
     Add directory DIR to the list of directories to be searched for
     `-l'.

`-BPREFIX'
     This option specifies where to find the executables, libraries and
     data files of the compiler itself.

     The compiler driver program runs one or more of the subprograms
     `cpp', `cc1', `as' and `ld'.

     For each subprogram to be run, the compiler driver first tries the
     `-B' prefix, if any.  If that name is not found, or if `-B' was
     not specified, the driver tries two standard prefixes, which are
     `/usr/lib/gcc/' and `/usr/local/lib/gcc-lib/'.  If neither of
     those results in a file name that is found, the unmodified program
     name is searched for using the directories specified in your
     `PATH' environment variable.

     `-B' prefixes that effectively specify directory names also apply
     to libraries in the linker, because the compiler translates these
     options into `-L' options for the linker.

     The run-time support file `libgcc.a' can also be searched for using
     the `-B' prefix, if needed.  If it is not found there, the two
     standard prefixes above are tried, and that is all.  The file is
     left out of the link if it is not found by those means.

     Another way to specify a prefix much like the `-B' prefix is to use
     the environment variable `GCC_EXEC_PREFIX'.  *Note Environment
     Variables::.


File: usegcc.i,  Node: Compiler Version,  Next: Code Gen Options,  Prev: Directory Options,  Up: Invoking GCC

Specifying Compiler Version
===========================

   Older and newer versions of GNU CC can be installed side by side. 
One of them (probably the newest) will be the default, but you may
sometimes wish to use another.

`-V VERSION'
     The argument VERSION specifies which version of GNU CC to run.
     This is useful when multiple versions are installed.  For example,
     VERSION might be `2.0', meaning to run GNU CC version 2.0.

     The default version, when you do not specify `-V', is controlled
     by the way GNU CC is installed.  Normally, it will be a version
     that is recommended for general use.


File: usegcc.i,  Node: Code Gen Options,  Next: Environment Variables,  Prev: Compiler Version,  Up: Invoking GCC

Options for Code Generation Conventions
=======================================

   These machine-independent options control the interface conventions
used in code generation.

   Most of them have both positive and negative forms; the negative form
of `-ffoo' would be `-fno-foo'.  In the table below, only one of the
forms is listed--the one which is not the default.  You can figure out
the other form by either removing `no-' or adding it.

`-fshort-enums'
     Allocate to an `enum' type only as many bytes as it needs for the
     declared range of possible values.  Specifically, the `enum' type
     will be equivalent to the smallest integer type which has enough
     room.

`-fshort-double'
     Use the same size for `double' as for `float'.

`-fshared-data'
     Requests that the data and non-`const' variables of this
     compilation be shared data rather than private data.  The
     distinction makes sense only on certain operating systems, where
     shared data is shared between processes running the same program,
     while private data exists in one copy per process.

`-fno-common'
     Allocate even uninitialized global variables in the bss section of
     the object file, rather than generating them as common blocks. 
     This has the effect that if the same variable is declared (without
     `extern') in two different compilations, you will get an error
     when you link them. The only reason this might be useful is if you
     wish to verify that the program will work on other systems which
     always work this way.

`-fno-ident'
     Ignore the `#ident' directive.

`-finhibit-size-directive'
     Don't output a `.size' assembler directive, or anything else that
     would cause trouble if the function is split in the middle, and the
     two halves are placed at locations far apart in memory.  This
     option is used when compiling `crtstuff.c'; you should not need to
     use it for anything else.

`-fverbose-asm'
     Put extra commentary information in the generated assembly code to
     make it more readable.  This option is generally only of use to
     those who actually need to read the generated assembly code
     (perhaps while debugging the compiler itself).

`-fvolatile'
     Consider all memory references through pointers to be volatile.

`-fpic'
     If supported for the target machine, generate position-independent
     code (PIC) suitable for use in a shared library.  All addresses
     will be accessed through a global offset table (GOT).  If the GOT
     size for the linked executable exceeds a machine-specific maximum
     size, you will get an error message from the linker indicating
     that `-fpic' does not work; recompile with `-fPIC' instead.

     The GNU assembler does not fully support PIC.  Currently, you must
     use some other assembler in order for PIC to work.  We would
     welcome volunteers to upgrade GAS to handle this; the first part
     of the job is to figure out what the assembler must do differently.

`-ffixed-REG'
     Treat the register named REG as a fixed register; generated code
     should never refer to it (except perhaps as a stack pointer, frame
     pointer or in some other fixed role).

     REG must be the name of a register.  The register names accepted
     are machine-specific and are defined in the `REGISTER_NAMES' macro
     in the machine description macro file.

     This flag does not have a negative form, because it specifies a
     three-way choice.

`-fcall-used-REG'
     Treat the register named REG as an allocatable register that is
     clobbered by function calls.  It may be allocated for temporaries
     or variables that do not live across a call.  Functions compiled
     this way will not save and restore the register REG.

     Use of this flag for a register that has a fixed pervasive role in
     the machine's execution model, such as the stack pointer or frame
     pointer, will produce disastrous results.

     This flag does not have a negative form, because it specifies a
     three-way choice.

`-fcall-saved-REG'
     Treat the register named REG as an allocatable register saved by
     functions.  It may be allocated even for temporaries or variables
     that live across a call.  Functions compiled this way will save
     and restore the register REG if they use it.

     Use of this flag for a register that has a fixed pervasive role in
     the machine's execution model, such as the stack pointer or frame
     pointer, will produce disastrous results.

     A different sort of disaster will result from the use of this flag
     for a register in which function values may be returned.

     This flag does not have a negative form, because it specifies a
     three-way choice.


File: usegcc.i,  Node: Environment Variables,  Prev: Code Gen Options,  Up: Invoking GCC

Environment Variables Affecting GNU CC
======================================

   This section describes several environment variables that affect how
GNU CC operates.  They work by specifying directories or prefixes to use
when searching for various kinds of files.

   Note that you can also specify places to search using options such as
`-B', `-I' and `-L' (*note Directory Options::.).  These take
precedence over places specified using environment variables, which in
turn take precedence over those specified by the configuration of GNU
CC.

`TMPDIR'
     If `TMPDIR' is set, it specifies the directory to use for temporary
     files.  GNU CC uses temporary files to hold the output of one
     stage of compilation which is to be used as input to the next
     stage: for example, the output of the preprocessor, which is the
     input to the compiler proper.

`GCC_EXEC_PREFIX'
     If `GCC_EXEC_PREFIX' is set, it specifies a prefix to use in the
     names of the subprograms executed by the compiler.  No slash is
     added when this prefix is combined with the name of a subprogram,
     but you can specify a prefix that ends with a slash if you wish.

     If GNU CC cannot find the subprogram using the specified prefix, it
     tries looking in the usual places for the subprogram.

     Other prefixes specified with `-B' take precedence over this
     prefix.

     This prefix is also used for finding files such as `crt0.o' that
     are used for linking.

     In addition, the prefix is used in an unusual way in finding the
     directories to search for header files.  For each of the standard
     directories whose name normally begins with
     `/usr/local/lib/gcc-lib' (more precisely, with the value of
     `GCC_INCLUDE_DIR'), GNU CC tries replacing that beginning with the
     specified prefix to produce an alternate directory name.  Thus,
     with `-Bfoo/', GNU CC will search `foo/bar' where it would
     normally search `/usr/local/lib/bar'. These alternate directories
     are searched first; the standard directories come next.

`COMPILER_PATH'
     The value of `COMPILER_PATH' is a colon-separated list of
     directories, much like `PATH'.  GNU CC tries the directories thus
     specified when searching for subprograms, if it can't find the
     subprograms using `GCC_EXEC_PREFIX'.

`LIBRARY_PATH'
     The value of `LIBRARY_PATH' is a colon-separated list of
     directories, much like `PATH'.  GNU CC tries the directories thus
     specified when searching for special linker files, if it can't
     find them using `GCC_EXEC_PREFIX'.  Linking using GNU CC also uses
     these directories when searching for ordinary libraries for the
     `-l' option (but directories specified with `-L' come first).

`C_INCLUDE_PATH'
     A colon-separated list of directories, much like `PATH'.  When GNU
     CC searches for header files, it tries these directories, after the
     directories specified with `-I' but before the standard header file
     directories.

`DEPENDENCIES_OUTPUT'
     If this variable is set, its value specifies how to output
     dependencies for Make based on the header files processed by the
     compiler.  This output looks much like the output from the `-M'
     option (*note Preprocessor Options::.), but it goes to a separate
     file, and is in addition to the usual results of compilation.

     The value of `DEPENDENCIES_OUTPUT' can be just a file name, in
     which case the Make rules are written to that file, guessing the
     target name from the source file name.  Or the value can have the
     form `FILE TARGET', in which case the rules are written to file
     FILE using TARGET as the target name.


File: usegcc.i,  Node: Extensions,  Next: Trouble,  Prev: Invoking GCC,  Up: Top

GNU Extensions to the C Language
********************************

   GNU C provides several language features not found in ANSI standard
C. (The `-pedantic' option directs GNU CC to print a warning message if
any of these features is used.)  To test for the availability of these
features in conditional compilation, check for a predefined macro
`__GNUC__', which is always defined under GNU CC.

* Menu:

* Statement Exprs::     Putting statements and declarations inside expressions.
* Local Labels::        Labels local to a statement-expression.
* Labels as Values::    Getting pointers to labels, and computed gotos.
* Nested Functions::    As in Algol and Pascal, lexical scoping of functions.
* Naming Types::        Giving a name to the type of some expression.
* Typeof::              `typeof': referring to the type of an expression.
* Lvalues::             Using `?:', `,' and casts in lvalues.
* Conditionals::        Omitting the middle operand of a `?:' expression.
* Long Long::		Double-word integers--`long long int'.
* Zero Length::         Zero-length arrays.
* Variable Length::     Arrays whose length is computed at run time.
* Macro Varargs::	Macros with variable number of arguments.
* Subscripting::        Any array can be subscripted, even if not an lvalue.
* Pointer Arith::       Arithmetic on `void'-pointers and function pointers.
* Initializers::        Non-constant initializers.
* Constructors::        Constructor expressions give structures, unions
                         or arrays as values.
* Labeled Elements::	Labeling elements of initializers.
* Cast to Union::       Casting to union type from any member of the union.
* Case Ranges::		`case 1 ... 9' and such.
* Function Attributes:: Declaring that functions have no side effects,
                         or that they can never return.
* Function Prototypes:: Prototype declarations and old-style definitions.
* Section Declarations:: Declaring section names explicitly
* Interrupt Functions:: Compiling functions for interrupt calls
* Dollar Signs::        Dollar sign is allowed in identifiers.
* Character Escapes::   `\e' stands for the character ESC.
* Variable Attributes::	Specifying attributes of variables.
* Alignment::           Inquiring about the alignment of a type or variable.
* Inline::              Defining inline functions (as fast as macros).
* Extended Asm::        Assembler instructions with C expressions as operands.
                         (With them you can define "built-in" functions.)
* Asm Labels::          Specifying the assembler name to use for a C symbol.
* Explicit Reg Vars::   Defining variables residing in specified registers.
* Alternate Keywords::  `__const__', `__asm__', etc., for header files.
* Incomplete Enums::    `enum foo;', with details to follow.


File: usegcc.i,  Node: Statement Exprs,  Next: Local Labels,  Up: Extensions

Statements and Declarations within Expressions
==============================================

   A compound statement enclosed in parentheses may appear as an
expression in GNU C.  This allows you to use loops, switches, and local
variables within an expression.

   Recall that a compound statement is a sequence of statements
surrounded by braces; in this construct, parentheses go around the
braces.  For example:

     ({ int y = foo (); int z;
        if (y > 0) z = y;
        else z = - y;
        z; })

is a valid (though slightly more complex than necessary) expression for
the absolute value of `foo ()'.

   The last thing in the compound statement should be an expression
followed by a semicolon; the value of this subexpression serves as the
value of the entire construct.  (If you use some other kind of statement
last within the braces, the construct has type `void', and thus
effectively no value.)

   This feature is especially useful in making macro definitions "safe"
(so that they evaluate each operand exactly once).  For example, the
"maximum" function is commonly defined as a macro in standard C as
follows:

     #define max(a,b) ((a) > (b) ? (a) : (b))

But this definition computes either A or B twice, with bad results if
the operand has side effects.  In GNU C, if you know the type of the
operands (here let's assume `int'), you can define the macro safely as
follows:

     #define maxint(a,b) \
       ({int _a = (a), _b = (b); _a > _b ? _a : _b; })

   Embedded statements are not allowed in constant expressions, such as
the value of an enumeration constant, the width of a bit field, or the
initial value of a static variable.

   If you don't know the type of the operand, you can still do this,
but you must use `typeof' (*note Typeof::.) or type naming (*note
Naming Types::.).


File: usegcc.i,  Node: Local Labels,  Next: Labels as Values,  Prev: Statement Exprs,  Up: Extensions

Locally Declared Labels
=======================

   Each statement expression is a scope in which "local labels" can be
declared.  A local label is simply an identifier; you can jump to it
with an ordinary `goto' statement, but only from within the statement
expression it belongs to.

   A local label declaration looks like this:

     __label__ LABEL;

or

     __label__ LABEL1, LABEL2, ...;

   Local label declarations must come at the beginning of the statement
expression, right after the `({', before any ordinary declarations.

   The label declaration defines the label *name*, but does not define
the label itself.  You must do this in the usual way, with `LABEL:',
within the statements of the statement expression.

   The local label feature is useful because statement expressions are
often used in macros.  If the macro contains nested loops, a `goto' can
be useful for breaking out of them.  However, an ordinary label whose
scope is the whole function cannot be used: if the macro can be
expanded several times in one function, the label will be multiply
defined in that function.  A local label avoids this problem.  For
example:

     #define SEARCH(array, target)                     \
     ({                                               \
       __label__ found;                                \
       typeof (target) _SEARCH_target = (target);      \
       typeof (*(array)) *_SEARCH_array = (array);     \
       int i, j;                                       \
       int value;                                      \
       for (i = 0; i < max; i++)                       \
         for (j = 0; j < max; j++)                     \
           if (_SEARCH_array[i][j] == _SEARCH_target)  \
             { value = i; goto found; }              \
       value = -1;                                     \
      found:                                           \
       value;                                          \
     })


File: usegcc.i,  Node: Labels as Values,  Next: Nested Functions,  Prev: Local Labels,  Up: Extensions

Labels as Values
================

   You can get the address of a label defined in the current function
(or a containing function) with the unary operator `&&'.  The value has
type `void *'.  This value is a constant and can be used wherever a
constant of that type is valid.  For example:

     void *ptr;
     ...
     ptr = &&foo;

   To use these values, you need to be able to jump to one.  This is
done with the computed goto statement(1), `goto *EXP;'.  For example,

     goto *ptr;

Any expression of type `void *' is allowed.

   One way of using these constants is in initializing a static array
that will serve as a jump table:

     static void *array[] = { &&foo, &&bar, &&hack };

   Then you can select a label with indexing, like this:

     goto *array[i];

Note that this does not check whether the subscript is in bounds--array
indexing in C never does that.

   Such an array of label values serves a purpose much like that of the
`switch' statement.  The `switch' statement is cleaner, so use that
rather than an array unless the problem does not fit a `switch'
statement very well.

   Another use of label values is in an interpreter for threaded code.
The labels within the interpreter function can be stored in the
threaded code for super-fast dispatching.

   You can use this mechanism to jump to code in a different function. 
If you do that, totally unpredictable things will happen.  The best way
to avoid this is to store the label address only in automatic variables
and never pass it as an argument.

   ---------- Footnotes ----------

   (1)  The analogous feature in Fortran is called an assigned goto,
but that name seems inappropriate in C, where one can do more than
simply store label addresses in label variables.


File: usegcc.i,  Node: Nested Functions,  Next: Naming Types,  Prev: Labels as Values,  Up: Extensions

Nested Functions
================

   A "nested function" is a function defined inside another function.
The nested function's name is local to the block where it is defined.
For example, here we define a nested function named `square', and call
it twice:

     foo (double a, double b)
     {
       double square (double z) { return z * z; }
     
       return square (a) + square (b);
     }

   The nested function can access all the variables of the containing
function that are visible at the point of its definition.  This is
called "lexical scoping".  For example, here we show a nested function
which uses an inherited variable named `offset':

     bar (int *array, int offset, int size)
     {
       int access (int *array, int index)
         { return array[index + offset]; }
       int i;
       ...
       for (i = 0; i < size; i++)
         ... access (array, i) ...
     }

   It is possible to call the nested function from outside the scope of
its name by storing its address or passing the address to another
function:

     hack (int *array, int size)
     {
       void store (int index, int value)
         { array[index] = value; }
     
       intermediate (store, size);
     }

   Here, the function `intermediate' receives the address of `store' as
an argument.  If `intermediate' calls `store', the arguments given to
`store' are used to store into `array'.  But this technique works only
so long as the containing function (`hack', in this example) does not
exit.  If you try to call the nested function through its address after
the containing function has exited, all hell will break loose.

   A nested function can jump to a label inherited from a containing
function, provided the label was explicitly declared in the containing
function (*note Local Labels::.).  Such a jump returns instantly to the
containing function, exiting the nested function which did the `goto'
and any intermediate functions as well.  Here is an example:

     bar (int *array, int offset, int size)
     {
       __label__ failure;
       int access (int *array, int index)
         {
           if (index > size)
             goto failure;
           return array[index + offset];
         }
       int i;
       ...
       for (i = 0; i < size; i++)
         ... access (array, i) ...
       ...
       return 0;
     
      /* Control comes here from `access'
         if it detects an error.  */
      failure:
       return -1;
     }

   A nested function always has internal linkage.  Declaring one with
`extern' is erroneous.  If you need to declare the nested function
before its definition, use `auto' (which is otherwise meaningless for
function declarations).

     bar (int *array, int offset, int size)
     {
       __label__ failure;
       auto int access (int *, int);
       ...
       int access (int *array, int index)
         {
           if (index > size)
             goto failure;
           return array[index + offset];
         }
       ...
     }


File: usegcc.i,  Node: Naming Types,  Next: Typeof,  Prev: Nested Functions,  Up: Extensions

Naming an Expression's Type
===========================

   You can give a name to the type of an expression using a `typedef'
declaration with an initializer.  Here is how to define NAME as a type
name for the type of EXP:

     typedef NAME = EXP;

   This is useful in conjunction with the statements-within-expressions
feature.  Here is how the two together can be used to define a safe
"maximum" macro that operates on any arithmetic type:

     #define max(a,b) \
       ({typedef _ta = (a), _tb = (b);  \
         _ta _a = (a); _tb _b = (b);     \
         _a > _b ? _a : _b; })

   The reason for using names that start with underscores for the local
variables is to avoid conflicts with variable names that occur within
the expressions that are substituted for `a' and `b'.  Eventually we
hope to design a new form of declaration syntax that allows you to
declare variables whose scopes start only after their initializers;
this will be a more reliable way to prevent such conflicts.


File: usegcc.i,  Node: Typeof,  Next: Lvalues,  Prev: Naming Types,  Up: Extensions

Referring to a Type with `typeof'
=================================

   Another way to refer to the type of an expression is with `typeof'.
The syntax of using of this keyword looks like `sizeof', but the
construct acts semantically like a type name defined with `typedef'.

   There are two ways of writing the argument to `typeof': with an
expression or with a type.  Here is an example with an expression:

     typeof (x[0](1))

This assumes that `x' is an array of functions; the type described is
that of the values of the functions.

   Here is an example with a typename as the argument:

     typeof (int *)

Here the type described is that of pointers to `int'.

   If you are writing a header file that must work when included in
ANSI C programs, write `__typeof__' instead of `typeof'. *Note
Alternate Keywords::.

   A `typeof'-construct can be used anywhere a typedef name could be
used.  For example, you can use it in a declaration, in a cast, or
inside of `sizeof' or `typeof'.

   * This declares `y' with the type of what `x' points to.

          typeof (*x) y;

   * This declares `y' as an array of such values.

          typeof (*x) y[4];

   * This declares `y' as an array of pointers to characters:

          typeof (typeof (char *)[4]) y;

     It is equivalent to the following traditional C declaration:

          char *y[4];

     To see the meaning of the declaration using `typeof', and why it
     might be a useful way to write, let's rewrite it with these macros:

          #define pointer(T)  typeof(T *)
          #define array(T, N) typeof(T [N])

     Now the declaration can be rewritten this way:

          array (pointer (char), 4) y;

     Thus, `array (pointer (char), 4)' is the type of arrays of 4
     pointers to `char'.


File: usegcc.i,  Node: Lvalues,  Next: Conditionals,  Prev: Typeof,  Up: Extensions

Generalized Lvalues
===================

   Compound expressions, conditional expressions and casts are allowed
as lvalues provided their operands are lvalues.  This means that you
can take their addresses or store values into them.

   For example, a compound expression can be assigned, provided the last
expression in the sequence is an lvalue.  These two expressions are
equivalent:

     (a, b) += 5
     a, (b += 5)

   Similarly, the address of the compound expression can be taken. 
These two expressions are equivalent:

     &(a, b)
     a, &b

   A conditional expression is a valid lvalue if its type is not void
and the true and false branches are both valid lvalues.  For example,
these two expressions are equivalent:

     (a ? b : c) = 5
     (a ? b = 5 : (c = 5))

   A cast is a valid lvalue if its operand is an lvalue.  A simple
assignment whose left-hand side is a cast works by converting the
right-hand side first to the specified type, then to the type of the
inner left-hand side expression.  After this is stored, the value is
converted back to the specified type to become the value of the
assignment.  Thus, if `a' has type `char *', the following two
expressions are equivalent:

     (int)a = 5
     (int)(a = (char *)(int)5)

   An assignment-with-arithmetic operation such as `+=' applied to a
cast performs the arithmetic using the type resulting from the cast,
and then continues as in the previous case.  Therefore, these two
expressions are equivalent:

     (int)a += 5
     (int)(a = (char *)(int) ((int)a + 5))

   You cannot take the address of an lvalue cast, because the use of its
address would not work out coherently.  Suppose that `&(int)f' were
permitted, where `f' has type `float'.  Then the following statement
would try to store an integer bit-pattern where a floating point number
belongs:

     *&(int)f = 1;

   This is quite different from what `(int)f = 1' would do--that would
convert 1 to floating point and store it.  Rather than cause this
inconsistency, we think it is better to prohibit use of `&' on a cast.

   If you really do want an `int *' pointer with the address of `f',
you can simply write `(int *)&f'.


File: usegcc.i,  Node: Conditionals,  Next: Long Long,  Prev: Lvalues,  Up: Extensions

Conditional Expressions with Omitted Operands
=============================================

   The middle operand in a conditional expression may be omitted.  Then
if the first operand is nonzero, its value is the value of the
conditional expression.

   Therefore, the expression

     x ? : y

has the value of `x' if that is nonzero; otherwise, the value of `y'.

   This example is perfectly equivalent to

     x ? x : y

In this simple case, the ability to omit the middle operand is not
especially useful.  When it becomes useful is when the first operand
does, or may (if it is a macro argument), contain a side effect.  Then
repeating the operand in the middle would perform the side effect
twice.  Omitting the middle operand uses the value already computed
without the undesirable effects of recomputing it.


File: usegcc.i,  Node: Long Long,  Next: Zero Length,  Prev: Conditionals,  Up: Extensions

Double-Word Integers
====================

   GNU C supports data types for integers that are twice as long as
`long int'.  Simply write `long long int' for a signed integer, or
`unsigned long long int' for an unsigned integer.

   You can use these types in arithmetic like any other integer types.
Addition, subtraction, and bitwise boolean operations on these types
are open-coded on all types of machines.  Multiplication is open-coded
if the machine supports fullword-to-doubleword a widening multiply
instruction.  Division and shifts are open-coded only on machines that
provide special support.  The operations that are not open-coded use
special library routines that come with GNU CC.

   There may be pitfalls when you use `long long' types for function
arguments, unless you declare function prototypes.  If a function
expects type `int' for its argument, and you pass a value of type `long
long int', confusion will result because the caller and the subroutine
will disagree about the number of bytes for the argument. Likewise, if
the function expects `long long int' and you pass `int'.  The best way
to avoid such problems is to use prototypes.


File: usegcc.i,  Node: Zero Length,  Next: Variable Length,  Prev: Long Long,  Up: Extensions

Arrays of Length Zero
=====================

   Zero-length arrays are allowed in GNU C.  They are very useful as
the last element of a structure which is really a header for a
variable-length object:

     struct line {
       int length;
       char contents[0];
     };
     
     {
       struct line *thisline = (struct line *)
         malloc (sizeof (struct line) + this_length);
       thisline->length = this_length;
     }

   In standard C, you would have to give `contents' a length of 1, which
means either you waste space or complicate the argument to `malloc'.


File: usegcc.i,  Node: Variable Length,  Next: Macro Varargs,  Prev: Zero Length,  Up: Extensions

Arrays of Variable Length
=========================

   Variable-length automatic arrays are allowed in GNU C.  These arrays
are declared like any other automatic arrays, but with a length that is
not a constant expression.  The storage is allocated at the point of
declaration and deallocated when the brace-level is exited.  For
example:

     FILE *
     concat_fopen (char *s1, char *s2, char *mode)
     {
       char str[strlen (s1) + strlen (s2) + 1];
       strcpy (str, s1);
       strcat (str, s2);
       return fopen (str, mode);
     }

   Jumping or breaking out of the scope of the array name deallocates
the storage.  Jumping into the scope is not allowed; you get an error
message for it.

   You can use the function `alloca' to get an effect much like
variable-length arrays.  The function `alloca' is available in many
other C implementations (but not in all).  On the other hand,
variable-length arrays are more elegant.

   There are other differences between these two methods.  Space
allocated with `alloca' exists until the containing *function* returns.
The space for a variable-length array is deallocated as soon as the
array name's scope ends.  (If you use both variable-length arrays and
`alloca' in the same function, deallocation of a variable-length array
will also deallocate anything more recently allocated with `alloca'.)

   You can also use variable-length arrays as arguments to functions:

     struct entry
     tester (int len, char data[len][len])
     {
       ...
     }

   The length of an array is computed once when the storage is allocated
and is remembered for the scope of the array in case you access it with
`sizeof'.

   If you want to pass the array first and the length afterward, you can
use a forward declaration in the parameter list--another GNU extension.

     struct entry
     tester (int len; char data[len][len], int len)
     {
       ...
     }

   The `int len' before the semicolon is a "parameter forward
declaration", and it serves the purpose of making the name `len' known
when the declaration of `data' is parsed.

   You can write any number of such parameter forward declarations in
the parameter list.  They can be separated by commas or semicolons, but
the last one must end with a semicolon, which is followed by the "real"
parameter declarations.  Each forward declaration must match a "real"
declaration in parameter name and data type.


File: usegcc.i,  Node: Macro Varargs,  Next: Subscripting,  Prev: Variable Length,  Up: Extensions

Macros with Variable Numbers of Arguments
=========================================

   In GNU C, a macro can accept a variable number of arguments, much as
a function can.  The syntax for defining the macro looks much like that
used for a function.  Here is an example:

     #define eprintf(format, args...)  \
      fprintf (stderr, format, ## args)

   Here `args' is a "rest argument": it takes in zero or more
arguments, as many as the call contains.  All of them plus the commas
between them form the value of `args', which is substituted into the
macro body where `args' is used.  Thus, we have these expansions:

     eprintf ("%s:%d: ", input_file_name, line_number)
     ==>
     fprintf (stderr, "%s:%d: ", input_file_name, line_number)

Note that the comma after the string constant comes from the definition
of `eprintf', whereas the last comma comes from the value of `args'.

   The reason for using `##' is to handle the case when `args' matches
no arguments at all.  In this case, `args' has an empty value.  In this
case, the second comma in the definition becomes an embarrassment: if
it got through to the expansion of the macro, we would get something
like this:

     fprintf (stderr, "success!\n", )

which is invalid C syntax.  `##' gets rid of the comma, so we get the
following instead:

     fprintf (stderr, "success!\n")

   This is a special feature of the GNU C preprocessor: `##' adjacent
to a rest argument discards the token on the other side of the `##', if
the rest argument value is empty.


File: usegcc.i,  Node: Subscripting,  Next: Pointer Arith,  Prev: Macro Varargs,  Up: Extensions

Non-Lvalue Arrays May Have Subscripts
=====================================

   Subscripting is allowed on arrays that are not lvalues, even though
the unary `&' operator is not.  For example, this is valid in GNU C
though not valid in other C dialects:

     struct foo {int a[4];};
     
     struct foo f();
     
     bar (int index)
     {
       return f().a[index];
     }


File: usegcc.i,  Node: Pointer Arith,  Next: Initializers,  Prev: Subscripting,  Up: Extensions

Arithmetic on `void'- and Function-Pointers
===========================================

   In GNU C, addition and subtraction operations are supported on
pointers to `void' and on pointers to functions.  This is done by
treating the size of a `void' or of a function as 1.

   A consequence of this is that `sizeof' is also allowed on `void' and
on function types, and returns 1.

   The option `-Wpointer-arith' requests a warning if these extensions
are used.


File: usegcc.i,  Node: Initializers,  Next: Constructors,  Prev: Pointer Arith,  Up: Extensions

Non-Constant Initializers
=========================

   The elements of an aggregate initializer for an automatic variable
are not required to be constant expressions in GNU C.  Here is an
example of an initializer with run-time varying elements:

     foo (float f, float g)
     {
       float beat_freqs[2] = { f-g, f+g };
       ...
     }


File: usegcc.i,  Node: Constructors,  Next: Labeled Elements,  Prev: Initializers,  Up: Extensions

Constructor Expressions
=======================

   GNU C supports constructor expressions.  A constructor looks like a
cast containing an initializer.  Its value is an object of the type
specified in the cast, containing the elements specified in the
initializer.

   Usually, the specified type is a structure.  Assume that `struct
foo' and `structure' are declared as shown:

     struct foo {int a; char b[2];} structure;

Here is an example of constructing a `struct foo' with a constructor:

     structure = ((struct foo) {x + y, 'a', 0});

This is equivalent to writing the following:

     {
       struct foo temp = {x + y, 'a', 0};
       structure = temp;
     }

   You can also construct an array.  If all the elements of the
constructor are (made up of) simple constant expressions, suitable for
use in initializers, then the constructor is an lvalue and can be
coerced to a pointer to its first element, as shown here:

     char **foo = (char *[]) { "x", "y", "z" };

   Array constructors whose elements are not simple constants are not
very useful, because the constructor is not an lvalue.  There are only
two valid ways to use it: to subscript it, or initialize an array
variable with it.  The former is probably slower than a `switch'
statement, while the latter does the same thing an ordinary C
initializer would do.  Here is an example of subscripting an array
constructor:

     output = ((int[]) { 2, x, 28 }) [input];

   Constructor expressions for scalar types and union types are is also
allowed, but then the constructor expression is equivalent to a cast.


File: usegcc.i,  Node: Labeled Elements,  Next: Cast to Union,  Prev: Constructors,  Up: Extensions

Labeled Elements in Initializers
================================

   Standard C requires the elements of an initializer to appear in a
fixed order, the same as the order of the elements in the array or
structure being initialized.

   In GNU C you can give the elements in any order, specifying the array
indices or structure field names they apply to.

   To specify an array index, write `[INDEX]' before the element value.
 For example,

     int a[6] = { [4] 29, [2] 15 };

is equivalent to

     int a[6] = { 0, 0, 15, 0, 29, 0 };

The index values must be constant expressions, even if the array being
initialized is automatic.

   In a structure initializer, specify the name of a field to initialize
with `FIELDNAME:' before the element value.  For example, given the
following structure,

     struct point { int x, y; };

the following initialization

     struct point p = { y: yvalue, x: xvalue };

is equivalent to

     struct point p = { xvalue, yvalue };

   You can also use an element label when initializing a union, to
specify which element of the union should be used.  For example,

     union foo { int i; double d; };
     
     union foo f = { d: 4 };

will convert 4 to a `double' to store it in the union using the second
element.  By contrast, casting 4 to type `union foo' would store it
into the union as the integer `i', since it is an integer.  (*Note Cast
to Union::.)

   You can combine this technique of naming elements with ordinary C
initialization of successive elements.  Each initializer element that
does not have a label applies to the next consecutive element of the
array or structure.  For example,

     int a[6] = { [1] v1, v2, [4] v4 };

is equivalent to

     int a[6] = { 0, v1, v2, 0, v4, 0 };

   Labeling the elements of an array initializer is especially useful
when the indices are characters or belong to an `enum' type. For
example:

     int whitespace[256]
       = { [' '] 1, ['\t'] 1, ['\h'] 1,
           ['\f'] 1, ['\n'] 1, ['\r'] 1 };


File: usegcc.i,  Node: Case Ranges,  Next: Function Attributes,  Prev: Cast to Union,  Up: Extensions

Case Ranges
===========

   You can specify a range of consecutive values in a single `case'
label, like this:

     case LOW ... HIGH:

This has the same effect as the proper number of individual `case'
labels, one for each integer value from LOW to HIGH, inclusive.

   This feature is especially useful for ranges of ASCII character
codes:

     case 'A' ... 'Z':

   *Be careful:* Write spaces around the `...', for otherwise it may be
parsed wrong when you use it with integer values.  For example, write
this:

     case 1 ... 5:

rather than this:

     case 1...5:


File: usegcc.i,  Node: Cast to Union,  Next: Case Ranges,  Prev: Labeled Elements,  Up: Extensions

Cast to a Union Type
====================

   A cast to union type is like any other cast, except that the type
specified is a union type.  You can specify the type either with `union
TAG' or with a typedef name.

   The types that may be cast to the union type are those of the members
of the union.  Thus, given the following union and variables:

     union foo { int i; double d; };
     int x;
     double y;

both `x' and `y' can be cast to type `union' foo.

   Using the cast as the right-hand side of an assignment to a variable
of union type is equivalent to storing in a member of the union:

     union foo u;
     ...
     u = (union foo) x  ==  u.i = x
     u = (union foo) y  ==  u.d = y

   You can also use the union cast as a function argument:

     void hack (union foo);
     ...
     hack ((union foo) x);


File: usegcc.i,  Node: Function Attributes,  Next: Function Prototypes,  Prev: Case Ranges,  Up: Extensions

Declaring Attributes of Functions
=================================

   In GNU C, you declare certain things about functions called in your
program which help the compiler optimize function calls.

   A few standard library functions, such as `abort' and `exit', cannot
return.  GNU CC knows this automatically.  Some programs define their
own functions that never return.  You can declare them `volatile' to
tell the compiler this fact.  For example,

     extern void volatile fatal ();
     
     void
     fatal (...)
     {
       ... /* Print error message. */ ...
       exit (1);
     }

   The `volatile' keyword tells the compiler to assume that `fatal'
cannot return.  This makes slightly better code, but more importantly
it helps avoid spurious warnings of uninitialized variables.

   It does not make sense for a `volatile' function to have a return
type other than `void'.

   Many functions do not examine any values except their arguments, and
have no effects except the return value.  Such a function can be subject
to common subexpression elimination and loop optimization just as an
arithmetic operator would be.  These functions should be declared
`const'.  For example,

     extern int const square ();

says that the hypothetical function `square' is safe to call fewer
times than the program says.

   Note that a function that has pointer arguments and examines the data
pointed to must *not* be declared `const'.  Likewise, a function that
calls a non-`const' function usually must not be `const'.  It does not
make sense for a `const' function to return `void'.

   We recommend placing the keyword `const' after the function's return
type.  It makes no difference in the example above, but when the return
type is a pointer, it is the only way to make the function itself
const.  For example,

     const char *mincp (int);

says that `mincp' returns `const char *'--a pointer to a const object. 
To declare `mincp' const, you must write this:

     char * const mincp (int);

   Some people object to this feature, suggesting that ANSI C's
`#pragma' should be used instead.  There are two reasons for not doing
this.

  1. It is impossible to generate `#pragma' commands from a macro.

  2. The `#pragma' command is just as likely as these keywords to mean
     something else in another compiler.

   These two reasons apply to almost any application that might be
proposed for `#pragma'.  It is basically a mistake to use `#pragma' for
*anything*.


File: usegcc.i,  Node: Function Prototypes,  Next: Section Declarations,  Prev: Function Attributes,  Up: Extensions

Prototypes and Old-Style Function Definitions
=============================================

   GNU C extends ANSI C to allow a function prototype to override a
later old-style non-prototype definition.  Consider the following
example:

     /* Use prototypes unless the compiler is old-fashioned.  */
     #if __STDC__
     #define P((x)) (x)
     #else
     #define P((x)) ()
     #endif
     
     /* Prototype function declaration.  */
     int isroot P((uid_t));
     
     /* Old-style function definition.  */
     int
     isroot (x)   /* ??? lossage here ??? */
          uid_t x;
     {
       return x == 0;
     }

   Suppose the type `uid_t' happens to be `short'.  ANSI C does not
allow this example, because subword arguments in old-style
non-prototype definitions are promoted.  Therefore in this example the
function definition's argument is really an `int', which does not match
the prototype argument type of `short'.

   This restriction of ANSI C makes it hard to write code that is
portable to traditional C compilers, because the programmer does not
know whether the `uid_t' type is `short', `int', or `long'.  Therefore,
in cases like these GNU C allows a prototype to override a later
old-style definition.  More precisely, in GNU C, a function prototype
argument type overrides the argument type specified by a later
old-style definition if the former type is the same as the latter type
before promotion.  Thus in GNU C the above example is equivalent to the
following:

     int isroot (uid_t);
     
     int
     isroot (uid_t x)
     {
       return x == 0;
     }


File: usegcc.i,  Node: Section Declarations,  Next: Interrupt Functions,  Prev: Function Prototypes,  Up: Extensions

Declaring Section Names Explicitly
==================================

   Normally, the compiler places the code it generates from your source
in one of three sections--for example, `text', `data', and `bss'. 
Sometimes, however, you need additional sections, or you need certain
particular objects to appear in special sections--for example, sections
that map to special hardware.

   In the Cygnus Support version of GNU C, you can use the qualifier
`__section__("NAME")' with any definition, to specify that the object
you are defining should go in section NAME.  For example, this small
program uses several specific section names:

     __section__ ("DUART_A") struct duart a;
     __section__ ("DUART_B") struct duart b;
     __section__ ("STACK")   char stack[10000];
     __section__ ("INITDATACOPY") int init_data_copy;
     
     
     main()
     {
     /* Initialize stack pointer */
      init_sp(stack + sizeof(stack));
     
     /* Initialize initialized data */
      memcpy(&init_data_copy, &data, &edata - &data);
     
     /* Turn on the serial ports */
      init_duart(&a);
      init_duart(&b);
     }

For some machine configurations, you may need to use `__section__' in
declarations, matching the section name you used in the definition
itself.

   If you need to map the entire contents of a module to a particular
section, consider using the facilities of the GNU linker instead. *Note
Overview: (ld.info)Overview.


File: usegcc.i,  Node: Interrupt Functions,  Next: Dollar Signs,  Prev: Section Declarations,  Up: Extensions

Compiling Functions for Interrupt Calls
=======================================

   When compiling code for certain platforms (currently the Hitachi
H8/300 and the Tandem ST-2000), you can instruct GCC that certain
functions are meant to be called from hardware interrupts.

   To mark a function as callable from interrupt, include the line
`#pragma interrupt' somewhere before the beginning of the function's
definition.  (For maximum readability, you might place it immediately
before the definition of the appropriate function.) `#pragma interrupt'
will affect only the next function defined; if you want to define more
than one function with this property, include `#pragma interrupt'
before each of them.

   When you define a function with `#pragma interrupt', GCC alters its
usual calling convention, to provide the right environment when the
function is called from an interrupt.  *Such functions cannot be called
in the usual way from your program*.

   You must use other facilities to actually associate these functions
with particular interrupts; GCC can only compile them in the
appropriate way.


File: usegcc.i,  Node: Dollar Signs,  Next: Character Escapes,  Prev: Interrupt Functions,  Up: Extensions

Dollar Signs in Identifier Names
================================

   In GNU C, you may use dollar signs in identifier names.  This is
because many traditional C implementations allow such identifiers.

   Dollar signs are allowed on certain machines if you specify
`-traditional'.  On a few systems they are allowed by default, even if
`-traditional' is not used.  But they are never allowed if you specify
`-ansi'.

   There are certain ANSI C programs (obscure, to be sure) that would
compile incorrectly if dollar signs were permitted in identifiers.  For
example:

     #define foo(a) #a
     #define lose(b) foo (b)
     #define test$
     lose (test)


File: usegcc.i,  Node: Character Escapes,  Next: Variable Attributes,  Prev: Dollar Signs,  Up: Extensions

The Character ESC in Constants
==============================

   You can use the sequence `\e' in a string or character constant to
stand for the ASCII character ESC.


File: usegcc.i,  Node: Alignment,  Next: Inline,  Prev: Variable Attributes,  Up: Extensions

Inquiring on Alignment of Types or Variables
============================================

   The keyword `__alignof__' allows you to inquire about how an object
is aligned, or the minimum alignment usually required by a type.  Its
syntax is just like `sizeof'.

   For example, if the target machine requires a `double' value to be
aligned on an 8-byte boundary, then `__alignof__ (double)' is 8. This
is true on many RISC machines.  On more traditional machine designs,
`__alignof__ (double)' is 4 or even 2.

   Some machines never actually require alignment; they allow reference
to any data type even at an odd addresses.  For these machines,
`__alignof__' reports the *recommended* alignment of a type.

   When the operand of `__alignof__' is an lvalue rather than a type,
the value is the largest alignment that the lvalue is known to have. 
It may have this alignment as a result of its data type, or because it
is part of a structure and inherits alignment from that structure. For
example, after this declaration:

     struct foo { int x; char y; } foo1;

the value of `__alignof__ (foo1.y)' is probably 2 or 4, the same as
`__alignof__ (int)', even though the data type of `foo1.y' does not
itself demand any alignment.


File: usegcc.i,  Node: Variable Attributes,  Next: Alignment,  Prev: Character Escapes,  Up: Extensions

Specifying Attributes of Variables
==================================

   The keyword `__attribute__' allows you to specify special attributes
of variables or structure fields.  The only attributes currently
defined are the `aligned' and `format' attributes.

   The `aligned' attribute specifies the alignment of the variable or
structure field.  For example, the declaration:

     int x __attribute__ ((aligned (16))) = 0;

causes the compiler to allocate the global variable `x' on a 16-byte
boundary.  On a 68000, this could be used in conjunction with an `asm'
expression to access the `move16' instruction which requires 16-byte
aligned operands.

   You can also specify the alignment of structure fields.  For
example, to create a double-word aligned `int' pair, you could write:

     struct foo { int x[2] __attribute__ ((aligned (8))); };

This is an alternative to creating a union with a `double' member that
forces the union to be double-word aligned.

   It is not possible to specify the alignment of functions; the
alignment of functions is determined by the machine's requirements and
cannot be changed.  You cannot specify alignment for a typedef name
because such a name is just an alias, not a distinct type.

   The `format' attribute specifies that a function takes `printf' or
`scanf' style arguments which should be type-checked against a format
string.  For example, the declaration:

     extern int
     my_printf (void *my_object, const char *my_format, ...)
           __attribute__ ((format (printf, 2, 3)));

causes the compiler to check the arguments in calls to `my_printf' for
consistency with the `printf' style format string argument `my_format'.

   The first parameter of the `format' attribute determines how the
format string is interpreted, and should be either `printf' or `scanf'.
 The second parameter specifies the number of the format string
argument (starting from 1).  The third parameter specifies the number
of the first argument which should be checked against the format
string.  For functions where the arguments are not available to be
checked (such as `vprintf'), specify the third parameter as zero.  In
this case the compiler only checks the format string for consistency.

   In the example above, the format string (`my_format') is the second
argument to `my_print' and the arguments to check start with the third
argument, so the correct parameters for the format attribute are 2 and
3.

   The `format' attribute allows you to identify your own functions
which take format strings as arguments, so that GNU CC can check the
calls to these functions for errors.  The compiler always checks
formats for the ANSI library functions `printf', `fprintf', `sprintf',
`scanf', `fscanf', `sscanf', `vprintf', `vfprintf' and `vsprintf'
whenever such warnings are requested (using `-Wformat'), so there is no
need to modify the header file `stdio.h'.


File: usegcc.i,  Node: Inline,  Next: Extended Asm,  Prev: Alignment,  Up: Extensions

An Inline Function is As Fast As a Macro
========================================

   By declaring a function `inline', you can direct GNU CC to integrate
that function's code into the code for its callers.  This makes
execution faster by eliminating the function-call overhead; in
addition, if any of the actual argument values are constant, their
known values may permit simplifications at compile time so that not all
of the inline function's code needs to be included.

   To declare a function inline, use the `inline' keyword in its
declaration, like this:

     inline int
     inc (int *a)
     {
       (*a)++;
     }

   (If you are writing a header file to be included in ANSI C programs,
write `__inline__' instead of `inline'.  *Note Alternate Keywords::.)

   You can also make all "simple enough" functions inline with the
option `-finline-functions'.  Note that certain usages in a function
definition can make it unsuitable for inline substitution.

   When a function is both inline and `static', if all calls to the
function are integrated into the caller, and the function's address is
never used, then the function's own assembler code is never referenced.
In this case, GNU CC does not actually output assembler code for the
function, unless you specify the option `-fkeep-inline-functions'. Some
calls cannot be integrated for various reasons (in particular, calls
that precede the function's definition cannot be integrated, and
neither can recursive calls within the definition).  If there is a
nonintegrated call, then the function is compiled to assembler code as
usual.  The function must also be compiled as usual if the program
refers to its address, because that can't be inlined.

   When an inline function is not `static', then the compiler must
assume that there may be calls from other source files; since a global
symbol can be defined only once in any program, the function must not
be defined in the other source files, so the calls therein cannot be
integrated. Therefore, a non-`static' inline function is always
compiled on its own in the usual fashion.

   If you specify both `inline' and `extern' in the function
definition, then the definition is used only for inlining.  In no case
is the function compiled on its own, not even if you refer to its
address explicitly.  Such an address becomes an external reference, as
if you had only declared the function, and had not defined it.

   This combination of `inline' and `extern' has almost the effect of a
macro.  The way to use it is to put a function definition in a header
file with these keywords, and put another copy of the definition
(lacking `inline' and `extern') in a library file. The definition in
the header file will cause most calls to the function to be inlined. 
If any uses of the function remain, they will refer to the single copy
in the library.


File: usegcc.i,  Node: Extended Asm,  Next: Asm Labels,  Prev: Inline,  Up: Extensions

Assembler Instructions with C Expression Operands
=================================================

   In an assembler instruction using `asm', you can now specify the
operands of the instruction using C expressions.  This means no more
guessing which registers or memory locations will contain the data you
want to use.

   You must specify an assembler instruction template much like what
appears in a machine description, plus an operand constraint string for
each operand.

   For example, here is how to use the 68881's `fsinx' instruction:

     asm ("fsinx %1,%0" : "=f" (result) : "f" (angle));

Here `angle' is the C expression for the input operand while `result'
is that of the output operand.  Each has `"f"' as its operand
constraint, saying that a floating point register is required.  The `='
in `=f' indicates that the operand is an output; all output operands'
constraints must use `='.  The constraints use the same language used
in the machine description (*note Operand Constraints:
(gcc.info)Constraints.).

Each operand is described by an operand-constraint string followed by
the C expression in parentheses.  A colon separates the assembler
template from the first output operand, and another separates the last
output operand from the first input, if any.  Commas separate output
operands and separate inputs.  The total number of operands is limited
to ten or to the maximum number of operands in any instruction pattern
in the machine description, whichever is greater.

   If there are no output operands, and there are input operands, then
there must be two consecutive colons surrounding the place where the
output operands would go.

   Output operand expressions must be lvalues; the compiler can check
this. The input operands need not be lvalues.  The compiler cannot
check whether the operands have data types that are reasonable for the
instruction being executed.  It does not parse the assembler
instruction template and does not know what it means, or whether it is
valid assembler input.  The extended `asm' feature is most often used
for machine instructions that the compiler itself does not know exist.

   The output operands must be write-only; GNU CC will assume that the
values in these operands before the instruction are dead and need not be
generated.  Extended asm does not support input-output or read-write
operands.  For this reason, the constraint character `+', which
indicates such an operand, may not be used.

   When the assembler instruction has a read-write operand, or an
operand in which only some of the bits are to be changed, you must
logically split its function into two separate operands, one input
operand and one write-only output operand.  The connection between them
is expressed by constraints which say they need to be in the same
location when the instruction executes.  You can use the same C
expression for both operands, or different expressions.  For example,
here we write the (fictitious) `combine' instruction with `bar' as its
read-only source operand and `foo' as its read-write destination:

     asm ("combine %2,%0" : "=r" (foo) : "0" (foo), "g" (bar));

The constraint `"0"' for operand 1 says that it must occupy the same
location as operand 0.  A digit in constraint is allowed only in an
input operand, and it must refer to an output operand.

   Only a digit in the constraint can guarantee that one operand will
be in the same place as another.  The mere fact that `foo' is the value
of both operands is not enough to guarantee that they will be in the
same place in the generated assembler code.  The following would not
work:

     asm ("combine %2,%0" : "=r" (foo) : "r" (foo), "g" (bar));

   Various optimizations or reloading could cause operands 0 and 1 to
be in different registers; GNU CC knows no reason not to do so.  For
example, the compiler might find a copy of the value of `foo' in one
register and use it for operand 1, but generate the output operand 0 in
a different register (copying it afterward to `foo''s own address).  Of
course, since the register for operand 1 is not even mentioned in the
assembler code, the result will not work, but GNU CC can't tell that.

   Some instructions clobber specific hard registers.  To describe
this, write a third colon after the input operands, followed by the
names of the clobbered hard registers (given as strings).  Here is a
realistic example for the Vax:

     asm volatile ("movc3 %0,%1,%2"
                   : /* no outputs */
                   : "g" (from), "g" (to), "g" (count)
                   : "r0", "r1", "r2", "r3", "r4", "r5");

   If you refer to a particular hardware register from the assembler
code, then you will probably have to list the register after the third
colon to tell the compiler that the register's value is modified.  In
many assemblers, the register names begin with `%'; to produce one `%'
in the assembler code, you must write `%%' in the input.

   If your assembler instruction can alter the condition code register,
add `cc' to the list of clobbered registers.  GNU CC on some machines
represents the condition codes as a specific hardware register; `cc'
serves to name this register.  On other machines, the condition code is
handled differently, and specifying `cc' has no effect.  But it is
valid no matter what the machine.

   You can put multiple assembler instructions together in a single
`asm' template, separated either with newlines (written as `\n') or with
semicolons if the assembler allows such semicolons.  The GNU assembler
allows semicolons and all Unix assemblers seem to do so.  The input
operands are guaranteed not to use any of the clobbered registers, and
neither will the output operands' addresses, so you can read and write
the clobbered registers as many times as you like.  Here is an example
of multiple instructions in a template; it assumes that the subroutine
`_foo' accepts arguments in registers 9 and 10:

     asm ("movl %0,r9;movl %1,r10;call _foo"
          : /* no outputs */
          : "g" (from), "g" (to)
          : "r9", "r10");

   Unless an output operand has the `&' constraint modifier, GNU CC may
allocate it in the same register as an unrelated input operand, on the
assumption that the inputs are consumed before the outputs are produced.
This assumption may be false if the assembler code actually consists of
more than one instruction.  In such a case, use `&' for each output
operand that may not overlap an input. *Note Constraint Modifier
Characters: (gcc.info)Modifiers.

   If you want to test the condition code produced by an assembler
instruction, you must include a branch and a label in the `asm'
construct, as follows:

     asm ("clr %0;frob %1;beq 0f;mov #1,%0;0:"
          : "g" (result)
          : "g" (input));

This assumes your assembler supports local labels, as the GNU assembler
and most Unix assemblers do.

   Usually the most convenient way to use these `asm' instructions is to
encapsulate them in macros that look like functions.  For example,

     #define sin(x)       \
     ({ double __value, __arg = (x);   \
        asm ("fsinx %1,%0": "=f" (__value): "f" (__arg));  \
        __value; })

Here the variable `__arg' is used to make sure that the instruction
operates on a proper `double' value, and to accept only those arguments
`x' which can convert automatically to a `double'.

   Another way to make sure the instruction operates on the correct
data type is to use a cast in the `asm'.  This is different from using a
variable `__arg' in that it converts more different types.  For
example, if the desired type were `int', casting the argument to `int'
would accept a pointer with no complaint, while assigning the argument
to an `int' variable named `__arg' would warn about using a pointer
unless the caller explicitly casts it.

   If an `asm' has output operands, GNU CC assumes for optimization
purposes that the instruction has no side effects except to change the
output operands.  This does not mean that instructions with a side
effect cannot be used, but you must be careful, because the compiler
may eliminate them if the output operands aren't used, or move them out
of loops, or replace two with one if they constitute a common
subexpression.  Also, if your instruction does have a side effect on a
variable that otherwise appears not to change, the old value of the
variable may be reused later if it happens to be found in a register.

   You can prevent an `asm' instruction from being deleted, moved
significantly, or combined, by writing the keyword `volatile' after the
`asm'.  For example:

     #define set_priority(x)  \
     asm volatile ("set_priority %0": /* no outputs */ : "g" (x))

An instruction without output operands will not be deleted or moved
significantly, regardless, unless it is unreachable.

   Note that even a volatile `asm' instruction can be moved in ways
that appear insignificant to the compiler, such as across jump
instructions.  You can't expect a sequence of volatile `asm'
instructions to remain perfectly consecutive.  If you want consecutive
output, use a single `asm'.

   It is a natural idea to look for a way to give access to the
condition code left by the assembler instruction.  However, when we
attempted to implement this, we found no way to make it work reliably. 
The problem is that output operands might need reloading, which would
result in additional following "store" instructions.  On most machines,
these instructions would alter the condition code before there was time
to test it.  This problem doesn't arise for ordinary "test" and
"compare" instructions because they don't have any output operands.

   If you are writing a header file that should be includable in ANSI C
programs, write `__asm__' instead of `asm'.  *Note Alternate Keywords::.


File: usegcc.i,  Node: Asm Labels,  Next: Explicit Reg Vars,  Prev: Extended Asm,  Up: Extensions

Controlling Names Used in Assembler Code
========================================

   You can specify the name to be used in the assembler code for a C
function or variable by writing the `asm' (or `__asm__') keyword after
the declarator as follows:

     int foo asm ("myfoo") = 2;

This specifies that the name to be used for the variable `foo' in the
assembler code should be `myfoo' rather than the usual `_foo'.

   On systems where an underscore is normally prepended to the name of
a C function or variable, this feature allows you to define names for
the linker that do not start with an underscore.

   You cannot use `asm' in this way in a function *definition*; but you
can get the same effect by writing a declaration for the function
before its definition and putting `asm' there, like this:

     extern func () asm ("FUNC");
     
     func (x, y)
          int x, y;
     ...

   It is up to you to make sure that the assembler names you choose do
not conflict with any other assembler symbols.  Also, you must not use a
register name; that would produce completely invalid assembler code. 
GNU CC does not as yet have the ability to store static variables in
registers. Perhaps that will be added.


File: usegcc.i,  Node: Explicit Reg Vars,  Next: Alternate Keywords,  Prev: Asm Labels,  Up: Extensions

Variables in Specified Registers
================================

   GNU C allows you to put a few global variables into specified
hardware registers.  You can also specify the register in which an
ordinary register variable should be allocated.

   * Global register variables reserve registers throughout the program.
     This may be useful in programs such as programming language
     interpreters which have a couple of global variables that are
     accessed very often.

   * Local register variables in specific registers do not reserve the
     registers.  The compiler's data flow analysis is capable of
     determining where the specified registers contain live values, and
     where they are available for other uses.

     These local variables are sometimes convenient for use with the
     extended `asm' feature (*note Extended Asm::.), if you want to
     write one output of the assembler instruction directly into a
     particular register. (This will work provided the register you
     specify fits the constraints specified for that operand in the
     `asm'.)

* Menu:

* Global Reg Vars::
* Local Reg Vars::


File: usegcc.i,  Node: Global Reg Vars,  Next: Local Reg Vars,  Up: Explicit Reg Vars

Defining Global Register Variables
----------------------------------

   You can define a global register variable in GNU C like this:

     register int *foo asm ("a5");

Here `a5' is the name of the register which should be used.  Choose a
register which is normally saved and restored by function calls on your
machine, so that library routines will not clobber it.

   Naturally the register name is cpu-dependent, so you would need to
conditionalize your program according to cpu type.  The register `a5'
would be a good choice on a 68000 for a variable of pointer type.  On
machines with register windows, be sure to choose a "global" register
that is not affected magically by the function call mechanism.

   In addition, operating systems on one type of cpu may differ in how
they name the registers; then you would need additional conditionals. 
For example, some 68000 operating systems call this register `%a5'.

   Eventually there may be a way of asking the compiler to choose a
register automatically, but first we need to figure out how it should
choose and how to enable you to guide the choice.  No solution is
evident.

   Defining a global register variable in a certain register reserves
that register entirely for this use, at least within the current
compilation. The register will not be allocated for any other purpose
in the functions in the current compilation.  The register will not be
saved and restored by these functions.  Stores into this register are
never deleted even if they would appear to be dead, but references may
be deleted or moved or simplified.

   It is not safe to access the global register variables from signal
handlers, or from more than one thread of control, because the system
library routines may temporarily use the register for other things
(unless you recompile them specially for the task at hand).

   It is not safe for one function that uses a global register variable
to call another such function `foo' by way of a third function `lose'
that was compiled without knowledge of this variable (i.e. in a
different source file in which the variable wasn't declared).  This is
because `lose' might save the register and put some other value there.
For example, you can't expect a global register variable to be
available in the comparison-function that you pass to `qsort', since
`qsort' might have put something else in that register.  (If you are
prepared to recompile `qsort' with the same global register variable,
you can solve this problem.)

   If you want to recompile `qsort' or other source files which do not
actually use your global register variable, so that they will not use
that register for any other purpose, then it suffices to specify the
compiler option `-ffixed-REG'.  You need not actually add a global
register declaration to their source code.

   A function which can alter the value of a global register variable
cannot safely be called from a function compiled without this variable,
because it could clobber the value the caller expects to find there on
return. Therefore, the function which is the entry point into the part
of the program that uses the global register variable must explicitly
save and restore the value which belongs to its caller.

   On most machines, `longjmp' will restore to each global register
variable the value it had at the time of the `setjmp'.  On some
machines, however, `longjmp' will not change the value of global
register variables.  To be portable, the function that called `setjmp'
should make other arrangements to save the values of the global register
variables, and to restore them in a `longjmp'.  This way, the same
thing will happen regardless of what `longjmp' does.

   All global register variable declarations must precede all function
definitions.  If such a declaration could appear after function
definitions, the declaration would be too late to prevent the register
from being used for other purposes in the preceding functions.

   Global register variables may not have initial values, because an
executable file has no means to supply initial contents for a register.

   On the Sparc, there are reports that g3 ... g7 are suitable
registers, but certain library functions, such as `getwd', as well as
the subroutines for division and remainder, modify g3 and g4.  g1 and
g2 are local temporaries.

   On the 68000, a2 ... a5 should be suitable, as should d2 ... d7. Of
course, it will not do to use more than a few of those.


File: usegcc.i,  Node: Local Reg Vars,  Prev: Global Reg Vars,  Up: Explicit Reg Vars

Specifying Registers for Local Variables
----------------------------------------

   You can define a local register variable with a specified register
like this:

     register int *foo asm ("a5");

Here `a5' is the name of the register which should be used.  Note that
this is the same syntax used for defining global register variables,
but for a local variable it would appear within a function.

   Naturally the register name is cpu-dependent, but this is not a
problem, since specific registers are most often useful with explicit
assembler instructions (*note Extended Asm::.).  Both of these things
generally require that you conditionalize your program according to cpu
type.

   In addition, operating systems on one type of cpu may differ in how
they name the registers; then you would need additional conditionals. 
For example, some 68000 operating systems call this register `%a5'.

   Eventually there may be a way of asking the compiler to choose a
register automatically, but first we need to figure out how it should
choose and how to enable you to guide the choice.  No solution is
evident.

   Defining such a register variable does not reserve the register; it
remains available for other uses in places where flow control determines
the variable's value is not live.  However, these registers are made
unavailable for use in the reload pass.  I would not be surprised if
excessive use of this feature leaves the compiler too few available
registers to compile certain functions.


File: usegcc.i,  Node: Alternate Keywords,  Next: Incomplete Enums,  Prev: Explicit Reg Vars,  Up: Extensions

Alternate Keywords
==================

   The option `-traditional' disables certain keywords; `-ansi'
disables certain others.  This causes trouble when you want to use GNU C
extensions, or ANSI C features, in a general-purpose header file that
should be usable by all programs, including ANSI C programs and
traditional ones.  The keywords `asm', `typeof' and `inline' cannot be
used since they won't work in a program compiled with `-ansi', while
the keywords `const', `volatile', `signed', `typeof' and `inline' won't
work in a program compiled with `-traditional'.

   The way to solve these problems is to put `__' at the beginning and
end of each problematical keyword.  For example, use `__asm__' instead
of `asm', `__const__' instead of `const', and `__inline__' instead of
`inline'.

   Other C compilers won't accept these alternative keywords; if you
want to compile with another compiler, you can define the alternate
keywords as macros to replace them with the customary keywords.  It
looks like this:

     #ifndef __GNUC__
     #define __asm__ asm
     #endif

   `-pedantic' causes warnings for many GNU C extensions.  You can
prevent such warnings within one expression by writing `__extension__'
before the expression.  `__extension__' has no effect aside from this.


File: usegcc.i,  Node: Incomplete Enums,  Prev: Alternate Keywords,  Up: Extensions

Incomplete `enum' Types
=======================

   You can define an `enum' tag without specifying its possible values.
This results in an incomplete type, much like what you get if you write
`struct foo' without describing the elements.  A later declaration
which does specify the possible values completes the type.

   You can't allocate variables or storage using the type while it is
incomplete.  However, you can work with pointers to that type.

   This extension may not be very useful, but it makes the handling of
`enum' more consistent with the way `struct' and `union' are handled.


File: usegcc.i,  Node: Trouble,  Next: Bugs,  Prev: Extensions,  Up: Top

Known Causes of Trouble with GNU CC
***********************************

   This section describes known problems that affect users of GNU CC. 
Most of these are not GNU CC bugs per se--if they were, we would fix
them. But the result for a user may be like the result of a bug.

   Some of these problems are due to bugs in other software, some are
missing features that are too much work to add, and some are places
where people's opinions differ as to what is best.

* Menu:

* Actual Bugs::		      Bugs we will fix later.
* Incompatibilities::   GNU CC is incompatible with traditional C.
* Disappointments::     Regrettable things we can't change, but not quite bugs.
* Non-bugs::		Things we think are right, but some others disagree.


File: usegcc.i,  Node: Actual Bugs,  Next: Incompatibilities,  Up: Trouble

Actual Bugs We Haven't Fixed Yet
================================

   * Loop unrolling doesn't work properly for certain programs.  This is
     because of difficulty in updating the debugging information within
     the loop being unrolled.  We plan to revamp the representation of
     debugging information so that this will work properly, but we have
     not done this in version 2.2 because we don't want to delay it any
     further.

   * There is a bug in producing DBX output which outputs a structure
     tag even when a structure doesn't have a tag.  The reason we
     aren't fixing this now is that a clean fix requires
     reorganizations that seem risky. We will do them after 2.2 is
     released.


File: usegcc.i,  Node: Incompatibilities,  Next: Disappointments,  Prev: Actual Bugs,  Up: Trouble

Incompatibilities of GNU CC
===========================

   There are several noteworthy incompatibilities between GNU C and most
existing (non-ANSI) versions of C.  The `-traditional' option
eliminates many of these incompatibilities, *but not all*, by telling
GNU C to behave like the other C compilers.

   * GNU CC normally makes string constants read-only.  If several
     identical-looking string constants are used, GNU CC stores only one
     copy of the string.

     One consequence is that you cannot call `mktemp' with a string
     constant argument.  The function `mktemp' always alters the string
     its argument points to.

     Another consequence is that `sscanf' does not work on some systems
     when passed a string constant as its format control string or
     input. This is because `sscanf' incorrectly tries to write into
     the string constant.  Likewise `fscanf' and `scanf'.

     The best solution to these problems is to change the program to use
     `char'-array variables with initialization strings for these
     purposes instead of string constants.  But if this is not possible,
     you can use the `-fwritable-strings' flag, which directs GNU CC to
     handle string constants the same way most C compilers do.
     `-traditional' also has this effect, among others.

   * `-2147483648' is positive.

     This is because 2147483648 cannot fit in the type `int', so
     (following the ANSI C rules) its data type is `unsigned long int'.
     Negating this value yields 2147483648 again.

   * GNU CC does not substitute macro arguments when they appear inside
     of string constants.  For example, the following macro in GNU CC

          #define foo(a) "a"

     will produce output `"a"' regardless of what the argument A is.

     The `-traditional' option directs GNU CC to handle such cases
     (among others) in the old-fashioned (non-ANSI) fashion.

   * When you use `setjmp' and `longjmp', the only automatic variables
     guaranteed to remain valid are those declared `volatile'.  This is
     a consequence of automatic register allocation.  Consider this
     function:

          jmp_buf j;
          
          foo ()
          {
            int a, b;
          
            a = fun1 ();
            if (setjmp (j))
              return a;
          
            a = fun2 ();
            /* `longjmp (j)' may occur in `fun3'. */
            return a + fun3 ();
          }

     Here `a' may or may not be restored to its first value when the
     `longjmp' occurs.  If `a' is allocated in a register, then its
     first value is restored; otherwise, it keeps the last value stored
     in it.

     If you use the `-W' option with the `-O' option, you will get a
     warning when GNU CC thinks such a problem might be possible.

     The `-traditional' option directs GNU C to put variables in the
     stack by default, rather than in registers, in functions that call
     `setjmp'.  This results in the behavior found in traditional C
     compilers.

   * Programs that use preprocessor directives in the middle of macro
     arguments do not work with GNU CC.  For example, a program like
     this will not work:

          foobar (
          #define luser
                  hack)

     ANSI C does not permit such a construct.  It would make sense to
     support it when `-traditional' is used, but it is too much work to
     implement.

   * Declarations of external variables and functions within a block
     apply only to the block containing the declaration.  In other
     words, they have the same scope as any other declaration in the
     same place.

     In some other C compilers, a `extern' declaration affects all the
     rest of the file even if it happens within a block.

     The `-traditional' option directs GNU C to treat all `extern'
     declarations as global, like traditional compilers.

   * In traditional C, you can combine `long', etc., with a typedef
     name, as shown here:

          typedef int foo;
          typedef long foo bar;

     In ANSI C, this is not allowed: `long' and other type modifiers
     require an explicit `int'.  Because this criterion is expressed by
     Bison grammar rules rather than C code, the `-traditional' flag
     cannot alter it.

   * Some older C compilers allow typedef names to be used as function
     parameters.  The difficulty described immediately above applies
     here too.

   * Some compilers allow whitespace in the middle of compound
     assignment operators such as `+='.  GNU CC, following the ANSI
     standard, does not allow this.  The difficulty described
     immediately above applies here too.

   * GNU CC will flag unterminated character constants inside of
     preprocessor conditionals that fail.  Some programs have English
     comments enclosed in conditionals that are guaranteed to fail; if
     these comments contain apostrophes, GNU CC will probably report an
     error.  For example, this code would produce an error:

          #if 0
          You can't expect this to work.
          #endif

     The best solution to such a problem is to put the text into an
     actual C comment delimited by `/*...*/'.  However, `-traditional'
     suppresses these error messages.

   * When compiling functions that return `float', some other compilers
     convert it to a double.  GNU CC actually returns a `float'.  If you
     are concerned with compatibility with such compilers, you should
     declare your functions to return `double'; you might as well say
     what you mean.


File: usegcc.i,  Node: Disappointments,  Next: Non-bugs,  Prev: Incompatibilities,  Up: Trouble

Disappointments and Misunderstandings
=====================================

   These problems are perhaps regrettable, but we don't know any
practical way around them.

   * Certain local variables aren't recognized by debuggers when you
     compile with optimization.

     This occurs because sometimes GNU CC optimizes the variable out of
     existence.  There is no way to tell the debugger how to compute the
     value such a variable "would have had", and it is not clear that
     would be desirable anyway.  So GNU CC simply does not mention the
     eliminated variable when it writes debugging information.

     You have to expect a certain amount of disagreement between the
     executable and your source code, when you use optimization.

   * Users often think it is a bug when GNU CC reports an error for code
     like this:

          int foo (struct mumble *);
          
          struct mumble { ... };
          
          int foo (struct mumble *x)
          { ... }

     This code really is erroneous, because the scope of `struct
     mumble' the prototype is limited to the argument list containing
     it. It does not refer to the `struct mumble' defined with file
     scope immediately below--they are two unrelated types with similar
     names in different scopes.

     But in the definition of `foo', the file-scope type is used
     because that is available to be inherited.  Thus, the definition
     and the prototype do not match, and you get an error.

     This behavior may seem silly, but it's what the ANSI standard
     specifies. It is easy enough for you to make your code work by
     moving the definition of `struct mumble' above the prototype. 
     It's not worth being incompatible with ANSI C just to avoid an
     error for the example shown above.


File: usegcc.i,  Node: Non-bugs,  Prev: Disappointments,  Up: Trouble

Certain Changes We Don't Want to Make
=====================================

   This section lists changes that people frequently request, but which
we do not make because we think GNU CC is better without them.

   * Checking the number and type of arguments to a function which has
     an old-fashioned definition and no prototype.

     Such a feature would work only occasionally--only for calls that
     appear in the same file as the called function, following the
     definition.  The only way to check all calls reliably is to add a
     prototype for the function.  But adding a prototype eliminates the
     motivation for this feature.  So the feature is not worthwhile.

   * Warning about using an expression whose type is signed as a shift
     count.

     Shift count operands are probably signed more often than unsigned.
     Warning about this would cause far more annoyance than good.

   * Warning about assigning a signed value to an unsigned variable.

     Such assignments must be very common; warning about them would
     cause more annoyance than good.

   * Warning when a non-void function value is ignored.

     Coming as I do from a Lisp background, I balk at the idea that
     there is something dangerous about discarding a value.  There are
     functions that return values which some callers may find useful;
     it makes no sense to clutter the program with a cast to `void'
     whenever the value isn't useful.

   * Assuming (for optimization) that the address of an external symbol
     is never zero.

     This assumption is false on certain systems when `#pragma weak' is
     used.

   * Making `-fshort-enums' the default.

     This would cause storage layout to be incompatible with most other
     C compilers.  And it doesn't seem very important, given that you
     can get the same result in other ways.  The case where it matters
     most is when the enumeration-valued object is inside a structure,
     and in that case you can specify a field width explicitly.

   * Making bitfields unsigned by default on particular machines where
     "the ABI standard" says to do so.

     The ANSI C standard leaves it up to the implementation whether a
     bitfield declared plain `int' is signed or not.  This in effect
     creates two alternative dialects of C.

     The GNU C compiler supports both dialects; you can specify the
     dialect you want with the option `-fsigned-bitfields' or
     `-funsigned-bitfields'.  However, this leaves open the question of
     which dialect to use by default.

     Currently, the preferred dialect makes plain bitfields signed,
     because this is simplest.  Since `int' is the same as `signed int'
     in every other context, it is cleanest for them to be the same in
     bitfields as well.

     Some computer manufacturers have published Application Binary
     Interface standards which specify that plain bitfields should be
     unsigned.  It is a mistake, however, to say anything about this
     issue in an ABI.  This is because the handling of plain bitfields
     distinguishes two dialects of C. Both dialects are meaningful on
     every type of machine.  Whether a particular object file was
     compiled using signed bitfields or unsigned is of no concern to
     other object files, even if they access the same bitfields in the
     same data structures.

     A given program is written in one or the other of these two
     dialects. The program stands a chance to work on most any machine
     if it is compiled with the proper dialect.  It is unlikely to work
     at all if compiled with the wrong dialect.

     Many users appreciate the GNU C compiler because it provides an
     environment that is uniform across machines.  These users would be
     inconvenienced if the compiler treated plain bitfields differently
     on certain machines.

     Occasionally users write programs intended only for a particular
     machine type.  On these occasions, the users would benefit if the
     GNU C compiler were to support by default the same dialect as the
     other compilers on that machine.  But such applications are rare. 
     And users writing a program to run on more than one type of
     machine cannot possibly benefit from this kind of compatibility.

     This is why GNU CC does and will treat plain bitfields in the same
     fashion on all types of machines (by default).

     There are some arguments for making bitfields unsigned by default
     on all machines.  If, for example, this becomes a universal de
     facto standard, it would make sense for GNU CC to go along with
     it.  This is something to be considered in the future.

     (Of course, users strongly concerned about portability should
     indicate explicitly in each bitfield whether it is signed or not. 
     In this way, they write programs which have the same meaning in
     both C dialects.)

   * Undefining `__STDC__' when `-ansi' is not used.

     Currently, GNU CC defines `__STDC__' as long as you don't use
     `-traditional'.  This provides good results in practice.

     Programmers normally use conditionals on `__STDC__' to ask whether
     it is safe to use certain features of ANSI C, such as function
     prototypes or ANSI token concatenation.  Since plain `gcc' supports
     all the features of ANSI C, the correct answer to these questions
     is "yes".

     Some users try to use `__STDC__' to check for the availability of
     certain library facilities.  This is actually incorrect usage in
     an ANSI C program, because the ANSI C standard says that a
     conforming freestanding implementation should define `__STDC__'
     even though it does not have the library facilities.  `gcc -ansi
     -pedantic' is a conforming freestanding implementation, and it is
     therefore required to define `__STDC__', even though it does not
     come with an ANSI C library.

     Sometimes people say that defining `__STDC__' in a compiler that
     does not completely conform to the ANSI C standard somehow
     violates the standard.  This is illogical.  The standard is a
     standard for compilers that claim to support ANSI C, such as `gcc
     -ansi'--not for other compilers such as plain `gcc'.  Whatever the
     ANSI C standard says is relevant to the design of plain `gcc'
     without `-ansi' only for pragmatic reasons, not as a requirement.

   * Deleting "empty" loops.

     GNU CC does not delete "empty" loops because the most likely reason
     you would put one in a program is to have a delay.  Deleting them
     will not make real programs run any faster, so it would be
     pointless.

     It would be different if optimization of a nonempty loop could
     produce an empty one.  But this generally can't happen.


File: usegcc.i,  Node: Bugs,  Next: Boycott,  Prev: Trouble,  Up: Top

Reporting Bugs
**************

   Your bug reports play an essential role in making GNU CC reliable.

   When you encounter a problem, the first thing to do is to see if it
is already known.  *Note Trouble::.  If it isn't known, then you should
report the problem.

   Reporting a bug may help you by bringing a solution to your problem,
or it may not. In any case, the principal function of a bug report is
to help the entire community by making the next version of GNU CC work
better.  Bug reports are your contribution to the maintenance of GNU CC.

   In order for a bug report to serve its purpose, you must include the
information that makes for fixing the bug.

* Menu:

* Criteria:  Bug Criteria.   Have you really found a bug?
* Where: Bug Lists.	     Where to send your bug report.
* Reporting: Bug Reporting.  How to report a bug effectively.
* Patches: Sending Patches.  How to send a patch for GNU CC.


File: usegcc.i,  Node: Bug Criteria,  Next: Bug Lists,  Up: Bugs

Have You Found a Bug?
=====================

   If you are not sure whether you have found a bug, here are some
guidelines:

   * If the compiler gets a fatal signal, for any input whatever, that
     is a compiler bug.  Reliable compilers never crash.

   * If the compiler produces invalid assembly code, for any input
     whatever (except an `asm' statement), that is a compiler bug,
     unless the compiler reports errors (not just warnings) which would
     ordinarily prevent the assembler from being run.

   * If the compiler produces valid assembly code that does not
     correctly execute the input source code, that is a compiler bug.

     However, you must double-check to make sure, because you may have
     run into an incompatibility between GNU C and traditional C (*note
     Incompatibilities::.).  These incompatibilities might be considered
     bugs, but they are inescapable consequences of valuable features.

     Or you may have a program whose behavior is undefined, which
     happened by chance to give the desired results with another C
     compiler.

     For example, in many nonoptimizing compilers, you can write `x;'
     at the end of a function instead of `return x;', with the same
     results.  But the value of the function is undefined if `return'
     is omitted; it is not a bug when GNU CC produces different results.

     Problems often result from expressions with two increment
     operators, as in `f (*p++, *p++)'.  Your previous compiler might
     have interpreted that expression the way you intended; GNU CC might
     interpret it another way.  Neither compiler is wrong.  The bug is
     in your code.

     After you have localized the error to a single source line, it
     should be easy to check for these things.  If your program is
     correct and well defined, you have found a compiler bug.

   * If the compiler produces an error message for valid input, that is
     a compiler bug.

   * If the compiler does not produce an error message for invalid
     input, that is a compiler bug.  However, you should note that your
     idea of "invalid input" might be my idea of "an extension" or
     "support for traditional practice".

   * If you are an experienced user of C compilers, your suggestions
     for improvement of GNU CC are welcome in any case.


File: usegcc.i,  Node: Bug Lists,  Next: Bug Reporting,  Prev: Bug Criteria,  Up: Bugs

Where to Report Bugs
====================

   Send bug reports for GNU C to one of these addresses:

     bug-gcc@prep.ai.mit.edu
     {ucbvax|mit-eddie|uunet}!prep.ai.mit.edu!bug-gcc

   The mailing list `bug-gcc' has a newsgroups which serve as a
repeater: `gnu.gcc.bug'. The mailing list and its newsgroup carry
exactly the same messages.

   Often people think of posting bug reports to the newsgroup instead of
mailing them.  This appears to work, but it has one problem which can be
crucial: a newsgroup posting does not contain a mail path back to the
sender.  Thus, if maintaners need more information, they may be unable
to reach you.  For this reason, you should always send bug reports by
mail to the proper mailing list.

   As a last resort, send bug reports on paper to:

     GNU Compiler Bugs
     Free Software Foundation
     675 Mass Ave
     Cambridge, MA 02139


File: usegcc.i,  Node: Bug Reporting,  Next: Sending Patches,  Prev: Bug Lists,  Up: Bugs

How to Report Bugs
==================

   The fundamental principle of reporting bugs usefully is this:
*report all the facts*.  If you are not sure whether to state a fact or
leave it out, state it!

   Often people omit facts because they think they know what causes the
problem and they conclude that some details don't matter.  Thus, you
might assume that the name of the variable you use in an example does
not matter. Well, probably it doesn't, but one cannot be sure.  Perhaps
the bug is a stray memory reference which happens to fetch from the
location where that name is stored in memory; perhaps, if the name were
different, the contents of that location would fool the compiler into
doing the right thing despite the bug.  Play it safe and give a
specific, complete example.  That is the easiest thing for you to do,
and the most helpful.

   Keep in mind that the purpose of a bug report is to enable someone to
fix the bug if it is not known.  It isn't very important what happens if
the bug is already known.  Therefore, always write your bug reports on
the assumption that the bug is not known.

   Sometimes people give a few sketchy facts and ask, "Does this ring a
bell?"  This cannot help us fix a bug, so it is basically useless.  We
respond by asking for enough details to enable us to investigate. You
might as well expedite matters by sending them to begin with.

   Try to make your bug report self-contained.  If we have to ask you
for more information, it is best if you include all the previous
information in your response, as well as the information that was
missing.

   To enable someone to investigate the bug, you should include all
these things:

   * The version of GNU CC.  You can get this by running it with the
     `-v' option.

     Without this, we won't know whether there is any point in looking
     for the bug in the current version of GNU CC.

   * A complete input file that will reproduce the bug.  If the bug is
     in the C preprocessor, send a source file and any header files
     that it requires.  If the bug is in the compiler proper (`cc1'),
     run your source file through the C preprocessor by doing `gcc -E
     SOURCEFILE > OUTFILE', then include the contents of OUTFILE in the
     bug report.  (When you do this, use the same `-I', `-D' or `-U'
     options that you used in actual compilation.)

     A single statement is not enough of an example.  In order to
     compile it, it must be embedded in a function definition; and the
     bug might depend on the details of how this is done.

     Without a real example one can compile, all anyone can do about
     your bug report is wish you luck.  It would be futile to try to
     guess how to provoke the bug.  For example, bugs in register
     allocation and reloading frequently depend on every little detail
     of the function they happen in.

   * The command arguments you gave GNU CC to compile that example and
     observe the bug.  For example, did you use `-O'?  To guarantee you
     won't omit something important, list all the options.

     If we were to try to guess the arguments, we would probably guess
     wrong and then we would not encounter the bug.

   * The type of machine you are using, and the operating system name
     and version number.

   * The operands you gave to the `configure' command when you installed
     the compiler.

   * A complete list of any modifications you have made to the compiler
     source.  (We don't promise to investigate the bug unless it
     happens in an unmodified compiler.  But if you've made
     modifications and don't tell us, then you are sending us on a wild
     goose chase.)

     Be precise about these changes--show a context diff for them.

     Adding files of your own (such as a machine description for a
     machine we don't support) is a modification of the compiler source.

   * Details of any other deviations from the standard procedure for
     installing GNU CC.

   * A description of what behavior you observe that you believe is
     incorrect.  For example, "The compiler gets a fatal signal," or,
     "The assembler instruction at line 208 in the output is incorrect."

     Of course, if the bug is that the compiler gets a fatal signal,
     then one can't miss it.  But if the bug is incorrect output, the
     maintainer might not notice unless it is glaringly wrong.  None of
     us has time to study all the assembler code from a 50-line C
     program just on the chance that one instruction might be wrong. 
     We need `you' to do this part!

     Even if the problem you experience is a fatal signal, you should
     still say so explicitly.  Suppose something strange is going on,
     such as, your copy of the compiler is out of synch, or you have
     encountered a bug in the C library on your system.  (This has
     happened!)  Your copy might crash and the copy here would not.  If
     you said to expect a crash, then when the compiler here fails to
     crash, we would know that the bug was not happening.  If you don't
     say to expect a crash, then we would not know whether the bug was
     happening.  We would not be able to draw any conclusion from our
     observations.

     Often the observed symptom is incorrect output when your program
     is run. Sad to say, this is not enough information unless the
     program is short and simple.  None of us has time to study a large
     program to figure out how it would work if compiled correctly,
     much less which line of it was compiled wrong.  So you will have
     to do that.  Tell us which source line it is, and what incorrect
     result happens when that line is executed.  A person who
     understands the program can find this as easily as finding a bug
     in the program itself.

   * If you send examples of assembler code output from GNU CC please
     use `-g' when you make them.  The debugging information includes
     source line numbers which are essential for correlating the output
     with the input.

   * If you wish to suggest changes to the GNU CC source, send them as
     context diffs.  If you even discuss something in the GNU CC source,
     refer to it by context, not by line number.

     The line numbers in the development sources don't match those in
     your sources.  Your line numbers would convey no useful
     information to the maintainers.

   * Additional information from a debugger might enable someone to
     find a problem on a machine which he does not have available. 
     However, you need to think when you collect this information if
     you want it to have any chance of being useful.

     For example, many people send just a backtrace, but that is never
     useful by itself.  A simple backtrace with arguments conveys little
     about GNU CC because the compiler is largely data-driven; the same
     functions are called over and over for different RTL insns, doing
     different things depending on the details of the insn.

     Most of the arguments listed in the backtrace are useless because
     they are pointers to RTL list structure.  The numeric values of the
     pointers, which the debugger prints in the backtrace, have no
     significance whatever; all that matters is the contents of the
     objects they point to (and most of the contents are other such
     pointers).

     In addition, most compiler passes consist of one or more loops that
     scan the RTL insn sequence.  The most vital piece of information
     about such a loop--which insn it has reached--is usually in a
     local variable, not in an argument.

     What you need to provide in addition to a backtrace are the values
     of the local variables for several stack frames up.  When a local
     variable or an argument is an RTX, first print its value and then
     use the GDB command `pr' to print the RTL expression that it points
     to.  (If GDB doesn't run on your machine, use your debugger to call
     the function `debug_rtx' with the RTX as an argument.)  In
     general, whenever a variable is a pointer, its value is no use
     without the data it points to.

     In addition, include a debugging dump from just before the pass in
     which the crash happens.  Most bugs involve a series of insns, not
     just one.

   Here are some things that are not necessary:

   * A description of the envelope of the bug.

     Often people who encounter a bug spend a lot of time investigating
     which changes to the input file will make the bug go away and which
     changes will not affect it.

     This is often time consuming and not very useful, because the way
     we will find the bug is by running a single example under the
     debugger with breakpoints, not by pure deduction from a series of
     examples.  You might as well save your time for something else.

     Of course, if you can find a simpler example to report *instead* of
     the original one, that is a convenience.  Errors in the output
     will be easier to spot, running under the debugger will take less
     time, etc. Most GNU CC bugs involve just one function, so the most
     straightforward way to simplify an example is to delete all the
     function definitions except the one where the bug occurs.  Those
     earlier in the file may be replaced by external declarations if
     the crucial function depends on them.  (Exception: inline
     functions may affect compilation of functions defined later in the
     file.)

     However, simplification is not vital; if you don't want to do this,
     report the bug anyway and send the entire test case you used.

   * A patch for the bug.

     A patch for the bug is useful if it is a good one.  But don't omit
     the necessary information, such as the test case, on the
     assumption that a patch is all we need.  We might see problems
     with your patch and decide to fix the problem another way, or we
     might not understand it at all.

     Sometimes with a program as complicated as GNU CC it is very hard
     to construct an example that will make the program follow a
     certain path through the code.  If you don't send the example, we
     won't be able to construct one, so we won't be able to verify that
     the bug is fixed.

     And if we can't understand what bug you are trying to fix, or why
     your patch should be an improvement, we won't install it.  A test
     case will help us to understand.

     *Note Sending Patches::, for guidelines on how to make it easy for
     us to understand and install your patches.

   * A guess about what the bug is or what it depends on.

     Such guesses are usually wrong.  Even I can't guess right about
     such things without first using the debugger to find the facts.


File: usegcc.i,  Node: Sending Patches,  Prev: Bug Reporting,  Up: Bugs

Sending Patches for GNU CC
==========================

   If you would like to write bug fixes or improvements for the GNU C
compiler, that is very helpful.  When you send your changes, please
follow these guidelines to avoid causing extra work for us in studying
the patches.

   If you don't follow these guidelines, your information might still be
useful, but using it will take extra work.  Maintaining GNU C is a lot
of work in the best of circumstances, and we can't keep up unless you do
your best to help.

   * Send an explanation with your changes of what problem they fix or
     what improvement they bring about.  For a bug fix, just include a
     copy of the bug report, and explain why the change fixes the bug.

     (Referring to a bug report is not as good as including it, because
     then we will have to look it up, and we have probably already
     deleted it if we've already fixed the bug.)

   * Always include a proper bug report for the problem you think you
     have fixed.  We need to convince ourselves that the change is
     right before installing it.  Even if it is right, we might have
     trouble judging it if we don't have a way to reproduce the problem.

   * Include all the comments that are appropriate to help people
     reading the source in the future understand why this change was
     needed.

   * Don't mix together changes made for different reasons. Send them
     *individually*.

     If you make two changes for separate reasons, then we might not
     want to install them both.  We might want to install just one.  If
     you send them all jumbled together in a single set of diffs, we
     have to do extra work to disentangle them--to figure out which
     parts of the change serve which purpose.  If we don't have time
     for this, we might have to ignore your changes entirely.

     If you send each change as soon as you have written it, with its
     own explanation, then the two changes never get tangled up, and we
     can consider each one properly without any extra work to
     disentangle them.

     Ideally, each change you send should be impossible to subdivide
     into parts that we might want to consider separately, because each
     of its parts gets its motivation from the other parts.

   * Send each change as soon as that change is finished.  Sometimes
     people think they are helping us by accumulating many changes to
     send them all together.  As explained above, this is absolutely
     the worst thing you could do.

     Since you should send each change separately, you might as well
     send it right away.  That gives us the option of installing it
     immediately if it is important.

   * Use `diff -c' to make your diffs.  Diffs without context are hard
     for us to install reliably.  More than that, they make it hard for
     us to study the diffs to decide whether we want to install them. 
     Unidiff format is better than contextless diffs, but not as easy
     to read as `-c' format.

     If you have GNU diff, use `diff -cp', which shows the name of the
     function that each change occurs in.

   * Write the change log entries for your changes.  We get lots of
     changes, and we don't have time to do all the change log writing
     ourselves.

     Read the `ChangeLog' file to see what sorts of information to put
     in, and to learn the style that we use.  The purpose of the change
     log is to show people where to find what was changed.  So you need
     to be specific about what functions you changed; in large
     functions, it's often helpful to indicate where within the
     function the change was.

     On the other hand, once you have shown people where to find the
     change, you need not explain its purpose. Thus, if you add a new
     function, all you need to say about it is that it is new.  If you
     feel that the purpose needs explaining, it probably does--but the
     explanation will be much more useful if you put it in comments in
     the code.

     If you would like your name to appear in the header line for who
     made the change, send us the header line.

   * When you write the fix, keep in mind that I can't install a change
     that would break other systems.

     People often suggest fixing a problem by changing
     machine-independent files such as `toplev.c' to do something
     special that a particular system needs.  Sometimes it is totally
     obvious that such changes would break GNU CC for almost all users.
      We can't possibly make a change like that.  At best it might tell
     us how to write another patch that would solve the problem
     acceptably.

     Sometimes people send fixes that *might* be an improvement in
     general--but it is hard to be sure of this.  It's hard to install
     such changes because we have to study them very carefully.  Of
     course, a good explanation of the reasoning by which you concluded
     the change was correct can help convince us.

     The safest changes are changes to the configuration files for a
     particular machine.  These are safe because they can't create new
     bugs on other machines.

     Please help us keep up with the workload by designing the patch in
     a form that is good to install.


File: usegcc.i,  Node: Boycott,  Next: Index,  Prev: Bugs,  Up: Top

Protect Your Freedom--Fight "Look And Feel"
*******************************************

     This section is a political message from the League for Programming
     Freedom to the users of GNU CC.  It is included here as an
     expression of support for the League on the part of the Free
     Software Foundation.

   Apple and Lotus are trying to create a new form of legal monopoly: a
copyright on a class of user interfaces.  These monopolies would cause
serious problems for users and developers of computer software and
systems.  Xerox, too, has tried to make a monopoly for itself on window
systems; their suit against Apple was thrown out on a technicality, but
Xerox has not said anything to indicate it wouldn't try again.

   Until a few years ago, the law seemed clear: no one could restrict
others from using a user interface; programmers were free to implement
any interface they chose.  Imitating interfaces, sometimes with changes,
was standard practice in the computer field.  The interfaces we know
evolved gradually in this way; for example, the Macintosh user interface
drew ideas from the Xerox interface, which in turn drew on work done at
Stanford and SRI.  1-2-3 imitated VisiCalc, and dBase imitated a
database program from JPL.

   Most computer companies, and nearly all computer users, were happy
with this state of affairs.  The companies that are suing say it does
not offer "enough incentive" to develop their products, but they must
have considered it "enough" when they made their decision to do so.  It
seems they are not satisfied with the opportunity to continue to compete
in the marketplace--not even with a head start.

   If companies like Xerox, Lotus, and Apple are permitted to make law
through the courts, the precedent will hobble the software industry:

   * Gratuitous incompatibilities will burden users.  Imagine if each
     car manufacturer had to arrange the pedals in a different order.

   * Software will become and remain more expensive.  Users will be
     "locked in" to proprietary interfaces, for which there is no real
     competition.

   * Large companies have an unfair advantage wherever lawsuits become
     commonplace.  Since they can easily afford to sue, they can
     intimidate small companies with threats even when they don't
     really have a case.

   * User interface improvements will come slower, since incremental
     evolution through creative imitation will no longer be permitted.

   * Even Apple, etc., will find it harder to make improvements if they
     can no longer adapt the good ideas that others introduce, for fear
     of weakening their own legal positions.  Some users suggest that
     this stagnation may already have started.

   * If you use GNU software, you might find it of some concern that
     user interface copyright will make it hard for the Free Software
     Foundation to develop programs compatible with the interfaces that
     you already know.

   To protect our freedom from lawsuits like these, a group of
programmers and users have formed a new grass-roots political
organization, the League for Programming Freedom.

   The purpose of the League is to oppose new monopolistic practices
such as user-interface copyright and software patents; it calls for a
return to the legal policies of the recent past, in which these
practices were not allowed.  The League is not concerned with free
software as an issue, and not affiliated with the Free Software
Foundation.

   The League's membership rolls include John McCarthy, inventor of
Lisp, Marvin Minsky, founder of the Artificial Intelligence lab, Guy L.
Steele, Jr., author of well-known books on Lisp and C, as well as
Richard Stallman, the developer of GNU CC.  Please join and add your
name to the list.  Membership dues in the League are $42 per year for
programmers, managers and professionals; $10.50 for students; $21 for
others.

   The League needs both activist members and members who only pay their
dues.

   To join, or for more information, phone (617) 492-0023 or write to:

     League for Programming Freedom
     1 Kendall Square #143
     P.O. Box 9171
     Cambridge, MA 02139

   You can also send electronic mail to `league@prep.ai.mit.edu'.

   Here are some suggestions from the League for things you can do to
protect your freedom to write programs:

   * Don't buy from Xerox, Lotus or Apple.  Buy from their competitors
     or from the defendants they are suing.

   * Don't develop software to work with the systems made by these
     companies.

   * Port your existing software to competing systems, so that you
     encourage users to switch.

   * Write letters to company presidents to let them know their conduct
     is unacceptable.

   * Tell your friends and colleagues about this issue and how it
     threatens to ruin the computer industry.

   * Above all, don't work for the look-and-feel plaintiffs, and don't
     accept contracts from them.

   * Write to Congress to explain the importance of this issue.

          House Subcommittee on Intellectual Property
          2137 Rayburn Bldg
          Washington, DC 20515
          
          Senate Subcommittee on Patents, Trademarks and Copyrights
          United States Senate
          Washington, DC 20510

     (These committees have received lots of mail already; let's give
     them even more.)

   Express your opinion!  You can make a difference.


File: usegcc.i,  Node: Index,  Prev: Boycott,  Up: Top

Index
*****

* Menu:

* $:                                    Dollar Signs.
* ':                                    Incompatibilities.
* ?: side effect:                       Conditionals.
* #pragma, reason for not using:        Function Attributes.
* ?: extensions:                        Lvalues.
* ?: extensions:                        Conditionals.
* alloca vs variable-length arrays:     Variable Length.
* asm expressions:                      Extended Asm.
* const applied to function:            Function Attributes.
* float as function value type:         Incompatibilities.
* fscanf, and constant strings:         Incompatibilities.
* long long data types:                 Long Long.
* longjmp and automatic variables:      Dialect Options.
* longjmp incompatibilities:            Incompatibilities.
* longjmp warnings:                     Warning Options.
* mktemp, and constant strings:         Incompatibilities.
* qsort, and global register variables: Global Reg Vars.
* scanf, and constant strings:          Incompatibilities.
* setjmp incompatibilities:             Incompatibilities.
* sscanf, and constant strings:         Incompatibilities.
* volatile applied to function:         Function Attributes.
* _ in variables in macros:             Naming Types.
* address of a label:                   Labels as Values.
* alignment:                            Alignment.
* alternate keywords:                   Alternate Keywords.
* ANSI support:                         Dialect Options.
* apostrophes:                          Incompatibilities.
* arrays of length zero:                Zero Length.
* arrays of variable length:            Variable Length.
* arrays, non-lvalue:                   Subscripting.
* assembler instructions:               Extended Asm.
* assembler names for identifiers:      Asm Labels.
* assembly code, invalid:               Bug Criteria.
* attribute of variables:               Variable Attributes.
* backtrace for bug reports:            Bug Reporting.
* bug criteria:                         Bug Criteria.
* bug report mailing lists:             Bug Lists.
* bugs:                                 Bugs.
* bugs, known:                          Trouble.
* C language extensions:                Extensions.
* C language, traditional:              Dialect Options.
* calling conventions for interrupts:   Interrupt Functions.
* case labels in initializers:          Labeled Elements.
* case ranges:                          Case Ranges.
* cast to a union:                      Cast to Union.
* casts as lvalues:                     Lvalues.
* code generation conventions:          Code Gen Options.
* command options:                      Invoking GCC.
* compiler bugs, reporting:             Bug Reporting.
* compiler version, specifying:         Compiler Version.
* COMPILER_PATH:                        Environment Variables.
* compound expressions as lvalues:      Lvalues.
* computed gotos:                       Labels as Values.
* conditional expressions as lvalues:   Lvalues.
* conditional expressions, extensions:  Conditionals.
* conflicting types:                    Disappointments.
* constructor expressions:              Constructors.
* contributors:                         Contributors.
* core dump:                            Bug Criteria.
* C_INCLUDE_PATH:                       Environment Variables.
* deallocating variable length arrays:  Variable Length.
* debugging information options:        Debugging Options.
* debug_rtx:                            Bug Reporting.
* declaration scope:                    Incompatibilities.
* declarations inside expressions:      Statement Exprs.
* declaring attributes of functions:    Function Attributes.
* dependencies for make as output:      Environment Variables.
* dependencies, make:                   Preprocessor Options.
* DEPENDENCIES_OUTPUT:                  Environment Variables.
* dialect options:                      Dialect Options.
* directory options:                    Directory Options.
* dollar signs in identifier names:     Dollar Signs.
* double-word arithmetic:               Long Long.
* downward funargs:                     Nested Functions.
* environment variables:                Environment Variables.
* explicit register variables:          Explicit Reg Vars.
* expressions containing statements:    Statement Exprs.
* expressions, compound, as lvalues:    Lvalues.
* expressions, conditional, as lvalues: Lvalues.
* expressions, constructor:             Constructors.
* extended asm:                         Extended Asm.
* extensions, ?::                       Lvalues.
* extensions, ?::                       Conditionals.
* extensions, C language:               Extensions.
* external declaration scope:           Incompatibilities.
* fatal signal:                         Bug Criteria.
* file name suffix:                     Overall Options.
* file names:                           Link Options.
* function attributes:                  Function Attributes.
* function pointers, arithmetic:        Pointer Arith.
* function prototype declarations:      Function Prototypes.
* function, size of pointer to:         Pointer Arith.
* functions that have no side effects:  Function Attributes.
* functions that never return:          Function Attributes.
* GCC_EXEC_PREFIX:                      Environment Variables.
* generalized lvalues:                  Lvalues.
* global offset table:                  Code Gen Options.
* global register after longjmp:        Global Reg Vars.
* global register variables:            Global Reg Vars.
* GNU CC command options:               Invoking GCC.
* GNU extensions to the C language:     Extensions.
* goto with computed label:             Labels as Values.
* grouping options:                     Invoking GCC.
* identifier names, dollar signs in:    Dollar Signs.
* identifiers, names in assembler code: Asm Labels.
* incompatibilities of GNU CC:          Incompatibilities.
* increment operators:                  Bug Criteria.
* initializations in expressions:       Constructors.
* initializers with labeled elements:   Labeled Elements.
* initializers, non-constant:           Initializers.
* inline functions:                     Inline.
* inline functions, omission of:        Inline.
* integrating function code:            Inline.
* interrupts, functions compiled for:   Interrupt Functions.
* introduction:                         Top.
* invalid assembly code:                Bug Criteria.
* invalid input:                        Bug Criteria.
* keywords, alternate:                  Alternate Keywords.
* known causes of trouble:              Trouble.
* labeled elements in initializers:     Labeled Elements.
* labels as values:                     Labels as Values.
* language dialect options:             Dialect Options.
* length-zero arrays:                   Zero Length.
* Libraries:                            Link Options.
* LIBRARY_PATH:                         Environment Variables.
* link options:                         Link Options.
* local labels:                         Local Labels.
* local variables in macros:            Naming Types.
* local variables, specifying registers: Local Reg Vars.
* longjmp:                              Global Reg Vars.
* lvalues, generalized:                 Lvalues.
* macro with variable arguments:        Macro Varargs.
* macros containing asm:                Extended Asm.
* macros, inline alternative:           Inline.
* macros, local labels:                 Local Labels.
* macros, local variables in:           Naming Types.
* macros, statements in expressions:    Statement Exprs.
* macros, types of arguments:           Typeof.
* make:                                 Preprocessor Options.
* messages, warning:                    Warning Options.
* middle-operands, omitted:             Conditionals.
* multiprecision arithmetic:            Long Long.
* names used in assembler code:         Asm Labels.
* naming explicit sections:             Section Declarations.
* naming types:                         Naming Types.
* nested functions:                     Nested Functions.
* non-constant initializers:            Initializers.
* non-static inline function:           Inline.
* old-style function definitions:       Function Prototypes.
* omitted middle-operands:              Conditionals.
* open coding:                          Inline.
* optimize options:                     Optimize Options.
* options to control warnings:          Warning Options.
* options, code generation:             Code Gen Options.
* options, debugging:                   Debugging Options.
* options, dialect:                     Dialect Options.
* options, directory search:            Directory Options.
* options, GNU CC command:              Invoking GCC.
* options, grouping:                    Invoking GCC.
* options, linking:                     Link Options.
* options, optimization:                Optimize Options.
* options, order:                       Invoking GCC.
* options, preprocessor:                Preprocessor Options.
* order of options:                     Invoking GCC.
* output file option:                   Overall Options.
* parameter forward declaration:        Variable Length.
* PIC:                                  Code Gen Options.
* pointer arguments:                    Function Attributes.
* pragma, reason for not using:         Function Attributes.
* preprocessor options:                 Preprocessor Options.
* promotion of formal parameters:       Function Prototypes.
* ranges in case statements:            Case Ranges.
* read-only strings:                    Incompatibilities.
* register variable after longjmp:      Global Reg Vars.
* registers:                            Extended Asm.
* registers for local variables:        Local Reg Vars.
* registers, global allocation:         Explicit Reg Vars.
* registers, global variables in:       Global Reg Vars.
* reporting bugs:                       Bugs.
* rest argument (in macro):             Macro Varargs.
* run-time options:                     Code Gen Options.
* scope of a variable length array:     Variable Length.
* scope of declaration:                 Disappointments.
* scope of external declarations:       Incompatibilities.
* search path:                          Directory Options.
* section name:                         Section Declarations.
* setjmp:                               Global Reg Vars.
* shared strings:                       Incompatibilities.
* side effect in ?::                    Conditionals.
* side effects, macro argument:         Statement Exprs.
* sizeof:                               Typeof.
* specified registers:                  Explicit Reg Vars.
* specifying registers for local variables: Local Reg Vars.
* statements inside expressions:        Statement Exprs.
* string constants:                     Incompatibilities.
* structures, constructor expression:   Constructors.
* subscripting:                         Subscripting.
* subscripting and function values:     Subscripting.
* suppressing warnings:                 Warning Options.
* syntax checking:                      Warning Options.
* thunks:                               Nested Functions.
* TMPDIR:                               Environment Variables.
* traditional C language:               Dialect Options.
* type alignment:                       Alignment.
* typedef names as function parameters: Incompatibilities.
* typeof:                               Typeof.
* undefined behavior:                   Bug Criteria.
* undefined function value:             Bug Criteria.
* underscores in variables in macros:   Naming Types.
* union, casting to a:                  Cast to Union.
* value after longjmp:                  Global Reg Vars.
* variable alignment:                   Alignment.
* variable attributes:                  Variable Attributes.
* variable number of arguments:         Macro Varargs.
* variable-length array scope:          Variable Length.
* variable-length arrays:               Variable Length.
* variables in specified registers:     Explicit Reg Vars.
* variables, local, in macros:          Naming Types.
* void pointers, arithmetic:            Pointer Arith.
* void, size of pointer to:             Pointer Arith.
* warning messages:                     Warning Options.
* whitespace:                           Incompatibilities.
* zero-length arrays:                   Zero Length.



Tag Table:
Node: Top1207
Node: Contributors1897
Node: Invoking GCC5719
Node: Option Summary8290
Node: Overall Options11386
Node: Dialect Options15461
Node: Warning Options22577
Node: Debugging Options33732
Node: Optimize Options38264
Node: Preprocessor Options47624
Node: Link Options52651
Node: Directory Options56285
Node: Compiler Version59046
Node: Code Gen Options59785
Node: Environment Variables64669
Node: Extensions68461
Node: Statement Exprs71345
Node: Local Labels73245
Node: Labels as Values75305
Node: Nested Functions77169
Node: Naming Types80268
Node: Typeof81358
Node: Lvalues83220
Node: Conditionals85484
Node: Long Long86395
Node: Zero Length87651
Node: Variable Length88325
Node: Macro Varargs90848
Node: Subscripting92479
Node: Pointer Arith92960
Node: Initializers93523
Node: Constructors93967
Node: Labeled Elements95659
Node: Case Ranges97764
Node: Cast to Union98443
Node: Function Attributes99374
Node: Function Prototypes101967
Node: Section Declarations103684
Node: Interrupt Functions105249
Node: Dollar Signs106473
Node: Character Escapes107242
Node: Alignment107521
Node: Variable Attributes108851
Node: Inline111862
Node: Extended Asm114815
Node: Asm Labels124722
Node: Explicit Reg Vars126039
Node: Global Reg Vars127284
Node: Local Reg Vars131847
Node: Alternate Keywords133440
Node: Incomplete Enums134840
Node: Trouble135523
Node: Actual Bugs136339
Node: Incompatibilities137135
Node: Disappointments142806
Node: Non-bugs144715
Node: Bugs151582
Node: Bug Criteria152571
Node: Bug Lists154971
Node: Bug Reporting155944
Node: Sending Patches166828
Node: Boycott172179
Node: Index177683

End Tag Table
