This is Info file libm.i, produced by Makeinfo-1.50 from the input file
./libm.texinfo.

START-INFO-DIR-ENTRY
* libm: (libm).			An ANSI-C conforming mathematical library.
END-INFO-DIR-ENTRY

   This file documents an ANSI-C conforming mathematical subroutine
library.

   Copyright (C) 1992 Cygnus Support

   `libm' includes software developed by the University of California,
Berkeley and its contributors.

   `libm' includes software developed by Martin Jackson, Graham Haley
and Steve Chamberlain of Tadpole Technology and released to Cygnus.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, subject to the
terms of the GNU General Public License, which includes the provision
that the entire resulting derived work is distributed under the terms
of a permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions.


File: libm.i,  Node: Top,  Next: Overview,  Prev: (DIR),  Up: (DIR)

LIBM
****

* Menu:

* Overview::            Math Library Overview
* Functions::           The Mathematical Functions
* Index::


File: libm.i,  Node: Overview,  Next: Functions,  Prev: Top,  Up: Top

Math Library Overview
*********************

   This library groups a wide variety of mathematical functions.  The
corresponding definitions and declarations are in `math.h'. Two
definitions from `math.h' are of particular interest.

   First: the largest number representable as a `double' is defined as
`HUGE_VAL'; this number is returned on overflow by many functions. 
(The corresponding functions on `float' types return `FLT_MAX' instead,
which is defined in `float.h'.)

   Second: the structure `exception' is used when you write customized
error handlers for the mathematical functions. You can customize error
handling for most of these functions by defining your own version of
`matherr'; see the section on `matherr' for details.

   With default error handling, the mathematical functions write
messages on standard error whenever they encounter an error.  For
example, by default `log(-1.0)' writes this message on standard error
output:

     log(-1.0): DOMAIN error

   Alternative declarations of the mathematical functions, which exploit
specific machine capabilities to operate faster--but generally have
less error checking and may reflect additional limitations on some
machines--are available when you include `fastmath.h' instead of
`math.h'.


File: libm.i,  Node: Functions,  Next: Index,  Prev: Overview,  Up: Top

The Mathematical Functions
**************************

* Menu:

* acosh::
* asin::
* acos::
* asinh::
* atan::
* atan2::
* atanh::
* bessel::
* copysign::
* cosh::
* erf::
* exp::
* fabs::
* floor::
* fmod::
* frexp::
* gamma::
* hypot::
* ldexp::
* log::
* log2::
* log10::
* log1p::
* matherr::
* modf::
* pow::
* sqrt::
* sincos::
* sinh::
* tan::
* tanh::


File: libm.i,  Node: acosh,  Next: asin,  Up: Functions

`acosh', `acoshf'--inverse hyperbolic cosine
============================================

   *Synopsis*
     #include <math.h>
     double acosh(double X);
     float acoshf(float X);
   *Description*
`acosh' calculates the inverse hyperbolic cosine of X. `acosh' is
defined as
      log(X + sqrt(X*X-1))

   X must be a number greater than or equal to 1.

   `acoshf' is identical, other than taking and returning floats.

*Returns*
`acosh' and `acoshf' return the calculated value.  If X is NaN (not a
number) or less than 1, the return value is NaN and `errno' is set to
`EDOM'.

   You can change the error-handling behavior with the non-ANSI
`matherr' function.

*Portability*
Neither `acosh' nor `acoshf' are ANSI C.  They are not recommended for
portable programs.


File: libm.i,  Node: acos,  Next: asinh,  Prev: asin,  Up: Functions

`acos', `acosf'--Arccosine
==========================

   *Synopsis*
     #include <math.h>
     double acos(double X);
     float acosf(float X);
   *Description*
`acos' computes the inverse cosine (Arccosine) of the input value.
Arguments to `acos' must be in the range -1 to 1.

   `acosf' is identical to `acos', except that it performs its
calculations on `floats'.

*Returns*
`acos' and `acosf' return values in radians, in the range of 0 to pi.

If X is not between -1 and 1, the returned value is NaN (not a number)
the global variable `errno' is set to `EDOM', and a `DOMAIN ERROR'
message is sent as standard error output.

   You can modify error handling for these functions using `matherr'.


File: libm.i,  Node: asin,  Next: acos,  Prev: acosh,  Up: Functions

`asin', `asinf'--Arcsine
========================

   *Synopsis*
     #include <math.h>
     double asin(double X);
     float asinf(float X);
   *Description*
`asin' computes the inverse sine (arcsine) of the argument X. Arguments
to `asin' must be in the range -1 to 1.

   `asinf' is identical to `asin', other than taking and returning
floats.

   You can modify error handling for these routines using `matherr'.

*Returns*
`asin' returns values in radians, in the range of -pi/2 to pi/2.

If X is not in the range -1 to 1, `asin' and `asinf' return NaN (not a
number), set the global variable `errno' to `EDOM', and issue a `DOMAIN
error' message.

   You can change this error treatment using `matherr'.


File: libm.i,  Node: asinh,  Next: atan,  Prev: acos,  Up: Functions

`asinh', `asinhf'--inverse hyperbolic sine
==========================================

   *Synopsis*
     #include <math.h>
     double asinh(double X);
     float asinhf(float X);
   *Description*
`asinh' calculates the inverse hyperbolic sine of X. `asinh' is defined
as
      sgn(X) * log(abs(X) + sqrt(1+X*X))

   `asinhf' is identical, other than taking and returning floats.

*Returns*
`asinh' and `asinhf' return the calculated value, save when X is NaN
(not a number).  In that case, the result is also NaN, the global
`errno' is set to `EDOM', and a `DOMAIN error' message is sent to
standard error output.

   You can modify error handling using `matherr'.

*Portability*
Neither `asinh' nor `asinhf' are ANSI C.


File: libm.i,  Node: atan,  Next: atan2,  Prev: asinh,  Up: Functions

`atan', `atanf'--Arctangent
===========================

   *Synopsis*
     #include <math.h>
     double atan(double X);
     float atanf(float X);
   *Description*
`atan' computes the inverse tangent (Arctan) of the input value.
Arguments to `atan' must be in the range -1 to 1.

   `atanf' is identical to `atan', save that it operates on `floats'.

*Returns*
`atan' returns a value in radians, in the range of -pi/2 to pi/2.

When the argument X is not in the range -1 to 1, the result is NaN (not
a number), the global variable `errno' is set to `EDOM', and `DOMAIN
error' is sent to standard error.

   You can modify error handling for these routines using `matherr'.

*Portability*
`atan' is ANSI C.  `atanf' is an extension.


File: libm.i,  Node: atan2,  Next: atanh,  Prev: atan,  Up: Functions

`atan2', `atan2f'--Arctangent of y/x
====================================

   *Synopsis*
     #include <math.h>
     double atan2(double Y,double X);
     float atan2f(float Y,float X);
   *Description*
`atan2' computes the inverse tangent (Arctan) of Y/X. `atan2' produces
the correct result even for angles near pi/2 or -pi/2 (that is, when X
is near 0).

   `atan2f' is identical to `atan2', save that it takes and returns
`float'.

*Returns*
`atan2' and `atan2f' return a value in radians, in the range of -pi to
pi.

   If both X and Y are 0.0, `atan2' causes a `DOMAIN' error.

   You can modify error handling for these functions using `matherr'.

*Portability*
`atan2' is ANSI C.  `atan2f' is an extension.


File: libm.i,  Node: atanh,  Next: bessel,  Prev: atan2,  Up: Functions

`atanh', `atanhf'--inverse hyperbolic tangent
=============================================

   *Synopsis*
     #include <math.h>
     double atanh(double X);
     float atanhf(float X);
   *Description*
`atanh' calculates the inverse hyperbolic tangent of X.

   `atanhf' is identical, other than taking and returning `float'
values.

*Returns*
`atanh' and `atanhf' return the calculated value.

   If
     X|
   is greater than 1, the global `errno' is set to `EDOM'.

   If
     X|
   is 1, the global `errno' is set to `ERANGE'; the result is has the
same sign as X, and magnitude `HUGE_VAL' (for `atanh') or `FLT_MAX'
(for `atanhf').

*Portability*
Neither `atanh' nor `atanhf' are ANSI C.


File: libm.i,  Node: bessel,  Next: copysign,  Prev: atanh,  Up: Functions

`j0',`j0f',`j1',`j1f',`jn',`jnf',`y0',`y0f',`y1',`y1f',`yn',`ynf'--Bessel functions
===================================================================================

   *Synopsis*
     #include <math.h>
     double j0(double X);
     float j0f(float X);
     double j1(double X);
     float j1f(float X);
     double jn(int N, double X);
     float jnf(int N, float X);
     double y0(double X);
     float y0f(float X);
     double y1(double X);
     float y1f(float X);
     double yn(int N, double X);
     float ynf(int N, float X);
   *Description*
The Bessel functions are a family of functions that solve the
differential equation
       2               2    2
      x  y'' + xy' + (x  - p )y  = 0
   These functions have many applications in engineering and physics.

   `jn' calculates the Bessel function of the first kind of order N. 
`j0' and `j1' are special cases for order 0 and order 1 respectively.

   Similarly, `yn' calculates the Bessel function of the second kind of
order N, and `y0' and `y1' are special cases for order 0 and 1.

   `jnf', `j0f', `j1f', `ynf', `y0f', and `y1f' perform the same
calculations, but on `float' rather than `double' values.

*Returns*
The value of each Bessel function at X is returned.

*Portability*
None of the Bessel functions are in ANSI C.


File: libm.i,  Node: copysign,  Next: cosh,  Prev: bessel,  Up: Functions

`copysign', `copysignf'--sign of Y, magnitude of X
==================================================

   *Synopsis*
     #include <math.h>
     double copysign (double X, double Y);
     float copysignf (float X, float Y);
   *Description*
`copysign' constructs a number with the magnitude (absolute value) of
its first argument, X, and the sign of its second argument, Y.

   `copysignf' does the same thing; the two functions differ only in
the type of their arguments and result.

*Returns*
`copysign' returns a `double' with the magnitude of X and the sign of Y.
`copysignf' returns a `float' with the magnitude of X and the sign of Y.

*Portability*
`copysign' is not required by either ANSI C or the System V Interface
Definition (Issue 2).


File: libm.i,  Node: cosh,  Next: erf,  Prev: copysign,  Up: Functions

`cosh', `coshf'--hyperbolic cosine
==================================

   *Synopsis*
     #include <math.h>
     double cosh(double X);
     float coshf(float X)
   *Description*
`cosh' computes the hyperbolic cosine of the argument X. `cosh(X)' is
defined as
      (exp(x) + exp(-x))/2

   Angles are specified in radians. `coshf' is identical, save that it
takes and returns `float'.

*Returns*
The computed value is returned.  When the correct value would create an
overflow,  `cosh' returns the value `HUGE_VAL' with the appropriate
sign, and the global value `errno' is set to `ERANGE'.

   `cosh' and `coshf' return `FLT_MAX' on overflow.

   You can modify error handling for these functions using the function
`matherr'.

*Portability*
`cosh' is ANSI. `coshf' is an extension.


File: libm.i,  Node: erf,  Next: exp,  Prev: cosh,  Up: Functions

`erf', `erff', `erfc', `erfcf'--error function
==============================================

   *Synopsis*
     #include <math.h>
     double erf(double X);
     float erff(float X);
     double erfc(double X);
     float erfcf(float X);
   *Description*
`erf' calculates an approximation to the "error function", which
estimates the probability that an observation will fall within X
standard deviations of the mean (assuming a normal distribution).

   `erfc' calculates the complementary probability; that is, `erfc(X)'
is `1 - erf(X)'.  `erfc' is computed directly, so that you can use it
to avoid the loss of precision that would result from subtracting large
probabilities (on large X) from 1.

   `erff' and `erfcf' differ from `erf' and `erfc' only in the argument
and result types.

*Returns*
For positive arguments, `erf' and all its variants return a
probability--a number between 0 and 1.

*Portability*
None of the variants of `erf' are ANSI C.


File: libm.i,  Node: exp,  Next: fabs,  Prev: erf,  Up: Functions

`exp', `expf'--exponential
==========================

   *Synopsis*
     #include <math.h>
     double exp(double X);
     float expf(float X);
   *Description*
`exp' and `expf' calculate the exponential of X, that is, e raised to
the power X (where e is the base of the natural system of logarithms,
approximately 2.71828).

   You can use the (non-ANSI) function `matherr' to specify error
handling for these functions.

*Returns*
On success, `exp' and `expf' return the calculated value. Otherwise, on
underflow (when X is a negative number whose magnitude is too large for
the result to be representable), the returned value is `0'.  When X is
NaN (not a number), the returned value is the same as X, and the global
`errno' is set to `EDOM'.  When X is too large, the global `errno' is
set to `ERANGE'.  The returned value is `HUGE_VAL' (the largest
representable `double') for `exp', or `FLT_MAX', the largest
representable floating-point value for `expf'.

*Portability*
`exp' is ANSI C.  `expf' is an extension.


File: libm.i,  Node: fabs,  Next: floor,  Prev: exp,  Up: Functions

`fabs', `fabsf'--absolute value (magnitude)
===========================================

   *Synopsis*
     #include <math.h>
     double fabs(double X);
     float fabsf(float X);
   *Description*
`fabs' and `fabsf' calculate the absolute value (magnitude) of the
argument X, by direct manipulation of the bit representation of X.

*Returns*
The calculated value is returned.  No errors are detected.

*Portability*
`fabs' is ANSI. `fabsf' is an extension.


File: libm.i,  Node: floor,  Next: fmod,  Prev: fabs,  Up: Functions

`floor', `floorf', `ceil', `ceilf'--floor and ceiling
=====================================================

   *Synopsis*
     #include <math.h>
     double floor(double X);
     float floorf(float X);
     double ceil(double X);
     float ceilf(float X);
   *Description*
`floor' and `floorf' find the nearest integer less than or equal to X.
`ceil' and `ceilf' find the nearest integer greater than or equal to X.

*Returns*
`floor' and `ceil' return the integer result as a double. `floorf' and
`ceilf' return the integer result as a float.

*Portability*
`floor' and `ceil' are ANSI. `floorf' and `ceilf' are extensions.


File: libm.i,  Node: fmod,  Next: frexp,  Prev: floor,  Up: Functions

`fmod', `fmodf'--floating-point remainder (modulo)
==================================================

   *Synopsis*
     #include <math.h>
     double fmod(double X, double Y)
     float fmodf(float X, float Y)
   *Description*
The `fmod' and `fmodf' functions compute the floating-point remainder
of X/Y (X modulo Y).

*Returns*
The `fmod' function returns the value X-I*Y, for the largest integer I
such that, if Y is nonzero, the result has the same sign as X and
magnitude less than the magnitude of Y.

   `fmod(INF,Y)' is an invalid operation and NaN (not a number) is
returned. `fmod(X,0)' returns 0.0;

   You can modify error treatment for these functions using `matherr'.

*Portability*
`fmod' is ANSI C. `fmodf' is an extension.


File: libm.i,  Node: frexp,  Next: gamma,  Prev: fmod,  Up: Functions

`frexp', `frexpf'--split floating-point number
==============================================

   *Synopsis*
     #include <math.h>
     double frexp(double VAL, int *EXP);
     float frexpf(float VAL, int *EXP);
   *Description*
All non zero, normal numbers can be described as M * 2**P. `frexp'
represents the double VAL as a mantissa M and a power of two P. The
resulting mantissa will always be greater than or equal to `0.5', and
less than `1.0' (as long as VAL is nonzero). The power of two will be
stored in `*'EXP.

   M and P are calculated so that VAL is M times `2' to the power P.

   `frexpf' is identical, other than taking and returning floats rather
than doubles.

*Returns*
`frexp' returns the mantissa M. If VAL is `0', `frexp' will set `*'EXP
to `0' and return `0'.

   A DOMAIN error occurs if VAL is NaN. `*'EXP is set to 0 and VAL is
returned.  A user matherr function can override the return of VAL but
cannot influence the setting of `*'EXP.

*Portability*
`frexp' is ANSI. `frexpf' is an extension.


File: libm.i,  Node: gamma,  Next: hypot,  Prev: frexp,  Up: Functions

`gamma', `gammaf'--logarithmic gamma function
=============================================

   *Synopsis*
     #include <math.h>
     double gamma(double X);
     float gammaf(float X);
   *Description*
`gamma' calculates the natural logarithm of the gamma function of X. 
The gamma function (`exp(gamma(X))') is a generalization of factorial,
and retains the property that `exp(gamma(N))' is equivalent to
`N*exp(gamma(N-1))'. Accordingly, the results of the gamma function
itself grow very quickly.  `gamma' is defined as the natural log of the
gamma function, rather than the gamma function itself, to extend the
useful range of results representable.

   `gammaf' performs the same calculation as `gamma', but uses and
returns `float' values.

*Returns*
Normally, the computed result is returned.

   When X is not positive, or when the result is too large to be
representable, `gamma' returns `HUGE_VAL' and `gammaf' returns
`FLT_MAX'.  In both cases, `errno' is set to `ERANGE'.

   You can modify this error treatment using `matherr'.

*Portability*
Neither `gamma' nor `gammaf' is ANSI C.


File: libm.i,  Node: hypot,  Next: ldexp,  Prev: gamma,  Up: Functions

`hypot', `hypotf'--distance from origin
=======================================

   *Synopsis*
     #include <math.h>
     double hypot(double X, double Y);
     float hypotf(float X, float Y);
   *Description*
`hypot' calculates the Euclidean distance `sqrt(X*X + Y*Y)' between the
origin (0,0) and a point represented by the Cartesian coordinates
(X,Y).  `hypotf' differs only in the type of its arguments and result.

*Returns*
Normally, the distance value is returned.  On overflow, `hypot' returns
`HUGE_VAL' and `hypotf' returns `MAX_FLT'; both set `errno' to `ERANGE'
when this happens.

   You can change the error treatment with `matherr'.

*Portability*
`hypot' and `hypotf' are not ANSI C.


File: libm.i,  Node: ldexp,  Next: log,  Prev: hypot,  Up: Functions

`ldexp', `ldexpf'--load exponent
================================

   *Synopsis*
     #include <math.h>
     double ldexp(double VAL, int EXP);
     float ldexpf(float VAL, int EXP);
   *Description*
`ldexp' calculates the value VAL times 2 to the power EXP. `ldexpf' is
identical, save that it takes and returns `float' rather than `double'
values.

*Returns*
`ldexp' returns the calculated value.

   Underflow and overflow both set `errno' to `ERANGE'. On underflow,
`ldexp' and `ldexpf' return 0.0. On overflow, `ldexp' returns plus or
minus `DBL_MAX'; `ldexpf' returns plus or minus `FLT_MAX'.

*Portability*
`ldexp' is ANSI, `ldexpf' is an extension.


File: libm.i,  Node: log,  Next: log2,  Prev: ldexp,  Up: Functions

`log', `logf'--natural logarithms
=================================

   *Synopsis*
     #include <math.h>
     double log(double X);
     float logf(float X);
   *Description*
Return the natural logarithm of X, that is, its logarithm base e (where
e is the base of the natural system of logarithms, 2.71828...). `log'
and `logf' are identical save for the return and argument types.

   You can use the (non-ANSI) function `matherr' to specify error
handling for these functions.

*Returns*
Normally, returns the calculated value.  When X is zero, the returned
value is `-HUGE_VAL' for `log' (`-FLT_MAX' for `logf'), and `errno' is
set to `ERANGE'.  When X is negative, the returned value is `-HUGE_VAL'
or `-FLT_MAX', and `errno' is set to `EDOM'.  When X is NaN (not a
number), `errno' is set to `EDOM' and the result is X.  You can control
the error behavior via `matherr'.

*Portability*
`log' is ANSI, `logf' is an extension.


File: libm.i,  Node: log2,  Next: log10,  Prev: log,  Up: Functions

`log2', `log2f'--base 2 logarithms
==================================

   *Synopsis*
     #include <math.h>
     double log2(double X);
     float log2f(float X);
   *Description*
`log2' returns the base 2 logarithm of X. It is implemented as `log(X)
/ log(2)'.

   `log2f' is identical, other than taking and returning floats.

*Returns*
`log2' and `log2f' return the calculated value.

   See the description of `log' for information about errors.

*Portability*
`log2' and `log2f' are extensions to ANSI C.


File: libm.i,  Node: log10,  Next: log1p,  Prev: log2,  Up: Functions

`log10', `log10f'--base 10 logarithms
=====================================

   *Synopsis*
     #include <math.h>
     double log10(double X);
     float log10f(float X);
   *Description*
`log10' returns the base 10 logarithm of X. It is implemented as
`log(X) / log(10)'.

   `log10f' is identical, save that it takes and returns `float' values.

*Returns*
`log10' and `log10f' return the calculated value.

   See the description of `log' for information on errors.

*Portability*
`log10' is ANSI C.  `log10f' is an extension.


File: libm.i,  Node: log1p,  Next: matherr,  Prev: log10,  Up: Functions

`log1p', `log1pf'--log of `1 + X'
=================================

   *Synopsis*
     #include <math.h>
     double log1p(double X);
     float log1pf(float X);
   *Description*
`log1p' calculates the natural logarithm of `1+X'.  You can use `log1p'
rather than ``log(1+X)'' for greater precision when X is very small.

   `log1pf' calculates the same thing, but accepts and returns `float'
values rather than `double'.

*Returns*
`log1p' returns a `double', the natural log of `1+X'. `log1pf' returns
a `float', the natural log of `1+X'.

   You can control the error behavior via `matherr'.  By default,
`log1p' sets `errno' to `ERANGE' and returns an IEEE infinity when X is
`-1', and sets `errno' to `EDOM' and returns an IEEE NaN (not a number)
when X is less than `-1'.

*Portability*
Neither `log1p' nor `log1pf' is required by ANSI C or by the System V
Interface Definition (Issue 2).


File: libm.i,  Node: matherr,  Next: modf,  Prev: log1p,  Up: Functions

`matherr'--user modifiable math error handler
=============================================

   *Synopsis*
     #include <math.h>
     int matherr(struct exception *E);
   *Description*
`matherr' is called whenever a math library function generates an error.
You can replace `matherr' by your own subroutine to customize error
treatment.  The customized `matherr' must return 0 if it fails to
resolve the error, and non-zero if the error is resolved.

   When `matherr' returns a nonzero value, no error message is printed
and the value of `errno' is not modified.  You can accomplish either or
both of these things in your own `matherr' using the information passed
in the structure `*E'.

   This is the `exception' structure (defined in ``math.h''):
     	struct exception {
     	        int type;
     	        char *name;
     	        double arg1, arg2, retval;
     	};

   The members of the exception structure have the following meanings:
`type'
     The type of mathematical error that occured; macros encoding error
     types are also defined in ``math.h''.

`name'
     a pointer to a null-terminated string holding the name of the math
     library function where the error occurred.

`arg1, arg2'
     The arguments which caused the error.

`retval'
     The error return value (what the calling function will return).

   The error types defined in ``math.h'' represent possible mathematical
errors as follows:

`DOMAIN'
     An argument was not in the domain of the function; e.g.
     `log(-1.0)'.

`SING'
     The requested calculation would result in a singularity; e.g.
     `pow(0.0,-2.0)'

`OVERFLOW'
     A calculation would produce a result too large to represent; e.g.
     `exp(1000.0)'.

`UNDERFLOW'
     A calculation would produce a result too small to represent; e.g.
     `exp(-1000.0)'.

`TLOSS'
     Total loss of precision.  The result would have no significant
     digits; e.g. `sin(10e70)'.

`PLOSS'
     Partial loss of precision.

*Returns*
The library definition for `matherr' returns `0' in all cases.

   You can change the calling function's result from a customized
`matherr' by modifying `e->retval', which propagates backs to the
caller.

   If `matherr' returns `0' (indicating that it was not able to resolve
the error) the caller sets `errno' to an appropriate value, and prints
an error message.

*Portability*
`matherr' is not ANSI C.


File: libm.i,  Node: modf,  Next: pow,  Prev: matherr,  Up: Functions

`modf', `modff'--split fractional and integer parts
===================================================

   *Synopsis*
     #include <math.h>
     double modf(double VAL, double *IPART);
     float modff(float VAL, float *IPART);
   *Description*
`modf' splits the double VAL apart into an integer part and a
fractional part, returning the fractional part and storing the integer
part in `*IPART'.  No rounding whatsoever is done; the sum of the
integer and fractional parts is guaranteed to be exactly  equal to VAL.
  That is, if . REALPART = modf(VAL, &INTPART); then
``REALPART+INTPART'' is the same as VAL. `modff' is identical, save
that it takes and returns `float' rather than `double' values.

*Returns*
The fractional part is returned.  Each result has the same sign as the
supplied argument VAL.

*Portability*
`modf' is ANSI C. `modff' is an extension.


File: libm.i,  Node: pow,  Next: sqrt,  Prev: modf,  Up: Functions

`pow', `powf'--x to the power y
===============================

   *Synopsis*
     #include <math.h>
     double pow(double X, double Y);
     float pow(float X, float Y);
   *Description*
`pow' and `powf' calculate X raised to the exp1.0nt Y.

*Returns*
On success, `pow' and `powf' return the value calculated.

   When the argument values would produce overflow, `pow' returns
`HUGE_VAL' and `powf' returns `MAX_FLOAT'; both set `errno' to
`ERANGE'.  If the argument X passed to `pow' or `powf' is a negative
noninteger, and Y is also not an integer, then `errno' is set to
`EDOM'.  If X and Y are both 0, then `pow' and `powf' return `1'.

   You can modify error handling for these functions using `matherr'.

*Portability*
`pow' is ANSI C. `powf' is an extension.


File: libm.i,  Node: sqrt,  Next: sincos,  Prev: pow,  Up: Functions

`sqrt', `sqrtf'--positive square root
=====================================

   *Synopsis*
     #include <math.h>
     double sqrt(double X);
     float  sqrtf(float X);
   *Description*
`sqrt' computes the positive square root of the argument. You can
modify error handling for this function with `matherr'.

*Returns*
On success, the square root is returned. If X is real and positive,
then the result is positive.  If X is real and negative, the global
value `errno' is set to `EDOM' (domain error).

*Portability*
`sqrt' is ANSI C.  `sqrtf' is an extension.


File: libm.i,  Node: sincos,  Next: sinh,  Prev: sqrt,  Up: Functions

`sin', `sinf', `cos', `cosf'--sine or cosine
============================================

   *Synopsis*
     #include <math.h>
     double sin(double X);
     float  sinf(float X);
     double cos(double X);
     float cosf(float X);
   *Description*
`sin' and `cos' compute (respectively) the sine and cosine of the
argument X.  Angles are specified in radians.

   `sinf' and `cosf' are identical, save that they take and return
`float' values.

*Returns*
The sine or cosine of X is returned. If X is NaN (not a number),
`errno' is set to `EDOM'.

   You can modify error handling for these functions using `matherr'.

*Portability*
`sin' and `cos' are ANSI C. `sinf' and `cosf' are extensions.


File: libm.i,  Node: sinh,  Next: tan,  Prev: sincos,  Up: Functions

`sinh', `sinhf'--hyperbolic sine
================================

   *Synopsis*
     #include <math.h>
     double sinh(double X);
     float  sinhf(float X);
   *Description*
`sinh' computes the hyperbolic sine of the argument X. Angles are
specified in radians.   `sinh'(X) is defined as
      (exp(X) - exp(-X))/2

   `sinhf' is identical, save that it takes and returns `float' values.

*Returns*
The hyperbolic sine of X is returned.

   When the correct result is too large to be representable (an
overflow),  `sinh' returns `HUGE_VAL' with the appropriate sign, and
sets the global value `errno' to `ERANGE'.

   `sinhf' returns `FLT_MAX' on overflow.

   You can modify error handling for these functions with `matherr'.

*Portability*
`sinh' is ANSI C. `sinhf' is an extension.


File: libm.i,  Node: tan,  Next: tanh,  Prev: sinh,  Up: Functions

`tan', `tanf'--tangent
======================

   *Synopsis*
     #include <math.h>
     double tan(double X);
     float tanf(float X);
   *Description*
`tan' computes the tangent of the argument X. Angles are specified in
radians.

   `tanf' is identical, save that it takes and returns `float' values.

*Returns*
The tangent of X is returned.

   If X is NaN (not a number), `errno' is set to `EDOM'.

   You can modify error handling for these functions using `matherr'.

*Portability*
`tan' is ANSI. `tanf' is an extension.


File: libm.i,  Node: tanh,  Prev: tan,  Up: Functions

`tanh', `tanhf'--hyperbolic tangent
===================================

   *Synopsis*
     #include <math.h>
     double tanh(double X);
     float tanhf(float X);
   *Description*
`tanh' computes the hyperbolic tangent of the argument X.  Angles are
specified in radians.

   `tanh(X)' is defined as
      sinh(X)/cosh(X)
   `tanhf' is identical, save that it takes and returns `float' values.

*Returns*
The hyperbolic tangent of X is returned.

   If X is NaN (not a number), `errno' is set to `EDOM'.

   You can modify error handling for these functions using `matherr'.

*Portability*
`tanh' is ANSI C.  `tanhf' is an extension.


File: libm.i,  Node: Index,  Prev: Functions,  Up: Top

Index
*****

* Menu:

* acos:                                 acos.
* acosf:                                acos.
* acosh:                                acosh.
* acoshf:                               acosh.
* asin:                                 asin.
* asinf:                                asin.
* asinh:                                asinh.
* asinhf:                               asinh.
* atan:                                 atan.
* atan2:                                atan2.
* atan2f:                               atan2.
* atanf:                                atan.
* atanh:                                atanh.
* atanhf:                               atanh.
* ceil:                                 floor.
* ceilf:                                floor.
* copysign:                             copysign.
* copysignf:                            copysign.
* cos:                                  sincos.
* cosf:                                 sincos.
* erf:                                  erf.
* erfc:                                 erf.
* erfcf:                                erf.
* erff:                                 erf.
* exp:                                  exp.
* expf:                                 exp.
* fabs:                                 fabs.
* fabsf:                                fabs.
* floor:                                floor.
* floorf:                               floor.
* fmod:                                 fmod.
* fmodf:                                fmod.
* frexp:                                frexp.
* frexpf:                               frexp.
* gamma:                                gamma.
* gammaf:                               gamma.
* hypot:                                hypot.
* hypotf:                               hypot.
* j0:                                   bessel.
* j0f:                                  bessel.
* j1:                                   bessel.
* j1f:                                  bessel.
* jn:                                   bessel.
* jnf:                                  bessel.
* ldexp:                                ldexp.
* ldexpf:                               ldexp.
* log:                                  log.
* log10:                                log10.
* log10f:                               log10.
* log1p:                                log1p.
* log1pf:                               log1p.
* log2:                                 log2.
* log2f:                                log2.
* logf:                                 log.
* matherr:                              matherr.
* modf:                                 modf.
* modff:                                modf.
* pow:                                  pow.
* powf:                                 pow.
* sin:                                  sincos.
* sinf:                                 sincos.
* sinh:                                 sinh.
* sinhf:                                sinh.
* sqrt:                                 sqrt.
* sqrtf:                                sqrt.
* tan:                                  tan.
* tanf:                                 tan.
* tanh:                                 tanh.
* tanhf:                                tanh.
* y0:                                   bessel.
* y0f:                                  bessel.
* y1:                                   bessel.
* y1f:                                  bessel.
* yn:                                   bessel.
* ynf:                                  bessel.



Tag Table:
Node: Top1192
Node: Overview1391
Node: Functions2731
Node: acosh3167
Node: acos4000
Node: asin4777
Node: asinh5561
Node: atan6357
Node: atan27165
Node: atanh7954
Node: bessel8725
Node: copysign10106
Node: cosh10932
Node: erf11792
Node: exp12822
Node: fabs13912
Node: floor14442
Node: fmod15142
Node: frexp15957
Node: gamma17055
Node: hypot18228
Node: ldexp19004
Node: log19734
Node: log220737
Node: log1021319
Node: log1p21922
Node: matherr22894
Node: modf25359
Node: pow26298
Node: sqrt27140
Node: sincos27775
Node: sinh28547
Node: tan29408
Node: tanh30008
Node: Index30702

End Tag Table
