This is Info file gdb.i, produced by Makeinfo-1.49 from the input file
gdb-h8.texi.

START-INFO-DIR-ENTRY
* Gdb: (gdb).                   The GNU debugger.
END-INFO-DIR-ENTRY
   This file documents the GNU debugger GDB.

   This is Edition 4.06, July 1992, of `Debugging with GDB: the GNU
Source-Level Debugger' for GDB Version _GDB_VN__.

   Copyright (C) 1988, 1989, 1990, 1991, 1992 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the section entitled "GNU General Public License" is included
exactly as in the original, and provided that the entire resulting
derived work is distributed under the terms of a permission notice
identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the section entitled "GNU General Public License"
may be included in a translation approved by the Free Software
Foundation instead of in the original English.


File: gdb.i,  Node: Top,  Next: Summary,  Prev: (DIR),  Up: (DIR)

Debugging with GDB
******************

   This file describes GDB, the GNU symbolic debugger.

   This is Edition 4.06, July 1992, for GDB Version _GDB_VN__.

* Menu:

* Summary::                     Summary of GDB
* Invocation::                  Getting in and out of GDB
* Commands::                    GDB commands
* Running::                     Running programs under GDB
* Stopping::                    Stopping and continuing
* Stack::                       Examining the stack
* Source::                      Examining source files
* Data::                        Examining data
* C::                           C Language Support
* Symbols::                     Examining the symbol table
* Altering::                    Altering execution
* GDB Files::                   GDB's files
* Targets::                     Specifying a debugging target
* Controlling GDB::             Controlling GDB
* Sequences::                   Canned sequences of commands
* GDB Bugs::                    Reporting bugs in GDB
* Index::                       Index


File: gdb.i,  Node: Summary,  Next: Invocation,  Prev: Top,  Up: Top

Summary of GDB
**************

   The purpose of a debugger such as GDB is to allow you to see what is
going on "inside" another program while it executes--or what another
program was doing at the moment it crashed.

   GDB can do four main kinds of things (plus other things in support of
these) to help you catch bugs in the act:

   * Start your program, specifying anything that might affect its
     behavior.

   * Make your program stop on specified conditions.

   * Examine what has happened, when your program has stopped.

   * Change things in your program, so you can experiment with
     correcting the effects of one bug and go on to learn about another.

* Menu:

* Free Software::               Free Software
* Contributors::                Contributors to GDB


File: gdb.i,  Node: Free Software,  Next: Contributors,  Up: Summary

Free Software
=============

   GDB is "free software", protected by the GNU General Public License
(GPL).  The GPL gives you the freedom to copy or adapt a licensed
program--but every person getting a copy also gets with it the freedom
to modify that copy (which means that they must get access to the
source code), and the freedom to distribute further copies. Typical
software companies use copyrights to limit your freedoms; the Free
Software Foundation uses the GPL to preserve these freedoms.

   Fundamentally, the General Public License is a license which says
that you have these freedoms and that you cannot take these freedoms
away from anyone else.


File: gdb.i,  Node: Contributors,  Prev: Free Software,  Up: Summary

Contributors to GDB
===================

   Richard Stallman was the original author of GDB, and of many other
GNU programs.  Many others have contributed to its development.  This
section attempts to credit major contributors.  One of the virtues of
free software is that everyone is free to contribute to it; with
regret, we cannot actually acknowledge everyone here.  The file
`ChangeLog' in the GDB distribution approximates a blow-by-blow account.

   Changes much prior to version 2.0 are lost in the mists of time.

     *Plea:* Additions to this section are particularly welcome.  If you
     or your friends (or enemies; let's be evenhanded) have been
     unfairly omitted from this list, we would like to add your names!

   So that they may not regard their long labor as thankless, we
particularly thank those who shepherded GDB through major releases: Stu
Grossman and John Gilmore (releases 4.6, 4.5, 4.4), John Gilmore
(releases 4.3, 4.2, 4.1, 4.0, and 3.9); Jim Kingdon (releases 3.5, 3.4,
3.3); and Randy Smith (releases 3.2, 3.1, 3.0).  As major maintainer of
GDB for some period, each contributed significantly to the structure,
stability, and capabilities of the entire debugger.

   Richard Stallman, assisted at various times by Pete TerMaat, Chris
Hanson, and Richard Mlynarik, handled releases through 2.8.

   Michael Tiemann is the author of most of the GNU C++ support in GDB,
with significant additional contributions from Per Bothner.  James
Clark wrote the GNU C++ demangler.  Early work on C++ was by Peter
TerMaat (who also did much general update work leading to release 3.0).

   GDB 4 uses the BFD subroutine library to examine multiple
object-file formats; BFD was a joint project of David V.
Henkel-Wallace, Rich Pixley, Steve Chamberlain, and John Gilmore.

   David Johnson wrote the original COFF support; Pace Willison did the
original support for encapsulated COFF.

   Adam de Boor and Bradley Davis contributed the ISI Optimum V support.
Per Bothner, Noboyuki Hikichi, and Alessandro Forin contributed MIPS
support.  Jean-Daniel Fekete contributed Sun 386i support.  Chris
Hanson improved the HP9000 support.  Noboyuki Hikichi and Tomoyuki
Hasei contributed Sony/News OS 3 support.  David Johnson contributed
Encore Umax support.  Jyrki Kuoppala contributed Altos 3068 support.
Keith Packard contributed NS32K support.  Doug Rabson contributed Acorn
Risc Machine support.  Chris Smith contributed Convex support (and
Fortran debugging).  Jonathan Stone contributed Pyramid support.
Michael Tiemann contributed SPARC support.  Tim Tucker contributed
support for the Gould NP1 and Gould Powernode.  Pace Willison
contributed Intel 386 support.  Jay Vosburgh contributed Symmetry
support.

   Rich Schaefer and Peter Schauer helped with support of SunOS shared
libraries.

   Jay Fenlason and Roland McGrath ensured that GDB and GAS agree about
several machine instruction sets.

   Patrick Duval, Ted Goldstein, Vikram Koka and Glenn Engel helped
develop remote debugging.  Intel Corporation and Wind River Systems
contributed remote debugging modules for their products.

   Brian Fox is the author of the readline libraries providing
command-line editing and command history.

   Andrew Beers of SUNY Buffalo wrote the language-switching code and
the Modula-2 support, and contributed the Languages chapter of this
manual.

   Fred Fish wrote most of the support for Unix System Vr4, and enhanced
the command-completion support to cover C++ overloaded symbols.


File: gdb.i,  Node: Invocation,  Next: Commands,  Prev: Summary,  Up: Top

Getting In and Out of GDB
*************************

   This chapter discusses how to start GDB, and how to get out of it.
(The essentials: type `gdb' to start GDB, and type `quit' or `C-d' to
exit.)

* Menu:

* Invoking GDB::                Starting GDB
* Leaving GDB::                 Leaving GDB


File: gdb.i,  Node: Invoking GDB,  Next: Leaving GDB,  Up: Invocation

Starting GDB
============

   For details on starting up gdb as a remote debugger attached to a
Hitachi H8/300 board, see *Note GDB and the Hitachi H8/300: Hitachi
H8/300 Remote.

   Start GDB by running the program `gdb'.  Once it's running, GDB
reads commands from the terminal until you tell it to exit.

   You can also run `gdb' with a variety of arguments and options, to
specify more of your debugging environment at the outset.

   The most usual way to start GDB is with one argument, specifying an
executable program:

     gdb PROGRAM

You can further control how GDB starts up by using command-line
options.  GDB itself can remind you of the options available.

Type

     gdb -help

to display all available options and briefly describe their use (`gdb
-h' is a shorter equivalent).

   All options and command line arguments you give are processed in
sequential order.  The order makes a difference when the `-x' option is
used.

* Menu:

* Hitachi H8/300 Remote::       GDB and the Hitachi H8/300

* File Options::                Choosing Files
* Mode Options::                Choosing Modes


File: gdb.i,  Node: Hitachi H8/300 Remote,  Next: File Options,  Up: Invoking GDB

GDB and the Hitachi H8/300
--------------------------

   GDB needs to know these things to talk to your H8/300:

  1. that you want to use `target hms', the remote debugging interface
     for the H8/300 (this is the default when GDB is configured
     specifically for the H8/300);

  2. what serial device connects your host to your H8/300 (the first
     serial device available on your host is the default);


   GDB depends on an auxiliary terminate-and-stay-resident program
called `asynctsr' to communicate with the H8/300 development board
through a PC serial port.  You must also use the DOS `mode' command to
set up the serial port on the DOS side.

   The following sample session illustrates the steps needed to start a
program under GDB control on your H8/300.  The example uses a sample
H8/300 program called `t.x'.

   First hook up your H8/300 development board.  In this example, we
use a board attached to serial port `COM2'; if you use a different
serial port, substitute its name in the argument of the `mode' command.
When you call `asynctsr', the auxiliary comms program used by the
degugger, you give it just the numeric part of the serial port's name;
for example, `asyncstr 2' below runs `asyncstr' on `COM2'.

     (eg-C:\H8300\TEST) mode com2:9600,n,8,1,p
     
     Resident portion of MODE loaded
     
     COM2: 9600, n, 8, 1, p
     
     (eg-C:\H8300\TEST) asynctsr 2

     *Warning:* We have noticed a bug in PC-NFS that conflicts with
     `asynctsr'.  If you also run PC-NFS on your DOS host, you may need
     to disable it, or even boot without it, to use `asynctsr' to
     control your H8/300 board.

   Now that serial communications are set up, and the H8/300 is
connected, you can start up GDB.  Call `gdb' with the name of your
program as the argument.  `gdb' prompts you, as usual, with the prompt
`(gdb)'.  Use two special commands to begin your debugging session:
`target hms' to specify cross-debugging to the Hitachi board, and the
`load' command to download your program to the board. `load' displays
the names of the program's sections, and a `*' for each 2K of data
downloaded.  (If you want to refresh GDB data on symbols or on the
executable file without downloading, use the GDB commands `file' or
`symbol-file'.  These commands, and `load' itself, are described in
*Note Commands to Specify Files: Files.)

     (eg-C:\H8300\TEST) gdb t.x
     GDB is free software and you are welcome to distribute copies
      of it under certain conditions; type "show copying" to see
      the conditions.
     There is absolutely no warranty for GDB; type "show warranty"
     for details.
     GDB _GDB_VN__, Copyright 1992 Free Software Foundation, Inc...
     (gdb) target hms
     Connected to remote H8/300 HMS system.
     (gdb) load t.x
     .text   : 0x8000 .. 0xabde ***********
     .data   : 0xabde .. 0xad30 *
     .stack  : 0xf000 .. 0xf014 *

   At this point, you're ready to run or debug your program.  From here
on, you can use all the usual GDB commands.  The `break' command sets
breakpoints; the `run' command starts your program; `print' or `x'
display data; the `continue' command resumes execution after stopping
at a breakpoint.  You can use the `help' command at any time to find
out more about GDB commands.

   Remember, however, that *operating system* facilities aren't
available on your H8/300; for example, if your program hangs, you can't
send an interrupt--but you can press the RESET switch!

   Use the RESET button on the H8/300 board
   * to interrupt your program (don't use `ctl-C' on the DOS host--it
     has no way to pass an interrupt signal to the H8/300); and

   * to return to the GDB command prompt after your program finishes
     normally.  The communications protocol provides no other way for
     GDB to detect program completion.

   In either case, GDB will see the effect of a RESET on the H8/300
board as a "normal exit" of your program.


File: gdb.i,  Node: File Options,  Next: Mode Options,  Prev: Hitachi H8/300 Remote,  Up: Invoking GDB

Choosing Files
--------------

   When GDB starts, it reads any argument other than options as
specifying an executable file.  This is the same as if the argument was
specified by the `-se' option.

   Many options have both long and short forms; both are shown in the
following list.  GDB also recognizes the long forms if you truncate
them, so long as enough of the option is present to be unambiguous. (If
you prefer, you can flag option arguments with `--' rather than `-',
though we illustrate the more usual convention.)

`-symbols=FILE'
`-s FILE'
     Read symbol table from file FILE.

`-exec=FILE'
`-e FILE'
     Use file FILE as the executable file to execute when appropriate,
     and for examining pure data in conjunction with a core dump.

`-se=FILE'
     Read symbol table from file FILE and use it as the executable file.

`-command=FILE'
`-x FILE'
     Execute GDB commands from file FILE.  *Note Command Files::.

`-directory=DIRECTORY'
`-d DIRECTORY'
     Add DIRECTORY to the path to search for source files.

`-r'
`-readnow'
     Read each symbol file's entire symbol table immediately, rather
     than the default, which is to read it incrementally as it is
     needed. This makes startup slower, but makes future operations
     faster.


File: gdb.i,  Node: Mode Options,  Prev: File Options,  Up: Invoking GDB

Choosing Modes
--------------

   You can run GDB in various alternative modes--for example, in batch
mode or quiet mode.

`-nx'
`-n'
     Do not execute commands from any `.gdbinit' initialization files.
     Normally, the commands in these files are executed after all the
     command options and arguments have been processed. *Note Command
     Files::.

`-quiet'
`-q'
     "Quiet".  Do not print the introductory and copyright messages. 
     These messages are also suppressed in batch mode.

`-batch'
     Run in batch mode.  Exit with status `0' after processing all the
     command files specified with `-x' (and `.gdbinit', if not
     inhibited). Exit with nonzero status if an error occurs in
     executing the GDB commands in the command files.

     Batch mode may be useful for running GDB as a filter, for example
     to download and run a program on another computer; in order to
     make this more useful, the message

          Program exited normally.

     (which is ordinarily issued whenever a program running under GDB
     control terminates) is not issued when running in batch mode.

`-cd=DIRECTORY'
     Run GDB using DIRECTORY as its working directory, instead of the
     current directory.

`-fullname'
`-f'
     Emacs sets this option when it runs GDB as a subprocess.  It tells
     GDB to output the full file name and line number in a standard,
     recognizable fashion each time a stack frame is displayed (which
     includes each time your program stops).  This recognizable format
     looks like two `\032' characters, followed by the file name, line
     number and character position separated by colons, and a newline. 
     The Emacs-to-GDB interface program uses the two `\032' characters
     as a signal to display the source code for the frame.


File: gdb.i,  Node: Leaving GDB,  Prev: Invoking GDB,  Up: Invocation

Leaving GDB
===========

`quit'
     To exit GDB, use the `quit' command (abbreviated `q'), or type an
     end-of-file character (usually `C-d').

   An interrupt (often `C-c') will not exit from GDB, but rather will
terminate the action of any GDB command that is in progress and return
to GDB command level.  It is safe to type the interrupt character at
any time because GDB does not allow it to take effect until a time when
it is safe.


File: gdb.i,  Node: Commands,  Next: Running,  Prev: Invocation,  Up: Top

GDB Commands
************

   You can abbreviate a GDB command to the first few letters of the
command name, if that abbreviation is unambiguous; and you can repeat
certain GDB commands by typing just RET.  You can also use the TAB key
to get GDB to fill out the rest of a word in a command (or to show you
the alternatives available, if there's more than one possibility).

* Menu:

* Command Syntax::              Command Syntax
* Completion::                  Command Completion
* Help::                        Getting Help


File: gdb.i,  Node: Command Syntax,  Next: Completion,  Up: Commands

Command Syntax
==============

   A GDB command is a single line of input.  There is no limit on how
long it can be.  It starts with a command name, which is followed by
arguments whose meaning depends on the command name.  For example, the
command `step' accepts an argument which is the number of times to step,
as in `step 5'.  You can also use the `step' command with no arguments.
 Some command names do not allow any arguments.

   GDB command names may always be truncated if that abbreviation is
unambiguous.  Other possible command abbreviations are listed in the
documentation for individual commands.  In some cases, even ambiguous
abbreviations are allowed; for example, `s' is specially defined as
equivalent to `step' even though there are other commands whose names
start with `s'.  You can test abbreviations by using them as arguments
to the `help' command.

   A blank line as input to GDB (typing just RET) means to repeat the
previous command. Certain commands (for example, `run') will not repeat
this way; these are commands for which unintentional repetition might
cause trouble and which you are unlikely to want to repeat.

   The `list' and `x' commands, when you repeat them with RET,
construct new arguments rather than repeating exactly as typed.  This
permits easy scanning of source or memory.

   GDB can also use RET in another way: to partition lengthy output, in
a way similar to the common utility `more' (*note Screen Size::.). 
Since it is easy to press one RET too many in this situation, GDB
disables command repetition after any command that generates this sort
of display.

   A line of input starting with `#' is a comment; it does nothing.
This is useful mainly in command files (*note Command Files::.).


File: gdb.i,  Node: Completion,  Next: Help,  Prev: Command Syntax,  Up: Commands

Command Completion
==================

   GDB can fill in the rest of a word in a command for you, if there's
only one possibility; it can also show you what the valid possibilities
are for the next word in a command, at any time.  This works for GDB
commands, GDB subcommands, and the names of symbols in your program.

   Press the TAB key whenever you want GDB to fill out the rest of a
word.  If there's only one possibility, GDB will fill in the word, and
wait for you to finish the command (or press RET to enter it).  For
example, if you type

     (gdb) info bre TAB

GDB fills in the rest of the word `breakpoints', since that's the only
`info' subcommand beginning with `bre':

     (gdb) info breakpoints

You can either press RET at this point, to run the `info breakpoints'
command, or backspace and enter something else, if `breakpoints'
doesn't look like the command you expected.  (If you were sure you
wanted `info breakpoints' in the first place, you might as well just
type RET immediately after `info bre', to exploit command abbreviations
rather than command completion).

   If there is more than one possibility for the next word when you
press TAB, GDB will sound a bell.  You can either supply more
characters and try again, or just press TAB a second time, and GDB will
display all the possible completions for that word.  For example, you
might want to set a breakpoint on a subroutine whose name begins with
`make_', but when you type `b make_TAB' GDB just sounds the bell. 
Typing TAB again will display all the function names in your program
that begin with those characters, for example:

     (gdb) b make_ TAB
GDB sounds bell; press TAB again, to see:
     make_a_section_from_file     make_environ
     make_abs_section             make_function_type
     make_blockvector             make_pointer_type
     make_cleanup                 make_reference_type
     make_command                 make_symbol_completion_list
     (GDBP__) b make_

After displaying the available possibilities, GDB copies your partial
input (`b make_' in the example) so you can finish the command.

   If you just want to see the list of alternatives in the first place,
you can press `M-?' rather than pressing TAB twice. `M-?' means `META
?'.  You can type this as ESC followed by `?'.

   Sometimes the string you need, while logically a "word", may contain
parentheses or other characters that GDB normally excludes from its
notion of a word.  To permit word completion to work in this situation,
you may enclose words in `'' (single quote marks) in GDB commands.

   The most likely situation where you might need this is in typing the
name of a C++ function.  This is because C++ allows function overloading
(multiple definitions of the same function, distinguished by argument
type).  For example, when you want to set a breakpoint you may need to
distinguish whether you mean the version of `name' that takes an `int'
parameter, `name(int)', or the version that takes a `float' parameter,
`name(float)'.  To use the word-completion facilities in this
situation, type a single quote `'' at the beginning of the function
name.  This alerts GDB that it may need to consider more information
than usual when you press TAB or `M-?' to request word completion:

     (gdb) b 'bubble( M-?
     bubble(double,double)    bubble(int,int)
     (gdb) b 'bubble(

   In some cases, GDB can tell that completing a name will require
quotes.  When this happens, GDB will insert the quote for you (while
completing as much as it can) if you do not type the quote in the first
place:

     (gdb) b bub TAB
GDB alters your input line to the following, and rings a bell:
     (gdb) b 'bubble(

In general, GDB can tell that a quote is needed (and inserts it) if you
have not yet started typing the argument list when you ask for
completion on an overloaded symbol.


File: gdb.i,  Node: Help,  Prev: Completion,  Up: Commands

Getting Help
============

   You can always ask GDB itself for information on its commands, using
the command `help'.

`help'
`h'
     You can use `help' (abbreviated `h') with no arguments to display
     a short list of named classes of commands:

          (gdb) help
          List of classes of commands:
          
          running -- Running the program
          stack -- Examining the stack
          data -- Examining data
          breakpoints -- Making program stop at certain points
          files -- Specifying and examining files
          status -- Status inquiries
          support -- Support facilities
          user-defined -- User-defined commands
          aliases -- Aliases of other commands
          obscure -- Obscure features
          
          Type "help" followed by a class name for a list of
          commands in that class.
          Type "help" followed by command name for full
          documentation.
          Command name abbreviations are allowed if unambiguous.
          (gdb)

`help CLASS'
     Using one of the general help classes as an argument, you can get a
     list of the individual commands in that class.  For example, here
     is the help display for the class `status':

          (gdb) help status
          Status inquiries.
          
          List of commands:
          
          show -- Generic command for showing things set with "set"
          info -- Generic command for printing status
          
          Type "help" followed by command name for full
          documentation.
          Command name abbreviations are allowed if unambiguous.
          (gdb)

`help COMMAND'
     With a command name as `help' argument, GDB will display a short
     paragraph on how to use that command.

   In addition to `help', you can use the GDB commands `info' and
`show' to inquire about the state of your program, or the state of GDB
itself.  Each command supports many topics of inquiry; this manual
introduces each of them in the appropriate context.  The listings under
`info' and under `show' in the Index point to all the sub-commands. 
*Note Index::.

`info'
     This command (abbreviated `i') is for describing the state of your
     program; for example, it can list the arguments given to your
     program (`info args'), the registers currently in use (`info
     registers'), or the breakpoints you have set (`info breakpoints').
     You can get a complete list of the `info' sub-commands with
     `help info'.

`show'
     In contrast, `show' is for describing the state of GDB itself. You
     can change most of the things you can `show', by using the related
     command `set'; for example, you can control what number system is
     used for displays with `set radix', or simply inquire which is
     currently in use with `show radix'.

     To display all the settable parameters and their current values,
     you can use `show' with no arguments; you may also use `info set'.
      Both commands produce the same display.

   Here are three miscellaneous `show' subcommands, all of which are
exceptional in lacking corresponding `set' commands:

`show version'
     Show what version of GDB is running.  You should include this
     information in GDB bug-reports.  If multiple versions of GDB are in
     use at your site, you may occasionally want to make sure what
     version of GDB you are running; as GDB evolves, new commands are
     introduced, and old ones may wither away.  The version number is
     also announced when you start GDB with no arguments.

`show copying'
     Display information about permission for copying GDB.

`show warranty'
     Display the GNU "NO WARRANTY" statement.


File: gdb.i,  Node: Running,  Next: Stopping,  Prev: Commands,  Up: Top

Running Programs Under GDB
**************************

   To debug a program, you must run it under GDB.

* Menu:

* Compilation::                 Compiling for Debugging
* Starting::                    Starting your Program


File: gdb.i,  Node: Compilation,  Next: Starting,  Up: Running

Compiling for Debugging
=======================

   In order to debug a program effectively, you need to generate
debugging information when you compile it.  This debugging information
is stored in the object file; it describes the data type of each
variable or function and the correspondence between source line numbers
and addresses in the executable code.

   To request debugging information, specify the `-g' option when you
run the compiler.

   Many C compilers are unable to handle the `-g' and `-O' options
together.  Using those compilers, you cannot generate optimized
executables containing debugging information.

   gcc, the GNU C compiler, supports `-g' with or without `-O', making
it possible to debug optimized code.  We recommend that you *always*
use `-g' whenever you compile a program. You may think your program is
correct, but there is no sense in pushing your luck.

   When you debug a program compiled with `-g -O', remember that the
optimizer is rearranging your code; the debugger will show you what's
really there.  Don't be too surprised when the execution path doesn't
exactly match your source file!  An extreme example: if you define a
variable, but never use it, GDB will never see that variable--because
the compiler optimizes it out of existence.

   Some things do not work as well with `-g -O' as with just `-g',
particularly on machines with instruction scheduling.  If in doubt,
recompile with `-g' alone, and if this fixes the problem, please report
it as a bug (including a test case!).

   Older versions of the GNU C compiler permitted a variant option
`-gg' for debugging information.  GDB no longer supports this format;
if your GNU C compiler has this option, do not use it.


File: gdb.i,  Node: Starting,  Prev: Compilation,  Up: Running

Starting your Program
=====================

`run'
`r'
     Use the `run' command to start your program under GDB.  You must
     first specify the program name with an argument to GDB (*note
     Getting In and Out of GDB: Invocation.), or by using the `file' or
     `exec-file' command (*note Commands to Specify Files: Files.).

   When you issue the `run' command, your program begins to execute
immediately.  *Note Stopping and Continuing: Stopping, for discussion
of how to arrange for your program to stop.  Once your program has
stopped, you may calls functions in your program, using the `print' or
`call' commands.  *Note Examining Data: Data.

   If the modification time of your symbol file has changed since the
last time GDB read its symbols, GDB will discard its symbol table and
re-read it.  When it does this, GDB tries to retain your current
breakpoints.


File: gdb.i,  Node: Stopping,  Next: Stack,  Prev: Running,  Up: Top

Stopping and Continuing
***********************

   The principal purpose of using a debugger is so that you can stop
your program before it terminates; or so that, if your program runs into
trouble, you can investigate and find out why.

   Inside GDB, your program may stop for any of several reasons, such
as a signal, a breakpoint, or reaching a new line after a GDB command
such as `step'.  You may then examine and change variables, set new
breakpoints or remove old ones, and then continue execution.  Usually,
the messages shown by GDB provide ample explanation of the status of
your program--but you can also explicitly request this information at
any time.

`info program'
     Display information about the status of your program: whether it is
     running or not, what process it is, and why it stopped.

* Menu:

* Breakpoints::                 Breakpoints and Watchpoints
* Continuing and Stepping::     Resuming Execution


File: gdb.i,  Node: Breakpoints,  Next: Continuing and Stepping,  Up: Stopping

Breakpoints and Watchpoints
===========================

   A "breakpoint" makes your program stop whenever a certain point in
the program is reached.  For each breakpoint, you can add various
conditions to control in finer detail whether your program will stop.
You can set breakpoints with the `break' command and its variants
(*note Setting Breakpoints: Set Breaks.), to specify the place where
your program should stop by line number, function name or exact address
in the program.

   A "watchpoint" is a special breakpoint that stops your program when
the value of an expression changes.  You must use a different command
to set watchpoints (*note Setting Watchpoints: Set Watchpoints.), but
aside from that, you can manage a watchpoint like any other breakpoint:
you enable, disable, and delete both breakpoints and watchpoints using
the same commands.

   GDB assigns a number to each breakpoint or watchpoint when you
create it; these numbers are successive integers starting with one.  In
many of the commands for controlling various features of breakpoints you
use the breakpoint number to say which breakpoint you want to change.
Each breakpoint may be "enabled" or "disabled"; if disabled, it has no
effect on your program until you enable it again.

* Menu:

* Set Breaks::                  Setting Breakpoints
* Set Watchpoints::             Setting Watchpoints
* Exception Handling::          Breakpoints and Exceptions
* Delete Breaks::               Deleting Breakpoints
* Disabling::                   Disabling Breakpoints
* Conditions::                  Break Conditions
* Break Commands::              Breakpoint Command Lists
* Breakpoint Menus::            Breakpoint Menus
* Error in Breakpoints::


File: gdb.i,  Node: Set Breaks,  Next: Set Watchpoints,  Up: Breakpoints

Setting Breakpoints
-------------------

   Breakpoints are set with the `break' command (abbreviated `b').  The
debugger convenience variable `$bpnum' records the number of the
beakpoint you've set most recently; see *Note Convenience Variables:
Convenience Vars, for a discussion of what you can do with convenience
variables.

   You have several ways to say where the breakpoint should go.

`break FUNCTION'
     Set a breakpoint at entry to function FUNCTION.

`break +OFFSET'
`break -OFFSET'
     Set a breakpoint some number of lines forward or back from the
     position at which execution stopped in the currently selected
     frame.

`break LINENUM'
     Set a breakpoint at line LINENUM in the current source file. That
     file is the last file whose source text was printed.  This
     breakpoint will stop your program just before it executes any of
     the code on that line.

`break FILENAME:LINENUM'
     Set a breakpoint at line LINENUM in source file FILENAME.

`break FILENAME:FUNCTION'
     Set a breakpoint at entry to function FUNCTION found in file
     FILENAME.  Specifying a file name as well as a function name is
     superfluous except when multiple files contain similarly named
     functions.

`break *ADDRESS'
     Set a breakpoint at address ADDRESS.  You can use this to set
     breakpoints in parts of your program which do not have debugging
     information or source files.

`break'
     When called without any arguments, `break' sets a breakpoint at
     the next instruction to be executed in the selected stack frame
     (*note Examining the Stack: Stack.).  In any selected frame but the
     innermost, this will cause your program to stop as soon as control
     returns to that frame.  This is similar to the effect of a
     `finish' command in the frame inside the selected frame--except
     that `finish' does not leave an active breakpoint.  If you use
     `break' without an argument in the innermost frame, GDB will stop
     the next time it reaches the current location; this may be useful
     inside loops.

     GDB normally ignores breakpoints when it resumes execution, until
     at least one instruction has been executed.  If it did not do
     this, you would be unable to proceed past a breakpoint without
     first disabling the breakpoint.  This rule applies whether or not
     the breakpoint already existed when your program stopped.

`break ... if COND'
     Set a breakpoint with condition COND; evaluate the expression COND
     each time the breakpoint is reached, and stop only if the value is
     nonzero--that is, if COND evaluates as true. `...' stands for one
     of the possible arguments described above (or no argument)
     specifying where to break.  *Note Break Conditions: Conditions,
     for more information on breakpoint conditions.

`tbreak ARGS'
     Set a breakpoint enabled only for one stop.  ARGS are the same as
     for the `break' command, and the breakpoint is set in the same
     way, but the breakpoint is automatically disabled after the first
     time your program stops there.  *Note Disabling Breakpoints:
     Disabling.

`rbreak REGEX'
     Set breakpoints on all functions matching the regular expression
     REGEX.  This command sets an unconditional breakpoint on all
     matches, printing a list of all breakpoints it set. Once these
     breakpoints are set, they are treated just like the breakpoints
     set with the `break' command.  They can be deleted, disabled, made
     conditional, etc., in the standard ways.

`info breakpoints [N]'
`info break [N]'
`info watchpoints [N]'
     Print a table of all breakpoints and watchpoints set and not
     deleted, with the following columns for each breakpoint:

    *Breakpoint Numbers*
    *Type*
          Breakpoint or watchpoint.

    *Disposition*
          Whether the breakpoint is marked to be disabled or deleted
          when hit.

    *Enabled or Disabled*
          Enabled breakpoints are marked with `y'.  `n' marks
          breakpoints that are not enabled.

    *Address*
          Where the breakpoint is in your program, as a memory address

    *What*
          Where the breakpoint is in the source for your program, as a
          file and line number.

     Breakpoint commands, if any, are listed after the line for the
     corresponding breakpoint.

     `info break' with a breakpoint number N as argument lists only
     that breakpoint.  The convenience variable `$_' and the default
     examining-address for the `x' command are set to the address of
     the last breakpoint listed (*note Examining Memory: Memory.).

   GDB allows you to set any number of breakpoints at the same place in
your program.  There is nothing silly or meaningless about this.  When
the breakpoints are conditional, this is even useful (*note Break
Conditions: Conditions.).

   GDB itself sometimes sets breakpoints in your program for special
purposes, such as proper handling of `longjmp' (in C programs). These
internal breakpoints are assigned negative numbers, starting with `-1';
`info breakpoints' does not display them.

   You can see these breakpoints with the GDB maintenance command
`maint info breakpoints'.

`maint info breakpoints'
     Using the same format as `info breakpoints', display both the
     breakpoints you've set explicitly, and those GDB is using for
     internal purposes.  Internal breakpoints are shown with negative
     breakpoint numbers.  The type column identifies what kind of
     breakpoint is shown:

    `breakpoint'
          Normal, explicitly set breakpoint.

    `watchpoint'
          Normal, explicitly set watchpoint.

    `longjmp'
          Internal breakpoint, used to handle correctly stepping through
          `longjmp' calls.

    `longjmp resume'
          Internal breakpoint at the target of a `longjmp'.

    `until'
          Temporary internal breakpoint used by the GDB `until' command.

    `finish'
          Temporary internal breakpoint used by the GDB `finish'
          command.


File: gdb.i,  Node: Set Watchpoints,  Next: Exception Handling,  Prev: Set Breaks,  Up: Breakpoints

Setting Watchpoints
-------------------

   You can use a watchpoint to stop execution whenever the value of an
expression changes, without having to predict a particular place where
this may happen.

   Watchpoints currently execute two orders of magnitude more slowly
than other breakpoints, but this can well be worth it to catch errors
where you have no clue what part of your program is the culprit.  Some
processors provide special hardware to support watchpoint evaluation;
future releases of GDB will use such hardware if it is available.

`watch EXPR'
     Set a watchpoint for an expression.

`info watchpoints'
     This command prints a list of watchpoints and breakpoints; it is
     the same as `info break'.


File: gdb.i,  Node: Exception Handling,  Next: Delete Breaks,  Prev: Set Watchpoints,  Up: Breakpoints

Breakpoints and Exceptions
--------------------------

   Some languages, such as GNU C++, implement exception handling.  You
can use GDB to examine what caused your program to raise an exception,
and to list the exceptions your program is prepared to handle at a
given point in time.

`catch EXCEPTIONS'
     You can set breakpoints at active exception handlers by using the
     `catch' command.  EXCEPTIONS is a list of names of exceptions to
     catch.

   You can use `info catch' to list active exception handlers. *Note
Information About a Frame: Frame Info.

   There are currently some limitations to exception handling in GDB.
These will be corrected in a future release.

   * If you call a function interactively, GDB normally returns control
     to you when the function has finished executing.  If the call
     raises an exception, however, the call may bypass the mechanism
     that returns control to you and cause your program to simply
     continue running until it hits a breakpoint, catches a signal that
     GDB is listening for, or exits.

   * You cannot raise an exception interactively.

   * You cannot interactively install an exception handler.

   Sometimes `catch' is not the best way to debug exception handling:
if you need to know exactly where an exception is raised, it is better
to stop *before* the exception handler is called, since that way you
can see the stack before any unwinding takes place.  If you set a
breakpoint in an exception handler instead, it may not be easy to find
out where the exception was raised.

   To stop just before an exception handler is called, you need some
knowledge of the implementation.  In the case of GNU C++, exceptions are
raised by calling a library function named `__raise_exception' which
has the following ANSI C interface:

         /* ADDR is where the exception identifier is stored.
            ID is the exception identifier.  */
         void __raise_exception (void **ADDR, void *ID);

To make the debugger catch all exceptions before any stack unwinding
takes place, set a breakpoint on `__raise_exception' (*note Breakpoints
Watchpoints and Exceptions: Breakpoints.).

   With a conditional breakpoint (*note Break Conditions: Conditions.)
that depends on the value of ID, you can stop your program when a
specific exception is raised.  You can use multiple conditional
breakpoints to stop your program when any of a number of exceptions are
raised.


File: gdb.i,  Node: Delete Breaks,  Next: Disabling,  Prev: Exception Handling,  Up: Breakpoints

Deleting Breakpoints
--------------------

   It is often necessary to eliminate a breakpoint or watchpoint once it
has done its job and you no longer want your program to stop there. 
This is called "deleting" the breakpoint.  A breakpoint that has been
deleted no longer exists; it is forgotten.

   With the `clear' command you can delete breakpoints according to
where they are in your program.  With the `delete' command you can
delete individual breakpoints or watchpoints by specifying their
breakpoint numbers.

   It is not necessary to delete a breakpoint to proceed past it.  GDB
automatically ignores breakpoints on the first instruction to be
executed when you continue execution without changing the execution
address.

`clear'
     Delete any breakpoints at the next instruction to be executed in
     the selected stack frame (*note Selecting a Frame: Selection.). 
     When the innermost frame is selected, this is a good way to delete
     a breakpoint where your program just stopped.

`clear FUNCTION'
`clear FILENAME:FUNCTION'
     Delete any breakpoints set at entry to the function FUNCTION.

`clear LINENUM'
`clear FILENAME:LINENUM'
     Delete any breakpoints set at or within the code of the specified
     line.

`delete [breakpoints] [BNUMS...]'
     Delete the breakpoints or watchpoints of the numbers specified as
     arguments.  If no argument is specified, delete all breakpoints
     (GDB asks confirmation, unless you have `set confirm off').  You
     can abbreviate this command as `d'.


File: gdb.i,  Node: Disabling,  Next: Conditions,  Prev: Delete Breaks,  Up: Breakpoints

Disabling Breakpoints
---------------------

   Rather than deleting a breakpoint or watchpoint, you might prefer to
"disable" it.  This makes the breakpoint inoperative as if it had been
deleted, but remembers the information on the breakpoint so that you
can "enable" it again later.

   You disable and enable breakpoints and watchpoints with the `enable'
and `disable' commands, optionally specifying one or more breakpoint
numbers as arguments.  Use `info break' or `info watch' to print a list
of breakpoints or watchpoints if you do not know which numbers to use.

   A breakpoint or watchpoint can have any of four different states of
enablement:

   * Enabled.  The breakpoint will stop your program.  A breakpoint set
     with the `break' command starts out in this state.

   * Disabled.  The breakpoint has no effect on your program.

   * Enabled once.  The breakpoint will stop your program, but when it
     does so it will become disabled.  A breakpoint set with the
     `tbreak' command starts out in this state.

   * Enabled for deletion.  The breakpoint will stop your program, but
     immediately after it does so it will be deleted permanently.

   You can use the following commands to enable or disable breakpoints
and watchpoints:

`disable [breakpoints] [BNUMS...]'
     Disable the specified breakpoints--or all breakpoints, if none are
     listed.  A disabled breakpoint has no effect but is not forgotten.
      All options such as ignore-counts, conditions and commands are
     remembered in case the breakpoint is enabled again later.  You may
     abbreviate `disable' as `dis'.

`enable [breakpoints] [BNUMS...]'
     Enable the specified breakpoints (or all defined breakpoints). 
     They become effective once again in stopping your program.

`enable [breakpoints] once BNUMS...'
     Enable the specified breakpoints temporarily.  Each will be
     disabled again the next time it stops your program.

`enable [breakpoints] delete BNUMS...'
     Enable the specified breakpoints to work once and then die.  Each
     of the breakpoints will be deleted the next time it stops your
     program.

   Save for a breakpoint set with `tbreak' (*note Setting Breakpoints:
Set Breaks.), breakpoints that you set are initially enabled;
subsequently, they become disabled or enabled only when you use one of
the commands above.  (The command `until' can set and delete a
breakpoint of its own, but it will not change the state of your other
breakpoints; see *Note Continuing and Stepping: Continuing and
Stepping.)


File: gdb.i,  Node: Conditions,  Next: Break Commands,  Prev: Disabling,  Up: Breakpoints

Break Conditions
----------------

   The simplest sort of breakpoint breaks every time your program
reaches a specified place.  You can also specify a "condition" for a
breakpoint.  A condition is just a Boolean expression in your
programming language (*note Expressions: Expressions.).  A breakpoint
with a condition evaluates the expression each time your program
reaches it, and your program stops only if the condition is *true*.

   This is the converse of using assertions for program validation; in
that situation, you want to stop when the assertion is violated--that
is, when the condition is false.  In C, if you want to test an
assertion expressed by the condition ASSERT, you should set the
condition `! ASSERT' on the appropriate breakpoint.

   Conditions are also accepted for watchpoints; you may not need them,
since a watchpoint is inspecting the value of an expression anyhow--but
it might be simpler, say, to just set a watchpoint on a variable name,
and specify a condition that tests whether the new value is an
interesting one.

   Break conditions can have side effects, and may even call functions
in your program.  This can be useful, for example, to activate functions
that log program progress, or to use your own print functions to format
special data structures. The effects are completely predictable unless
there is another enabled breakpoint at the same address.  (In that
case, GDB might see the other breakpoint first and stop your program
without checking the condition of this one.)  Note that breakpoint
commands are usually more convenient and flexible for the purpose of
performing side effects when a breakpoint is reached (*note Breakpoint
Command Lists: Break Commands.).

   Break conditions can be specified when a breakpoint is set, by using
`if' in the arguments to the `break' command.  *Note Setting
Breakpoints: Set Breaks.  They can also be changed at any time with the
`condition' command.  The `watch' command does not recognize the `if'
keyword; `condition' is the only way to impose a further condition on a
watchpoint.

`condition BNUM EXPRESSION'
     Specify EXPRESSION as the break condition for breakpoint or
     watchpoint number BNUM.  From now on, this breakpoint will stop
     your program only if the value of EXPRESSION is true (nonzero, in
     C).  When you use `condition', GDB checks EXPRESSION immediately
     for syntactic correctness, and to determine whether symbols in it
     have referents in the context of your breakpoint. GDB does not
     actually evaluate EXPRESSION at the time the `condition' command
     is given, however.  *Note Expressions: Expressions.

`condition BNUM'
     Remove the condition from breakpoint number BNUM.  It becomes an
     ordinary unconditional breakpoint.

   A special case of a breakpoint condition is to stop only when the
breakpoint has been reached a certain number of times.  This is so
useful that there is a special way to do it, using the "ignore count"
of the breakpoint.  Every breakpoint has an ignore count, which is an
integer.  Most of the time, the ignore count is zero, and therefore has
no effect.  But if your program reaches a breakpoint whose ignore count
is positive, then instead of stopping, it just decrements the ignore
count by one and continues.  As a result, if the ignore count value is
N, the breakpoint will not stop the next N times it is reached.

`ignore BNUM COUNT'
     Set the ignore count of breakpoint number BNUM to COUNT. The next
     COUNT times the breakpoint is reached, your program's execution
     will not stop; other than to decrement the ignore count, GDB takes
     no action.

     To make the breakpoint stop the next time it is reached, specify a
     count of zero.

`continue COUNT'
`c COUNT'
`fg COUNT'
     Continue execution of your program, setting the ignore count of the
     breakpoint where your program stopped to COUNT minus one. Thus,
     your program will not stop at this breakpoint until the COUNT'th
     time it is reached.

     An argument to this command is meaningful only when your program
     stopped due to a breakpoint.  At other times, the argument to
     `continue' is ignored.

     The synonym `fg' is provided purely for convenience, and has
     exactly the same behavior as other forms of the command.

   If a breakpoint has a positive ignore count and a condition, the
condition is not checked.  Once the ignore count reaches zero, the
condition will be checked.

   You could achieve the effect of the ignore count with a condition
such as `$foo-- <= 0' using a debugger convenience variable that is
decremented each time.  *Note Convenience Variables: Convenience Vars.


File: gdb.i,  Node: Break Commands,  Next: Breakpoint Menus,  Prev: Conditions,  Up: Breakpoints

Breakpoint Command Lists
------------------------

   You can give any breakpoint (or watchpoint) a series of commands to
execute when your program stops due to that breakpoint.  For example,
you might want to print the values of certain expressions, or enable
other breakpoints.

`commands [BNUM]'
`... COMMAND-LIST ...'
`end'
     Specify a list of commands for breakpoint number BNUM.  The
     commands themselves appear on the following lines.  Type a line
     containing just `end' to terminate the commands.

     To remove all commands from a breakpoint, type `commands' and
     follow it immediately with `end'; that is, give no commands.

     With no BNUM argument, `commands' refers to the last breakpoint or
     watchpoint set (not to the breakpoint most recently encountered).

   Pressing RET as a means of repeating the last GDB command is
disabled within a COMMAND-LIST.

   You can use breakpoint commands to start your program up again. 
Simply use the `continue' command, or `step', or any other command that
resumes execution.  Subsequent commands in the command list are ignored.

   If the first command specified is `silent', the usual message about
stopping at a breakpoint is not printed.  This may be desirable for
breakpoints that are to print a specific message and then continue. If
the remaining commands too print nothing, you will see no sign that the
breakpoint was reached at all.  `silent' is meaningful only at the
beginning of a breakpoint command list.

   The commands `echo' and `output' that allow you to print precisely
controlled output are often useful in silent breakpoints. *Note
Commands for Controlled Output: Output.

   For example, here is how you could use breakpoint commands to print
the value of `x' at entry to `foo' whenever `x' is positive.

     break foo if x>0
     commands
     silent
     echo x is\040
     output x
     echo \n
     cont
     end

   One application for breakpoint commands is to compensate for one bug
so you can test for another.  Put a breakpoint just after the erroneous
line of code, give it a condition to detect the case in which something
erroneous has been done, and give it commands to assign correct values
to any variables that need them.  End with the `continue' command so
that your program does not stop, and start with the `silent' command so
that no output is produced.  Here is an example:

     break 403
     commands
     silent
     set x = y + 4
     cont
     end

   One deficiency in the operation of automatically continuing
breakpoints under Unix appears when your program uses raw mode for the
terminal. GDB switches back to its own terminal modes (not raw) before
executing commands, and then must switch back to raw mode when your
program is continued.  This causes any pending terminal input to be
lost.

   Under Unix, you can get around this problem by writing actions into
the breakpoint condition rather than in commands.  For example

     condition 5  (x = y + 4), 0

specifies a condition expression (*note Expressions: Expressions.) that
will change `x' as needed, then always have the value zero so your
program will not stop.  No input is lost here, because GDB evaluates
break conditions without changing the terminal modes.  When you want to
have nontrivial conditions for performing the side effects, the
operators `&&', `||' and `?...:' may be useful.


File: gdb.i,  Node: Breakpoint Menus,  Next: Error in Breakpoints,  Prev: Break Commands,  Up: Breakpoints

Breakpoint Menus
----------------

   Some programming languages (notably C++) permit a single function
name to be defined several times, for application in different contexts.
This is called "overloading".  When a function name is overloaded,
`break FUNCTION' is not enough to tell GDB where you want a breakpoint.
 If you realize this will be a problem, you can use something like
`break FUNCTION(TYPES)' to specify which particular version of the
function you want.  Otherwise, GDB offers you a menu of numbered
choices for different possible breakpoints, and waits for your
selection with the prompt `>'.  The first two options are always `[0]
cancel' and `[1] all'.  Typing `1' sets a breakpoint at each definition
of FUNCTION, and typing `0' aborts the `break' command without setting
any new breakpoints.

   For example, the following session excerpt shows an attempt to set a
breakpoint at the overloaded symbol `String::after'. We choose three
particular definitions of that function name:

     (gdb) b String::after
     [0] cancel
     [1] all
     [2] file:String.cc; line number:867
     [3] file:String.cc; line number:860
     [4] file:String.cc; line number:875
     [5] file:String.cc; line number:853
     [6] file:String.cc; line number:846
     [7] file:String.cc; line number:735
     > 2 4 6
     Breakpoint 1 at 0xb26c: file String.cc, line 867.
     Breakpoint 2 at 0xb344: file String.cc, line 875.
     Breakpoint 3 at 0xafcc: file String.cc, line 846.
     Multiple breakpoints were set.
     Use the "delete" command to delete unwanted breakpoints.
     (gdb)


File: gdb.i,  Node: Error in Breakpoints,  Prev: Breakpoint Menus,  Up: Breakpoints

"Cannot Insert Breakpoints"
---------------------------

   Under some operating systems, breakpoints cannot be used in a
program if any other process is running that program.  In this
situation, attempting to run or continue a program with a breakpoint
causes GDB to stop the other process.

   When this happens, you have three ways to proceed:

  1. Remove or disable the breakpoints, then continue.

  2. Suspend GDB, and copy the file containing your program to a new
     name. Resume GDB and use the `exec-file' command to specify that
     GDB should run your program under that name.  Then start your
     program again.

  3. Relink your program so that the text segment is nonsharable, using
     the linker option `-N'.  The operating system limitation may not
     apply to nonsharable executables.


File: gdb.i,  Node: Continuing and Stepping,  Prev: Breakpoints,  Up: Stopping

Continuing and Stepping
=======================

   "Continuing" means resuming program execution until your program
completes normally.  In contrast, "stepping" means executing just one
more "step" of your program, where "step" may mean either one line of
source code, or one machine instruction (depending on what particular
command you use).  Either when continuing or when stepping, your
program may stop even sooner, due to a breakpoint.

`continue [IGNORE-COUNT]'
     Resume program execution, at the address where your program last
     stopped; any breakpoints set at that address are bypassed.  The
     optional argument IGNORE-COUNT allows you to specify a further
     number of times to ignore a breakpoint at this location; its
     effect is like that of `ignore' (*note Break Conditions:
     Conditions.).

     To resume execution at a different place, you can use `return'
     (*note Returning from a Function: Returning.) to go back to the
     calling function; or `jump' (*note Continuing at a Different
     Address: Jumping.) to go to an arbitrary location in your program.

   A typical technique for using stepping is to set a breakpoint (*note
Breakpoints Watchpoints and Exceptions: Breakpoints.) at the beginning
of the function or the section of your program where a problem is
believed to lie, run your program until it stops at that breakpoint,
and then step through the suspect area, examining the variables that
are interesting, until you see the problem happen.

`step'
     Continue running your program until control reaches a different
     source line, then stop it and return control to GDB.  This command
     is abbreviated `s'.

          *Warning:* If you use the `step' command while control is
          within a function that was compiled without debugging
          information, execution will proceed until control reaches
          another function.

`step COUNT'
     Continue running as in `step', but do so COUNT times.  If a
     breakpoint is reached or a signal not related to stepping occurs
     before COUNT steps, stepping stops right away.

`next [COUNT]'
     Continue to the next source line in the current (innermost) stack
     frame. Similar to `step', but any function calls appearing within
     the line of code are executed without stopping.  Execution stops
     when control reaches a different line of code at the stack level
     which was executing when the `next' command was given.  This
     command is abbreviated `n'.

     An argument COUNT is a repeat count, as for `step'.

     `next' within a function that lacks debugging information acts like
     `step', but any function calls appearing within the code of the
     function are executed without stopping.

`finish'
     Continue running until just after function in the selected stack
     frame returns.  Print the returned value (if any).

     Contrast this with the `return' command (*note Returning from a
     Function: Returning.).

`until'
`u'
     Continue running until a source line past the current line, in the
     current stack frame, is reached.  This command is used to avoid
     single stepping through a loop more than once.  It is like the
     `next' command, except that when `until' encounters a jump, it
     automatically continues execution until the program counter is
     greater than the address of the jump.

     This means that when you reach the end of a loop after single
     stepping though it, `until' will cause your program to continue
     execution until the loop is exited.  In contrast, a `next' command
     at the end of a loop will simply step back to the beginning of the
     loop, which would force you to step through the next iteration.

     `until' always stops your program if it attempts to exit the
     current stack frame.

     `until' may produce somewhat counterintuitive results if the order
     of machine code does not match the order of the source lines.  For
     example, in the following excerpt from a debugging session, the `f'
     (`frame') command shows that execution is stopped at line `206';
     yet when we use `until', we get to line `195':

          (gdb) f
          #0  main (argc=4, argv=0xf7fffae8) at m4.c:206
          206                 expand_input();
          (gdb) until
          195             for ( ; argc > 0; NEXTARG) {

     This happened because, for execution efficiency, the compiler had
     generated code for the loop closure test at the end, rather than
     the start, of the loop--even though the test in a C `for'-loop is
     written before the body of the loop.  The `until' command appeared
     to step back to the beginning of the loop when it advanced to this
     expression; however, it has not really gone to an earlier
     statement--not in terms of the actual machine code.

     `until' with no argument works by means of single instruction
     stepping, and hence is slower than `until' with an argument.

`until LOCATION'
`u LOCATION'
     Continue running your program until either the specified location
     is reached, or the current stack frame returns.  LOCATION is any of
     the forms of argument acceptable to `break' (*note Setting
     Breakpoints: Set Breaks.).  This form of the command uses
     breakpoints, and hence is quicker than `until' without an argument.

`stepi'
`si'
     Execute one machine instruction, then stop and return to the
     debugger.

     It is often useful to do `display/i $pc' when stepping by machine
     instructions.  This will cause the next instruction to be executed
     to be displayed automatically at each stop.  *Note Automatic
     Display: Auto Display.

     An argument is a repeat count, as in `step'.

`nexti'
`ni'
     Execute one machine instruction, but if it is a function call,
     proceed until the function returns.

     An argument is a repeat count, as in `next'.


File: gdb.i,  Node: Stack,  Next: Source,  Prev: Stopping,  Up: Top

Examining the Stack
*******************

   When your program has stopped, the first thing you need to know is
where it stopped and how it got there.

   Each time your program performs a function call, the information
about where in your program the call was made from is saved in a block
of data called a "stack frame".  The frame also contains the arguments
of the call and the local variables of the function that was called. 
All the stack frames are allocated in a region of memory called the
"call stack".

   When your program stops, the GDB commands for examining the stack
allow you to see all of this information.

   One of the stack frames is "selected" by GDB and many GDB commands
refer implicitly to the selected frame.  In particular, whenever you ask
GDB for the value of a variable in your program, the value is found in
the selected frame.  There are special GDB commands to select whichever
frame you are interested in.

   When your program stops, GDB automatically selects the currently
executing frame and describes it briefly as the `frame' command does
(*note Information About a Frame: Frame Info.).

* Menu:

* Frames::                      Stack Frames
* Backtrace::                   Backtraces
* Selection::                   Selecting a Frame
* Frame Info::                  Information on a Frame


File: gdb.i,  Node: Frames,  Next: Backtrace,  Up: Stack

Stack Frames
============

   The call stack is divided up into contiguous pieces called "stack
frames", or "frames" for short; each frame is the data associated with
one call to one function.  The frame contains the arguments given to
the function, the function's local variables, and the address at which
the function is executing.

   When your program is started, the stack has only one frame, that of
the function `main'.  This is called the "initial" frame or the
"outermost" frame.  Each time a function is called, a new frame is
made.  Each time a function returns, the frame for that function
invocation is eliminated.  If a function is recursive, there can be
many frames for the same function.  The frame for the function in which
execution is actually occurring is called the "innermost" frame.  This
is the most recently created of all the stack frames that still exist.

   Inside your program, stack frames are identified by their addresses.
 A stack frame consists of many bytes, each of which has its own
address; each kind of computer has a convention for choosing one of
those bytes whose address serves as the address of the frame.  Usually
this address is kept in a register called the "frame pointer register"
while execution is going on in that frame.

   GDB assigns numbers to all existing stack frames, starting with zero
for the innermost frame, one for the frame that called it, and so on
upward.  These numbers do not really exist in your program; they are
assigned by GDB to give you a way of designating stack frames in GDB
commands.

   Some compilers allow functions to be compiled so that they operate
without stack frames.  (For example, the `gcc' option
`-fomit-frame-pointer' will generate functions without a frame.) This
is occasionally done with heavily used library functions to save the
frame setup time.  GDB has limited facilities for dealing with these
function invocations.  If the innermost function invocation has no
stack frame, GDB will nevertheless regard it as though it had a
separate frame, which is numbered zero as usual, allowing correct
tracing of the function call chain.  However, GDB has no provision for
frameless functions elsewhere in the stack.


File: gdb.i,  Node: Backtrace,  Next: Selection,  Prev: Frames,  Up: Stack

Backtraces
==========

   A backtrace is a summary of how your program got where it is.  It
shows one line per frame, for many frames, starting with the currently
executing frame (frame zero), followed by its caller (frame one), and
on up the stack.

`backtrace'
`bt'
     Print a backtrace of the entire stack: one line per frame for all
     frames in the stack.

     You can stop the backtrace at any time by typing the system
     interrupt character, normally `C-c'.

`backtrace N'
`bt N'
     Similar, but print only the innermost N frames.

`backtrace -N'
`bt -N'
     Similar, but print only the outermost N frames.

   The names `where' and `info stack' (abbreviated `info s') are
additional aliases for `backtrace'.

   Each line in the backtrace shows the frame number and the function
name. The program counter value is also shown--unless you use `set
print address off'.  The backtrace also shows the source file name and
line number, as well as the arguments to the function.  The program
counter value is omitted if it is at the beginning of the code for that
line number.

   Here is an example of a backtrace.  It was made with the command `bt
3', so it shows the innermost three frames.

     #0  m4_traceon (obs=0x24eb0, argc=1, argv=0x2b8c8)
         at builtin.c:993
     #1  0x6e38 in expand_macro (sym=0x2b600) at macro.c:242
     #2  0x6840 in expand_token (obs=0x0, t=177664, td=0xf7fffb08)
         at macro.c:71
     (More stack frames follow...)

The display for frame zero does not begin with a program counter value,
indicating that your program has stopped at the beginning of the code
for line `993' of `builtin.c'.


File: gdb.i,  Node: Selection,  Next: Frame Info,  Prev: Backtrace,  Up: Stack

Selecting a Frame
=================

   Most commands for examining the stack and other data in your program
work on whichever stack frame is selected at the moment.  Here are the
commands for selecting a stack frame; all of them finish by printing a
brief description of the stack frame just selected.

`frame N'
`f N'
     Select frame number N.  Recall that frame zero is the innermost
     (currently executing) frame, frame one is the frame that called the
     innermost one, and so on.  The highest-numbered frame is `main''s
     frame.

`frame ADDR'
`f ADDR'
     Select the frame at address ADDR.  This is useful mainly if the
     chaining of stack frames has been damaged by a bug, making it
     impossible for GDB to assign numbers properly to all frames.  In
     addition, this can be useful when your program has multiple stacks
     and switches between them.

`up N'
     Move N frames up the stack.  For positive numbers N, this advances
     toward the outermost frame, to higher frame numbers, to frames
     that have existed longer.  N defaults to one.

`down N'
     Move N frames down the stack.  For positive numbers N, this
     advances toward the innermost frame, to lower frame numbers, to
     frames that were created more recently.  N defaults to one.  You
     may abbreviate `down' as `do'.

   All of these commands end by printing two lines of output describing
the frame.  The first line shows the frame number, the function name,
the arguments, and the source file and line number of execution in that
frame.  The second line shows the text of that source line.  For
example:

     (gdb) up
     #1  0x22f0 in main (argc=1, argv=0xf7fffbf4, env=0xf7fffbfc)
         at env.c:10
     10              read_input_file (argv[i]);

   After such a printout, the `list' command with no arguments will
print ten lines centered on the point of execution in the frame. *Note
Printing Source Lines: List.

`up-silently N'
`down-silently N'
     These two commands are variants of `up' and `down', respectively;
     they differ in that they do their work silently, without causing
     display of the new frame.  They are intended primarily for use in
     GDB command scripts, where the output might be unnecessary and
     distracting.


File: gdb.i,  Node: Frame Info,  Prev: Selection,  Up: Stack

Information About a Frame
=========================

   There are several other commands to print information about the
selected stack frame.

`frame'
`f'
     When used without any argument, this command does not change which
     frame is selected, but prints a brief description of the currently
     selected stack frame.  It can be abbreviated `f'.  With an
     argument, this command is used to select a stack frame (*note
     Selecting a Frame: Selection.).

`info frame'
`info f'
     This command prints a verbose description of the selected stack
     frame, including the address of the frame, the addresses of the
     next frame down (called by this frame) and the next frame up
     (caller of this frame), the language that the source code
     corresponding to this frame was written in, the address of the
     frame's arguments, the program counter saved in it (the address of
     execution in the caller frame), and which registers were saved in
     the frame.  The verbose description is useful when something has
     gone wrong that has made the stack format fail to fit the usual
     conventions.

`info frame ADDR'
`info f ADDR'
     Print a verbose description of the frame at address ADDR, without
     selecting that frame.  The selected frame remains unchanged by
     this command.

`info args'
     Print the arguments of the selected frame, each on a separate line.

`info locals'
     Print the local variables of the selected frame, each on a separate
     line.  These are all variables declared static or automatic within
     all program blocks that execution in this frame is currently
     inside of.

`info catch'
     Print a list of all the exception handlers that are active in the
     current stack frame at the current point of execution.  To see
     other exception handlers, visit the associated frame (using the
     `up', `down', or `frame' commands); then type `info catch'. *Note
     Breakpoints and Exceptions: Exception Handling.


File: gdb.i,  Node: Source,  Next: Data,  Prev: Stack,  Up: Top

Examining Source Files
**********************

   GDB can print parts of your program's source, since the debugging
information recorded in your program tells GDB what source files were
used to build it.  When your program stops, GDB spontaneously prints
the line where it stopped.  Likewise, when you select a stack frame
(*note Selecting a Frame: Selection.), GDB prints the line where
execution in that frame has stopped.  You can print other portions of
source files by explicit command.

* Menu:

* List::                        Printing Source Lines
* Source Path::                 Specifying Source Directories
* Machine Code::                Source and Machine Code


File: gdb.i,  Node: List,  Next: Source Path,  Up: Source

Printing Source Lines
=====================

   To print lines from a source file, use the `list' command
(abbreviated `l').  There are several ways to specify what part of the
file you want to print.

   Here are the forms of the `list' command most commonly used:

`list LINENUM'
     Print lines centered around line number LINENUM in the current
     source file.

`list FUNCTION'
     Print lines centered around the beginning of function FUNCTION.

`list'
     Print more lines.  If the last lines printed were printed with a
     `list' command, this prints lines following the last lines
     printed; however, if the last line printed was a solitary line
     printed as part of displaying a stack frame (*note Examining the
     Stack: Stack.), this prints lines centered around that line.

`list -'
     Print lines just before the lines last printed.

   By default, GDB prints ten source lines with any of these forms of
the `list' command.  You can change this using `set listsize':

`set listsize COUNT'
     Make the `list' command display COUNT source lines (unless the
     `list' argument explicitly specifies some other number).

`show listsize'
     Display the number of lines that `list' will currently display by
     default.

   Repeating a `list' command with RET discards the argument, so it is
equivalent to typing just `list'.  This is more useful than listing the
same lines again.  An exception is made for an argument of `-'; that
argument is preserved in repetition so that each repetition moves up in
the source file.

   In general, the `list' command expects you to supply zero, one or two
"linespecs".  Linespecs specify source lines; there are several ways of
writing them but the effect is always to specify some source line. Here
is a complete description of the possible arguments for `list':

`list LINESPEC'
     Print lines centered around the line specified by LINESPEC.

`list FIRST,LAST'
     Print lines from FIRST to LAST.  Both arguments are linespecs.

`list ,LAST'
     Print lines ending with LAST.

`list FIRST,'
     Print lines starting with FIRST.

`list +'
     Print lines just after the lines last printed.

`list -'
     Print lines just before the lines last printed.

`list'
     As described in the preceding table.

   Here are the ways of specifying a single source line--all the kinds
of linespec.

`NUMBER'
     Specifies line NUMBER of the current source file. When a `list'
     command has two linespecs, this refers to the same source file as
     the first linespec.

`+OFFSET'
     Specifies the line OFFSET lines after the last line printed. When
     used as the second linespec in a `list' command that has two, this
     specifies the line OFFSET lines down from the first linespec.

`-OFFSET'
     Specifies the line OFFSET lines before the last line printed.

`FILENAME:NUMBER'
     Specifies line NUMBER in the source file FILENAME.

`FUNCTION'
     Specifies the line of the open-brace that begins the body of the
     function FUNCTION.

`FILENAME:FUNCTION'
     Specifies the line of the open-brace that begins the body of the
     function FUNCTION in the file FILENAME.  You only need the file
     name with a function name to avoid ambiguity when there are
     identically named functions in different source files.

`*ADDRESS'
     Specifies the line containing the program address ADDRESS. ADDRESS
     may be any expression.


File: gdb.i,  Node: Source Path,  Next: Machine Code,  Prev: List,  Up: Source

Specifying Source Directories
=============================

   Executable programs sometimes do not record the directories of the
source files from which they were compiled, just the names.  Even when
they do, the directories could be moved between the compilation and
your debugging session.  GDB has a list of directories to search for
source files; this is called the "source path".  Each time GDB wants a
source file, it tries all the directories in the list, in the order
they are present in the list, until it finds a file with the desired
name.  Note that the executable search path is *not* used for this
purpose.  Neither is the current working directory, unless it happens
to be in the source path.

   If GDB cannot find a source file in the source path, and the object
program records a directory, GDB tries that directory too.  If the
source path is empty, and there is no record of the compilation
directory, GDB will, as a last resort, look in the current directory.

   Whenever you reset or rearrange the source path, GDB will clear out
any information it has cached about where source files are found, where
each line is in the file, etc.

   When you start GDB, its source path is empty. To add other
directories, use the `directory' command.

`directory DIRNAME ...'
     Add directory DIRNAME to the front of the source path.  Several
     directory names may be given to this command, separated by `:' or
     whitespace.  You may specify a directory that is already in the
     source path; this moves it forward, so it will be searched sooner.

     You can use the string `$cdir' to refer to the compilation
     directory (if one is recorded), and `$cwd' to refer to the current
     working directory.  `$cwd' is not the same as `.'--the former
     tracks the current working directory as it changes during your GDB
     session, while the latter is immediately expanded to the current
     directory at the time you add an entry to the source path.

`directory'
     Reset the source path to empty again.  This requires confirmation.

`show directories'
     Print the source path: show which directories it contains.

   If your source path is cluttered with directories that are no longer
of interest, GDB may sometimes cause confusion by finding the wrong
versions of source.  You can correct the situation as follows:

  1. Use `directory' with no argument to reset the source path to empty.

  2. Use `directory' with suitable arguments to reinstall the
     directories you want in the source path.  You can add all the
     directories in one command.


File: gdb.i,  Node: Machine Code,  Prev: Source Path,  Up: Source

Source and Machine Code
=======================

   You can use the command `info line' to map source lines to program
addresses (and viceversa), and the command `disassemble' to display a
range of addresses as machine instructions.

`info line LINESPEC'
     Print the starting and ending addresses of the compiled code for
     source line LINESPEC.  You can specify source lines in any of the
     ways understood by the `list' command (*note Printing Source
     Lines: List.).

   For example, we can use `info line' to discover the location of the
object code for the first line of function `m4_changequote':

     (gdb) info line m4_changecom
     Line 895 of "builtin.c" starts at pc 0x634c and ends at 0x6350.

We can also inquire (using `*ADDR' as the form for LINESPEC) what
source line covers a particular address:
     (gdb) info line *0x63ff
     Line 926 of "builtin.c" starts at pc 0x63e4 and ends at 0x6404.

   After `info line', the default address for the `x' command is
changed to the starting address of the line, so that `x/i' is
sufficient to begin examining the machine code (*note Examining Memory:
Memory.).  Also, this address is saved as the value of the convenience
variable `$_' (*note Convenience Variables: Convenience Vars.).

`disassemble'
     This specialized command dumps a range of memory as machine
     instructions.  The default memory range is the function
     surrounding the program counter of the selected frame.  A single
     argument to this command is a program counter value; the function
     surrounding this value will be dumped.  Two arguments specify a
     range of addresses (first inclusive, second exclusive) to dump.

   For example, here is the beginning of the output for the disassembly
of a function `fact':

     (gdb) disas fact
     Dump of assembler code for function fact:
     to 0x808c:
     0x802c <fact>: 6d f2		mov.w r2,@-r7
     0x802e <fact+2>:  6d f3		mov.w r3,@-r7
     0x8030 <fact+4>:  6d f6		mov.w r6,@-r7
     0x8032 <fact+6>:  0d 76		mov.w r7,r6
     0x8034 <fact+8>:  6f 70 00 08	mov.w @(0x8,r7),r0
     0x8038 <fact+12>  19 11		sub.w	r1,r1
      .
      .
      .


File: gdb.i,  Node: Data,  Next: C,  Prev: Source,  Up: Top

Examining Data
**************

   The usual way to examine data in your program is with the `print'
command (abbreviated `p'), or its synonym `inspect'.

`print EXP'
`print /F EXP'
     EXP is an expression (in the source language).  By default the
     value of EXP is printed in a format appropriate to its data type;
     you can choose a different format by specifying `/F', where F is a
     letter specifying the format; *note Output formats::..

`print'
`print /F'
     If you omit EXP, GDB displays the last value again (from the
     "value history"; *note Value History: Value History.).  This
     allows you to conveniently inspect the same value in an
     alternative format.

   A more low-level way of examining data is with the `x' command. It
examines data in memory at a specified address and prints it in a
specified format.  *Note Examining Memory: Memory.

   If you are interested in information about types, or about how the
fields of a struct or class are declared, use the `ptype EXP' command
rather than `print'. *Note Examining the Symbol Table: Symbols.

* Menu:

* Expressions::                 Expressions
* Variables::                   Program Variables
* Arrays::                      Artificial Arrays
* Output formats::              Output formats
* Memory::                      Examining Memory
* Auto Display::                Automatic Display
* Print Settings::              Print Settings
* Value History::               Value History
* Convenience Vars::            Convenience Variables
* Registers::                   Registers


File: gdb.i,  Node: Expressions,  Next: Variables,  Up: Data

Expressions
===========

   `print' and many other GDB commands accept an expression and compute
its value.  Any kind of constant, variable or operator defined by the
programming language you are using is legal in an expression in GDB. 
This includes conditional expressions, function calls, casts and string
constants.  It unfortunately does not include symbols defined by
preprocessor `#define' commands.

   GDB supports these operators in addition to those of programming
languages:

`@'
     `@' is a binary operator for treating parts of memory as arrays.
     *Note Artificial Arrays: Arrays, for more information.

`::'
     `::' allows you to specify a variable in terms of the file or
     function where it is defined.  *Note Program Variables: Variables.

`{TYPE} ADDR'
     Refers to an object of type TYPE stored at address ADDR in memory.
      ADDR may be any expression whose value is an integer or pointer
     (but parentheses are required around binary operators, just as in
     a cast).  This construct is allowed regardless of what kind of
     data is normally supposed to reside at ADDR.


File: gdb.i,  Node: Variables,  Next: Arrays,  Prev: Expressions,  Up: Data

Program Variables
=================

   The most common kind of expression to use is the name of a variable
in your program.

   Variables in expressions are understood in the selected stack frame
(*note Selecting a Frame: Selection.); they must either be global (or
static) or be visible according to the scope rules of the programming
language from the point of execution in that frame.  This means that in
the function

     foo (a)
          int a;
     {
       bar (a);
       {
         int b = test ();
         bar (b);
       }
     }

the variable `a' is usable whenever your program is executing within
the function `foo', but the variable `b' is visible only while your
program is executing inside the block in which `b' is declared.

   There is an exception: you can refer to a variable or function whose
scope is a single source file even if the current execution point is not
in this file.  But it is possible to have more than one such variable or
function with the same name (in different source files).  If that
happens, referring to that name has unpredictable effects.  If you wish,
you can specify a static variable in a particular function or file,
using the colon-colon notation:

     FILE::VARIABLE
     FUNCTION::VARIABLE

Here FILE or FUNCTION is the name of the context for the static
VARIABLE.  In the case of file names, you can use quotes to make sure
GDB parses the file name as a single word--for example, to print a
global value of `x' defined in `f2.c':

     (gdb) p 'f2.c'::x

     *Warning:* Occasionally, a local variable may appear to have the
     wrong value at certain points in a function--just after entry to
     the function, and just before exit.  You may see this problem when
     you are stepping by machine instructions.  This is because on most
     machines, it takes more than one instruction to set up a stack
     frame (including local variable definitions); if you are stepping
     by machine instructions, variables may appear to have the wrong
     values until the stack frame is completely built.  On function
     exit, it usually also takes more than one machine instruction to
     destroy a stack frame; after you begin stepping through that group
     of instructions, local variable definitions may be gone.


File: gdb.i,  Node: Arrays,  Next: Output formats,  Prev: Variables,  Up: Data

Artificial Arrays
=================

   It is often useful to print out several successive objects of the
same type in memory; a section of an array, or an array of dynamically
determined size for which only a pointer exists in the program.

   This can be done by constructing an "artificial array" with the
binary operator `@'.  The left operand of `@' should be the first
element of the desired array, as an individual object. The right
operand should be the desired length of the array.  The result is an
array value whose elements are all of the type of the left argument.
The first element is actually the left argument; the second element
comes from bytes of memory immediately following those that hold the
first element, and so on.  Here is an example.  If a program says

     int *array = (int *) malloc (len * sizeof (int));

you can print the contents of `array' with

     p *array@len

   The left operand of `@' must reside in memory.  Array values made
with `@' in this way behave just like other arrays in terms of
subscripting, and are coerced to pointers when used in expressions.
Artificial arrays most often appear in expressions via the value history
(*note Value History: Value History.), after printing one out.)

   Sometimes the artificial array mechanism is not quite enough; in
moderately complex data structures, the elements of interest may not
actually be adjacent--for example, if you are interested in the values
of pointers in an array.  One useful work-around in this situation is
to use a convenience variable (*note Convenience Variables: Convenience
Vars.) as a counter in an expression that prints the first interesting
value, and then repeat that expression via RET.  For instance, suppose
you have an array `dtab' of pointers to structures, and you are
interested in the values of a field `fv' in each structure.  Here is an
example of what you might type:

     set $i = 0
     p dtab[$i++]->fv
     RET
     RET
     ...


File: gdb.i,  Node: Output formats,  Next: Memory,  Prev: Arrays,  Up: Data

Output formats
==============

   By default, GDB prints a value according to its data type.  Sometimes
this is not what you want.  For example, you might want to print a
number in hex, or a pointer in decimal.  Or you might want to view data
in memory at a certain address as a character string or as an
instruction.  To do these things, specify an "output format" when you
print a value.

   The simplest use of output formats is to say how to print a value
already computed.  This is done by starting the arguments of the
`print' command with a slash and a format letter.  The format letters
supported are:

`x'
     Regard the bits of the value as an integer, and print the integer
     in hexadecimal.

`d'
     Print as integer in signed decimal.

`u'
     Print as integer in unsigned decimal.

`o'
     Print as integer in octal.

`t'
     Print as integer in binary.  The letter `t' stands for "two".

`a'
     Print as an address, both absolute in hex and as an offset from the
     nearest preceding symbol.  This format can be used to discover
     where (in what function) an unknown address is located:

          (gdb) p/a 0x54320
          $3 = 0x54320 <_initialize_vx+396>

`c'
     Regard as an integer and print it as a character constant.

`f'
     Regard the bits of the value as a floating point number and print
     using typical floating point syntax.

   For example, to print the program counter in hex (*note
Registers::.), type

     p/x $pc

Note that no space is required before the slash; this is because command
names in GDB cannot contain a slash.

   To reprint the last value in the value history with a different
format, you can use the `print' command with just a format and no
expression.  For example, `p/x' reprints the last value in hex.


File: gdb.i,  Node: Memory,  Next: Auto Display,  Prev: Output formats,  Up: Data

Examining Memory
================

   You can use the command `x' (for "examine") to examine memory in any
of several formats, independently of your program's data types.

`x/NFU ADDR'
`x ADDR'
`x'
     Use the command `x' to examine memory.

   N, F, and U are all optional parameters that specify how much memory
to display and how to format it; ADDR is an expression giving the
address where you want to start displaying memory. If you use defaults
for NFU, you need not type the slash `/'. Several commands set
convenient defaults for ADDR.

N, the repeat count
     The repeat count is a decimal integer; the default is 1.  It
     specifies how much memory (counting by units U) to display.

F, the display format
     The display format is one of the formats used by `print', or `s'
     (null-terminated string) or `i' (machine instruction). The default
     is `x' (hexadecimal) initially, or the format from the last time
     you used either `x' or `print'.

U, the unit size
     The unit size is any of
    `b'
          Bytes.

    `h'
          Halfwords (two bytes).

    `w'
          Words (four bytes).  This is the initial default.

    `g'
          Giant words (eight bytes).

     Each time you specify a unit size with `x', that size becomes the
     default unit the next time you use `x'.  (For the `s' and `i'
     formats, the unit size is ignored and is normally not written.)

ADDR, starting display address
     ADDR is the address where you want GDB to begin displaying memory.
      The expression need not have a pointer value (though it may); it
     is always interpreted as an integer address of a byte of memory.
     *Note Expressions: Expressions, for more information on
     expressions.  The default for ADDR is usually just after the last
     address examined--but several other commands also set the default
     address: `info breakpoints' (to the address of the last breakpoint
     listed), `info line' (to the starting address of a line), and
     `print' (if you use it to display a value from memory).

   For example, `x/3uh 0x54320' is a request to display three halfwords
(`h') of memory, formatted as unsigned decimal integers (`u'), starting
at address `0x54320'.  `x/4xw $sp' prints the four words (`w') of
memory above the stack pointer (here, `$sp'; *note Registers::.) in
hexadecimal (`x').

   Since the letters indicating unit sizes are all distinct from the
letters specifying output formats, you do not have to remember whether
unit size or format comes first; either order will work.  The output
specifications `4xw' and `4wx' mean exactly the same thing. (However,
the count N must come first; `wx4' will not work.)

   Even though the unit size U is ignored for the formats `s' and `i',
you might still want to use a count N; for example, `3i' specifies that
you want to see three machine instructions, including any operands. 
The command `disassemble' gives an alternative way of inspecting
machine instructions; *note Machine Code::..

   All the defaults for the arguments to `x' are designed to make it
easy to continue scanning memory with minimal specifications each time
you use `x'.  For example, after you have inspected three machine
instructions with `x/3i ADDR', you can inspect the next seven with just
`x/7'.  If you use RET to repeat the `x' command, the repeat count N is
used again; the other arguments default as for successive uses of `x'.

   The addresses and contents printed by the `x' command are not saved
in the value history because there is often too much of them and they
would get in the way.  Instead, GDB makes these values available for
subsequent use in expressions as values of the convenience variables
`$_' and `$__'.  After an `x' command, the last address examined is
available for use in expressions in the convenience variable `$_'.  The
contents of that address, as examined, are available in the convenience
variable `$__'.

   If the `x' command has a repeat count, the address and contents saved
are from the last memory unit printed; this is not the same as the last
address printed if several units were printed on the last line of
output.


File: gdb.i,  Node: Auto Display,  Next: Print Settings,  Prev: Memory,  Up: Data

Automatic Display
=================

   If you find that you want to print the value of an expression
frequently (to see how it changes), you might want to add it to the
"automatic display list" so that GDB will print its value each time
your program stops. Each expression added to the list is given a number
to identify it; to remove an expression from the list, you specify that
number. The automatic display looks like this:

     2: foo = 38
     3: bar[5] = (struct hack *) 0x3804

showing item numbers, expressions and their current values.  As with
displays you request manually using `x' or `print', you can specify the
output format you prefer; in fact, `display' decides whether to use
`print' or `x' depending on how elaborate your format specification
is--it uses `x' if you specify a unit size, or one of the two formats
(`i' and `s') that are only supported by `x'; otherwise it uses `print'.

`display EXP'
     Add the expression EXP to the list of expressions to display each
     time your program stops.  *Note Expressions: Expressions.

     `display' will not repeat if you press RET again after using it.

`display/FMT EXP'
     For FMT specifying only a display format and not a size or count,
     add the expression EXP to the auto-display list but arranges to
     display it each time in the specified format FMT. *Note Output
     formats::.

`display/FMT ADDR'
     For FMT `i' or `s', or including a unit-size or a number of units,
     add the expression ADDR as a memory address to be examined each
     time your program stops.  Examining means in effect doing `x/FMT
     ADDR'.  *Note Examining Memory: Memory.

   For example, `display/i $pc' can be helpful, to see the machine
instruction about to be executed each time execution stops (`$pc' is a
common name for the program counter; *note Registers::.).

`undisplay DNUMS...'
`delete display DNUMS...'
     Remove item numbers DNUMS from the list of expressions to display.

     `undisplay' will not repeat if you press RET after using it.
     (Otherwise you would just get the error `No display number ...'.)

`disable display DNUMS...'
     Disable the display of item numbers DNUMS.  A disabled display
     item is not printed automatically, but is not forgotten.  It may be
     enabled again later.

`enable display DNUMS...'
     Enable display of item numbers DNUMS.  It becomes effective once
     again in auto display of its expression, until you specify
     otherwise.

`display'
     Display the current values of the expressions on the list, just as
     is done when your program stops.

`info display'
     Print the list of expressions previously set up to display
     automatically, each one with its item number, but without showing
     the values.  This includes disabled expressions, which are marked
     as such. It also includes expressions which would not be displayed
     right now because they refer to automatic variables not currently
     available.

   If a display expression refers to local variables, then it does not
make sense outside the lexical context for which it was set up.  Such an
expression is disabled when execution enters a context where one of its
variables is not defined.  For example, if you give the command
`display last_char' while inside a function with an argument
`last_char', then this argument will be displayed while your program
continues to stop inside that function.  When it stops elsewhere--where
there is no variable `last_char'--display is disabled.  The next time
your program stops where `last_char' is meaningful, you can enable the
display expression once again.


File: gdb.i,  Node: Print Settings,  Next: Value History,  Prev: Auto Display,  Up: Data

Print Settings
==============

   GDB provides the following ways to control how arrays, structures,
and symbols are printed.

These settings are useful for debugging programs in any language:

`set print address'
`set print address on'
     GDB will print memory addresses showing the location of stack
     traces, structure values, pointer values, breakpoints, and so
     forth, even when it also displays the contents of those addresses.
      The default is on.  For example, this is what a stack frame
     display looks like, with `set print address on':

          (gdb) f
          #0  set_quotes (lq=0x34c78 "<<", rq=0x34c88 ">>")
              at input.c:530
          530         if (lquote != def_lquote)

`set print address off'
     Do not print addresses when displaying their contents.  For
     example, this is the same stack frame displayed with `set print
     address off':

          (gdb) set print addr off
          (gdb) f
          #0  set_quotes (lq="<<", rq=">>") at input.c:530
          530         if (lquote != def_lquote)

`show print address'
     Show whether or not addresses are to be printed.

`set print array'
`set print array on'
     GDB will pretty print arrays.  This format is more convenient to
     read, but uses more space.  The default is off.

`set print array off.'
     Return to compressed format for arrays.

`show print array'
     Show whether compressed or pretty format is selected for displaying
     arrays.

`set print elements NUMBER-OF-ELEMENTS'
     If GDB is printing a large array, it will stop printing after it
     has printed the number of elements set by the `set print elements'
     command. This limit also applies to the display of strings.

`show print elements'
     Display the number of elements of a large array that GDB will print
     before losing patience.

`set print pretty on'
     Cause GDB to print structures in an indented format with one
     member per line, like this:

          $1 = {
            next = 0x0,
            flags = {
              sweet = 1,
              sour = 1
            },
            meat = 0x54 "Pork"
          }

`set print pretty off'
     Cause GDB to print structures in a compact format, like this:

          $1 = {next = 0x0, flags = {sweet = 1, sour = 1}, \
          meat = 0x54 "Pork"}

     This is the default format.

`show print pretty'
     Show which format GDB will use to print structures.

`set print sevenbit-strings on'
     Print using only seven-bit characters; if this option is set, GDB
     will display any eight-bit characters (in strings or character
     values) using the notation `\'NNN.  For example, `M-a' is
     displayed as `\341'.

`set print sevenbit-strings off'
     Print using either seven-bit or eight-bit characters, as required.
      This is the default.

`show print sevenbit-strings'
     Show whether or not GDB will print only seven-bit characters.

`set print union on'
     Tell GDB to print unions which are contained in structures.  This
     is the default setting.

`set print union off'
     Tell GDB not to print unions which are contained in structures.

`show print union'
     Ask GDB whether or not it will print unions which are contained in
     structures.

     For example, given the declarations

          typedef enum {Tree, Bug} Species;
          typedef enum {Big_tree, Acorn, Seedling} Tree_forms;
          typedef enum {Caterpillar, Cocoon, Butterfly}
                        Bug_forms;
          
          struct thing {
            Species it;
            union {
              Tree_forms tree;
              Bug_forms bug;
            } form;
          };
          
          struct thing foo = {Tree, {Acorn}};

     with `set print union on' in effect `p foo' would print

          $1 = {it = Tree, form = {tree = Acorn, bug = Cocoon}}

     and with `set print union off' in effect it would print

          $1 = {it = Tree, form = {...}}

These settings are of interest when debugging C++ programs:

`set print demangle'
`set print demangle on'
     Print C++ names in their source form rather than in the mangled
     form in which they are passed to the assembler and linker for
     type-safe linkage. The default is on.

`show print demangle'
     Show whether C++ names will be printed in mangled or demangled
     form.

`set print asm-demangle'
`set print asm-demangle on'
     Print C++ names in their source form rather than their mangled
     form, even in assembler code printouts such as instruction
     disassemblies. The default is off.

`show print asm-demangle'
     Show whether C++ names in assembly listings will be printed in
     mangled or demangled form.

`set print object'
`set print object on'
     When displaying a pointer to an object, identify the *actual*
     (derived) type of the object rather than the *declared* type, using
     the virtual function table.

`set print object off'
     Display only the declared type of objects, without reference to the
     virtual function table.  This is the default setting.

`show print object'
     Show whether actual, or declared, object types will be displayed.

`set print vtbl'
`set print vtbl on'
     Pretty print C++ virtual function tables.  The default is off.

`set print vtbl off'
     Do not pretty print C++ virtual function tables.

`show print vtbl'
     Show whether C++ virtual function tables are pretty printed, or
     not.


File: gdb.i,  Node: Value History,  Next: Convenience Vars,  Prev: Print Settings,  Up: Data

Value History
=============

   Values printed by the `print' command are saved in GDB's "value
history" so that you can refer to them in other expressions.  Values are
kept until the symbol table is re-read or discarded (for example with
the `file' or `symbol-file' commands).  When the symbol table changes,
the value history is discarded, since the values may contain pointers
back to the types defined in the symbol table.

   The values printed are given "history numbers" for you to refer to
them by.  These are successive integers starting with one.  `print'
shows you the history number assigned to a value by printing `$NUM = '
before the value; here NUM is the history number.

   To refer to any previous value, use `$' followed by the value's
history number.  The way `print' labels its output is designed to
remind you of this.  Just `$' refers to the most recent value in the
history, and `$$' refers to the value before that. `$$N' refers to the
Nth value from the end; `$$2' is the value just prior to `$$', `$$1' is
equivalent to `$$', and `$$0' is equivalent to `$'.

   For example, suppose you have just printed a pointer to a structure
and want to see the contents of the structure.  It suffices to type

     p *$

   If you have a chain of structures where the component `next' points
to the next one, you can print the contents of the next one with this:

     p *$.next

You can print successive links in the chain by repeating this
command--which you can do by just typing RET.

   Note that the history records values, not expressions.  If the value
of `x' is 4 and you type these commands:

     print x
     set x=5

then the value recorded in the value history by the `print' command
remains 4 even though the value of `x' has changed.

`show values'
     Print the last ten values in the value history, with their item
     numbers. This is like `p $$9' repeated ten times, except that `show
     values' does not change the history.

`show values N'
     Print ten history values centered on history item number N.

`show values +'
     Print ten history values just after the values last printed.  If
     no more values are available, produces no display.

   Pressing RET to repeat `show values N' has exactly the same effect
as `show values +'.


File: gdb.i,  Node: Convenience Vars,  Next: Registers,  Prev: Value History,  Up: Data

Convenience Variables
=====================

   GDB provides "convenience variables" that you can use within GDB to
hold on to a value and refer to it later.  These variables exist
entirely within GDB; they are not part of your program, and setting a
convenience variable has no direct effect on further execution of your
program.  That is why you can use them freely.

   Convenience variables are prefixed with `$'.  Any name preceded by
`$' can be used for a convenience variable, unless it is one of the
predefined machine-specific register names (*note Registers::.). (Value
history references, in contrast, are *numbers* preceded by `$'.  *Note
Value History: Value History.)

   You can save a value in a convenience variable with an assignment
expression, just as you would set a variable in your program.  Example:

     set $foo = *object_ptr

would save in `$foo' the value contained in the object pointed to by
`object_ptr'.

   Using a convenience variable for the first time creates it; but its
value is `void' until you assign a new value.  You can alter the value
with another assignment at any time.

   Convenience variables have no fixed types.  You can assign a
convenience variable any type of value, including structures and
arrays, even if that variable already has a value of a different type. 
The convenience variable, when used as an expression, has the type of
its current value.

`show convenience'
     Print a list of convenience variables used so far, and their
     values. Abbreviated `show con'.

   One of the ways to use a convenience variable is as a counter to be
incremented or a pointer to be advanced.  For example, to print a field
from successive elements of an array of structures:

     set $i = 0
     print bar[$i++]->contents
     ... repeat that command by typing RET.

   Some convenience variables are created automatically by GDB and given
values likely to be useful.

`$_'
     The variable `$_' is automatically set by the `x' command to the
     last address examined (*note Examining Memory: Memory.).  Other
     commands which provide a default address for `x' to examine also
     set `$_' to that address; these commands include `info line' and
     `info breakpoint'.  The type of `$_' is `void *' except when set
     by the `x' command, in which case it is a pointer to the type of
     `$__'.

`$__'
     The variable `$__' is automatically set by the `x' command to the
     value found in the last address examined.  Its type is chosen to
     match the format in which the data was printed.


File: gdb.i,  Node: Registers,  Prev: Convenience Vars,  Up: Data

Registers
=========

   You can refer to machine register contents, in expressions, as
variables with names starting with `$'.  The names of registers are
different for each machine; use `info registers' to see the names used
on your machine.

`info registers'
     Print the names and values of all registers except floating-point
     registers (in the selected stack frame).

`info all-registers'
     Print the names and values of all registers, including
     floating-point registers.

`info registers REGNAME ...'
     Print the relativized value of each specified register REGNAME.
     REGNAME may be any register name valid on the machine you are
     using, with or without the initial `$'.

   GDB has four "standard" register names that are available (in
expressions) on most machines--whenever they do not conflict with an
architecture's canonical mnemonics for registers.  The register names
`$pc' and `$sp' are used for the program counter register and the stack
pointer.  `$fp' is used for a register that contains a pointer to the
current stack frame, and `$ps' is used for a register that contains the
processor status.  For example, you could print the program counter in
hex with

     p/x $pc

or print the instruction to be executed next with

     x/i $pc

or add four to the stack pointer (1) with

     set $sp += 4

   Whenever possible, these four standard register names are available
on your machine even though the machine has different canonical
mnemonics, so long as there is no conflict.  The `info registers'
command shows the canonical names.  For example, on the SPARC, `info
registers' displays the processor status register as `$psr' but you can
also refer to it as `$ps'.

   GDB always considers the contents of an ordinary register as an
integer when the register is examined in this way.  Some machines have
special registers which can hold nothing but floating point; these
registers are considered to have floating point values.  There is no way
to refer to the contents of an ordinary register as floating point value
(although you can *print* it as a floating point value with `print/f
$REGNAME').

   Some registers have distinct "raw" and "virtual" data formats.  This
means that the data format in which the register contents are saved by
the operating system is not the same one that your program normally
sees.  For example, the registers of the 68881 floating point
coprocessor are always saved in "extended" (raw) format, but all C
programs expect to work with "double" (virtual) format.  In such cases,
GDB normally works with the virtual format only (the format that makes
sense for your program), but the `info registers' command prints the
data in both formats.

   Normally, register values are relative to the selected stack frame
(*note Selecting a Frame: Selection.).  This means that you get the
value that the register would contain if all stack frames farther in
were exited and their saved registers restored.  In order to see the
true contents of hardware registers, you must select the innermost
frame (with `frame 0').

   However, GDB must deduce where registers are saved, from the machine
code generated by your compiler.  If some registers are not saved, or if
GDB is unable to locate the saved registers, the selected stack frame
will make no difference.

   ---------- Footnotes ----------

   (1)  This is a way of removing one word from the stack, on machines
where stacks grow downward in memory (most machines, nowadays).  This
assumes that the innermost stack frame is selected; setting `$sp' is
not allowed when other stack frames are selected.  To pop entire frames
off the stack, regardless of machine architecture, use `return'; *note
Returning from a Function: Returning..


File: gdb.i,  Node: C,  Next: Symbols,  Prev: Data,  Up: Top

C Language Support
******************

   Information specific to the C language is built into GDB so that you
can use C expressions while degugging.  This also permits GDB to output
values in a manner consistent with C conventions.

* Menu:

* C Operators::                 C Operators
* C Constants::                 C Constants
* Debugging C::                 GDB and C


File: gdb.i,  Node: C Operators,  Next: C Constants,  Up: C

C Operators
===========

   Operators must be defined on values of specific types.  For instance,
`+' is defined on numbers, but not on structures.  Operators are often
defined on groups of types.

   * *Integral types* include `int' with any of its storage-class
     specifiers, `char', and `enum's.

   * *Floating-point types* include `float' and `double'.

   * *Pointer types* include all types defined as `(TYPE *)'.

   * *Scalar types* include all of the above.

The following operators are supported.  They are listed here in order
of increasing precedence:

`,'
     The comma or sequencing operator.  Expressions in a
     comma-separated list are evaluated from left to right, with the
     result of the entire expression being the last expression
     evaluated.

`='
     Assignment.  The value of an assignment expression is the value
     assigned.  Defined on scalar types.

`OP='
     Used in an expression of the form `A OP= B', and translated to
     `A = A OP B'. `OP=' and `=' have the same precendence. OP is any
     one of the operators `|', `^', `&', `<<', `>>', `+', `-', `*',
     `/', `%'.

`?:'
     The ternary operator.  `A ? B : C' can be thought of as:  if A
     then B else C.  A should be of an integral type.

`||'
     Logical OR.  Defined on integral types.

`&&'
     Logical AND.  Defined on integral types.

`|'
     Bitwise OR.  Defined on integral types.

`^'
     Bitwise exclusive-OR.  Defined on integral types.

`&'
     Bitwise AND.  Defined on integral types.

`==, !='
     Equality and inequality.  Defined on scalar types.  The value of
     these expressions is 0 for false and non-zero for true.

`<, >, <=, >='
     Less than, greater than, less than or equal, greater than or equal.
     Defined on scalar types.  The value of these expressions is 0 for
     false and non-zero for true.

`<<, >>'
     left shift, and right shift.  Defined on integral types.

`@'
     The GDB "artificial array" operator (*note Expressions:
     Expressions.).

`+, -'
     Addition and subtraction.  Defined on integral types,
     floating-point types and pointer types.

`*, /, %'
     Multiplication, division, and modulus.  Multiplication and
     division are defined on integral and floating-point types. 
     Modulus is defined on integral types.

`++, --'
     Increment and decrement.  When appearing before a variable, the
     operation is performed before the variable is used in an
     expression; when appearing after it, the variable's value is used
     before the operation takes place.

`*'
     Pointer dereferencing.  Defined on pointer types.  Same precedence
     as `++'.

`&'
     Address operator.  Defined on variables.  Same precedence as `++'.

`-'
     Negative.  Defined on integral and floating-point types.  Same
     precedence as `++'.

`!'
     Logical negation.  Defined on integral types.  Same precedence as
     `++'.

`~'
     Bitwise complement operator.  Defined on integral types.  Same
     precedence as `++'.

`., ->'
     Structure member, and pointer-to-structure member.  For
     convenience, GDB regards the two as equivalent, choosing whether
     to dereference a pointer based on the stored type information.
     Defined on `struct's and `union's.

`[]'
     Array indexing.  `A[I]' is defined as `*(A+I)'.  Same precedence
     as `->'.

`()'
     Function parameter list.  Same precedence as `->'.

`::'
     The GDB scope operator (*note Expressions: Expressions.).


File: gdb.i,  Node: C Constants,  Next: Debugging C,  Prev: C Operators,  Up: C

C Constants
===========

   GDB allows you to express the constants of C in the following ways:

   * Integer constants are a sequence of digits.  Octal constants are
     specified by a leading `0' (ie. zero), and hexadecimal constants by
     a leading `0x' or `0X'.  Constants may also end with a letter `l',
     specifying that the constant should be treated as a `long' value.

   * Floating point constants are a sequence of digits, followed by a
     decimal point, followed by a sequence of digits, and optionally
     followed by an exponent.  An exponent is of the form:
     `e[[+]|-]NNN', where NNN is another sequence of digits.  The `+'
     is optional for positive exponents.

   * Enumerated constants consist of enumerated identifiers, or their
     integral equivalents.

   * Character constants are a single character surrounded by single
     quotes (`''), or a number--the ordinal value of the corresponding
     character (usually its ASCII value).  Within quotes, the single
     character may be represented by a letter or by "escape sequences",
     which are of the form `\NNN', where NNN is the octal representation
     of the character's ordinal value; or of the form `\X', where `X'
     is a predefined special character--for example, `\n' for newline.

   * String constants are a sequence of character constants surrounded
     by double quotes (`"').

   * Pointer constants are an integral value.


File: gdb.i,  Node: Debugging C,  Prev: C Constants,  Up: C

GDB and C
=========

   The `set print union' and `show print union' commands apply to the
`union' type.  When set to `on', any `union' that is inside a `struct'
or `class' will also be printed. Otherwise, it will appear as `{...}'.

   The `@' operator aids in the debugging of dynamic arrays, formed
with pointers and a memory allocation function.  (*note Expressions:
Expressions.)


File: gdb.i,  Node: Symbols,  Next: Altering,  Prev: C,  Up: Top

Examining the Symbol Table
**************************

   The commands described in this section allow you to inquire about the
symbols (names of variables, functions and types) defined in your
program.  This information is inherent in the text of your program and
does not change as your program executes.  GDB finds it in your
program's symbol table, in the file indicated when you started GDB
(*note Choosing Files: File Options.), or by one of the file-management
commands (*note Commands to Specify Files: Files.).

   Occasionally, you may need to refer to symbols that contain unusual
characters, which GDB ordinarily treats as word delimiters.  The most
frequent case is in referring to static variables in other source files
(*note Program Variables: Variables.).  File names are recorded in
object files as debugging symbols, but GDB would ordinarily parse a
typical file name, like `foo.c', as the three words `foo' `.' `c'.  To
allow GDB to recognize `foo.c' as a single symbol, enclose it in single
quotes; for example,

     p 'foo.c'::x

looks up the value of `x' in the scope of the file `foo.c'.

`info address SYMBOL'
     Describe where the data for SYMBOL is stored.  For a register
     variable, this says which register it is kept in.  For a
     non-register local variable, this prints the stack-frame offset at
     which the variable is always stored.

     Note the contrast with `print &SYMBOL', which does not work at all
     for a register variables, and for a stack local variable prints
     the exact address of the current instantiation of the variable.

`whatis EXP'
     Print the data type of expression EXP.  EXP is not actually
     evaluated, and any side-effecting operations (such as assignments
     or function calls) inside it do not take place. *Note Expressions:
     Expressions.

`whatis'
     Print the data type of `$', the last value in the value history.

`ptype TYPENAME'
     Print a description of data type TYPENAME.  TYPENAME may be the
     name of a type, or for C code it may have the form `struct
     STRUCT-TAG', `union UNION-TAG' or `enum ENUM-TAG'.

`ptype EXP'
`ptype'
     Print a description of the type of expression EXP.  `ptype'
     differs from `whatis' by printing a detailed description, instead
     of just the name of the type.  For example, if your program
     declares a variable as

          struct complex {double real; double imag;} v;

     compare the output of the two commands:

          (gdb) whatis v
          type = struct complex
          (gdb) ptype v
          type = struct complex {
              double real;
              double imag;
          }

     As with `whatis', using `ptype' without an argument refers to the
     type of `$', the last value in the value history.

`info types REGEXP'
`info types'
     Print a brief description of all types whose name matches REGEXP
     (or all types in your program, if you supply no argument).  Each
     complete typename is matched as though it were a complete line;
     thus, `i type value' gives information on all types in your
     program whose name includes the string `value', but `i type
     ^value$' gives information only on types whose complete name is
     `value'.

     This command differs from `ptype' in two ways: first, like
     `whatis', it does not print a detailed description; second, it
     lists all source files where a type is defined.

`info source'
     Show the name of the current source file--that is, the source file
     for the function containing the current point of execution--and
     the language it was written in.

`info sources'
     Print the names of all source files in your program for which
     there is debugging information, organized into two lists: files
     whose symbols have already been read, and files whose symbols will
     be read when needed.

`info functions'
     Print the names and data types of all defined functions.

`info functions REGEXP'
     Print the names and data types of all defined functions whose
     names contain a match for regular expression REGEXP. Thus, `info
     fun step' finds all functions whose names include `step'; `info
     fun ^step' finds those whose names start with `step'.

`info variables'
     Print the names and data types of all variables that are declared
     outside of functions (i.e., excluding local variables).

`info variables REGEXP'
     Print the names and data types of all variables (except for local
     variables) whose names contain a match for regular expression
     REGEXP.

`maint print symbols FILENAME'
`maint print psymbols FILENAME'
`maint print msymbols FILENAME'
     Write a dump of debugging symbol data into the file FILENAME.
     These commands are used to debug the GDB symbol-reading code.  Only
     symbols with debugging data are included.  If you use `maint print
     symbols', GDB includes all the symbols for which it has already
     collected full details: that is, FILENAME reflects symbols for
     only those files whose symbols GDB has read.  You can use the
     command `info sources' to find out which files these are.  If you
     use `maint print psymbols' instead, the dump shows information
     about symbols that GDB only knows partially--that is, symbols
     defined in files that GDB has skimmed, but not yet read
     completely.  Finally, `maint print msymbols' dumps just the
     minimal symbol information required for each object file from
     which GDB has read some symbols. The description of `symbol-file'
     explains how GDB reads symbols; both `info source' and
     `symbol-file' are described in *Note Commands to Specify Files:
     Files.


File: gdb.i,  Node: Altering,  Next: GDB Files,  Prev: Symbols,  Up: Top

Altering Execution
******************

   Once you think you have found an error in your program, you might
want to find out for certain whether correcting the apparent error
would lead to correct results in the rest of the run.  You can find the
answer by experiment, using the GDB features for altering execution of
the program.

   For example, you can store new values into variables or memory
locations, give your program a signal, restart it at a different
address, or even return prematurely from a function to its caller.

* Menu:

* Assignment::                  Assignment to Variables
* Jumping::                     Continuing at a Different Address
* Returning::                   Returning from a Function
* Calling::                     Calling your Program's Functions
* Patching::                    Patching your Program


File: gdb.i,  Node: Assignment,  Next: Jumping,  Up: Altering

Assignment to Variables
=======================

   To alter the value of a variable, evaluate an assignment expression.
*Note Expressions: Expressions.  For example,

     print x=4

stores the value 4 into the variable `x', and then prints the value of
the assignment expression (which is 4).

   If you are not interested in seeing the value of the assignment, use
the `set' command instead of the `print' command.  `set' is really the
same as `print' except that the expression's value is not printed and
is not put in the value history (*note Value History: Value History.). 
The expression is evaluated only for its effects.

   If the beginning of the argument string of the `set' command appears
identical to a `set' subcommand, use the `set variable' command instead
of just `set'.  This command is identical to `set' except for its lack
of subcommands.  For example, a program might well have a variable
`width'--which leads to an error if we try to set a new value with just
`set width=13', as we might if `set width' did not happen to be a GDB
command:

     (gdb) whatis width
     type = double
     (gdb) p width
     $4 = 13
     (gdb) set width=47
     Invalid syntax in expression.

The invalid expression, of course, is `=47'.  What we can do in order
to actually set our program's variable `width' is

     (gdb) set var width=47

   GDB allows more implicit conversions in assignments than C; you can
freely store an integer value into a pointer variable or vice versa,
and any structure can be converted to any other structure that is the
same length or shorter.

   To store values into arbitrary places in memory, use the `{...}'
construct to generate a value of specified type at a specified address
(*note Expressions: Expressions.).  For example, `{int}0x83040' refers
to memory location `0x83040' as an integer (which implies a certain size
and representation in memory), and

     set {int}0x83040 = 4

stores the value 4 into that memory location.


File: gdb.i,  Node: Jumping,  Next: Returning,  Prev: Assignment,  Up: Altering

Continuing at a Different Address
=================================

   Ordinarily, when you continue your program, you do so at the place
where it stopped, with the `continue' command.  You can instead
continue at an address of your own choosing, with the following
commands:

`jump LINESPEC'
     Resume execution at line LINESPEC.  Execution will stop
     immediately if there is a breakpoint there.  *Note Printing Source
     Lines: List, for a description of the different forms of LINESPEC.

     The `jump' command does not change the current stack frame, or the
     stack pointer, or the contents of any memory location or any
     register other than the program counter.  If line LINESPEC is in a
     different function from the one currently executing, the results
     may be bizarre if the two functions expect different patterns of
     arguments or of local variables.  For this reason, the `jump'
     command requests confirmation if the specified line is not in the
     function currently executing.  However, even bizarre results are
     predictable if you are well acquainted with the machine-language
     code of your program.

`jump *ADDRESS'
     Resume execution at the instruction at address ADDRESS.

   You can get much the same effect as the `jump' command by storing a
new value into the register `$pc'.  The difference is that this does
not start your program running; it only changes the address where it
*will* run when it is continued.  For example,

     set $pc = 0x485

causes the next `continue' command or stepping command to execute at
address `0x485', rather than at the address where your program stopped.
*Note Continuing and Stepping: Continuing and Stepping.

   The most common occasion to use the `jump' command is to back up,
perhaps with more breakpoints set, over a portion of a program that has
already executed, in order to examine its execution in more detail.


File: gdb.i,  Node: Returning,  Next: Calling,  Prev: Jumping,  Up: Altering

Returning from a Function
=========================

`return'
`return EXPRESSION'
     You can cancel execution of a function call with the `return'
     command.  If you give an EXPRESSION argument, its value is used as
     the function's return value.

   When you use `return', GDB discards the selected stack frame (and
all frames within it).  You can think of this as making the discarded
frame return prematurely.  If you wish to specify a value to be
returned, give that value as the argument to `return'.

   This pops the selected stack frame (*note Selecting a Frame:
Selection.), and any other frames inside of it, leaving its caller as
the innermost remaining frame.  That frame becomes selected.  The
specified value is stored in the registers used for returning values of
functions.

   The `return' command does not resume execution; it leaves the
program stopped in the state that would exist if the function had just
returned.  In contrast, the `finish' command (*note Continuing and
Stepping: Continuing and Stepping.) resumes execution until the
selected stack frame returns naturally.


File: gdb.i,  Node: Calling,  Next: Patching,  Prev: Returning,  Up: Altering

Calling your Program's Functions
================================

`call EXPR'
     Evaluate the expression EXPR without displaying `void' returned
     values.

   You can use this variant of the `print' command if you want to
execute a function from your program, but without cluttering the output
with `void' returned values.  The result is printed and saved in the
value history, if it is not void.


File: gdb.i,  Node: Patching,  Prev: Calling,  Up: Altering

Patching your Program
=====================

   By default, GDB opens the file containing your program's executable
code (or the corefile) read-only.  This prevents accidental alterations
to machine code; but it also prevents you from intentionally patching
your program's binary.

   If you'd like to be able to patch the binary, you can specify that
explicitly with the `set write' command.  For example, you might want
to turn on internal debugging flags, or even to make emergency repairs.

`set write on'
`set write off'
     If you specify `set write on', GDB will open executable files for
     both reading and writing; if you specify `set write off' (the
     default), GDB will open them read-only.

     If you have already loaded a file, you must load it again (using
     the `exec-file' or `core-file' command) after changing `set
     write', for your new setting to take effect.

`show write'
     Display whether executable files will be opened for writing as
     well as reading.


File: gdb.i,  Node: GDB Files,  Next: Targets,  Prev: Altering,  Up: Top

GDB's Files
***********

   GDB needs to know the file name of the program to be debugged, both
in order to read its symbol table and in order to start your program.

* Menu:

* Files::                       Commands to Specify Files
* Symbol Errors::               Errors Reading Symbol Files


File: gdb.i,  Node: Files,  Next: Symbol Errors,  Up: GDB Files

Commands to Specify Files
=========================

   The usual way to specify an executable file name is with the command
argument given when you start GDB, (*note Getting In and Out of GDB:
Invocation..

   Occasionally it is necessary to change to a different file during a
GDB session.  Or you may run GDB and forget to specify a file you want
to use.  In these situations the GDB commands to specify new files are
useful.

`file FILENAME'
     Use FILENAME as the program to be debugged.  It is read for its
     symbols and for the contents of pure memory.  It is also the
     program executed when you use the `run' command.  If you do not
     specify a directory and the file is not found in GDB's working
     directory, GDB uses the environment variable `PATH' as a list of
     directories to search, just as the shell does when looking for a
     program to run.  You can change the value of this variable, for
     both GDB and your program, using the `path' command.

     On systems with memory-mapped files, an auxiliary symbol table file
     `FILENAME.syms' may be available for FILENAME.  If it is, GDB will
     map in the symbol table from `FILENAME.syms', starting up more
     quickly.  See the descriptions of the options `-mapped' and
     `-readnow' (available on the command line, and with the commands
     `file', `symbol-file', or `add-symbol-file'), for more information.

`file'
     `file' with no argument makes GDB discard any information it has
     on both executable file and the symbol table.

`exec-file [ FILENAME ]'
     Specify that the program to be run (but not the symbol table) is
     found in FILENAME.  GDB will search the environment variable `PATH'
     if necessary to locate your program.  Omitting FILENAME means to
     discard information on the executable file.

`symbol-file [ FILENAME ]'
     Read symbol table information from file FILENAME.  `PATH' is
     searched when necessary.  Use the `file' command to get both symbol
     table and program to run from the same file.

     `symbol-file' with no argument clears out GDB's information on your
     program's symbol table.

     The `symbol-file' command causes GDB to forget the contents of its
     convenience variables, the value history, and all breakpoints and
     auto-display expressions.  This is because they may contain
     pointers to the internal data recording symbols and data types,
     which are part of the old symbol table data being discarded inside
     GDB.

     `symbol-file' will not repeat if you press RET again after
     executing it once.

     When GDB is configured for a particular environment, it will
     understand debugging information in whatever format is the standard
     generated for that environment; you may use either a GNU compiler,
     or other compilers that adhere to the local conventions.  Best
     results are usually obtained from GNU compilers; for example,
     using `gcc' you can generate debugging information for optimized
     code.

     On some kinds of object files, the `symbol-file' command does not
     normally read the symbol table in full right away.  Instead, it
     scans the symbol table quickly to find which source files and
     which symbols are present.  The details are read later, one source
     file at a time, as they are needed.

     The purpose of this two-stage reading strategy is to make GDB
     start up faster.  For the most part, it is invisible except for
     occasional pauses while the symbol table details for a particular
     source file are being read.  (The `set verbose' command can turn
     these pauses into messages if desired. *Note Optional Warnings and
     Messages: Messages/Warnings.)

     When the symbol table is stored in COFF format, `symbol-file' does
     read the symbol table data in full right away.  We have not
     implemented the two-stage strategy for COFF yet.

`symbol-file FILENAME [ -readnow ] [ -mapped ]'
`file FILENAME [ -readnow ] [ -mapped ]'
     You can override the GDB two-stage strategy for reading symbol
     tables by using the `-readnow' option with any of the commands that
     load symbol table information, if you want to be sure GDB has the
     entire symbol table available.

`load FILENAME'
     When you select remote debugging to a Hitachi H8/300 board (*note
     GDB and the Hitachi H8/300: Hitachi H8/300 Remote.), the `load'
     command downloads your program to the H8/300 and also opens it as
     the current executable target for GDB on your host (like the
     `file' command).

     `load' will not repeat if you press RET again after using it.

`info files'
`info target'
     `info files' and `info target' are synonymous; both print the
     current targets (*note Specifying a Debugging Target: Targets.),
     including the names of the executable and core dump files
     currently in use by GDB, and the files from which symbols were
     loaded.  The command `help targets' lists all possible targets
     rather than current ones.

   All file-specifying commands allow both absolute and relative file
names as arguments.  GDB always converts the file name to an absolute
path name and remembers it that way.


File: gdb.i,  Node: Symbol Errors,  Prev: Files,  Up: GDB Files

Errors Reading Symbol Files
===========================

   While reading a symbol file, GDB will occasionally encounter
problems, such as symbol types it does not recognize, or known bugs in
compiler output.  By default, GDB does not notify you of such problems,
since they are relatively common and primarily of interest to people
debugging compilers.  If you are interested in seeing information about
ill-constructed symbol tables, you can either ask GDB to print only one
message about each such type of problem, no matter how many times the
problem occurs; or you can ask GDB to print more messages, to see how
many times the problems occur, with the `set complaints' command (*note
Optional Warnings and Messages: Messages/Warnings.).

   The messages currently printed, and their meanings, are:

`inner block not inside outer block in SYMBOL'
     The symbol information shows where symbol scopes begin and end
     (such as at the start of a function or a block of statements). 
     This error indicates that an inner scope block is not fully
     contained in its outer scope blocks.

     GDB circumvents the problem by treating the inner block as if it
     had the same scope as the outer block.  In the error message,
     SYMBOL may be shown as "`(don't know)'" if the outer block is not a
     function.

`block at ADDRESS out of order'
     The symbol information for symbol scope blocks should occur in
     order of increasing addresses.  This error indicates that it does
     not do so.

     GDB does not circumvent this problem, and will have trouble
     locating symbols in the source file whose symbols being read. 
     (You can often determine what source file is affected by
     specifying `set verbose on'.  *Note Optional Warnings and
     Messages: Messages/Warnings.)

`bad block start address patched'
     The symbol information for a symbol scope block has a start address
     smaller than the address of the preceding source line.  This is
     known to occur in the SunOS 4.1.1 (and earlier) C compiler.

     GDB circumvents the problem by treating the symbol scope block as
     starting on the previous source line.

`bad string table offset in symbol N'
     Symbol number N contains a pointer into the string table which is
     larger than the size of the string table.

     GDB circumvents the problem by considering the symbol to have the
     name `foo', which may cause other problems if many symbols end up
     with this name.

`unknown symbol type `0xNN''
     The symbol information contains new data types that GDB does not
     yet know how to read.  `0xNN' is the symbol type of the
     misunderstood information, in hexadecimal.

     GDB circumvents the error by ignoring this symbol information. 
     This will usually allow your program to be debugged, though
     certain symbols will not be accessible.  If you encounter such a
     problem and feel like debugging it, you can debug `gdb' with
     itself, breakpoint on `complain', then go up to the function
     `read_dbx_symtab' and examine `*bufp' to see the symbol.

`stub type has NULL name'
     GDB could not find the full definition for a struct or class.

`const/volatile indicator missing (ok if using g++ v1.x), got...'
     The symbol information for a C++ member function is missing some
     information that recent versions of the compiler should have output
     for it.

`info mismatch between compiler and debugger'
     GDB could not parse a type specification output by the compiler.


File: gdb.i,  Node: Targets,  Next: Controlling GDB,  Prev: GDB Files,  Up: Top

Specifying a Debugging Target
*****************************

   A "target" is the execution environment occupied by your program. You
can use the `target' command to specify one of the target types
configured for GDB (*note Commands for Managing Targets: Target
Commands.).

* Menu:

* Active Targets::              Active Targets
* Target Commands::             Commands for Managing Targets
* Remote::                      Remote Debugging


File: gdb.i,  Node: Active Targets,  Next: Target Commands,  Up: Targets

Active Targets
==============

   When you type `run', your executable file becomes an active process
target as well.  When a process target is active, all GDB commands
requesting memory addresses refer to that target; addresses in an
executable file target are obscured while the process target is active.

   Use the `exec-file' command to select a new executable target (*note
Commands to Specify Files: Files.).


File: gdb.i,  Node: Target Commands,  Next: Remote,  Prev: Active Targets,  Up: Targets

Commands for Managing Targets
=============================

`target TYPE PARAMETERS'
     Connects the GDB host environment to a target machine or process. 
     A target is typically a protocol for talking to debugging
     facilities.  You use the argument TYPE to specify the type or
     protocol of the target machine.

     Further PARAMETERS are interpreted by the target protocol, but
     typically include things like device names or host names to connect
     with, process numbers, and baud rates.

     The `target' command will not repeat if you press RET again after
     executing the command.

`help target'
     Displays the names of all targets available.  To display targets
     currently selected, use either `info target' or `info files'
     (*note Commands to Specify Files: Files.).

`help target NAME'
     Describe a particular target, including any parameters necessary to
     select it.

   Here are some common targets (available, or not, depending on the GDB
configuration):

`target exec PROG'
     An executable file.  `target exec PROG' is the same as `exec-file
     PROG'.

`target core FILENAME'
     A core dump file.  `target core FILENAME' is the same as
     `core-file FILENAME'.

`target hms'
     A Hitachi H8/300 board, attached via serial line to your host.  Use
     special commands `device' and `speed' to control the serial line
     and the communications speed used. *Note GDB and the Hitachi
     H8/300: Hitachi H8/300 Remote.


File: gdb.i,  Node: Remote,  Prev: Target Commands,  Up: Targets

Remote Debugging
================

   If you are trying to debug a program running on a machine that
cannot run GDB in the usual way, it is often useful to use remote
debugging.  For example, you might use remote debugging on an operating
system kernel, or on a small system which does not have a general
purpose operating system powerful enough to run a full-featured
debugger.

   Some configurations of GDB have special serial or TCP/IP interfaces
to make this work with particular debugging targets.  In addition, GDB
comes with a generic serial protocol (specific to GDB, but not specific
to any particular target system) which you can use if you write the
remote stubs--the code that will run on the remote system to
communicate with GDB.

   Other remote targets may be available in your configuration of GDB;
use `help targets' to list them.


File: gdb.i,  Node: Controlling GDB,  Next: Sequences,  Prev: Targets,  Up: Top

Controlling GDB
***************

   You can alter many aspects of GDB's interaction with you by using
the `set' command.  For commands controlling how GDB displays data,
*note Print Settings: Print Settings.; other settings are described
here.

* Menu:

* Prompt::                      Prompt
* Editing::                     Command Editing
* History::                     Command History
* Screen Size::                 Screen Size
* Numbers::                     Numbers
* Messages/Warnings::           Optional Warnings and Messages


File: gdb.i,  Node: Prompt,  Next: Editing,  Up: Controlling GDB

Prompt
======

   GDB indicates its readiness to read a command by printing a string
called the "prompt".  This string is normally `(gdb)'.  You can change
the prompt string with the `set prompt' command.  For instance, when
debugging GDB with GDB, it is useful to change the prompt in one of the
GDBs so that you can always tell which one you are talking to.

`set prompt NEWPROMPT'
     Directs GDB to use NEWPROMPT as its prompt string henceforth.

`show prompt'
     Prints a line of the form: `Gdb's prompt is: YOUR-PROMPT'


File: gdb.i,  Node: Editing,  Next: History,  Prev: Prompt,  Up: Controlling GDB

Command Editing
===============

   GDB reads its input commands via the "readline" interface.  This GNU
library provides consistent behavior for programs which provide a
command line interface to the user.  Advantages are `emacs'-style or
`vi'-style inline editing of commands, `csh'-like history substitution,
and a storage and recall of command history across debugging sessions.

   You may control the behavior of command line editing in GDB with the
command `set'.

`set editing'
`set editing on'
     Enable command line editing (enabled by default).

`set editing off'
     Disable command line editing.

`show editing'
     Show whether command line editing is enabled.


File: gdb.i,  Node: History,  Next: Screen Size,  Prev: Editing,  Up: Controlling GDB

Command History
===============

`set history filename FNAME'
     Set the name of the GDB command history file to FNAME.  This is
     the file from which GDB will read an initial command history list
     or to which it will write this list when it exits.  This list is
     accessed through history expansion or through the history command
     editing characters listed below.  This file defaults to the value
     of the environment variable `GDBHISTFILE', or to `./.gdb_history'
     if this variable is not set.

`set history save'
`set history save on'
     Record command history in a file, whose name may be specified with
     the `set history filename' command.  By default, this option is
     disabled.

`set history save off'
     Stop recording command history in a file.

`set history size SIZE'
     Set the number of commands which GDB will keep in its history list.
     This defaults to the value of the environment variable `HISTSIZE',
     or to 256 if this variable is not set.

   History expansion assigns special meaning to the character `!'.
Since `!' is also the logical not operator in C, history expansion is
off by default. If you decide to enable history expansion with the `set
history expansion on' command, you may sometimes need to follow `!'
(when it is used as logical not, in an expression) with a space or a
tab to prevent it from being expanded.  The readline history facilities
will not attempt substitution on the strings `!=' and `!(', even when
history expansion is enabled.

   The commands to control history expansion are:

`set history expansion on'
`set history expansion'
     Enable history expansion.  History expansion is off by default.

`set history expansion off'
     Disable history expansion.

     The readline code comes with more complete documentation of
     editing and history expansion features.  Users unfamiliar with
     `emacs' or `vi' may wish to read it.

`show history'
`show history filename'
`show history save'
`show history size'
`show history expansion'
     These commands display the state of the GDB history parameters.
     `show history' by itself displays all four states.

`show commands'
     Display the last ten commands in the command history.

`show commands N'
     Print ten commands centered on command number N.

`show commands +'
     Print ten commands just after the commands last printed.


File: gdb.i,  Node: Screen Size,  Next: Numbers,  Prev: History,  Up: Controlling GDB

Screen Size
===========

   Certain commands to GDB may produce large amounts of information
output to the screen.  To help you read all of it, GDB pauses and asks
you for input at the end of each page of output.  Type RET when you
want to continue the output.  GDB also uses the screen width setting to
determine when to wrap lines of output.  Depending on what is being
printed, it tries to break the line at a readable place, rather than
simply letting it overflow onto the following line.

   Normally GDB knows the size of the screen from the termcap data base
together with the value of the `TERM' environment variable and the
`stty rows' and `stty cols' settings. If this is not correct, you can
override it with the `set height' and `set width' commands:

`set height LPP'
`show height'
`set width CPL'
`show width'
     These `set' commands specify a screen height of LPP lines and a
     screen width of CPL characters.  The associated `show' commands
     display the current settings.

     If you specify a height of zero lines, GDB will not pause during
     output no matter how long the output is.  This is useful if output
     is to a file or to an editor buffer.


File: gdb.i,  Node: Numbers,  Next: Messages/Warnings,  Prev: Screen Size,  Up: Controlling GDB

Numbers
=======

   You can always enter numbers in octal, decimal, or hexadecimal in
GDB by the usual conventions: octal numbers begin with `0', decimal
numbers end with `.', and hexadecimal numbers begin with `0x'. Numbers
that begin with none of these are, by default, entered in base 10;
likewise, the default display for numbers--when no particular format is
specified--is base 10.  You can change the default base for both input
and output with the `set radix' command.

`set radix BASE'
     Set the default base for numeric input and display.  Supported
     choices for BASE are decimal 2, 8, 10, 16.  BASE must itself be
     specified either unambiguously or using the current default radix;
     for example, any of

          set radix 1010
          set radix 012
          set radix 10.
          set radix 0xa

     will set the base to decimal.  On the other hand, `set radix 10'
     will leave the radix unchanged no matter what it was.

`show radix'
     Display the current default base for numeric input and display.


File: gdb.i,  Node: Messages/Warnings,  Prev: Numbers,  Up: Controlling GDB

Optional Warnings and Messages
==============================

   By default, GDB is silent about its inner workings.  If you are
running on a slow machine, you may want to use the `set verbose'
command. It will make GDB tell you when it does a lengthy internal
operation, so you will not think it has crashed.

   Currently, the messages controlled by `set verbose' are those which
announce that the symbol table for a source file is being read; see
`symbol-file' in *Note Commands to Specify Files: Files.

`set verbose on'
     Enables GDB's output of certain informational messages.

`set verbose off'
     Disables GDB's output of certain informational messages.

`show verbose'
     Displays whether `set verbose' is on or off.

   By default, if GDB encounters bugs in the symbol table of an object
file, it is silent; but if you are debugging a compiler, you may find
this information useful (*note Errors Reading Symbol Files: Symbol
Errors.).

`set complaints LIMIT'
     Permits GDB to output LIMIT complaints about each type of unusual
     symbols before becoming silent about the problem.  Set LIMIT to
     zero to suppress all complaints; set it to a large number to
     prevent complaints from being suppressed.

`show complaints'
     Displays how many symbol complaints GDB is permitted to produce.

   By default, GDB is cautious, and asks what sometimes seems to be a
lot of stupid questions to confirm certain commands.  For example, if
you try to run a program which is already running:

     (gdb) run
     The program being debugged has been started already.
     Start it from the beginning? (y or n)

   If you are willing to unflinchingly face the consequences of your own
commands, you can disable this "feature":

`set confirm off'
     Disables confirmation requests.

`set confirm on'
     Enables confirmation requests (the default).

`show confirm'
     Displays state of confirmation requests.

   Some systems allow individual object files that make up your program
to be replaced without stopping and restarting your program. If you are
running on one of these systems, you can allow GDB to reload the
symbols for automatically relinked modules:

`set symbol-reloading on'
     Replace symbol definitions for the corresponding source file when
     an object file with a particular name is seen again.

`set symbol-reloading off'
     Do not replace symbol definitions when re-encountering object
     files of the same name.  This is the default state; if you are not
     running on a system that permits automatically relinking modules,
     you should leave `symbol-reloading' off, since otherwise GDB may
     discard symbols when linking large programs, that may contain
     several modules (from different directories or libraries) with the
     same name.

`show symbol-reloading'
     Show the current `on' or `off' setting.


File: gdb.i,  Node: Sequences,  Next: GDB Bugs,  Prev: Controlling GDB,  Up: Top

Canned Sequences of Commands
****************************

   Aside from breakpoint commands (*note Breakpoint Command Lists:
Break Commands.), GDB provides two ways to store sequences of commands
for execution as a unit: user-defined commands and command files.

* Menu:

* Define::                      User-Defined Commands
* Command Files::               Command Files
* Output::                      Commands for Controlled Output


File: gdb.i,  Node: Define,  Next: Command Files,  Up: Sequences

User-Defined Commands
=====================

   A "user-defined command" is a sequence of GDB commands to which you
assign a new name as a command.  This is done with the `define' command.

`define COMMANDNAME'
     Define a command named COMMANDNAME.  If there is already a command
     by that name, you are asked to confirm that you want to redefine
     it.

     The definition of the command is made up of other GDB command
     lines, which are given following the `define' command.  The end of
     these commands is marked by a line containing `end'.

`document COMMANDNAME'
     Give documentation to the user-defined command COMMANDNAME.  The
     command COMMANDNAME must already be defined.  This command reads
     lines of documentation just as `define' reads the lines of the
     command definition, ending with `end'.  After the `document'
     command is finished, `help' on command COMMANDNAME will print the
     documentation you have specified.

     You may use the `document' command again to change the
     documentation of a command.  Redefining the command with `define'
     does not change the documentation.

`help user-defined'
     List all user-defined commands, with the first line of the
     documentation (if any) for each.

`show user'
`show user COMMANDNAME'
     Display the GDB commands used to define COMMANDNAME (but not its
     documentation).  If no COMMANDNAME is given, display the
     definitions for all user-defined commands.

   User-defined commands do not take arguments.  When they are
executed, the commands of the definition are not printed.  An error in
any command stops execution of the user-defined command.

   Commands that would ask for confirmation if used interactively
proceed without asking when used inside a user-defined command.  Many
GDB commands that normally print messages to say what they are doing
omit the messages when used in a user-defined command.


File: gdb.i,  Node: Command Files,  Next: Output,  Prev: Define,  Up: Sequences

Command Files
=============

   A command file for GDB is a file of lines that are GDB commands. 
Comments (lines starting with `#') may also be included.  An empty line
in a command file does nothing; it does not mean to repeat the last
command, as it would from the terminal.

   When you start GDB, it automatically executes commands from its
"init files".  These are files named `.gdbinit'.  GDB reads the init
file (if any) in your home directory and then the init file (if any) in
the current working directory.  (The init files are not executed if you
use the `-nx' option; *note Choosing Modes: Mode Options..)  You can
also request the execution of a command file with the `source' command:

`source FILENAME'
     Execute the command file FILENAME.

   The lines in a command file are executed sequentially.  They are not
printed as they are executed.  An error in any command terminates
execution of the command file.

   Commands that would ask for confirmation if used interactively
proceed without asking when used in a command file.  Many GDB commands
that normally print messages to say what they are doing omit the
messages when called from command files.


File: gdb.i,  Node: Output,  Prev: Command Files,  Up: Sequences

Commands for Controlled Output
==============================

   During the execution of a command file or a user-defined command,
normal GDB output is suppressed; the only output that appears is what is
explicitly printed by the commands in the definition.  This section
describes three commands useful for generating exactly the output you
want.

`echo TEXT'
     Print TEXT.  Nonprinting characters can be included in TEXT using
     C escape sequences, such as `\n' to print a newline.  *No newline
     will be printed unless you specify one.* In addition to the
     standard C escape sequences, a backslash followed by a space
     stands for a space.  This is useful for outputting a string with
     spaces at the beginning or the end, since leading and trailing
     spaces are otherwise trimmed from all arguments. To print ` and
     foo = ', use the command `echo \ and foo = \ '.

     A backslash at the end of TEXT can be used, as in C, to continue
     the command onto subsequent lines.  For example,

          echo This is some text\n\
          which is continued\n\
          onto several lines.\n

     produces the same output as

          echo This is some text\n
          echo which is continued\n
          echo onto several lines.\n

`output EXPRESSION'
     Print the value of EXPRESSION and nothing but that value: no
     newlines, no `$NN = '.  The value is not entered in the value
     history either.  *Note Expressions: Expressions, for more
     information on expressions.

`output/FMT EXPRESSION'
     Print the value of EXPRESSION in format FMT.  You can use the same
     formats as for `print'; *note Output formats::., for more
     information.

`printf STRING, EXPRESSIONS...'
     Print the values of the EXPRESSIONS under the control of STRING. 
     The EXPRESSIONS are separated by commas and may be either numbers
     or pointers.  Their values are printed as specified by STRING,
     exactly as if your program were to execute

          printf (STRING, EXPRESSIONS...);

     For example, you can print two values in hex like this:

          printf "foo, bar-foo = 0x%x, 0x%x\n", foo, bar-foo

     The only backslash-escape sequences that you can use in the format
     string are the simple ones that consist of backslash followed by a
     letter.


File: gdb.i,  Node: GDB Bugs,  Next: Index,  Prev: Sequences,  Up: Top

Reporting Bugs in GDB
*********************

   Your bug reports play an essential role in making GDB reliable.

   Reporting a bug may help you by bringing a solution to your problem,
or it may not.  But in any case the principal function of a bug report
is to help the entire community by making the next version of GDB work
better.  Bug reports are your contribution to the maintenance of GDB.

   In order for a bug report to serve its purpose, you must include the
information that enables us to fix the bug.

* Menu:

* Bug Criteria::                Have You Found a Bug?
* Bug Reporting::               How to Report Bugs


File: gdb.i,  Node: Bug Criteria,  Next: Bug Reporting,  Up: GDB Bugs

Have You Found a Bug?
=====================

   If you are not sure whether you have found a bug, here are some
guidelines:

   * If the debugger gets a fatal signal, for any input whatever, that
     is a GDB bug.  Reliable debuggers never crash.

   * If GDB produces an error message for valid input, that is a bug.

   * If GDB does not produce an error message for invalid input, that
     is a bug.  However, you should note that your idea of "invalid
     input" might be our idea of "an extension" or "support for
     traditional practice".

   * If you are an experienced user of debugging tools, your suggestions
     for improvement of GDB are welcome in any case.


File: gdb.i,  Node: Bug Reporting,  Prev: Bug Criteria,  Up: GDB Bugs

How to Report Bugs
==================

   A number of companies and individuals offer support for GNU products.
If you obtained GDB from a support organization, we recommend you
contact that organization first.

   Contact information for many support companies and individuals is
available in the file `etc/SERVICE' in the GNU Emacs distribution.

   In any event, we also recommend that you send bug reports for GDB to
one of these addresses:

     bug-gdb@prep.ai.mit.edu
     {ucbvax|mit-eddie|uunet}!prep.ai.mit.edu!bug-gdb

   *Do not send bug reports to `info-gdb', or to `help-gdb', or to any
newsgroups.* Most users of GDB do not want to receive bug reports. 
Those that do, have arranged to receive `bug-gdb'.

   The mailing list `bug-gdb' has a newsgroup `gnu.gdb.bug' which
serves as a repeater.  The mailing list and the newsgroup carry exactly
the same messages.  Often people think of posting bug reports to the
newsgroup instead of mailing them.  This appears to work, but it has one
problem which can be crucial: a newsgroup posting often lacks a mail
path back to the sender.  Thus, if we need to ask for more information,
we may be unable to reach you.  For this reason, it is better to send
bug reports to the mailing list.

   As a last resort, send bug reports on paper to:

     GNU Debugger Bugs
     Free Software Foundation
     545 Tech Square
     Cambridge, MA 02139

   The fundamental principle of reporting bugs usefully is this:
*report all the facts*.  If you are not sure whether to state a fact or
leave it out, state it!

   Often people omit facts because they think they know what causes the
problem and assume that some details do not matter.  Thus, you might
assume that the name of the variable you use in an example does not
matter. Well, probably it does not, but one cannot be sure.  Perhaps
the bug is a stray memory reference which happens to fetch from the
location where that name is stored in memory; perhaps, if the name were
different, the contents of that location would fool the debugger into
doing the right thing despite the bug.  Play it safe and give a
specific, complete example.  That is the easiest thing for you to do,
and the most helpful.

   Keep in mind that the purpose of a bug report is to enable us to fix
the bug if it is new to us.  It is not as important as what happens if
the bug is already known.  Therefore, always write your bug reports on
the assumption that the bug has not been reported previously.

   Sometimes people give a few sketchy facts and ask, "Does this ring a
bell?"  Those bug reports are useless, and we urge everyone to *refuse
to respond to them* except to chide the sender to report bugs properly.

   To enable us to fix the bug, you should include all these things:

   * The version of GDB.  GDB announces it if you start with no
     arguments; you can also print it at any time using `show version'.

     Without this, we will not know whether there is any point in
     looking for the bug in the current version of GDB.

   * The type of machine you are using, and the operating system name
     and version number.

   * What compiler (and its version) was used to compile GDB--e.g.
     "gcc-2.0".

   * What compiler (and its version) was used to compile the program you
     are debugging--e.g.  "gcc-2.0".

   * The command arguments you gave the compiler to compile your
     example and observe the bug.  For example, did you use `-O'?  To
     guarantee you will not omit something important, list them all.  A
     copy of the Makefile (or the output from make) is sufficient.

     If we were to try to guess the arguments, we would probably guess
     wrong and then we might not encounter the bug.

   * A complete input script, and all necessary source files, that will
     reproduce the bug.

   * A description of what behavior you observe that you believe is
     incorrect.  For example, "It gets a fatal signal."

     Of course, if the bug is that GDB gets a fatal signal, then we will
     certainly notice it.  But if the bug is incorrect output, we might
     not notice unless it is glaringly wrong.  We are human, after all.
      You might as well not give us a chance to make a mistake.

     Even if the problem you experience is a fatal signal, you should
     still say so explicitly.  Suppose something strange is going on,
     such as, your copy of GDB is out of synch, or you have encountered
     a bug in the C library on your system.  (This has happened!)  Your
     copy might crash and ours would not.  If you told us to expect a
     crash, then when ours fails to crash, we would know that the bug
     was not happening for us.  If you had not told us to expect a
     crash, then we would not be able to draw any conclusion from our
     observations.

   * If you wish to suggest changes to the GDB source, send us context
     diffs.  If you even discuss something in the GDB source, refer to
     it by context, not by line number.

     The line numbers in our development sources will not match those
     in your sources.  Your line numbers would convey no useful
     information to us.

   Here are some things that are not necessary:

   * A description of the envelope of the bug.

     Often people who encounter a bug spend a lot of time investigating
     which changes to the input file will make the bug go away and which
     changes will not affect it.

     This is often time consuming and not very useful, because the way
     we will find the bug is by running a single example under the
     debugger with breakpoints, not by pure deduction from a series of
     examples. We recommend that you save your time for something else.

     Of course, if you can find a simpler example to report *instead*
     of the original one, that is a convenience for us.  Errors in the
     output will be easier to spot, running under the debugger will take
     less time, etc.

     However, simplification is not vital; if you do not want to do
     this, report the bug anyway and send us the entire test case you
     used.

   * A patch for the bug.

     A patch for the bug does help us if it is a good one.  But do not
     omit the necessary information, such as the test case, on the
     assumption that a patch is all we need.  We might see problems
     with your patch and decide to fix the problem another way, or we
     might not understand it at all.

     Sometimes with a program as complicated as GDB it is very hard to
     construct an example that will make the program follow a certain
     path through the code.  If you do not send us the example, we will
     not be able to construct one, so we will not be able to verify
     that the bug is fixed.

     And if we cannot understand what bug you are trying to fix, or why
     your patch should be an improvement, we will not install it.  A
     test case will help us to understand.

   * A guess about what the bug is or what it depends on.

     Such guesses are usually wrong.  Even we cannot guess right about
     such things without first using the debugger to find the facts.


File: gdb.i,  Node: Index,  Prev: GDB Bugs,  Up: Top

Index
*****

* Menu:

* #:                                    Command Syntax.
* $bpnum:                               Set Breaks.
* $_:                                   Convenience Vars.
* $__:                                  Convenience Vars.
* @:                                    Arrays.
* $$:                                   Value History.
* $_ and info breakpoints:              Set Breaks.
* $_ and info line:                     Machine Code.
* $_, $__, and value history:           Memory.
* $:                                    Value History.
* .gdbinit:                             Command Files.
* abbreviation:                         Command Syntax.
* active targets:                       Active Targets.
* artificial array:                     Arrays.
* assignment:                           Assignment.
* automatic display:                    Auto Display.
* b:                                    Set Breaks.
* backtrace:                            Backtrace.
* break:                                Set Breaks.
* breakpoint commands:                  Break Commands.
* breakpoint conditions:                Conditions.
* breakpoint numbers:                   Breakpoints.
* breakpoint on memory address:         Breakpoints.
* breakpoint on variable modification:  Breakpoints.
* breakpoints:                          Breakpoints.
* bt:                                   Backtrace.
* Bug Criteria:                         Bug Criteria.
* bug reports:                          Bug Reporting.
* Bugs in GDB:                          GDB Bugs.
* C constants:                          C Operators.
* C language:                           C.
* C operators:                          C.
* call:                                 Calling.
* call stack:                           Stack.
* calling functions:                    Calling.
* catch:                                Exception Handling.
* catch exceptions:                     Frame Info.
* clear:                                Delete Breaks.
* clearing breakpoints, watchpoints:    Delete Breaks.
* colon-colon:                          Variables.
* command files:                        Command Files.
* command line editing:                 Editing.
* commands:                             Break Commands.
* comment:                              Command Syntax.
* completion:                           Completion.
* completion of quoted strings:         Completion.
* condition:                            Conditions.
* conditional breakpoints:              Conditions.
* confirmation:                         Messages/Warnings.
* continue:                             Continuing and Stepping.
* continue COUNT:                       Conditions.
* continuing:                           Continuing and Stepping.
* convenience variables:                Convenience Vars.
* core dump:                            Bug Criteria.
* d:                                    Delete Breaks.
* debugging optimized code:             Compilation.
* debugging target:                     Targets.
* define:                               Define.
* delete:                               Delete Breaks.
* delete breakpoints:                   Delete Breaks.
* delete display:                       Auto Display.
* deleting breakpoints, watchpoints:    Delete Breaks.
* device:                               Hitachi H8/300 Remote.
* directories for source files:         Source Path.
* directory:                            Source Path.
* dis:                                  Disabling.
* disable:                              Disabling.
* disable breakpoints:                  Disabling.
* disable display:                      Auto Display.
* disabled breakpoints:                 Disabling.
* disassemble:                          Machine Code.
* display:                              Auto Display.
* display of expressions:               Auto Display.
* do:                                   Selection.
* document:                             Define.
* down:                                 Selection.
* down-silently:                        Selection.
* download to H8/300:                   Files.
* echo:                                 Output.
* editing:                              Editing.
* enable:                               Disabling.
* enable breakpoints:                   Disabling.
* enable display:                       Auto Display.
* enabled breakpoints:                  Disabling.
* end:                                  Break Commands.
* entering numbers:                     Numbers.
* error on valid input:                 Bug Criteria.
* examining data:                       Data.
* examining memory:                     Memory.
* exception handlers:                   Exception Handling.
* exception handlers:                   Frame Info.
* exec-file:                            Files.
* executable file:                      Files.
* exiting GDB:                          Leaving GDB.
* expressions:                          Expressions.
* expressions in C:                     C.
* f:                                    Selection.
* fatal signal:                         Bug Criteria.
* file:                                 Files.
* finish:                               Continuing and Stepping.
* flinching:                            Messages/Warnings.
* floating point registers:             Registers.
* foo:                                  Symbol Errors.
* format options:                       Print Settings.
* formatted output:                     Output formats.
* frame:                                Frames.
* frame:                                Selection.
* frame number:                         Frames.
* frame pointer:                        Frames.
* frameless execution:                  Frames.
* GDB bugs, reporting:                  Bug Reporting.
* h:                                    Help.
* H8/300 download:                      Files.
* help:                                 Help.
* help target:                          Target Commands.
* help user-defined:                    Define.
* history expansion:                    History.
* history file:                         History.
* history number:                       Value History.
* history save:                         History.
* history size:                         History.
* history substitution:                 History.
* i:                                    Help.
* ignore:                               Conditions.
* ignore count (of breakpoint):         Conditions.
* info:                                 Help.
* info address:                         Symbols.
* info all-registers:                   Registers.
* info args:                            Frame Info.
* info breakpoints:                     Set Breaks.
* info catch:                           Frame Info.
* info display:                         Auto Display.
* info f:                               Frame Info.
* info files:                           Files.
* info frame:                           Frame Info.
* info functions:                       Symbols.
* info line:                            Machine Code.
* info locals:                          Frame Info.
* info program:                         Stopping.
* info registers:                       Registers.
* info s:                               Backtrace.
* info set:                             Help.
* info source:                          Symbols.
* info sources:                         Symbols.
* info stack:                           Backtrace.
* info target:                          Files.
* info types:                           Symbols.
* info variables:                       Symbols.
* info watchpoints:                     Set Watchpoints.
* init file:                            Command Files.
* initial frame:                        Frames.
* innermost frame:                      Frames.
* inspect:                              Data.
* internal GDB breakpoints:             Set Breaks.
* interrupt:                            Leaving GDB.
* Invalid Input:                        Bug Criteria.
* jump:                                 Jumping.
* l:                                    List.
* latest breakpoint:                    Set Breaks.
* linespec:                             List.
* list:                                 List.
* load:                                 Files.
* lost output:                          Break Commands.
* maint info breakpoints:               Set Breaks.
* maint print psymbols:                 Symbols.
* maint print symbols:                  Symbols.
* mapped:                               Files.
* memory tracing:                       Breakpoints.
* memory-mapped symbol file:            Files.
* multiple targets:                     Active Targets.
* n:                                    Continuing and Stepping.
* names of symbols:                     Symbols.
* negative breakpoint numbers:          Set Breaks.
* next:                                 Continuing and Stepping.
* nexti:                                Continuing and Stepping.
* ni:                                   Continuing and Stepping.
* number representation:                Numbers.
* numbers for breakpoints:              Breakpoints.
* online documentation:                 Help.
* optimized code, debugging:            Compilation.
* outermost frame:                      Frames.
* output:                               Output.
* output formats:                       Output formats.
* overloading:                          Breakpoint Menus.
* partial symbol dump:                  Symbols.
* patching binaries:                    Patching.
* pauses in output:                     Screen Size.
* print:                                Data.
* print settings:                       Print Settings.
* printf:                               Output.
* printing data:                        Data.
* prompt:                               Prompt.
* ptype:                                Symbols.
* q:                                    Leaving GDB.
* quit:                                 Leaving GDB.
* quotes in commands:                   Completion.
* quoting names:                        Symbols.
* raise exceptions:                     Exception Handling.
* rbreak:                               Set Breaks.
* reading symbols immediately:          Files.
* readline:                             Editing.
* readnow:                              Files.
* registers:                            Registers.
* regular expression:                   Set Breaks.
* reloading symbols:                    Messages/Warnings.
* remote debugging:                     Remote.
* repeating commands:                   Command Syntax.
* Reporting Bugs in GDB:                GDB Bugs.
* resuming execution:                   Continuing and Stepping.
* RET:                                  Command Syntax.
* return:                               Returning.
* returning from a function:            Returning.
* run:                                  Starting.
* running:                              Starting.
* s:                                    Continuing and Stepping.
* saving symbol table:                  Files.
* selected frame:                       Stack.
* serial device for H8/300:             Hitachi H8/300 Remote.
* set complaints:                       Messages/Warnings.
* set confirm:                          Messages/Warnings.
* set editing:                          Editing.
* set height:                           Screen Size.
* set history expansion:                History.
* set history filename:                 History.
* set history save:                     History.
* set history size:                     History.
* set listsize:                         List.
* set print address:                    Print Settings.
* set print array:                      Print Settings.
* set print asm-demangle:               Print Settings.
* set print demangle:                   Print Settings.
* set print elements:                   Print Settings.
* set print object:                     Print Settings.
* set print pretty:                     Print Settings.
* set print sevenbit-strings:           Print Settings.
* set print union:                      Print Settings.
* set print vtbl:                       Print Settings.
* set prompt:                           Prompt.
* set radix:                            Numbers.
* set symbol-reloading:                 Messages/Warnings.
* set variable:                         Assignment.
* set verbose:                          Messages/Warnings.
* set width:                            Screen Size.
* set write:                            Patching.
* setting variables:                    Assignment.
* setting watchpoints:                  Set Watchpoints.
* show:                                 Help.
* show commands:                        History.
* show complaints:                      Messages/Warnings.
* show confirm:                         Messages/Warnings.
* show convenience:                     Convenience Vars.
* show copying:                         Help.
* show directories:                     Source Path.
* show editing:                         Editing.
* show height:                          Screen Size.
* show history:                         History.
* show listsize:                        List.
* show print address:                   Print Settings.
* show print array:                     Print Settings.
* show print asm-demangle:              Print Settings.
* show print demangle:                  Print Settings.
* show print elements:                  Print Settings.
* show print object:                    Print Settings.
* show print pretty:                    Print Settings.
* show print sevenbit-strings:          Print Settings.
* show print union:                     Print Settings.
* show print vtbl:                      Print Settings.
* show prompt:                          Prompt.
* show radix:                           Numbers.
* show user:                            Define.
* show values:                          Value History.
* show verbose:                         Messages/Warnings.
* show version:                         Help.
* show warranty:                        Help.
* show width:                           Screen Size.
* show write:                           Patching.
* si:                                   Continuing and Stepping.
* silent:                               Break Commands.
* size of screen:                       Screen Size.
* source:                               Command Files.
* source path:                          Source Path.
* stack frame:                          Frames.
* stacking targets:                     Active Targets.
* starting:                             Starting.
* step:                                 Continuing and Stepping.
* stepi:                                Continuing and Stepping.
* stepping:                             Continuing and Stepping.
* stupid questions:                     Messages/Warnings.
* symbol dump:                          Symbols.
* symbol names:                         Symbols.
* symbol overloading:                   Breakpoint Menus.
* symbol table:                         Files.
* symbol-file:                          Files.
* symbols, reading immediately:         Files.
* target:                               Targets.
* target core:                          Target Commands.
* target exec:                          Target Commands.
* target hms:                           Target Commands.
* tbreak:                               Set Breaks.
* u:                                    Continuing and Stepping.
* undisplay:                            Auto Display.
* until:                                Continuing and Stepping.
* up:                                   Selection.
* up-silently:                          Selection.
* user-defined command:                 Define.
* value history:                        Value History.
* variable name conflict:               Variables.
* variable values, wrong:               Variables.
* variables, setting:                   Assignment.
* version number:                       Help.
* watch:                                Set Watchpoints.
* watchpoints:                          Breakpoints.
* whatis:                               Symbols.
* where:                                Backtrace.
* word completion:                      Completion.
* writing into corefiles:               Patching.
* writing into executables:             Patching.
* wrong values:                         Variables.
* x:                                    Memory.



Tag Table:
Node: Top1270
Node: Summary2395
Node: Free Software3246
Node: Contributors3980
Node: Invocation7559
Node: Invoking GDB7936
Node: Hitachi H8/300 Remote9117
Node: File Options13143
Node: Mode Options14513
Node: Leaving GDB16389
Node: Commands16905
Node: Command Syntax17510
Node: Completion19332
Node: Help23283
Node: Running27042
Node: Compilation27343
Node: Starting29134
Node: Stopping30075
Node: Breakpoints31086
Node: Set Breaks32892
Node: Set Watchpoints39011
Node: Exception Handling39838
Node: Delete Breaks42391
Node: Disabling44018
Node: Conditions46660
Node: Break Commands51438
Node: Breakpoint Menus54924
Node: Error in Breakpoints56625
Node: Continuing and Stepping57525
Node: Stack63515
Node: Frames64917
Node: Backtrace67188
Node: Selection68916
Node: Frame Info71267
Node: Source73322
Node: List74064
Node: Source Path77544
Node: Machine Code80216
Node: Data82438
Node: Expressions84074
Node: Variables85252
Node: Arrays87612
Node: Output formats89660
Node: Memory91520
Node: Auto Display95762
Node: Print Settings99479
Node: Value History105005
Node: Convenience Vars107383
Node: Registers110034
Node: C113862
Node: C Operators114300
Node: C Constants117836
Node: Debugging C119355
Node: Symbols119804
Node: Altering125556
Node: Assignment126472
Node: Jumping128516
Node: Returning130520
Node: Calling131707
Node: Patching132192
Node: GDB Files133255
Node: Files133626
Node: Symbol Errors138908
Node: Targets142499
Node: Active Targets143025
Node: Target Commands143518
Node: Remote145094
Node: Controlling GDB146013
Node: Prompt146633
Node: Editing147231
Node: History147995
Node: Screen Size150475
Node: Numbers151747
Node: Messages/Warnings152886
Node: Sequences155839
Node: Define156360
Node: Command Files158362
Node: Output159619
Node: GDB Bugs161997
Node: Bug Criteria162701
Node: Bug Reporting163452
Node: Index170650

End Tag Table
