This is Info file as.i, produced by Makeinfo-1.50 from the input file
as-h8.texinfo.

START-INFO-DIR-ENTRY
* As: (as).			The GNU assembler.
END-INFO-DIR-ENTRY

   This file documents the GNU Assembler "as".

   Copyright (C) 1991 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the section entitled "GNU General Public License" is included
exactly as in the original, and provided that the entire resulting
derived work is distributed under the terms of a permission notice
identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the section entitled "GNU General Public License"
may be included in a translation approved by the Free Software
Foundation instead of in the original English.


File: as.i,  Node: Top,  Next: Overview,  Prev: (DIR),  Up: (DIR)

Using as
********

   This file is a user guide to the GNU assembler `as'. This version of
the file describes `as' configured to generate code for H8/300
architectures.

* Menu:

* Overview::			Overview
* Invoking::			Command-Line Options
* Syntax::			Syntax
* Sections::			Sections and Relocation
* Symbols::			Symbols
* Expressions::			Expressions
* Pseudo Ops::			Assembler Directives
* H8/300-Dependent:: 	Machine Dependent Features
* Copying::			GNU GENERAL PUBLIC LICENSE
* Index::                       Index


File: as.i,  Node: Overview,  Next: Invoking,  Prev: Top,  Up: Top

Overview
********

   Here is a brief summary of how to invoke `as'.  For details, *note
Comand-Line Options: Invoking..

       as [ -a | -al | -as ] [ -D ] [ -f ]
        [ -I PATH ] [ -K ] [ -L ]
        [ -o OBJFILE ] [ -R ] [ -v ] [ -w ]
        [ -- | FILES ... ]

`-a | -al | -as'
     Turn on assembly listings; `-al', listing only, `-as', symbols
     only, `-a', everything.

`-D'
     This option is accepted only for script compatibility with calls to
     other assemblers; it has no effect on `as'.

`-f'
     "fast"--skip preprocessing (assume source is compiler output)

`-I PATH'
     Add PATH to the search list for `.include' directives

`-K'
     This option is accepted but has no effect on the H8/300 family.

`-L'
     Keep (in symbol table) local symbols, starting with `L'

`-o OBJFILE'
     Name the object-file output from `as'

`-R'
     Fold data section into text section

`-v'
     Announce `as' version

`-W'
     Suppress warning messages

`-- | FILES ...'
     Standard input, or source files to assemble

* Menu:

* Manual::			Structure of this Manual
* GNU Assembler::		as, the GNU Assembler
* Object Formats::		Object File Formats
* Command Line::		Command Line
* Input Files::			Input Files
* Object::			Output (Object) File
* Errors::			Error and Warning Messages


File: as.i,  Node: Manual,  Next: GNU Assembler,  Up: Overview

Structure of this Manual
========================

   This manual is intended to describe what you need to know to use GNU
`as'.  We cover the syntax expected in source files, including notation
for symbols, constants, and expressions; the directives that `as'
understands; and of course how to invoke `as'.

   We also cover special features in the H8/300 configuration of `as',
including assembler directives.

   On the other hand, this manual is *not* intended as an introduction
to programming in assembly language--let alone programming in general!
In a similar vein, we make no attempt to introduce the machine
architecture; we do *not* describe the instruction set, standard
mnemonics, registers or addressing modes that are standard to a
particular architecture. For information on the H8/300 machine
instruction set, see `H8/300 Series Programming Manual' (Hitachi
ADE--602--025).


File: as.i,  Node: GNU Assembler,  Next: Object Formats,  Prev: Manual,  Up: Overview

as, the GNU Assembler
=====================

   GNU `as' is really a family of assemblers. This manual describes
`as', a member of that family which is configured for the H8/300
architectures. If you use (or have used) the GNU assembler on one
architecture, you should find a fairly similar environment when you use
it on another architecture.  Each version has much in common with the
others, including object file formats, most assembler directives (often
called "pseudo-ops)" and assembler syntax.

   Unlike older assemblers, `as' is designed to assemble a source
program in one pass of the source file.  This has a subtle impact on the
`.org' directive (*note `.org': Org.).


File: as.i,  Node: Object Formats,  Next: Command Line,  Prev: GNU Assembler,  Up: Overview

Object File Formats
===================

   The GNU assembler can be configured to produce several alternative
object file formats.  For the most part, this does not affect how you
write assembly language programs; but directives for debugging symbols
are typically different in different file formats.  *Note Symbol
Attributes: Symbol Attributes. On the H8/300, `as' is configured to
produce COFF format object files.


File: as.i,  Node: Command Line,  Next: Input Files,  Prev: Object Formats,  Up: Overview

Command Line
============

   After the program name `as', the command line may contain options
and file names.  Options may appear in any order, and may be before,
after, or between file names.  The order of file names is significant.

   `--' (two hyphens) by itself names the standard input file
explicitly, as one of the files for `as' to assemble.

   Except for `--' any command line argument that begins with a hyphen
(`-') is an option.  Each option changes the behavior of `as'.  No
option changes the way another option works.  An option is a `-'
followed by one or more letters; the case of the letter is important.  
All options are optional.

   Some options expect exactly one file name to follow them.  The file
name may either immediately follow the option's letter (compatible with
older assemblers) or it may be the next command argument (GNU
standard).  These two command lines are equivalent:

     as -o my-object-file.o mumble.s
     as -omy-object-file.o mumble.s


File: as.i,  Node: Input Files,  Next: Object,  Prev: Command Line,  Up: Overview

Input Files
===========

   We use the phrase "source program", abbreviated "source", to
describe the program input to one run of `as'.  The program may be in
one or more files; how the source is partitioned into files doesn't
change the meaning of the source.

   The source program is a concatenation of the text in all the files,
in the order specified.

   Each time you run `as' it assembles exactly one source program.  The
source program is made up of one or more files. (The standard input is
also a file.)

   You give `as' a command line that has zero or more input file names.
 The input files are read (from left file name to right).  A command
line argument (in any position) that has no special meaning is taken to
be an input file name.

   If you give `as' no file names it attempts to read one input file
from the `as' standard input, which is normally your terminal.  You may
have to type ctl-D to tell `as' there is no more program to assemble.

   Use `--' if you need to explicitly name the standard input file in
your command line.

   If the source is empty, `as' will produce a small, empty object file.

Filenames and Line-numbers
--------------------------

   There are two ways of locating a line in the input file (or files)
and either may be used in reporting error messages.  One way refers to
a line number in a physical file; the other refers to a line number in a
"logical" file.  *Note Error and Warning Messages: Errors.

   "Physical files" are those files named in the command line given to
`as'.

   "Logical files" are simply names declared explicitly by assembler
directives; they bear no relation to physical files.  Logical file names
help error messages reflect the original source file, when `as' source
is itself synthesized from other files. *Note `.app-file': App-File.


File: as.i,  Node: Object,  Next: Errors,  Prev: Input Files,  Up: Overview

Output (Object) File
====================

   Every time you run `as' it produces an output file, which is your
assembly language program translated into numbers.  This file is the
object file, named `a.out' unless you tell `as' to give it another name
by using the `-o' option.  Conventionally, object file names end with
`.o'.  The default name of `a.out' is used for historical reasons: 
older assemblers were capable of assembling self-contained programs
directly into a runnable program.

   The object file is meant for input to the linker `ld'.  It contains
assembled program code, information to help `ld' integrate the
assembled program into a runnable file, and (optionally) symbolic
information for the debugger.


File: as.i,  Node: Errors,  Prev: Object,  Up: Overview

Error and Warning Messages
==========================

   `as' may write warnings and error messages to the standard error
file (usually your terminal).  This should not happen when  a compiler
runs `as' automatically.  Warnings report an assumption made so that
`as' could keep assembling a flawed program; errors report a grave
problem that stops the assembly.

   Warning messages have the format

     file_name:NNN:Warning Message Text

(where NNN is a line number).  If a logical file name has been given
(*note `.app-file': App-File.) it is used for the filename, otherwise
the name of the current input file is used.  If a logical line number
was given (*note `.line': Line.) then it is used to calculate the
number printed, otherwise the actual line in the current source file is
printed.  The message text is intended to be self explanatory (in the
grand Unix tradition).

   Error messages have the format
     file_name:NNN:FATAL:Error Message Text
   The file name and line number are derived as for warning messages. 
The actual message text may be rather less explanatory because many of
them aren't supposed to happen.


File: as.i,  Node: Invoking,  Next: Syntax,  Prev: Overview,  Up: Top

Command-Line Options
********************

   This chapter describes command-line options available in *all*
versions of the GNU assembler; *note H8/300-Dependent::., for options
specific to the H8/300.

Enable Listings: `-a', `-al', `-as'
===================================

   These options enable listing output from the assembler.  `-a' by
itself requests all listing output; `-al' requests only the
output-program listing, and `-as' requests only a symbol table listing.

   Once you have specified one of these options, you can further control
listing output and its appearance using the directives `.list',
`.nolist', `.psize', `.eject', `.title', and `.sbttl'.

   If you do not request listing output with one of the `-a' options,
the listing-control directives have no effect.

`-D'
====

   This option has no effect whatsoever, but it is accepted to make it
more likely that scripts written for other assemblers will also work
with `as'.

Work Faster: `-f'
=================

   `-f' should only be used when assembling programs written by a
(trusted) compiler.  `-f' stops the assembler from pre-processing the
input file(s) before assembling them.  *Note Pre-processing:
Pre-processing.

     *Warning:* if the files actually need to be pre-processed (if they
     contain comments, for example), `as' will not work correctly if
     `-f' is used.

`.include' search path: `-I' PATH
=================================

   Use this option to add a PATH to the list of directories `as' will
search for files specified in `.include' directives (*note `.include':
Include.).  You may use `-I' as many times as necessary to include a
variety of paths.  The current working directory is always searched
first; after that, `as' searches any `-I' directories in the same order
as they were specified (left to right) on the command line.

Difference Tables: `-K'
=======================

   On the H8/300 family, this option is allowed, but has no effect.  It
is permitted for compatibility with the GNU assembler on other
platforms, where it can be used to warn when the assembler alters the
machine code generated for `.word' directives in difference tables. 
The H8/300 family does not have the addressing limitations that
sometimes lead to this alteration on other platforms.

Include Local Labels: `-L'
==========================

   Labels beginning with `L' (upper case only) are called "local
labels". *Note Symbol Names::.  Normally you don't see such labels when
debugging, because they are intended for the use of programs (like
compilers) that compose assembler programs, not for your notice.
Normally both `as' and `ld' discard such labels, so you don't normally
debug with them.

   This option tells `as' to retain those `L...' symbols in the object
file.  Usually if you do this you also tell the linker `ld' to preserve
symbols whose names begin with `L'.

Name the Object File: `-o'
==========================

   There is always one object file output when you run `as'.  By
default it has the name `a.out'.  You use this option (which takes
exactly one filename) to give the object file a different name.

   Whatever the object file is called, `as' will overwrite any existing
file of the same name.

Join Data and Text Sections: `-R'
=================================

   `-R' tells `as' to write the object file as if all data-section data
lives in the text section.  This is only done at the very last moment: 
your binary data are the same, but data section parts are relocated
differently.  The data section part of your object file is zero bytes
long because all it bytes are appended to the text section.  (*Note
Sections and Relocation: Sections.)

   When you specify `-R' it would be possible to generate shorter
address displacements (because we don't have to cross between text and
data section).  We refrain from doing this simply for compatibility with
older versions of `as'.  In future, `-R' may work this way.

   When `as' is configured for COFF output, this option is only useful
if you use sections named `.text' and `.data'.

Announce Version: `-v'
======================

   You can find out what version of as is running by including the
option `-v' (which you can also spell as `-version') on the command
line.

Suppress Warnings: `-W'
=======================

   `as' should never give a warning or error message when assembling
compiler output.  But programs written by people often cause `as' to
give a warning that a particular assumption was made.  All such
warnings are directed to the standard error file. If you use this
option, no warnings are issued.  This option only affects the warning
messages: it does not change any particular of how `as' assembles your
file.  Errors, which stop the assembly, are still reported.


File: as.i,  Node: Syntax,  Next: Sections,  Prev: Invoking,  Up: Top

Syntax
******

   This chapter describes the machine-independent syntax allowed in a
source file.  `as' syntax is similar to what many other assemblers use;
it is inspired in BSD 4.2 assembler.

* Menu:

* Pre-processing::		Pre-processing
* Whitespace::			Whitespace
* Comments::			Comments
* Symbol Intro::		Symbols
* Statements::			Statements
* Constants::			Constants


File: as.i,  Node: Pre-processing,  Next: Whitespace,  Up: Syntax

Pre-Processing
==============

   The pre-processor:
   * adjusts and removes extra whitespace.  It leaves one space or tab
     before the keywords on a line, and turns any other whitespace on
     the line into a single space.

   * removes all comments, replacing them with a single space, or an
     appropriate number of newlines.

   * converts character constants into the appropriate numeric values.

   Excess whitespace, comments, and character constants cannot be used
in the portions of the input text that are not pre-processed.

   If the first line of an input file is `#NO_APP' or the `-f' option
is given, the input file will not be pre-processed.  Within such an
input file, parts of the file can be pre-processed by putting a line
that says `#APP' before the text that should be pre-processed, and
putting a line that says `#NO_APP' after them.  This feature is mainly
intend to support `asm' statements in compilers whose output normally
does not need to be pre-processed.


File: as.i,  Node: Whitespace,  Next: Comments,  Prev: Pre-processing,  Up: Syntax

Whitespace
==========

   "Whitespace" is one or more blanks or tabs, in any order. Whitespace
is used to separate symbols, and to make programs neater for people to
read.  Unless within character constants (*note Character Constants:
Characters.), any whitespace means the same as exactly one space.


File: as.i,  Node: Comments,  Next: Symbol Intro,  Prev: Whitespace,  Up: Syntax

Comments
========

   There are two ways of rendering comments to `as'.  In both cases the
comment is equivalent to one space.

   Anything from `/*' through the next `*/' is a comment. This means
you may not nest these comments.

     /*
       The only way to include a newline ('\n') in a comment
       is to use this sort of comment.
     */
     
     /* This sort of comment does not nest. */

   Anything from the "line comment" character to the next newline is
considered a comment and is ignored.  The line comment character is `;'
for the H8/300 family; *note H8/300-Dependent::..

   To be compatible with past assemblers, a special interpretation is
given to lines that begin with `#'.  Following the `#' an absolute
expression (*note Expressions::.) is expected:  this will be the
logical line number of the next line.  Then a string (*Note Strings::.)
is allowed: if present it is a new logical file name.  The rest of the
line, if any, should be whitespace.

   If the first non-whitespace characters on the line are not numeric,
the line is ignored.  (Just like a comment.)
                               # This is an ordinary comment.
     # 42-6 "new_file_name"    # New logical file name
                               # This is logical line # 36.
   This feature is deprecated, and may disappear from future versions
of `as'.


File: as.i,  Node: Symbol Intro,  Next: Statements,  Prev: Comments,  Up: Syntax

Symbols
=======

   A "symbol" is one or more characters chosen from the set of all
letters (both upper and lower case), digits and the two characters `_.'
No symbol may begin with a digit.  Case is significant. There is no
length limit: all characters are significant.  Symbols are delimited by
characters not in that set, or by the beginning of a file (since the
source program must end with a newline, the end of a file is not a
possible symbol delimiter).  *Note Symbols::.


File: as.i,  Node: Statements,  Next: Constants,  Prev: Symbol Intro,  Up: Syntax

Statements
==========

   A "statement" ends at a newline character (`\n') or a dollar sign
(`$').  The newline or dollar sign is considered part of the preceding
statement.  Newlines and dollar signs within character constants are an
exception: they don't end statements.

   It is an error to end any statement with end-of-file:  the last
character of any input file should be a newline.

   You may write a statement on more than one line if you put a
backslash (`\') immediately in front of any newlines within the
statement.  When `as' reads a backslashed newline both characters are
ignored.  You can even put backslashed newlines in the middle of symbol
names without changing the meaning of your source program.

   An empty statement is allowed, and may include whitespace.  It is
ignored.

   A statement begins with zero or more labels, optionally followed by a
key symbol which determines what kind of statement it is.  The key
symbol determines the syntax of the rest of the statement.  If the
symbol begins with a dot `.' then the statement is an assembler
directive: typically valid for any computer.  If the symbol begins with
a letter the statement is an assembly language "instruction": it will
assemble into a machine language instruction.

   A label is a symbol immediately followed by a colon (`:').
Whitespace before a label or after a colon is permitted, but you may not
have whitespace between a label's symbol and its colon. *Note Labels::.

     label:     .directive    followed by something
     another_label:           # This is an empty statement.
                instruction   operand_1, operand_2, ...


File: as.i,  Node: Constants,  Prev: Statements,  Up: Syntax

Constants
=========

   A constant is a number, written so that its value is known by
inspection, without knowing any context.  Like this:
     .byte  74, 0112, 092, 0x4A, 0X4a, 'J, '\J # All the same value.
     .ascii "Ring the bell\7"                  # A string constant.
     .octa  0x123456789abcdef0123456789ABCDEF0 # A bignum.
     .float 0f-314159265358979323846264338327\
     95028841971.693993751E-40                 # - pi, a flonum.

* Menu:

* Characters::			Character Constants
* Numbers::			Number Constants


File: as.i,  Node: Characters,  Next: Numbers,  Up: Constants

Character Constants
-------------------

   There are two kinds of character constants.  A "character" stands
for one character in one byte and its value may be used in numeric
expressions.  String constants (properly called string *literals*) are
potentially many bytes and their values may not be used in arithmetic
expressions.

* Menu:

* Strings::			Strings
* Chars::			Characters


File: as.i,  Node: Strings,  Next: Chars,  Up: Characters

Strings
.......

   A "string" is written between double-quotes.  It may contain
double-quotes or null characters.  The way to get special characters
into a string is to "escape" these characters: precede them with a
backslash `\' character.  For example `\\' represents one backslash: 
the first `\' is an escape which tells `as' to interpret the second
character literally as a backslash (which prevents `as' from
recognizing the second `\' as an escape character).  The complete list
of escapes follows.

`\b'
     Mnemonic for backspace; for ASCII this is octal code 010.

`\f'
     Mnemonic for FormFeed; for ASCII this is octal code 014.

`\n'
     Mnemonic for newline; for ASCII this is octal code 012.

`\r'
     Mnemonic for carriage-Return; for ASCII this is octal code 015.

`\t'
     Mnemonic for horizontal Tab; for ASCII this is octal code 011.

`\ DIGIT DIGIT DIGIT'
     An octal character code.  The numeric code is 3 octal digits. For
     compatibility with other Unix systems, 8 and 9 are accepted as
     digits: for example, `\008' has the value 010, and `\009' the
     value 011.

`\\'
     Represents one `\' character.

`\"'
     Represents one `"' character.  Needed in strings to represent this
     character, because an unescaped `"' would end the string.

`\ ANYTHING-ELSE'
     Any other character when escaped by `\' will give a warning, but
     assemble as if the `\' was not present.  The idea is that if you
     used an escape sequence you clearly didn't want the literal
     interpretation of the following character.  However `as' has no
     other interpretation, so `as' knows it is giving you the wrong
     code and warns you of the fact.

   Which characters are escapable, and what those escapes represent,
varies widely among assemblers.  The current set is what we think the
BSD 4.2 assembler recognizes, and is a subset of what most C compilers
recognize.  If you are in doubt, don't use an escape sequence.


File: as.i,  Node: Chars,  Prev: Strings,  Up: Characters

Characters
..........

   A single character may be written as a single quote immediately
followed by that character.  The same escapes apply to characters as to
strings.  So if you want to write the character backslash, you must
write `'\\' where the first `\' escapes the second `\'.  As you can
see, the quote is an acute accent, not a grave accent.  A newline (or
dollar sign `$') immediately following an acute accent is taken as a
literal character and does not count as the end of a statement.  The
value of a character constant in a numeric expression is the machine's
byte-wide code for that character.  `as' assumes your character code is
ASCII: `'A' means 65, `'B' means 66, and so on.


File: as.i,  Node: Numbers,  Prev: Characters,  Up: Constants

Number Constants
----------------

   `as' distinguishes three kinds of numbers according to how they are
stored in the target machine.  *Integers* are numbers that would fit
into an `int' in the C language.  *Bignums* are integers, but they are
stored in more than 32 bits.  *Flonums* are floating point numbers,
described below.

* Menu:

* Integers::			Integers
* Bignums::			Bignums
* Flonums::			Flonums


File: as.i,  Node: Integers,  Next: Bignums,  Up: Numbers

Integers
........

   A binary integer is `0b' or `0B' followed by zero or more of the
binary digits `01'.

   An octal integer is `0' followed by zero or more of the octal digits
(`01234567').

   A decimal integer starts with a non-zero digit followed by zero or
more digits (`0123456789').

   A hexadecimal integer is `0x' or `0X' followed by one or more
hexadecimal digits chosen from `0123456789abcdefABCDEF'.

   Integers have the usual values.  To denote a negative integer, use
the prefix operator `-' discussed under expressions (*note Prefix
Operators: Prefix Ops.).


File: as.i,  Node: Bignums,  Next: Flonums,  Prev: Integers,  Up: Numbers

Bignums
.......

   A "bignum" has the same syntax and semantics as an integer except
that the number (or its negative) takes more than 32 bits to represent
in binary.  The distinction is made because in some places integers are
permitted while bignums are not.


File: as.i,  Node: Flonums,  Prev: Bignums,  Up: Numbers

Flonums
.......

   A "flonum" represents a floating point number.  The translation is
indirect: a decimal floating point number from the text is converted by
`as' to a generic binary floating point number of more than sufficient
precision.  This generic floating point number is converted to a
particular computer's floating point format (or formats) by a portion
of `as' specialized to that computer.

   A flonum is written by writing (in order)
   * The digit `0'.

   * A letter, to tell `as' the rest of the number is a flonum. One of
     the letters `DFPRSX' (in upper or lower case).

   * An optional sign: either `+' or `-'.

   * An optional "integer part": zero or more decimal digits.

   * An optional "fractional part": `.' followed by zero or more
     decimal digits.

   * An optional exponent, consisting of:
        * An `E' or `e'.

        * Optional sign: either `+' or `-'.

        * One or more decimal digits.

   At least one of the integer part or the fractional part must be
present.  The floating point number has the usual base-10 value.

   `as' does all processing using integers.  Flonums are computed
independently of any floating point hardware in the computer running
`as'.


File: as.i,  Node: Sections,  Next: Symbols,  Prev: Syntax,  Up: Top

Sections and Relocation
***********************

* Menu:

* Secs Background::		Background
* ld Sections::		ld Sections
* as Sections::		as Internal Sections
* Sub-Sections::		Sub-Sections
* bss::				bss Section


File: as.i,  Node: Secs Background,  Next: ld Sections,  Up: Sections

Background
==========

   Roughly, a section is a range of addresses, with no gaps; all data
"in" those addresses is treated the same for some particular purpose.
For example there may be a "read only" section.

   The linker `ld' reads many object files (partial programs) and
combines their contents to form a runnable program.  When `as' emits an
object file, the partial program is assumed to start at address 0. 
`ld' will assign the final addresses the partial program occupies, so
that different partial programs don't overlap.  This is actually an
over-simplification, but it will suffice to explain how `as' uses
sections.

   `ld' moves blocks of bytes of your program to their run-time
addresses.  These blocks slide to their run-time addresses as rigid
units; their length does not change and neither does the order of bytes
within them.  Such a rigid unit is called a *section*.  Assigning
run-time addresses to sections is called "relocation".  It includes the
task of adjusting mentions of object-file addresses so they refer to
the proper run-time addresses. For the H8/300, `as' pads sections if
needed to ensure they end on a word (sixteen bit) boundary.

   An object file written by `as' has at least three sections, any of
which may be empty.  These are named "text", "data" and "bss" sections.

   `as' can also generate whatever other named sections you specify
using the `.section' directive (*note `.section': Section.). If you
don't use any directives that place output in the `.text' or `.data'
sections, these sections will still exist, but will be empty.

   Within the object file, the text section starts at address `0', the
data section follows, and the bss section follows the data section.

   To let `ld' know which data will change when the sections are
relocated, and how to change that data, `as' also writes to the object
file details of the relocation needed.  To perform relocation `ld' must
know, each time an address in the object file is mentioned:
   * Where in the object file is the beginning of this reference to an
     address?

   * How long (in bytes) is this reference?

   * Which section does the address refer to?  What is the numeric
     value of
          (ADDRESS) - (START-ADDRESS OF SECTION)?

   * Is the reference to an address "Program-Counter relative"?

   In fact, every address `as' ever uses is expressed as
     (SECTION) + (OFFSET INTO SECTION)

Further, every expression `as' computes is of this section-relative
nature.  "Absolute expression" means an expression with section
"absolute" (*note ld Sections::.).  A "pass1 expression" means an
expression with section "pass1" (*note as Internal Sections: as
Sections.).  In this manual we use the notation {SECNAME N} to mean
"offset N into section SECNAME".

   Apart from text, data and bss sections you need to know about the
"absolute" section.  When `ld' mixes partial programs, addresses in the
absolute section remain unchanged.  For example, address `{absolute 0}'
is "relocated" to run-time address 0 by `ld'. Although two partial
programs' data sections will not overlap addresses after linking, *by
definition* their absolute sections will overlap. Address `{absolute
239}' in one partial program will always be the same address when the
program is running as address `{absolute 239}' in any other partial
program.

   The idea of sections is extended to the "undefined" section.  Any
address whose section is unknown at assembly time is by definition
rendered {undefined U}--where U will be filled in later. Since numbers
are always defined, the only way to generate an undefined address is to
mention an undefined symbol.  A reference to a named common block would
be such a symbol: its value is unknown at assembly time so it has
section *undefined*.

   By analogy the word *section* is used to describe groups of sections
in the linked program.  `ld' puts all partial programs' text sections
in contiguous addresses in the linked program.  It is customary to
refer to the *text section* of a program, meaning all the addresses of
all partial program's text sections.  Likewise for data and bss
sections.

   Some sections are manipulated by `ld'; others are invented for use
of `as' and have no meaning except during assembly.


File: as.i,  Node: ld Sections,  Next: as Sections,  Prev: Secs Background,  Up: Sections

ld Sections
===========

   `ld' deals with just four kinds of sections, summarized below.

*named sections*
     These sections hold your program.  `as' and `ld' treat them as
     separate but equal sections.  Anything you can say of one section
     is true another.

*bss section*
     This section contains zeroed bytes when your program begins
     running.  It is used to hold unitialized variables or common
     storage.  The length of each partial program's bss section is
     important, but because it starts out containing zeroed bytes there
     is no need to store explicit zero bytes in the object file.  The
     bss section was invented to eliminate those explicit zeros from
     object files.

*absolute section*
     Address 0 of this section is always "relocated" to runtime address
     0. This is useful if you want to refer to an address that `ld' must
     not change when relocating.  In this sense we speak of absolute
     addresses being "unrelocatable": they don't change during
     relocation.

*undefined section*
     This "section" is a catch-all for address references to objects
     not in the preceding sections.

   An idealized example of three relocatable sections follows. The
example uses the traditional section names `.text' and `.data'. Memory
addresses are on the horizontal axis.

                           +-----+----+--+
     partial program # 1:  |ttttt|dddd|00|
                           +-----+----+--+
     
                           text   data bss
                           seg.   seg. seg.
     
                           +---+---+---+
     partial program # 2:  |TTT|DDD|000|
                           +---+---+---+
     
                           +--+---+-----+--+----+---+-----+~~
     linked program:       |  |TTT|ttttt|  |dddd|DDD|00000|
                           +--+---+-----+--+----+---+-----+~~
     
         addresses:        0 ...


File: as.i,  Node: as Sections,  Next: Sub-Sections,  Prev: ld Sections,  Up: Sections

as Internal Sections
====================

   These sections are meant only for the internal use of `as'.  They
have no meaning at run-time.  You don't really need to know about these
sections for most purposes; but they can be mentioned in `as' warning
messages, so it might be helpful to have an idea of their meanings to
`as'.  These sections are used to permit the value of every expression
in your assembly language program to be a section-relative address.

absent
     An expression was expected and none was found.

ASSEMBLER-INTERNAL-LOGIC-ERROR!
     An internal assembler logic error has been found.  This means
     there is a bug in the assembler.

bignum/flonum
     If a number can't be written as a C `int' constant (a bignum or a
     flonum, but not an integer), it is recorded as belonging to this
     "section".  `as' has to remember that a flonum or a bignum does
     not fit into 32 bits, and cannot be an argument (*note
     Arguments::.) in an expression: this is done by making a flonum or
     bignum be in a separate internal section.  This is purely for
     internal `as' convenience; bignum/flonum section behaves similarly
     to absolute section.

pass1 section
     The expression was impossible to evaluate in the first pass.  The
     assembler will attempt a second pass (second reading of the
     source) to evaluate the expression.  Your expression mentioned an
     undefined symbol in a way that defies the one-pass (section +
     offset in section) assembly process.  No compiler need emit such
     an expression.

          *Warning:* the second pass is currently not implemented.  `as'
          will abort with an error message if one is required.

difference section
     As an assist to the C compiler, expressions of the forms
             (UNDEFINED SYMBOL) - (EXPRESSION)
             SOMETHING - (UNDEFINED SYMBOL)
             (UNDEFINED SYMBOL) - (UNDEFINED SYMBOL)

     are permitted, and belong to the difference section.  `as'
     re-evaluates such expressions after the source file has been read
     and the symbol table built.  If by that time there are no
     undefined symbols in the expression then the expression assumes a
     new section.  The intention is to permit statements like `.word
     label - base_of_table' to be assembled in one pass where both
     `label' and `base_of_table' are undefined.  This is useful for
     compiling C and Algol switch statements, Pascal case statements,
     FORTRAN computed goto statements and the like.


File: as.i,  Node: Sub-Sections,  Next: bss,  Prev: as Sections,  Up: Sections

Sub-Sections
============

   You may have separate groups of data in named sections that you want
to end up near to each other in the object file, even though they are
not contiguous in the assembler source. `as' allows you to use
"subsections" for this purpose. Within each section, there can be
numbered subsections with values from 0 to 8192.  Objects assembled
into the same subsection will be grouped with other objects in the same
subsection when they are all put into the object file.  For example, a
compiler might want to store constants in the text section, but might
not want to have them interspersed with the program being assembled. 
In this case, the compiler could issue a `.text 0' before each section
of code being output, and a `.text 1' before each group of constants
being output.

   Subsections are optional.  If you don't use subsections, everything
will be stored in subsection number zero.

   On the H8/300 platform, each subsection is zero-padded to a word
boundary (two bytes).

   Subsections appear in your object file in numeric order, lowest
numbered to highest.  (All this to be compatible with other people's
assemblers.) The object file contains no representation of subsections;
`ld' and other programs that manipulate object files will see no trace
of them. They just see all your text subsections as a text section, and
all your data subsections as a data section.

   To specify which subsection you want subsequent statements assembled
into, use a numeric argument to specify it, in a `.text EXPRESSION' or
a `.data EXPRESSION' statement. You can also use an extra subsection
argument with arbitrary named sections: `.section NAME, EXPRESSION'.
EXPRESSION should be an absolute expression. (*Note Expressions::.)  If
you just say `.text' then `.text 0' is assumed.  Likewise `.data' means
`.data 0'.  Assembly begins in `text 0'.  For instance:
     .text 0     # The default subsection is text 0 anyway.
     .ascii "This lives in the first text subsection. *"
     .text 1
     .ascii "But this lives in the second text subsection."
     .data 0
     .ascii "This lives in the data section,"
     .ascii "in the first data subsection."
     .text 0
     .ascii "This lives in the first text section,"
     .ascii "immediately following the asterisk (*)."

   Each section has a "location counter" incremented by one for every
byte assembled into that section.  Because subsections are merely a
convenience restricted to `as' there is no concept of a subsection
location counter.  There is no way to directly manipulate a location
counter--but the `.align' directive will change it, and any label
definition will capture its current value.  The location counter of the
section that statements are being assembled into is said to be the
"active" location counter.


File: as.i,  Node: bss,  Prev: Sub-Sections,  Up: Sections

bss Section
===========

   The bss section is used for local common variable storage. You may
allocate address space in the bss section, but you may not dictate data
to load into it before your program executes.  When your program starts
running, all the contents of the bss section are zeroed bytes.

   Addresses in the bss section are allocated with special directives;
you may not assemble anything directly into the bss section.  Hence
there are no bss subsections. *Note `.comm': Comm, *note `.lcomm':
Lcomm..


File: as.i,  Node: Symbols,  Next: Expressions,  Prev: Sections,  Up: Top

Symbols
*******

   Symbols are a central concept: the programmer uses symbols to name
things, the linker uses symbols to link, and the debugger uses symbols
to debug.

     *Warning:* `as' does not place symbols in the object file in the
     same order they were declared.  This may break some debuggers.

* Menu:

* Labels::			Labels
* Setting Symbols::		Giving Symbols Other Values
* Symbol Names::		Symbol Names
* Dot::				The Special Dot Symbol
* Symbol Attributes::		Symbol Attributes


File: as.i,  Node: Labels,  Next: Setting Symbols,  Up: Symbols

Labels
======

   A "label" is written as a symbol immediately followed by a colon
`:'.  The symbol then represents the current value of the active
location counter, and is, for example, a suitable instruction operand. 
You are warned if you use the same symbol to represent two different
locations: the first definition overrides any other definitions.


File: as.i,  Node: Setting Symbols,  Next: Symbol Names,  Prev: Labels,  Up: Symbols

Giving Symbols Other Values
===========================

   A symbol can be given an arbitrary value by writing a symbol,
followed by an equals sign `=', followed by an expression (*note
Expressions::.).  This is equivalent to using the `.set' directive. 
*Note `.set': Set.


File: as.i,  Node: Symbol Names,  Next: Dot,  Prev: Setting Symbols,  Up: Symbols

Symbol Names
============

   Symbol names begin with a letter or with one of `_.' That character
may be followed by any string of digits, letters, and underscores. Case
of letters is significant: `foo' is a different symbol name than `Foo'.

   Each symbol has exactly one name. Each name in an assembly language
program refers to exactly one symbol. You may use that symbol name any
number of times in a program.

Local Symbol Names
------------------

   Local symbols help compilers and programmers use names temporarily.
There are ten local symbol names, which are re-used throughout the
program.  You may refer to them using the names `0' `1' ... `9'.  To
define a local symbol, write a label of the form `N:' (where N
represents any digit).  To refer to the most recent previous definition
of that symbol write `Nb', using the same digit as when you defined the
label.  To refer to the next definition of a local label, write
`Nf'--where N gives you a choice of 10 forward references.  The `b'
stands for "backwards" and the `f' stands for "forwards".

   Local symbols are not emitted by the current GNU C compiler.

   There is no restriction on how you can use these labels, but
remember that at any point in the assembly you can refer to at most 10
prior local labels and to at most 10 forward local labels.

   Local symbol names are only a notation device.  They are immediately
transformed into more conventional symbol names before the assembler
uses them.  The symbol names stored in the symbol table, appearing in
error messages and optionally emitted to the object file have these
parts:

`L'
     All local labels begin with `L'. Normally both `as' and `ld'
     forget symbols that start with `L'. These labels are used for
     symbols you are never intended to see.  If you give the `-L'
     option then `as' will retain these symbols in the object file. If
     you also instruct `ld' to retain these symbols, you may use them
     in debugging.

`DIGIT'
     If the label is written `0:' then the digit is `0'. If the label
     is written `1:' then the digit is `1'. And so on up through `9:'.

A'
     This unusual character is included so you don't accidentally invent
     a symbol of the same name.  The character has ASCII value `\001'.

`*ordinal number*'
     This is a serial number to keep the labels distinct.  The first
     `0:' gets the number `1'; The 15th `0:' gets the number `15';
     *etc.*.  Likewise for the other labels `1:' through `9:'.

   For instance, the first `1:' is named `LA1', the 44th `3:' is named
`LA44'.


File: as.i,  Node: Dot,  Next: Symbol Attributes,  Prev: Symbol Names,  Up: Symbols

The Special Dot Symbol
======================

   The special symbol `.' refers to the current address that `as' is
assembling into.  Thus, the expression `melvin: .long .' will cause
`melvin' to contain its own address. Assigning a value to `.' is
treated the same as a `.org' directive.  Thus, the expression `.=.+4'
is the same as saying `.space 4'.


File: as.i,  Node: Symbol Attributes,  Prev: Dot,  Up: Symbols

Symbol Attributes
=================

   Every symbol has, as well as its name, the attributes "Value" and
"Type".  Depending on output format, symbols can also have auxiliary
attributes.

   If you use a symbol without defining it, `as' assumes zero for all
these attributes, and probably won't warn you.  This makes the symbol
an externally defined symbol, which is generally what you would want.

* Menu:

* Symbol Value::		Value
* Symbol Type::			Type
* COFF Symbols::		Symbol Attributes for COFF


File: as.i,  Node: Symbol Value,  Next: Symbol Type,  Up: Symbol Attributes

Value
-----

   The value of a symbol is (usually) 32 bits.  For a symbol which
labels a location in the text, data, bss or absolute sections the value
is the number of addresses from the start of that section to the label.
Naturally for text, data and bss sections the value of a symbol changes
as `ld' changes section base addresses during linking.  Absolute
symbols' values do not change during linking: that is why they are
called absolute.

   The value of an undefined symbol is treated in a special way.  If it
is 0 then the symbol is not defined in this assembler source program,
and `ld' will try to determine its value from other programs it is
linked with.  You make this kind of symbol simply by mentioning a symbol
name without defining it.  A non-zero value represents a `.comm' common
declaration.  The value is how much common storage to reserve, in bytes
(addresses).  The symbol refers to the first address of the allocated
storage.


File: as.i,  Node: Symbol Type,  Next: COFF Symbols,  Prev: Symbol Value,  Up: Symbol Attributes

Type
----

   The type attribute of a symbol contains relocation (section)
information, any flag settings indicating that a symbol is external, and
(optionally), other information for linkers and debuggers.  The exact
format depends on the object-code output format in use.


File: as.i,  Node: COFF Symbols,  Prev: Symbol Type,  Up: Symbol Attributes

Symbol Attributes for COFF
--------------------------

   The COFF format supports a multitude of auxiliary symbol attributes;
like the primary symbol attributes, they are set between `.def' and
`.endef' directives.

Primary Attributes
..................

   The symbol name is set with `.def'; the value and type,
respectively, with `.val' and `.type'.

Auxiliary Attributes
....................

   The `as' directives `.dim', `.line', `.scl', `.size', and `.tag' can
generate auxiliary symbol table information for COFF.


File: as.i,  Node: Expressions,  Next: Pseudo Ops,  Prev: Symbols,  Up: Top

Expressions
***********

   An "expression" specifies an address or numeric value. Whitespace
may precede and/or follow an expression.

* Menu:

* Empty Exprs::			Empty Expressions
* Integer Exprs::		Integer Expressions


File: as.i,  Node: Empty Exprs,  Next: Integer Exprs,  Up: Expressions

Empty Expressions
=================

   An empty expression has no value: it is just whitespace or null.
Wherever an absolute expression is required, you may omit the
expression and `as' will assume a value of (absolute) 0.  This is
compatible with other assemblers.


File: as.i,  Node: Integer Exprs,  Prev: Empty Exprs,  Up: Expressions

Integer Expressions
===================

   An "integer expression" is one or more *arguments* delimited by
*operators*.

* Menu:

* Arguments::			Arguments
* Operators::			Operators
* Prefix Ops::			Prefix Operators
* Infix Ops::			Infix Operators


File: as.i,  Node: Arguments,  Next: Operators,  Up: Integer Exprs

Arguments
---------

   "Arguments" are symbols, numbers or subexpressions.  In other
contexts arguments are sometimes called "arithmetic operands".  In this
manual, to avoid confusing them with the "instruction operands" of the
machine language, we use the term "argument" to refer to parts of
expressions only, reserving the word "operand" to refer only to machine
instruction operands.

   Symbols are evaluated to yield {SECTION NNN} where SECTION is one of
text, data, bss, absolute, or undefined.  NNN is a signed, 2's
complement 32 bit integer.

   Numbers are usually integers.

   A number can be a flonum or bignum.  In this case, you are warned
that only the low order 32 bits are used, and `as' pretends these 32
bits are an integer.  You may write integer-manipulating instructions
that act on exotic constants, compatible with other assemblers.

   Subexpressions are a left parenthesis `(' followed by an integer
expression, followed by a right parenthesis `)'; or a prefix operator
followed by an argument.


File: as.i,  Node: Operators,  Next: Prefix Ops,  Prev: Arguments,  Up: Integer Exprs

Operators
---------

   "Operators" are arithmetic functions, like `+' or `%'.  Prefix
operators are followed by an argument.  Infix operators appear between
their arguments.  Operators may be preceded and/or followed by
whitespace.


File: as.i,  Node: Prefix Ops,  Next: Infix Ops,  Prev: Operators,  Up: Integer Exprs

Prefix Operator
---------------

   `as' has the following "prefix operators".  They each take one
argument, which must be absolute.

`-'
     "Negation".  Two's complement negation.

`~'
     "Complementation".  Bitwise not.


File: as.i,  Node: Infix Ops,  Prev: Prefix Ops,  Up: Integer Exprs

Infix Operators
---------------

   "Infix operators" take two arguments, one on either side.  Operators
have precedence, but operations with equal precedence are performed left
to right.  Apart from `+' or `-', both arguments must be absolute, and
the result is absolute.

  1. Highest Precedence

    `*'
          "Multiplication".

    `/'
          "Division".  Truncation is the same as the C operator `/'

    `%'
          "Remainder".

    `<'
    `<<'
          "Shift Left".  Same as the C operator `<<'

    `>'
    `>>'
          "Shift Right".  Same as the C operator `>>'

  2. Intermediate precedence

    `|'
          "Bitwise Inclusive Or".

    `&'
          "Bitwise And".

    `^'
          "Bitwise Exclusive Or".

    `!'
          "Bitwise Or Not".

  3. Lowest Precedence

    `+'
          "Addition".  If either argument is absolute, the result has
          the section of the other argument. If either argument is
          pass1 or undefined, the result is pass1. Otherwise `+' is
          illegal.

    `-'
          "Subtraction".  If the right argument is absolute, the result
          has the section of the left argument. If either argument is
          pass1 the result is pass1. If either argument is undefined
          the result is difference section. If both arguments are in
          the same section, the result is absolute--provided that
          section is one of text, data or bss. Otherwise subtraction is
          illegal.

   The sense of the rule for addition is that it's only meaningful to
add the *offsets* in an address; you can only have a defined section in
one of the two arguments.

   Similarly, you can't subtract quantities from two different sections.


File: as.i,  Node: Pseudo Ops,  Next: H8/300-Dependent,  Prev: Expressions,  Up: Top

Assembler Directives
********************

   All assembler directives have names that begin with a period (`.').
The rest of the name is letters, usually in lower case.

   This chapter discusses directives present regardless of the target
machine configuration for the GNU assembler.

* Menu:

* Abort::			`.abort'
* coff-ABORT::			`.ABORT'
* Align::			`.align ABS-EXPR , ABS-EXPR'
* App-File::			`.app-file STRING'
* Ascii::			`.ascii "STRING"'...
* Asciz::			`.asciz "STRING"'...
* Byte::			`.byte EXPRESSIONS'
* Comm::			`.comm SYMBOL , LENGTH '
* Data::			`.data SUBSECTION'
* Def::				`.def NAME'
* Dim::				`.dim'
* Double::			`.double FLONUMS'
* Eject::			`.eject'
* Else::			`.else'
* Endef::			`.endef'
* Endif::			`.endif'
* Equ::				`.equ SYMBOL, EXPRESSION'
* Extern::			`.extern'
* File::			`.file STRING'
* Fill::			`.fill REPEAT , SIZE , VALUE'
* Float::			`.float FLONUMS'
* Global::			`.global SYMBOL', `.globl SYMBOL'
* hword::			`.hword EXPRESSIONS'
* Ident::			`.ident'
* If::				`.if ABSOLUTE EXPRESSION'
* Include::			`.include "FILE"'
* Int::				`.int EXPRESSIONS'
* Lcomm::			`.lcomm SYMBOL , LENGTH'
* Lflags::                      `.lflags'
* Line::			`.line LINE-NUMBER'
* Ln::				`.ln LINE-NUMBER'
* List::			`.list'
* Long::			`.long EXPRESSIONS'
* Nolist::			`.nolist'
* Octa::			`.octa BIGNUMS'
* Org::				`.org NEW-LC , FILL'
* Psize::                       `.psize LINES, COLUMNS'
* Quad::			`.quad BIGNUMS'
* Sbttl::			`.sbttl "SUBHEADING"'
* Scl::				`.scl CLASS'
* Section::                     `.section NAME, SUBSECTION'
* Set::				`.set SYMBOL, EXPRESSION'
* Short::			`.short EXPRESSIONS'
* Single::			`.single FLONUMS'
* Size::			`.size'
* Space::			`.space SIZE , FILL'
* Tag::				`.tag STRUCTNAME'
* Text::			`.text SUBSECTION'
* Title::			`.title "HEADING"'
* Type::			`.type INT'
* Val::				`.val ADDR'
* Word::			`.word EXPRESSIONS'
* Deprecated::			Deprecated Directives


File: as.i,  Node: Abort,  Next: coff-ABORT,  Up: Pseudo Ops

`.abort'
========

   This directive stops the assembly immediately.  It is for
compatibility with other assemblers.  The original idea was that the
assembly language source would be piped into the assembler.  If the
sender of the source quit, it could use this directive tells `as' to
quit also.  One day `.abort' will not be supported.


File: as.i,  Node: coff-ABORT,  Next: Align,  Prev: Abort,  Up: Pseudo Ops

`.ABORT'
========

   When producing COFF output, `as' accepts this directive as a synonym
for `.abort'.


File: as.i,  Node: Align,  Next: App-File,  Prev: coff-ABORT,  Up: Pseudo Ops

`.align ABS-EXPR , ABS-EXPR'
============================

   Pad the location counter (in the current subsection) to a particular
storage boundary.  The first expression (which must be absolute) is the
number of low-order zero bits the location counter will have after
advancement.  For example `.align 3' will advance the location counter
until it a multiple of 8.  If the location counter is already a
multiple of 8, no change is needed.

   The second expression (also absolute) gives the value to be stored in
the padding bytes.  It (and the comma) may be omitted.  If it is
omitted, the padding bytes are zero.


File: as.i,  Node: App-File,  Next: Ascii,  Prev: Align,  Up: Pseudo Ops

`.app-file STRING'
==================

   `.app-file' (which may also be spelled `.file') tells `as' that we
are about to start a new logical file.  STRING is the new file name. 
In general, the filename is recognized whether or not it is surrounded
by quotes `"'; but if you wish to specify an empty file name is
permitted, you must give the quotes--`""'.  This statement may go away
in future: it is only recognized to be compatible with old `as'
programs.


File: as.i,  Node: Ascii,  Next: Asciz,  Prev: App-File,  Up: Pseudo Ops

`.ascii "STRING"'...
====================

   `.ascii' expects zero or more string literals (*note Strings::.)
separated by commas.  It assembles each string (with no automatic
trailing zero byte) into consecutive addresses.


File: as.i,  Node: Asciz,  Next: Byte,  Prev: Ascii,  Up: Pseudo Ops

`.asciz "STRING"'...
====================

   `.asciz' is just like `.ascii', but each string is followed by a
zero byte.  The "z" in `.asciz' stands for "zero".


File: as.i,  Node: Byte,  Next: Comm,  Prev: Asciz,  Up: Pseudo Ops

`.byte EXPRESSIONS'
===================

   `.byte' expects zero or more expressions, separated by commas. Each
expression is assembled into the next byte.


File: as.i,  Node: Comm,  Next: Data,  Prev: Byte,  Up: Pseudo Ops

`.comm SYMBOL , LENGTH '
========================

   `.comm' declares a named common area in the bss section.  Normally
`ld' reserves memory addresses for it during linking, so no partial
program defines the location of the symbol.  Use `.comm' to tell `ld'
that it must be at least LENGTH bytes long.  `ld' will allocate space
for each `.comm' symbol that is at least as long as the longest `.comm'
request in any of the partial programs linked.  LENGTH is an absolute
expression.


File: as.i,  Node: Data,  Next: Def,  Prev: Comm,  Up: Pseudo Ops

`.data SUBSECTION'
==================

   `.data' tells `as' to assemble the following statements onto the end
of the data subsection numbered SUBSECTION (which is an absolute
expression).  If SUBSECTION is omitted, it defaults to zero.


File: as.i,  Node: Def,  Next: Dim,  Prev: Data,  Up: Pseudo Ops

`.def NAME'
===========

   Begin defining debugging information for a symbol NAME; the
definition extends until the `.endef' directive is encountered.


File: as.i,  Node: Dim,  Next: Double,  Prev: Def,  Up: Pseudo Ops

`.dim'
======

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.


File: as.i,  Node: Double,  Next: Eject,  Prev: Dim,  Up: Pseudo Ops

`.double FLONUMS'
=================

   `.double' expects zero or more flonums, separated by commas.  It
assembles floating point numbers. On the H8/300 family `.double' emits
64-bit floating-point numbers in IEEE format.


File: as.i,  Node: Eject,  Next: Else,  Prev: Double,  Up: Pseudo Ops

`.eject'
========

   Force a page break at this point, when generating assembly listings.


File: as.i,  Node: Else,  Next: Endef,  Prev: Eject,  Up: Pseudo Ops

`.else'
=======

   `.else' is part of the `as' support for conditional assembly; *note
`.if': If..  It marks the beginning of a section of code to be
assembled if the condition for the preceding `.if' was false.


File: as.i,  Node: Endef,  Next: Endif,  Prev: Else,  Up: Pseudo Ops

`.endef'
========

   This directive flags the end of a symbol definition begun with
`.def'.


File: as.i,  Node: Endif,  Next: Equ,  Prev: Endef,  Up: Pseudo Ops

`.endif'
========

   `.endif' is part of the `as' support for conditional assembly; it
marks the end of a block of code that is only assembled conditionally. 
*Note `.if': If.


File: as.i,  Node: Equ,  Next: Extern,  Prev: Endif,  Up: Pseudo Ops

`.equ SYMBOL, EXPRESSION'
=========================

   This directive sets the value of SYMBOL to EXPRESSION. It is
synonymous with `.set'; *note `.set': Set..


File: as.i,  Node: Extern,  Next: File,  Prev: Equ,  Up: Pseudo Ops

`.extern'
=========

   `.extern' is accepted in the source program--for compatibility with
other assemblers--but it is ignored.  `as' treats all undefined symbols
as external.


File: as.i,  Node: File,  Next: Fill,  Prev: Extern,  Up: Pseudo Ops

`.file STRING'
==============

   `.file' (which may also be spelled `.app-file') tells `as' that we
are about to start a new logical file. STRING is the new file name.  In
general, the filename is recognized whether or not it is surrounded by
quotes `"'; but if you wish to specify an empty file name, you must
give the quotes--`""'.  This statement may go away in future: it is only
recognized to be compatible with old `as' programs.


File: as.i,  Node: Fill,  Next: Float,  Prev: File,  Up: Pseudo Ops

`.fill REPEAT , SIZE , VALUE'
=============================

   RESULT, SIZE and VALUE are absolute expressions. This emits REPEAT
copies of SIZE bytes.  REPEAT may be zero or more.  SIZE may be zero or
more, but if it is more than 8, then it is deemed to have the value 8,
compatible with other people's assemblers.  The contents of each REPEAT
bytes is taken from an 8-byte number.  The highest order 4 bytes are
zero.  The lowest order 4 bytes are VALUE rendered in the byte-order of
an integer on the computer `as' is assembling for. Each SIZE bytes in a
repetition is taken from the lowest order SIZE bytes of this number. 
Again, this bizarre behavior is compatible with other people's
assemblers.

   SIZE and VALUE are optional. If the second comma and VALUE are
absent, VALUE is assumed zero.  If the first comma and following tokens
are absent, SIZE is assumed to be 1.


File: as.i,  Node: Float,  Next: Global,  Prev: Fill,  Up: Pseudo Ops

`.float FLONUMS'
================

   This directive assembles zero or more flonums, separated by commas. 
It has the same effect as `.single'. On the H8/300 family, `.float'
emits 32-bit floating point numbers in IEEE format.


File: as.i,  Node: Global,  Next: hword,  Prev: Float,  Up: Pseudo Ops

`.global SYMBOL', `.globl SYMBOL'
=================================

   `.global' makes the symbol visible to `ld'.  If you define SYMBOL in
your partial program, its value is made available to other partial
programs that are linked with it.  Otherwise, SYMBOL will take its
attributes from a symbol of the same name from another partial program
it is linked with.

   Both spellings (`.globl' and `.global') are accepted, for
compatibility with other assemblers.


File: as.i,  Node: hword,  Next: Ident,  Prev: Global,  Up: Pseudo Ops

`.hword EXPRESSIONS'
====================

   This expects zero or more EXPRESSIONS, and emits a 16 bit number for
each.

   This directive is a synonym for both `.short' and `.word'.


File: as.i,  Node: Ident,  Next: If,  Prev: hword,  Up: Pseudo Ops

`.ident'
========

   This directive is used by some assemblers to place tags in object
files. `as' simply accepts the directive for source-file compatibility
with such assemblers, but does not actually emit anything for it.


File: as.i,  Node: If,  Next: Include,  Prev: Ident,  Up: Pseudo Ops

`.if ABSOLUTE EXPRESSION'
=========================

   `.if' marks the beginning of a section of code which is only
considered part of the source program being assembled if the argument
(which must be an ABSOLUTE EXPRESSION) is non-zero.  The end of the
conditional section of code must be marked by `.endif' (*note `.endif':
Endif.); optionally, you may include code for the alternative
condition, flagged by `.else' (*note `.else': Else..

   The following variants of `.if' are also supported:
`.ifdef SYMBOL'
     Assembles the following section of code if the specified SYMBOL
     has been defined.

`.ifndef SYMBOL'
`ifnotdef SYMBOL'
     Assembles the following section of code if the specified SYMBOL
     has not been defined.  Both spelling variants are equivalent.


File: as.i,  Node: Include,  Next: Int,  Prev: If,  Up: Pseudo Ops

`.include "FILE"'
=================

   This directive provides a way to include supporting files at
specified points in your source program.  The code from FILE is
assembled as if it followed the point of the `.include'; when the end
of the included file is reached, assembly of the original file
continues.  You can control the search paths used with the `-I'
command-line option (*note Command-Line Options: Invoking.).  Quotation
marks are required around FILE.


File: as.i,  Node: Int,  Next: Lcomm,  Prev: Include,  Up: Pseudo Ops

`.int EXPRESSIONS'
==================

   Expect zero or more EXPRESSIONS, of any section, separated by
commas.  For each expression, emit a 16-bit number that will, at run
time, be the value of that expression.  The byte order of the
expression depends on what kind of computer will run the program.


File: as.i,  Node: Lcomm,  Next: Lflags,  Prev: Int,  Up: Pseudo Ops

`.lcomm SYMBOL , LENGTH'
========================

   Reserve LENGTH (an absolute expression) bytes for a local common
denoted by SYMBOL.  The section and value of SYMBOL are those of the
new local common.  The addresses are allocated in the bss section, so
at run-time the bytes will start off zeroed.  SYMBOL is not declared
global (*note `.global': Global.), so is normally not visible to `ld'.


File: as.i,  Node: Lflags,  Next: Line,  Prev: Lcomm,  Up: Pseudo Ops

`.lflags'
=========

   `as' accepts this directive, for compatibility with other
assemblers, but ignores it.


File: as.i,  Node: Line,  Next: Ln,  Prev: Lflags,  Up: Pseudo Ops

`.line LINE-NUMBER'
===================

   Even though this is a directive associated with the `a.out' or
`b.out' object-code formats, `as' will still recognize it when
producing COFF output, and will treat `.line' as though it were the
COFF `.ln' *if* it is found outside a `.def'/`.endef' pair.

   Inside a `.def', `.line' is, instead, one of the directives used by
compilers to generate auxiliary symbol information for debugging.


File: as.i,  Node: Ln,  Next: List,  Prev: Line,  Up: Pseudo Ops

`.ln LINE-NUMBER'
=================

   Tell `as' to change the logical line number.  LINE-NUMBER must be an
absolute expression.  The next line will have that logical line number,
so any other statements on the current line (after a statement
separator character `;') will be reported as on logical line number
LINE-NUMBER - 1.


File: as.i,  Node: List,  Next: Long,  Prev: Ln,  Up: Pseudo Ops

`.list'
=======

   Control (in conjunction with the `.nolist' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.

   By default, listings are disabled.  When you enable them (with the
`-a' command line option; *note Command-Line Options: Invoking.), the
initial value of the listing counter is one.


File: as.i,  Node: Long,  Next: Nolist,  Prev: List,  Up: Pseudo Ops

`.long EXPRESSIONS'
===================

   `.long' is the same as `.int', *note `.int': Int..


File: as.i,  Node: Nolist,  Next: Octa,  Prev: Long,  Up: Pseudo Ops

`.nolist'
=========

   Control (in conjunction with the `.list' directive) whether or not
assembly listings are generated.  These two directives maintain an
internal counter (which is zero initially).   `.list' increments the
counter, and `.nolist' decrements it.  Assembly listings are generated
whenever the counter is greater than zero.


File: as.i,  Node: Octa,  Next: Org,  Prev: Nolist,  Up: Pseudo Ops

`.octa BIGNUMS'
===============

   This directive expects zero or more bignums, separated by commas. 
For each bignum, it emits a 16-byte integer.

   The term "octa" comes from contexts in which a "word" is two bytes;
hence *octa*-word for 16 bytes.


File: as.i,  Node: Org,  Next: Psize,  Prev: Octa,  Up: Pseudo Ops

`.org NEW-LC , FILL'
====================

   `.org' will advance the location counter of the current section to
NEW-LC.  NEW-LC is either an absolute expression or an expression with
the same section as the current subsection.  That is, you can't use
`.org' to cross sections: if NEW-LC has the wrong section, the `.org'
directive is ignored.  To be compatible with former assemblers, if the
section of NEW-LC is absolute, `as' will issue a warning, then pretend
the section of NEW-LC is the same as the current subsection.

   `.org' may only increase the location counter, or leave it
unchanged; you cannot use `.org' to move the location counter backwards.

   Because `as' tries to assemble programs in one pass NEW-LC may not
be undefined.  If you really detest this restriction we eagerly await a
chance to share your improved assembler.

   Beware that the origin is relative to the start of the section, not
to the start of the subsection.  This is compatible with other people's
assemblers.

   When the location counter (of the current subsection) is advanced,
the intervening bytes are filled with FILL which should be an absolute
expression.  If the comma and FILL are omitted, FILL defaults to zero.


File: as.i,  Node: Psize,  Next: Quad,  Prev: Org,  Up: Pseudo Ops

`.psize LINES , COLUMNS'
========================

   Use this directive to declare the number of lines--and, optionally,
the number of columns--to use for each page, when generating listings.

   If you don't use `.psize', listings will use a default line-count of
60.  You may omit the comma and COLUMNS specification; the default
width is 200 columns.

   `as' will generate formfeeds whenever the specified number of lines
is exceeded (or whenever you explicitly request one, using `.eject').

   If you specify LINES as `0', no formfeeds are generated save those
explicitly specified with `.eject'.


File: as.i,  Node: Quad,  Next: Sbttl,  Prev: Psize,  Up: Pseudo Ops

`.quad BIGNUMS'
===============

   `.quad' expects zero or more bignums, separated by commas.  For each
bignum, it emits an 8-byte integer.  If the bignum won't fit in 8
bytes, it prints a warning message; and just takes the lowest order 8
bytes of the bignum.

   The term "quad" comes from contexts in which a "word" is two bytes;
hence *quad*-word for 8 bytes.


File: as.i,  Node: Sbttl,  Next: Scl,  Prev: Quad,  Up: Pseudo Ops

`.sbttl "SUBHEADING"'
=====================

   Use SUBHEADING as the title (third line, immediately after the title
line) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.i,  Node: Scl,  Next: Section,  Prev: Sbttl,  Up: Pseudo Ops

`.scl CLASS'
============

   Set the storage-class value for a symbol.  This directive may only be
used inside a `.def'/`.endef' pair.  Storage class may flag whether a
symbol is static or external, or it may record further symbolic
debugging information.


File: as.i,  Node: Section,  Next: Set,  Prev: Scl,  Up: Pseudo Ops

`.section NAME, SUBSECTION'
===========================

   Assemble the following code into end of subsection numbered
SUBSECTION in the COFF named section NAME.  If you omit SUBSECTION,
`as' uses subsection number zero. `.section .text' is equivalent to the
`.text' directive; `.section .data' is equivalent to the `.data'
directive.


File: as.i,  Node: Set,  Next: Short,  Prev: Section,  Up: Pseudo Ops

`.set SYMBOL, EXPRESSION'
=========================

   This directive sets the value of SYMBOL to EXPRESSION.  This will
change SYMBOL's value and type to conform to EXPRESSION.  If SYMBOL was
flagged as external, it remains flagged. (*Note Symbol Attributes::.)

   You may `.set' a symbol many times in the same assembly. If the
expression's section is unknowable during pass 1, a second pass over
the source program will be forced.  The second pass is currently not
implemented.  `as' will abort with an error message if one is required.

   If you `.set' a global symbol, the value stored in the object file
is the last value stored into it.


File: as.i,  Node: Short,  Next: Single,  Prev: Set,  Up: Pseudo Ops

`.short EXPRESSIONS'
====================

   `.short' is the same as `.word'.  *Note `.word': Word.


File: as.i,  Node: Single,  Next: Size,  Prev: Short,  Up: Pseudo Ops

`.single FLONUMS'
=================

   This directive assembles zero or more flonums, separated by commas. 
It has the same effect as `.float'. On the H8/300 family, `.single'
emits 32-bit floating point numbers in IEEE format.


File: as.i,  Node: Size,  Next: Space,  Prev: Single,  Up: Pseudo Ops

`.size'
=======

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.


File: as.i,  Node: Space,  Next: Tag,  Prev: Size,  Up: Pseudo Ops

`.space SIZE , FILL'
====================

   This directive emits SIZE bytes, each of value FILL.  Both SIZE and
FILL are absolute expressions.  If the comma and FILL are omitted, FILL
is assumed to be zero.


File: as.i,  Node: Tag,  Next: Text,  Prev: Space,  Up: Pseudo Ops

`.tag STRUCTNAME'
=================

   This directive is generated by compilers to include auxiliary
debugging information in the symbol table.  It is only permitted inside
`.def'/`.endef' pairs.  Tags are used to link structure definitions in
the symbol table with instances of those structures.


File: as.i,  Node: Text,  Next: Title,  Prev: Tag,  Up: Pseudo Ops

`.text SUBSECTION'
==================

   Tells `as' to assemble the following statements onto the end of the
text subsection numbered SUBSECTION, which is an absolute expression. 
If SUBSECTION is omitted, subsection number zero is used.


File: as.i,  Node: Title,  Next: Type,  Prev: Text,  Up: Pseudo Ops

`.title "HEADING"'
==================

   Use HEADING as the title (second line, immediately after the source
file name and pagenumber) when generating assembly listings.

   This directive affects subsequent pages, as well as the current page
if it appears within ten lines of the top of a page.


File: as.i,  Node: Type,  Next: Val,  Prev: Title,  Up: Pseudo Ops

`.type INT'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the integer INT as the type attribute of a symbol table entry.


File: as.i,  Node: Val,  Next: Word,  Prev: Type,  Up: Pseudo Ops

`.val ADDR'
===========

   This directive, permitted only within `.def'/`.endef' pairs, records
the address ADDR as the value attribute of a symbol table entry.


File: as.i,  Node: Word,  Next: Deprecated,  Prev: Val,  Up: Pseudo Ops

`.word EXPRESSIONS'
===================

   This directive expects zero or more EXPRESSIONS, of any section,
separated by commas. For each expression, `as' emits a 16-bit number.


File: as.i,  Node: Deprecated,  Prev: Word,  Up: Pseudo Ops

Deprecated Directives
=====================

   One day these directives won't work. They are included for
compatibility with older assemblers.
.abort
.app-file
.line

File: as.i,  Node: H8/300-Dependent,  Next: Copying,  Prev: Pseudo Ops,  Up: Top

H8/300 Dependent Features
*************************

* Menu:

* H8/300 Options::		Options
* H8/300 Syntax::		Syntax
* H8/300 Floating Point::	Floating Point
* H8/300 Directives::		H8/300 Machine Directives
* H8/300 Opcodes::		Opcodes


File: as.i,  Node: H8/300 Options,  Next: H8/300 Syntax,  Up: H8/300-Dependent

Options
=======

   `as' has no additional command-line options for the Hitachi H8/300
family.


File: as.i,  Node: H8/300 Syntax,  Next: H8/300 Floating Point,  Prev: H8/300 Options,  Up: H8/300-Dependent

Syntax
======

* Menu:

* H8/300-Chars::		Special Characters
* H8/300-Regs::			Register Names
* H8/300-Addressing::           Addressing Modes


File: as.i,  Node: H8/300-Chars,  Next: H8/300-Regs,  Up: H8/300 Syntax

Special Characters
------------------

   `;' is the line comment character.

   `$' can be used instead of a newline to separate statements.
Therefore *you may not use `$' in symbol names* on the H8/300.


File: as.i,  Node: H8/300-Regs,  Next: H8/300-Addressing,  Prev: H8/300-Chars,  Up: H8/300 Syntax

Register Names
--------------

   You can use predefined symbols of the form `rNh' and `rNl' to refer
to the H8/300 registers as sixteen 8-bit general-purpose registers.  N
is a digit from `0' to `7'); for instance, both `r0h' and `r7l' are
valid register names.

   You can also use the eight predefined symbols `rN' to refer to the
H8/300 registers as 16-bit registers (you must use this form for
addressing).

   The two control registers are called `pc' (program counter; a 16-bit
register) and `ccr' (condition code register; an 8-bit register).  
`r7' is used as the stack pointer, and can also be called `sp'.


File: as.i,  Node: H8/300-Addressing,  Prev: H8/300-Regs,  Up: H8/300 Syntax

Addressing Modes
----------------

   as understands the following addressing modes for the H8/300:
`rN'
     Register direct

`@rN'
     Register indirect

`@(D, rN)'
`@(D:16, rN)'
     Register indirect: 16-bit displacement D from register N. (You may
     specify the `:16' for clarity if you wish, but it is not required
     and has no effect.)

`@rN+'
     Register indirect with post-increment

`@-rN'
     Register indirect with pre-decrement

``@'AA'
``@'AA:8'
``@'AA:16'
     Absolute address `aa'.  You may specify the `:8' or `:16' for
     clarity, if you wish; but `as' neither requires this nor uses
     it--the address size required is taken from context.

`#XX'
`#XX:8'
`#XX:16'
     Immediate data XX.  You may specify the `:8' or `:16' for clarity,
     if you wish; but `as' neither requires this nor uses it--the data
     size required is taken from context.

``@'`@'AA'
``@'`@'AA:8'
     Memory indirect.  You may specify the `:8' for clarity, if you
     wish; but `as' neither requires this nor uses it.


File: as.i,  Node: H8/300 Floating Point,  Next: H8/300 Directives,  Prev: H8/300 Syntax,  Up: H8/300-Dependent

Floating Point
==============

   The H8/300 family uses IEEE floating-point numbers.


File: as.i,  Node: H8/300 Directives,  Next: H8/300 Opcodes,  Prev: H8/300 Floating Point,  Up: H8/300-Dependent

H8/300 Machine Directives
=========================

   `as' has no machine-dependent directives for the H8/300. However, on
this platform the `.int' and `.word' directives generate 16-bit numbers.


File: as.i,  Node: H8/300 Opcodes,  Prev: H8/300 Directives,  Up: H8/300-Dependent

Opcodes
=======

   For detailed information on the H8/300 machine instruction set, see
`H8/300 Series Programming Manual' (Hitachi ADE--602--025).

   `as' implements all the standard H8/300 opcodes.  No additional
pseudo-instructions are needed on this family.

   The following table summarizes the opcodes and their arguments:

     Rs   source register
                 Rd   destination register
                 imm  immediate data
                 x:3  a bit (as a number between 0 and 7)
                 d:8  eight bit displacement from `pc'
                 d:16 sixteen bit displacement from `Rs'
     
     add.b   Rs,Rd                  biand   #x:3,Rd
     add.b   #imm:8,Rd              biand   #x:3,@Rd
     add.w   Rs,Rd                  biand   #x:3,@aa:8
     adds    #1,Rd                  bild    #x:3,Rd
     adds    #2,Rd                  bild    #x:3,@Rd
     addx    #imm:8,Rd              bild    #x:3,@aa:8
     addx    Rs,Rd                  bior    #x:3,Rd
     and     #imm:8,Rd              bior    #x:3,@Rd
     and     Rs,Rd                  bior    #x:3,@aa:8
     andc    #imm:8,ccr             bist    #x:3,Rd
     band    #x:3,Rd                bist    #x:3,@Rd
     band    #x:3,@Rd               bist    #x:3,@aa:8
     bra     d:8                    bixor   #x:3,Rd
     bt      d:8                    bixor   #x:3,@Rd
     brn     d:8                    bixor   #x:3,@aa:8
     bf      d:8                    bld     #x:3,Rd
     bhi     d:8                    bld     #x:3,@Rd
     bls     d:8                    bld     #x:3,@aa:8
     bcc     d:8                    bnot    #x:3,Rd
     bhs     d:8                    bnot    #x:3,@Rd
     bcs     d:8                    bnot    #x:3,@aa:8
     blo     d:8                    bnot    Rs,Rd
     bne     d:8                    bnot    Rs,@Rd
     beq     d:8                    bnot    Rs,@aa:8
     bvc     d:8                    bor     #x:3,Rd
     bvs     d:8                    bor     #x:3,@Rd
     bpl     d:8                    bor     #x:3,@aa:8
     bmi     d:8                    bset    #x:3,@Rd
     bge     d:8                    bset    #x:3,@aa:8
     blt     d:8                    bset    Rs,Rd
     bgt     d:8                    bset    Rs,@Rd
     ble     d:8                    bset    Rs,@aa:8
     bclr    #x:3,Rd                bsr     d:8
     bclr    #x:3,@Rd               bst     #x:3,Rd
     bclr    #x:3,@aa:8             bst     #x:3,@Rd
     bclr    Rs,Rd                  bst     #x:3,@aa:8
     bclr    Rs,@Rd                 btst    #x:3,Rd

     btst    #x:3,@Rd               mov.w   @(d:16, Rs),Rd
     btst    #x:3,@aa:8             mov.w   @Rs+,Rd
     btst    Rs,Rd                  mov.w   @aa:16,Rd
     btst    Rs,@Rd                 mov.w   Rs,@Rd
     btst    Rs,@aa:8               mov.w   Rs,@(d:16, Rd)
     bxor    #x:3,Rd                mov.w   Rs,@-Rd
     bxor    #x:3,@Rd               mov.w   Rs,@aa:16
     bxor    #x:3,@aa:8             movfpe  @aa:16,Rd
     cmp.b   #imm:8,Rd              movtpe  Rs,@aa:16
     cmp.b   Rs,Rd                  mulxu   Rs,Rd
     cmp.w   Rs,Rd                  neg     Rs
     daa     Rs                     nop
     das     Rs                     not     Rs
     dec     Rs                     or      #imm:8,Rd
     divxu   Rs,Rd                  or      Rs,Rd
     eepmov                         orc     #imm:8,ccr
     inc     Rs                     pop     Rs
     jmp     @Rs                    push    Rs
     jmp     @aa:16                 rotl    Rs
     jmp     @@aa                   rotr    Rs
     jsr     @Rs                    rotxl   Rs
     jsr     @aa:16                 rotxr   Rs
     jsr     @@aa:8                 rte
     ldc     #imm:8,ccr             rts
     ldc     Rs,ccr                 shal    Rs
     mov.b   Rs,Rd                  shar    Rs
     mov.b   #imm:8,Rd              shll    Rs
     mov.b   @Rs,Rd                 shlr    Rs
     mov.b   @(d:16, Rs),Rd         sleep
     mov.b   @Rs+,Rd                stc     ccr,Rd
     mov.b   @aa:16,Rd              sub.b   Rs,Rd
     mov.b   @aa:8,Rd               sub.w   Rs,Rd
     mov.b   Rs,@Rd                 subs    #1,Rd
     mov.b   Rs,@(d:16, Rd)         subs    #2,Rd
     mov.b   Rs,@-Rd                subx    #imm:8,Rd
     mov.b   Rs,@aa:16              subx    Rs,Rd
     mov.b   Rs,@aa:8               xor     #imm:8,Rd
     mov.w   Rs,Rd                  xor     Rs,Rd
     mov.w   #imm:16,Rd             xorc    #imm:8,ccr
     mov.w   @Rs,Rd

   Four H8/300 instructions (`add', `cmp', `mov', `sub') are defined
with variants using the suffixes `.b' and `.w' to specify the size of a
memory operand.  `as' supports these suffixes, but does not require
them; since one of the operands is always a register, `as' can deduce
the correct size.

   For example, since `r0' refers to a 16-bit register,
     mov    r0,@foo
is equivalent to
     mov.w  r0,@foo

   If you use the size suffixes, `as' will issue a warning if there's a
mismatch between the suffix and the register size.


File: as.i,  Node: Copying,  Next: Index,  Prev: H8/300-Dependent,  Up: Top

GNU GENERAL PUBLIC LICENSE
**************************

                         Version 2, June 1991

     Copyright (C) 1989, 1991 Free Software Foundation, Inc.
     675 Mass Ave, Cambridge, MA 02139, USA
     
     Everyone is permitted to copy and distribute verbatim copies
     of this license document, but changing it is not allowed.

Preamble
========

   The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

   When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it in
new free programs; and that you know you can do these things.

   To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

   For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

   We protect your rights with two steps: (1) copyright the software,
and (2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

   Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

   Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

   The precise terms and conditions for copying, distribution and
modification follow.

    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  1. This License applies to any program or other work which contains a
     notice placed by the copyright holder saying it may be distributed
     under the terms of this General Public License.  The "Program",
     below, refers to any such program or work, and a "work based on
     the Program" means either the Program or any derivative work under
     copyright law: that is to say, a work containing the Program or a
     portion of it, either verbatim or with modifications and/or
     translated into another language.  (Hereinafter, translation is
     included without limitation in the term "modification".)  Each
     licensee is addressed as "you".

     Activities other than copying, distribution and modification are
     not covered by this License; they are outside its scope.  The act
     of running the Program is not restricted, and the output from the
     Program is covered only if its contents constitute a work based on
     the Program (independent of having been made by running the
     Program). Whether that is true depends on what the Program does.

  2. You may copy and distribute verbatim copies of the Program's
     source code as you receive it, in any medium, provided that you
     conspicuously and appropriately publish on each copy an appropriate
     copyright notice and disclaimer of warranty; keep intact all the
     notices that refer to this License and to the absence of any
     warranty; and give any other recipients of the Program a copy of
     this License along with the Program.

     You may charge a fee for the physical act of transferring a copy,
     and you may at your option offer warranty protection in exchange
     for a fee.

  3. You may modify your copy or copies of the Program or any portion
     of it, thus forming a work based on the Program, and copy and
     distribute such modifications or work under the terms of Section 1
     above, provided that you also meet all of these conditions:

       a. You must cause the modified files to carry prominent notices
          stating that you changed the files and the date of any change.

       b. You must cause any work that you distribute or publish, that
          in whole or in part contains or is derived from the Program
          or any part thereof, to be licensed as a whole at no charge
          to all third parties under the terms of this License.

       c. If the modified program normally reads commands interactively
          when run, you must cause it, when started running for such
          interactive use in the most ordinary way, to print or display
          an announcement including an appropriate copyright notice and
          a notice that there is no warranty (or else, saying that you
          provide a warranty) and that users may redistribute the
          program under these conditions, and telling the user how to
          view a copy of this License.  (Exception: if the Program
          itself is interactive but does not normally print such an
          announcement, your work based on the Program is not required
          to print an announcement.)

     These requirements apply to the modified work as a whole.  If
     identifiable sections of that work are not derived from the
     Program, and can be reasonably considered independent and separate
     works in themselves, then this License, and its terms, do not
     apply to those sections when you distribute them as separate
     works.  But when you distribute the same sections as part of a
     whole which is a work based on the Program, the distribution of
     the whole must be on the terms of this License, whose permissions
     for other licensees extend to the entire whole, and thus to each
     and every part regardless of who wrote it.

     Thus, it is not the intent of this section to claim rights or
     contest your rights to work written entirely by you; rather, the
     intent is to exercise the right to control the distribution of
     derivative or collective works based on the Program.

     In addition, mere aggregation of another work not based on the
     Program with the Program (or with a work based on the Program) on
     a volume of a storage or distribution medium does not bring the
     other work under the scope of this License.

  4. You may copy and distribute the Program (or a work based on it,
     under Section 2) in object code or executable form under the terms
     of Sections 1 and 2 above provided that you also do one of the
     following:

       a. Accompany it with the complete corresponding machine-readable
          source code, which must be distributed under the terms of
          Sections 1 and 2 above on a medium customarily used for
          software interchange; or,

       b. Accompany it with a written offer, valid for at least three
          years, to give any third party, for a charge no more than your
          cost of physically performing source distribution, a complete
          machine-readable copy of the corresponding source code, to be
          distributed under the terms of Sections 1 and 2 above on a
          medium customarily used for software interchange; or,

       c. Accompany it with the information you received as to the offer
          to distribute corresponding source code.  (This alternative is
          allowed only for noncommercial distribution and only if you
          received the program in object code or executable form with
          such an offer, in accord with Subsection b above.)

     The source code for a work means the preferred form of the work for
     making modifications to it.  For an executable work, complete
     source code means all the source code for all modules it contains,
     plus any associated interface definition files, plus the scripts
     used to control compilation and installation of the executable. 
     However, as a special exception, the source code distributed need
     not include anything that is normally distributed (in either
     source or binary form) with the major components (compiler,
     kernel, and so on) of the operating system on which the executable
     runs, unless that component itself accompanies the executable.

     If distribution of executable or object code is made by offering
     access to copy from a designated place, then offering equivalent
     access to copy the source code from the same place counts as
     distribution of the source code, even though third parties are not
     compelled to copy the source along with the object code.

  5. You may not copy, modify, sublicense, or distribute the Program
     except as expressly provided under this License.  Any attempt
     otherwise to copy, modify, sublicense or distribute the Program is
     void, and will automatically terminate your rights under this
     License. However, parties who have received copies, or rights,
     from you under this License will not have their licenses
     terminated so long as such parties remain in full compliance.

  6. You are not required to accept this License, since you have not
     signed it.  However, nothing else grants you permission to modify
     or distribute the Program or its derivative works.  These actions
     are prohibited by law if you do not accept this License. 
     Therefore, by modifying or distributing the Program (or any work
     based on the Program), you indicate your acceptance of this
     License to do so, and all its terms and conditions for copying,
     distributing or modifying the Program or works based on it.

  7. Each time you redistribute the Program (or any work based on the
     Program), the recipient automatically receives a license from the
     original licensor to copy, distribute or modify the Program
     subject to these terms and conditions.  You may not impose any
     further restrictions on the recipients' exercise of the rights
     granted herein. You are not responsible for enforcing compliance
     by third parties to this License.

  8. If, as a consequence of a court judgment or allegation of patent
     infringement or for any other reason (not limited to patent
     issues), conditions are imposed on you (whether by court order,
     agreement or otherwise) that contradict the conditions of this
     License, they do not excuse you from the conditions of this
     License.  If you cannot distribute so as to satisfy simultaneously
     your obligations under this License and any other pertinent
     obligations, then as a consequence you may not distribute the
     Program at all.  For example, if a patent license would not permit
     royalty-free redistribution of the Program by all those who
     receive copies directly or indirectly through you, then the only
     way you could satisfy both it and this License would be to refrain
     entirely from distribution of the Program.

     If any portion of this section is held invalid or unenforceable
     under any particular circumstance, the balance of the section is
     intended to apply and the section as a whole is intended to apply
     in other circumstances.

     It is not the purpose of this section to induce you to infringe any
     patents or other property right claims or to contest validity of
     any such claims; this section has the sole purpose of protecting
     the integrity of the free software distribution system, which is
     implemented by public license practices.  Many people have made
     generous contributions to the wide range of software distributed
     through that system in reliance on consistent application of that
     system; it is up to the author/donor to decide if he or she is
     willing to distribute software through any other system and a
     licensee cannot impose that choice.

     This section is intended to make thoroughly clear what is believed
     to be a consequence of the rest of this License.

  9. If the distribution and/or use of the Program is restricted in
     certain countries either by patents or by copyrighted interfaces,
     the original copyright holder who places the Program under this
     License may add an explicit geographical distribution limitation
     excluding those countries, so that distribution is permitted only
     in or among countries not thus excluded.  In such case, this
     License incorporates the limitation as if written in the body of
     this License.

 10. The Free Software Foundation may publish revised and/or new
     versions of the General Public License from time to time.  Such
     new versions will be similar in spirit to the present version, but
     may differ in detail to address new problems or concerns.

     Each version is given a distinguishing version number.  If the
     Program specifies a version number of this License which applies
     to it and "any later version", you have the option of following
     the terms and conditions either of that version or of any later
     version published by the Free Software Foundation.  If the Program
     does not specify a version number of this License, you may choose
     any version ever published by the Free Software Foundation.

 11. If you wish to incorporate parts of the Program into other free
     programs whose distribution conditions are different, write to the
     author to ask for permission.  For software which is copyrighted
     by the Free Software Foundation, write to the Free Software
     Foundation; we sometimes make exceptions for this.  Our decision
     will be guided by the two goals of preserving the free status of
     all derivatives of our free software and of promoting the sharing
     and reuse of software generally.

                                NO WARRANTY

 12. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
     WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
     LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
     HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
     WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
     NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
     FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
     QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
     PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
     SERVICING, REPAIR OR CORRECTION.

 13. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
     WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
     MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
     LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
     INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
     INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
     DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
     OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
     OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
     ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

                      END OF TERMS AND CONDITIONS

Applying These Terms to Your New Programs
=========================================

   If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these
terms.

   To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

     ONE LINE TO GIVE THE PROGRAM'S NAME AND AN IDEA OF WHAT IT DOES.
     Copyright (C) 19YY  NAME OF AUTHOR
     
     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2
     of the License, or (at your option) any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the
     Free Software Foundation, Inc., 675 Mass Ave,
     Cambridge, MA 02139, USA.

   Also add information on how to contact you by electronic and paper
mail.

   If the program is interactive, make it output a short notice like
this when it starts in an interactive mode:

     Gnomovision version 69, Copyright (C) 19YY NAME OF AUTHOR
     Gnomovision comes with ABSOLUTELY NO WARRANTY; for details
     type `show w'.  This is free software, and you are welcome
     to redistribute it under certain conditions; type `show c'
     for details.

   The hypothetical commands `show w' and `show c' should show the
appropriate parts of the General Public License.  Of course, the
commands you use may be called something other than `show w' and `show
c'; they could even be mouse-clicks or menu items--whatever suits your
program.

   You should also get your employer (if you work as a programmer) or
your school, if any, to sign a "copyright disclaimer" for the program,
if necessary.  Here is a sample; alter the names:

     Yoyodyne, Inc., hereby disclaims all copyright interest in
     the program `Gnomovision' (which makes passes at compilers)
     written by James Hacker.
     
     SIGNATURE OF TY COON, 1 April 1989
     Ty Coon, President of Vice

   This General Public License does not permit incorporating your
program into proprietary programs.  If your program is a subroutine
library, you may consider it more useful to permit linking proprietary
applications with the library.  If this is what you want to do, use the
GNU Library General Public License instead of this License.


File: as.i,  Node: Index,  Prev: Copying,  Up: Top

Index
*****

* Menu:

* #:                                    Comments.
* #APP:                                 Pre-processing.
* #NO_APP:                              Pre-processing.
* --:                                   Command Line.
* -a:                                   Invoking.
* -al:                                  Invoking.
* -as:                                  Invoking.
* -D:                                   Invoking.
* -f:                                   Invoking.
* -I PATH:                              Invoking.
* -K:                                   Invoking.
* -L:                                   Invoking.
* -o:                                   Invoking.
* -R:                                   Invoking.
* -v:                                   Invoking.
* -version:                             Invoking.
* -W:                                   Invoking.
* .o:                                   Object.
* . (symbol):                           Dot.
* : (label):                            Statements.
* abort directive:                      Abort.
* ABORT directive:                      coff-ABORT.
* align directive:                      Align.
* app-file directive:                   App-File.
* ascii directive:                      Ascii.
* asciz directive:                      Asciz.
* as version:                           Invoking.
* byte directive:                       Byte.
* comm directive:                       Comm.
* data directive:                       Data.
* def directive:                        Def.
* dim directive:                        Dim.
* double directive:                     Double.
* eject directive:                      Eject.
* else directive:                       Else.
* endef directive:                      Endef.
* endif directive:                      Endif.
* equ directive:                        Equ.
* extern directive:                     Extern.
* file directive:                       File.
* fill directive:                       Fill.
* float directive:                      Float.
* global directive:                     Global.
* hword directive:                      hword.
* ident directive:                      Ident.
* ifdef directive:                      If.
* ifndef directive:                     If.
* ifnotdef directive:                   If.
* if directive:                         If.
* include directive:                    Include.
* include directive search path:        Invoking.
* int directive:                        Int.
* int directive, H8/300:                H8/300 Directives.
* lcomm directive:                      Lcomm.
* lflags directive (ignored):           Lflags.
* line directive:                       Line.
* list directive:                       List.
* ln directive:                         Ln.
* long directive:                       Long.
* nolist directive:                     Nolist.
* octa directive:                       Octa.
* org directive:                        Org.
* psize directive:                      Psize.
* quad directive:                       Quad.
* sbttl directive:                      Sbttl.
* scl directive:                        Scl.
* section directive:                    Section.
* set directive:                        Set.
* short directive:                      Short.
* single directive:                     Single.
* size directive:                       Size.
* space directive:                      Space.
* tag directive:                        Tag.
* text directive:                       Text.
* title directive:                      Title.
* type directive:                       Type.
* val directive:                        Val.
* word directive:                       Word.
* word directive, H8/300:               H8/300 Directives.
* \" (doublequote character):           Strings.
* \DDD (octal character code):          Strings.
* \b (backspace character):             Strings.
* \f (formfeed character):              Strings.
* \n (newline character):               Strings.
* \r (carriage return character):       Strings.
* \t (tab):                             Strings.
* \\ (\ character):                     Strings.
* a.out:                                Object.
* absent (internal section):            as Sections.
* absolute section:                     ld Sections.
* addition, permitted arguments:        Infix Ops.
* addresses:                            Expressions.
* addresses, format of:                 Secs Background.
* addressing modes, H8/300:             H8/300-Addressing.
* advancing location counter:           Org.
* arguments for addition:               Infix Ops.
* arguments for subtraction:            Infix Ops.
* arguments in expressions:             Arguments.
* arithmetic functions:                 Operators.
* arithmetic operands:                  Arguments.
* assembler internal logic error:       as Sections.
* assembler, and linker:                Secs Background.
* assembly listings, enabling:          Invoking.
* assigning values to symbols:          Equ.
* assigning values to symbols:          Setting Symbols.
* attributes, symbol:                   Symbol Attributes.
* auxiliary attributes, COFF symbols:   COFF Symbols.
* auxiliary symbol information, COFF:   Dim.
* backslash (\\):                       Strings.
* backspace (\b):                       Strings.
* bignum/flonum (internal section):     as Sections.
* bignums:                              Bignums.
* binary integers:                      Integers.
* bss section:                          ld Sections.
* bss section:                          bss.
* carriage return (\r):                 Strings.
* character constants:                  Characters.
* character escape codes:               Strings.
* character, single:                    Chars.
* characters used in symbols:           Symbol Intro.
* COFF auxiliary symbol information:    Dim.
* COFF named section:                   Section.
* COFF structure debugging:             Tag.
* COFF symbol attributes:               COFF Symbols.
* COFF symbol storage class:            Scl.
* COFF symbol type:                     Type.
* COFF symbols, debugging:              Def.
* COFF value attribute:                 Val.
* command line conventions:             Command Line.
* comments:                             Comments.
* comments, removed by preprocessor:    Pre-processing.
* common variable storage:              bss.
* conditional assembly:                 If.
* constant, single character:           Chars.
* constants:                            Constants.
* constants, bignum:                    Bignums.
* constants, character:                 Characters.
* constants, converted by preprocessor: Pre-processing.
* constants, floating point:            Flonums.
* constants, integer:                   Integers.
* constants, number:                    Numbers.
* constants, string:                    Strings.
* continuing statements:                Statements.
* copying as:                           Copying.
* current address:                      Dot.
* current address, advancing:           Org.
* data and text sections, joining:      Invoking.
* debuggers, and symbol order:          Symbols.
* debugging COFF symbols:               Def.
* decimal integers:                     Integers.
* deprecated directives:                Deprecated.
* difference (internal section):        as Sections.
* directives and instructions:          Statements.
* directives, machine independent:      Pseudo Ops.
* dot (symbol):                         Dot.
* doublequote (\"):                     Strings.
* eight-byte integer:                   Quad.
* empty expressions:                    Empty Exprs.
* EOF, newline must precede:            Statements.
* error messsages:                      Errors.
* escape codes, character:              Strings.
* expression arguments:                 Arguments.
* expressions:                          Expressions.
* expressions, empty:                   Empty Exprs.
* expressions, integer:                 Integer Exprs.
* faster processing (-f):               Invoking.
* file name, logical:                   App-File.
* file name, logical:                   File.
* files, including:                     Include.
* files, input:                         Input Files.
* filling memory:                       Space.
* floating point numbers:               Flonums.
* floating point numbers (double):      Double.
* floating point numbers (single):      Single.
* floating point numbers (single):      Float.
* floating point, H8/300 (IEEE):        H8/300 Floating Point.
* flonums:                              Flonums.
* format of error messages:             Errors.
* format of warning messages:           Errors.
* formfeed (\f):                        Strings.
* functions, in expressions:            Operators.
* GPL:                                  Copying.
* grouping data:                        Sub-Sections.
* H8/300 addressing modes:              H8/300-Addressing.
* H8/300 floating point (IEEE):         H8/300 Floating Point.
* H8/300 line comment character:        H8/300-Chars.
* H8/300 line separator:                H8/300-Chars.
* H8/300 machine directives (none):     H8/300 Directives.
* H8/300 opcode summary:                H8/300 Opcodes.
* H8/300 options (none):                H8/300 Options.
* H8/300 registers:                     H8/300-Regs.
* H8/300 size suffixes:                 H8/300 Opcodes.
* H8/300 support:                       H8/300-Dependent.
* hexadecimal integers:                 Integers.
* infix operators:                      Infix Ops.
* input:                                Input Files.
* input file linenumbers:               Input Files.
* instruction summary, H8/300:          H8/300 Opcodes.
* instructions and directives:          Statements.
* integer expressions:                  Integer Exprs.
* integer, 16-byte:                     Octa.
* integer, 8-byte:                      Quad.
* integers:                             Integers.
* integers, 16-bit:                     hword.
* integers, binary:                     Integers.
* integers, decimal:                    Integers.
* integers, hexadecimal:                Integers.
* integers, octal:                      Integers.
* integers, one byte:                   Byte.
* internal as sections:                 as Sections.
* invocation summary:                   Overview.
* joining text and data sections:       Invoking.
* label (:):                            Statements.
* labels:                               Labels.
* ld:                                   Object.
* length of symbols:                    Symbol Intro.
* license:                              Copying.
* line comment character:               Comments.
* line comment character, H8/300:       H8/300-Chars.
* line numbers, in input files:         Input Files.
* line numbers, in warnings/errors:     Errors.
* line separator character:             Statements.
* line separator, H8/300:               H8/300-Chars.
* lines starting with #:                Comments.
* linker:                               Object.
* linker, and assembler:                Secs Background.
* listing control, turning off:         Nolist.
* listing control, turning on:          List.
* listing control: new page:            Eject.
* listing control: paper size:          Psize.
* listing control: subtitle:            Sbttl.
* listing control: title line:          Title.
* listings, enabling:                   Invoking.
* local common symbols:                 Lcomm.
* local labels, retaining in output:    Invoking.
* local symbol names:                   Symbol Names.
* location counter:                     Dot.
* location counter, advancing:          Org.
* logical file name:                    File.
* logical file name:                    App-File.
* logical line number:                  Line.
* logical line numbers:                 Comments.
* machine directives, H8/300 (none):    H8/300 Directives.
* machine independent directives:       Pseudo Ops.
* machine instructions (not covered):   Manual.
* machine-independent syntax:           Syntax.
* manual, structure and purpose:        Manual.
* merging text and data sections:       Invoking.
* messages from as:                     Errors.
* minus, permitted arguments:           Infix Ops.
* mnemonics, H8/300:                    H8/300 Opcodes.
* multi-line statements:                Statements.
* named section (COFF):                 Section.
* named sections:                       ld Sections.
* names, symbol:                        Symbol Names.
* naming object file:                   Invoking.
* new page, in listings:                Eject.
* newline (\n):                         Strings.
* newline, required at file end:        Statements.
* null-terminated strings:              Asciz.
* number constants:                     Numbers.
* numbered subsections:                 Sub-Sections.
* numbers, 16-bit:                      hword.
* numeric values:                       Expressions.
* object file:                          Object.
* object file format:                   Object Formats.
* object file name:                     Invoking.
* obsolescent directives:               Deprecated.
* octal character code (\DDD):          Strings.
* octal integers:                       Integers.
* opcode summary, H8/300:               H8/300 Opcodes.
* operands in expressions:              Arguments.
* operator precedence:                  Infix Ops.
* operators, in expressions:            Operators.
* operators, permitted arguments:       Infix Ops.
* option summary:                       Overview.
* options, all versions of as:          Invoking.
* options, command line:                Command Line.
* options, H8/300 (none):               H8/300 Options.
* output file:                          Object.
* padding the location counter:         Align.
* page, in listings:                    Eject.
* paper size, for listings:             Psize.
* pass1 (internal section):             as Sections.
* paths for .include:                   Invoking.
* patterns, writing in memory:          Fill.
* plus, permitted arguments:            Infix Ops.
* precedence of operators:              Infix Ops.
* precision, floating point:            Flonums.
* prefix operators:                     Prefix Ops.
* preprocessing:                        Pre-processing.
* preprocessing, turning on and off:    Pre-processing.
* primary attributes, COFF symbols:     COFF Symbols.
* pseudo-ops, machine independent:      Pseudo Ops.
* registers, H8/300:                    H8/300-Regs.
* relocation:                           Sections.
* relocation example:                   ld Sections.
* search path for .include:             Invoking.
* section-relative addressing:          Secs Background.
* sections:                             Sections.
* sections in messages, internal:       as Sections.
* sections, named:                      ld Sections.
* single character constant:            Chars.
* sixteen bit integers:                 hword.
* sixteen byte integer:                 Octa.
* size suffixes, H8/300:                H8/300 Opcodes.
* source program:                       Input Files.
* standard as sections:                 Secs Background.
* standard input, as input file:        Command Line.
* statement on multiple lines:          Statements.
* statement separator character:        Statements.
* statement separator, H8/300:          H8/300-Chars.
* statements, structure of:             Statements.
* stopping the assembly:                Abort.
* string constants:                     Strings.
* string literals:                      Ascii.
* structure debugging, COFF:            Tag.
* subexpressions:                       Arguments.
* subtitles for listings:               Sbttl.
* subtraction, permitted arguments:     Infix Ops.
* summary of options:                   Overview.
* supporting files, including:          Include.
* suppressing warnings:                 Invoking.
* symbol attributes:                    Symbol Attributes.
* symbol attributes, COFF:              COFF Symbols.
* symbol names:                         Symbol Names.
* symbol names, local:                  Symbol Names.
* symbol names, temporary:              Symbol Names.
* symbol storage class (COFF):          Scl.
* symbol type:                          Symbol Type.
* symbol type, COFF:                    Type.
* symbol value:                         Symbol Value.
* symbol value, setting:                Set.
* symbol values, assigning:             Setting Symbols.
* symbol, common:                       Comm.
* symbol, making visible to linker:     Global.
* symbols:                              Symbols.
* symbols, assigning values to:         Equ.
* symbols, local common:                Lcomm.
* syntax, machine-independent:          Syntax.
* tab (\t):                             Strings.
* temporary symbol names:               Symbol Names.
* text and data sections, joining:      Invoking.
* trusted compiler:                     Invoking.
* turning preprocessing on and off:     Pre-processing.
* type of a symbol:                     Symbol Type.
* undefined section:                    ld Sections.
* value attribute, COFF:                Val.
* value of a symbol:                    Symbol Value.
* version of as:                        Invoking.
* warning messages:                     Errors.
* warnings, suppressing:                Invoking.
* whitespace:                           Whitespace.
* whitespace, removed by preprocessor:  Pre-processing.
* writing patterns in memory:           Fill.
* zero-terminated strings:              Asciz.



Tag Table:
Node: Top1114
Node: Overview1700
Node: Manual3074
Node: GNU Assembler4032
Node: Object Formats4802
Node: Command Line5317
Node: Input Files6398
Node: Object8302
Node: Errors9106
Node: Invoking10301
Node: Syntax15155
Node: Pre-processing15600
Node: Whitespace16663
Node: Comments17051
Node: Symbol Intro18483
Node: Statements19046
Node: Constants20768
Node: Characters21358
Node: Strings21810
Node: Chars23831
Node: Numbers24590
Node: Integers25065
Node: Bignums25705
Node: Flonums26045
Node: Sections27319
Node: Secs Background27603
Node: ld Sections31942
Node: as Sections33947
Node: Sub-Sections36559
Node: bss39448
Node: Symbols40028
Node: Labels40598
Node: Setting Symbols41020
Node: Symbol Names41384
Node: Dot44040
Node: Symbol Attributes44481
Node: Symbol Value45048
Node: Symbol Type46079
Node: COFF Symbols46454
Node: Expressions47058
Node: Empty Exprs47358
Node: Integer Exprs47700
Node: Arguments48024
Node: Operators49118
Node: Prefix Ops49441
Node: Infix Ops49757
Node: Pseudo Ops51549
Node: Abort53558
Node: coff-ABORT53961
Node: Align54145
Node: App-File54844
Node: Ascii55380
Node: Asciz55682
Node: Byte55917
Node: Comm56145
Node: Data56699
Node: Def57006
Node: Dim57227
Node: Double57473
Node: Eject57768
Node: Else57933
Node: Endef58219
Node: Endif58385
Node: Equ58634
Node: Extern58868
Node: File59117
Node: Fill59627
Node: Float60579
Node: Global60880
Node: hword61419
Node: Ident61678
Node: If61974
Node: Include62825
Node: Int63362
Node: Lcomm63737
Node: Lflags64208
Node: Line64392
Node: Ln64899
Node: List65297
Node: Long65891
Node: Nolist66059
Node: Octa66473
Node: Org66797
Node: Psize68082
Node: Quad68757
Node: Sbttl69195
Node: Scl69550
Node: Section69881
Node: Set70289
Node: Short71010
Node: Single71184
Node: Size71487
Node: Space71738
Node: Tag72018
Node: Text72387
Node: Title72697
Node: Type73066
Node: Val73297
Node: Word73529
Node: Deprecated73784
Node: H8/300-Dependent74014
Node: H8/300 Options74333
Node: H8/300 Syntax74511
Node: H8/300-Chars74767
Node: H8/300-Regs75048
Node: H8/300-Addressing75767
Node: H8/300 Floating Point76878
Node: H8/300 Directives77080
Node: H8/300 Opcodes77395
Node: Copying82547
Node: Index101694

End Tag Table
