#
# $RCSfile: genComposeFiles.awk,v $
#
# x-kernel v3.2
#
# Copyright (c) 1993,1991,1990  Arizona Board of Regents
#
# $Revision: 1.2 $
# $Date: 1993/11/11 21:53:25 $
#

#
# list[i] contains strings naming collections of files or libraries.
# This name is taken from the second part of the filename and is
# usually a protocol name.  Indexed from 0 to numLists.
#
# fileList[str] is an associative map from the strings naming the
# collections to strings describing the files in the collection.
# Similarly, libList[str] maps collection names to the libraries
# associated with that collection.


BEGIN { FS = "/" }

TOP_LEV_DIR == "protocols" || $1 == "api" || $1 == "drivers" {
	if ( TOP_LEV_DIR == "protocols" ) {
		dir = $1
	} else {
		dir = $2
	}
	if ( fileList[dir] == "" ) {
		list[numLists++] = dir
	}
	if ( $NF == "LIBRARY" ) {
		libList[dir] = libList[dir] "$(" $(NF-1) ") "
	} else {
		fileList[dir] = fileList[dir] TOP_LEV_DIR "/" $0 " \\\n"
	}
	next
}

#
# Default
#
{
	defFiles = defFiles TOP_LEV_DIR "/" $0 " \\\n"
}

END {
	print "#"
	print "# Caution -- this file is automatically generated and overwritten"
	print "#"
	print ""
	for ( i=0; i < numLists; i++ ) {
		print ""
		printf("%s_FILES := \\\n", list[i]);
		print fileList[list[i]]
		if ( libList[list[i]] != "" ) {
			printf("%s_LIBS := ", list[i]);
			print libList[list[i]];
			print "\n"
		}
	}
	print ""
	print "STD_OBJ := \\"
	printf defFiles
	print ""
}