## -*-Tcl-*- (install)
 # ###################################################################
 #  Alpha - new Tcl folder configuration
 # 
 #  FILE: "switchTo.tcl"
 #                                    created: 18/9/97 {2:52:46 pm} 
 #                                last update: 30/1/1999 {12:28:35 am} 
 #  
 # Reorganisation carried out by Vince Darley with much help from Tom 
 # Fetherston, Johan Linde and suggestions from the Alpha-D mailing list.  
 # Alpha is shareware; please register with the author using the register 
 # button in the about box.
 #  
 # Description:
 # 
 # Adds a 'Switch To' menu to Alpha's Utils menu.
 # ###################################################################
 ##

alpha::extension switchToMenu 0.1 {
    menu::buildProc switchTo menu::buildSwitchTo
    menu::insert Utils submenu end switchTo
} help {Adds a 'switch to' menu to the Utils menu}

proc menu::buildSwitchTo {} {
    global switchApps
    Menu -m -n switchTo -p menu::switchTo {"<O<I/NNow" "Add" "Remove" "(-"}
    
    if {[info exists switchApps] && [llength $switchApps]} {
	foreach app $switchApps {
	    lappend names [list [file tail $app] [file::getSig $app]]
	}
	foreach name [lsort -ignore $names] {
	    set sig [lindex $name 1]
	    if {[set p [lsearch -glob $names "* $sig"]] != -1} {
		addMenuItem -m -l "/\x1e s[icon::MenuFromSig $sig]" switchTo "[lindex $name 0]"
	    } else {
		addMenuItem -m -l "blah" switchTo "[lindex $name 0]"
	    }
	    
	}
    }
}

proc menu::switchTo {menu name} {
    global switchTo switchApps
    
    if {$name == "Add"} {
	set fname [getfile "Pick an app:"]
	lappend switchApps $fname
	addDef switchApps $switchApps
	menu::buildSwitchTo
    } elseif {$name == "Remove"} {
	foreach app $switchApps {
	    lappend apps [file tail $app]
	}
	set name [listpick -p "Remove which app?" $apps]
	if {[set ind [lsearch $switchApps "*$name"]] >= 0} {
	    set switchApps [lreplace $switchApps $ind $ind]
	    addDef switchApps $switchApps
	    menu::buildSwitchTo
	}
    } elseif {$name == "Now"} {
	switchApp
    } else {
	if {[set ind [lsearch $switchApps "*$name"]] >= 0} {
	    if {[catch {switchTo $name}]} {
		launch -f [lindex $switchApps $ind]
	    }
	}
    }
}

proc switchApp {} {
    set procs ""
    foreach p [processes] {
	lappend procs [lindex $p 0]
    }
    set to [listpick -p "Switch to app:" [lsort $procs]]
    if {[string length $to]} {
	switchTo $to
    }
}

