#!/bin/sh

if [ "$1" = "-?" ]
then
	echo "accesslog.sh: possible args:"
	echo "              <none>, '.'[0-9]  -> analyze named daily log"
	echo "              mv     Rotate daily logs - ROOT!"
	echo "              anal   CRON analysis of daily log. Mail to 'usagereports'"
	echo "              weekly CRON analysis of some weekly summaries.  Mail to 'usagereports'"
	exit
fi

if [ "$1" = "mv" ]
then
	# Run this by cron at about midnight
	cd /usr/adm
	mv -f ftpd-accesslog.8 ftpd-accesslog.9
	mv -f ftpd-accesslog.7 ftpd-accesslog.8
	mv -f ftpd-accesslog.6 ftpd-accesslog.7
	mv -f ftpd-accesslog.5 ftpd-accesslog.6
	mv -f ftpd-accesslog.4 ftpd-accesslog.5
	mv -f ftpd-accesslog.3 ftpd-accesslog.4
	mv -f ftpd-accesslog.2 ftpd-accesslog.3
	mv -f ftpd-accesslog.1 ftpd-accesslog.2
	mv -f ftpd-accesslog.0 ftpd-accesslog.1
	mv ftpd-accesslog   ftpd-accesslog.0
	exit
	# Come back 3 hours later in hope that nobody stays longer...
fi

if [ "$1" = "anal" ]
then
	# Run this by cron at about 3 AM
	cd /usr/adm
	mv -f ftpd.analysis.8 ftpd.analysis.9
	mv -f ftpd.analysis.7 ftpd.analysis.8
	mv -f ftpd.analysis.6 ftpd.analysis.7
	mv -f ftpd.analysis.5 ftpd.analysis.6
	mv -f ftpd.analysis.4 ftpd.analysis.5
	mv -f ftpd.analysis.3 ftpd.analysis.4
	mv -f ftpd.analysis.2 ftpd.analysis.3
	mv -f ftpd.analysis.1 ftpd.analysis.2
	mv -f ftpd.analysis.0 ftpd.analysis.1
	mv -f ftpd.analysis   ftpd.analysis.0
	( echo "From: Accesslog analyzer <postmaster>"
	  echo " "
	  echo " Analysis statistics of FTPD usage of NIC.FUNET.FI"
	  echo "             Run date: "`date` 
	  echo "      Data collected during previous day."
	  echo ) > ftpd.analysis
	/usr/adm/accessanal.perl < /usr/adm/ftpd-accesslog.0 | sort >> ftpd.analysis
	TMP=/usr/tmp/ftpd.anal$$
	TMP2=/usr/tmp/ftpd.ana2$$
	head -16 ftpd.analysis > $TMP
	egrep '^.Store' ftpd.analysis > $TMP2
	cat $TMP2 >> $TMP
	( echo "Subject: Short FTPD Usage stats with uploads"
	  echo "To: Usage reports <usagereports>"
	  cat $TMP ) | /lib/sendmail -f postmaster usagereports
	( echo "From: Accesslog analyzer <postmaster>"
	  echo "Subject: Past day uploads"
	  echo "To: Upload reports <uploadreports>"
	  echo " "
	  cat $TMP2 ) | /lib/sendmail -f postmaster uploadreport
	rm -f $TMP
	rm -f $TMP2
	( echo "To: Usage statistics list <usagestat>"
	  echo "Subject: Long FTPD usage stats"
	  cat ftpd.analysis ) | /lib/sendmail -f postmaster usagestat
	( echo "To: Usage reports <usagereports>"
	  echo "From: Accesslog analyzer <postmaster>"
	  echo "Subject: FTPD usage (area) analysis"
	  echo
	  /usr/adm/access-usage-anal.perl <ftpd.analysis ) | \
		/lib/sendmail -f postmaster usagereports
	/usr/adm/access-anal.top-domains < ftpd.analysis >$TMP
	( echo "To: Usage reports <usagereports>"
	  echo "From: Accesslog analyzer <postmaster>"
	  echo "Subject: FTPD user (top domain) analysis"
	  echo
	  head -16 $TMP ) | /lib/sendmail -f postmaster usagereports
	rm -f $TMP
	exit
fi
if [ "$1" = "weekly" ]
then
	# Run this by cron at about 5 AM  ONCE IN A WEEK
	cd /usr/adm
	TMP=/usr/tmp/ftpd.anal$$
	TMP2=/usr/tmp/ftpd.ana2$$
	cat ftpd.analysis ftpd.analysis.[012345] | \
	    /usr/adm/access-anal.top-domains >$TMP
	( echo "To: Weekly usage reports <weekly-usage>"
	  echo "From: Accesslog analyzer <postmaster>"
	  echo "Subject: Weekly FTPD user (top domain) analysis"
	  echo
	  head -30 $TMP ) | /lib/sendmail -f postmaster weekly-usage
	rm -f $TMP
	exit
fi

/usr/adm/accessanal.perl < /usr/adm/ftpd-accesslog$1 | sort
