#!/usr/local/bin/perl

$search_area = "X11";

$lines = 0;
$total_counter = 0;
$total_size = 0;

while (<>) {
	next if (! /^\//);

	($file, $size, $status, $site, $user) = split;
	$file =~ s/^\/\.//;
	$file =~ s/\/\//\//g;
#	$file =~ s/^\/disk1//;
	$file =~ s/^\/disk./\/pub/;
	$file =~ s/^\/pub\/4.3bsd-tahoe/\/pub\/unix\/4.3bsd-tahoe/;
	$site =~ s/[,']//g;
	$user =~ s/[,']//g;

#	print $file . " - " . $user . "@" . $site . "\n";

#	Statistics about /pub/dir directories

	if ($file =~ /^\/pub/) {
		@filepath = split(/\//, $file);
		if ($search_area eq "") {
#			print "pub = $filepath[2], size = $size\n";
			$pub_counter{$filepath[2]}++;
			$pub_size{$filepath[2]}+=$size;
#			$pub_files{$filepath[2]}=$pub_files{$filepath[2]} . " " . $file;
		} 
		if ($filepath[2] eq $search_area) {
			($temp, $pub, $area, @filepath) = split(/\//, $file);
			$filename = join('/', @filepath);
			$filename = $filepath[0];
			$pub_filestatistics{$filename}++;
		}
	} else {
		$other_counter++;
		$other_size+=$size;
#		$other_files=$other_files . " " . $file;
	}
	
	$lines++;
	$total_counter ++;
	$total_size += $size;

#	if (($lines % 100) == 0) { print "$lines\r"; }
}

if ($search_area eq "") {
	foreach $pub (keys %pub_counter) {
		$counter_percentage = $size_percentage = 0;

		if ($pub_counter{$pub} > 0) {
			$counter_percentage = ($pub_counter{$pub} * 100) / $total_counter;
		}
		if ($pub_size{$pub} > 0) {
			$size_percentage = ($pub_size{$pub} * 100) / $total_size;
		}

		printf("%-15s: %d requests (%d %%), %d kbytes (%d %%)\n", "/pub/$pub", $pub_counter{$pub}, $counter_percentage, $pub_size{$pub}/1024, $size_percentage);
	}

	$counter_percentage = $size_percentage = 0;

	if ($other_counter > 0) {
		$counter_percentage = ($other_counter * 100) / $total_counter;
	}
	if ($other_size > 0) {
		$size_percentage = ($other_size * 100) / $total_size;
	}

	printf("Others         : %d requests, (%d %%), %d kbytes (%d %%)\n\n", $other_counter, $counter_percentage, $other_size/1024, $size_percentage);
	
	printf("Total          : %d requests, %d kbytes\n", $total_counter, $total_size/1024);
} else {

	foreach $file (keys %pub_filestatistics) {
		printf ("%-60s %d\n", $file, $pub_filestatistics{$file});
	}
}

