/*
 * names and info for general-midi instruments
 * "solo" flags voices which should be cut off when the next
 *   note on the same track starts
 * "newv" and "transpose" have Kawai-K1 idiosyncratic data:
 *   "newv" is -1 when this timbre is not available, otherwise it has
 *      the general-midi number of the timbre which should actually be used;
 *   "transpose" has the number of semi-tones to shift up (neg. if down).
 */
struct sub_type{
	char *vname;
	char solo;
	char newv;
	char transpose;
} sub_voice[] = {
	"Acoustic Grand Piano",	0, 0,  0,
	"Bright Acoustic Grand",0, 1,  0,
	"Electric Grand Piano",	0, 2,  0,
	"Honky-tonk Piano",	0, 3,  0,
	"Rhodes Piano",		0, 4,  0,
	"Chorused Piano",	0, 2,  0,
	"Harpsichord",		0, 6,  0,
	"Clavinet",		0, 7,  0,
	"Celesta",		0, 8,  0,
	"Glockenspiel",		0, 9,  0,
	"Musicbox",		0, 10,  0,
	"Vibraphone",		0, 11,  0,
	"Marimba",		0, 12,  0,
	"Xylophone",		0, 13,  0,
	"Tubular Bells",	0, 14,  0,
	"Dulcimer",		0, 15,  0,
	"Hammond Organ",	0, 16,  0,
	"Percussive Organ",	0, 17,  0,
	"Rock Organ",		0, 18,  0,
	"Church Organ",		0, 19,  0,
	"Reed Organ",		0, 20,  0,
	"Accordion",		1, 21,  0,
	"Harmonica",		1, 22,  0,
	"Tango Accordion",	1, 23,  0,
	"Acoustic Guitar1",	0, 24,  0,
	"Acoustic Guitar2",	0, 25,  0,
	"Electric Guitar1",	1, 28,  0,
	"Electric Guitar2",	1, 28,  0,
	"Electric Guitar3",	1, 28,  0,
	"Overdrive Guitar",	1, 29,  0,
	"Distorton Guitar",	1, 28,  0,
	"Guitar Harmonics",	1, 28,  0,
	"Acoustic Bass",	1, 32,  0,
	"Electric Bass1",	1, 33,  0,
	"Electric Bass2",	1, 34,  0,
	"Fretless Bass",	1, 35,  0,
	"Slap Bass1",		1, 36,  0,
	"Slap Bass2",		1, 36,  0, /* above */
	"Synth Bass1",		1, 38,  0,
	"Synth Bass2",		1, 39,  0,
	"Violin",		1, 48, 12,
	"Viola",		1, 42, 12,
	"Cello",		1, 42,  0,
	"Contrabass",		1, 42,-12,
	"Tremolo Strings",	1, 48,  0, /* below */
	"Pizzicato String",	1, 45,  0,
	"Orchestral Harp",	0, 46,  0,
	"Timpani",		1, 47,  0,
	"String Ensemble1",	1, 48,  0,
	"String Ensemble2",	1, 49,  0,
	"Synth Strings1",	1, 50,  0,
	"Synth Strings2",	1, -1,  0,
	"Choir Aahs",		0, 52,  0,
	"Voice Oohs",		1, 53,  0,
	"Synth Voice",		1, 53,  0, /* above */
	"Orchestra Hit",	0, -1,  0,
	"Trumpet",		1, 56,  0,
	"Trombone",		1, 56,-12,
	"Tuba",			1, 56,-24,
	"Muted Trumpet",	1, 56,  0, /* above */
	"French Horn",		1, 60,  0,
	"Brass Section",	1, -1,  0,
	"Synth Brass1",		1, -1,  0,
	"Synth Brass2",		1, -1,  0,
	"Soprano Sax",		1, 57, 24,
	"Alto Sax",		1, 57, 12,
	"Tenor Sax",		1, 57,  0,
	"Baritone Sax",		1, 57,-12,
	"Oboe",			1, 58,  0,
	"English Horn",		1, 58,-12,
	"Bassoon",		1, 58,-24,
	"Clarinet",		1, 59,  0,
	"Piccolo",		1, 61, 12,
	"Flute",		1, 61,  0,
	"Recorder",		1, -1,  0,
	"Pan Flute",		1, 62,  0,
	"Bottle Blow",		1, 63,  0,
	"Shakuhachi",		1, -1,  0,
	"Whistle",		1, -1,  0,
	"Ocarina",		1, -1,  0,
	"Lead1 squareea",	1, -1,  0,
	"Lead2 sawtooth",	1, -1,  0,
	"Lead3 caliope",	1, -1,  0,
	"Lead4 chiff",		1, -1,  0,
	"Lead5 charang",	1, -1,  0,
	"Lead6 voice",		1, -1,  0,
	"Lead7 fifths",		1, -1,  0,
	"Lead8 brass",		1, -1,  0,
	"Pad1 newage",		1, -1,  0,
	"Pad2 warm",		1, -1,  0,
	"Pad3 polysynth",	1, -1,  0,
	"Pad4 choir Pad",	1, -1,  0,
	"Pad5 bowed Pad",	1, -1,  0,
	"Pad6 metallic",	1, -1,  0,
	"Pad7 halo",		1, -1,  0,
	"Pad8 sweep",		1, -1,  0,
	"FX1 rain",		1, -1,  0,
	"FX2 soundtrack",	1, -1,  0,
	"FX3 crystal",		1, -1,  0,
	"FX4 atmosphere",	1, 40,  0, /* "Breathe" */
	"FX5 brightness",	1, -1,  0,
	"FX6 goblins",		1, -1,  0,
	"FX7 echoes",		1, -1,  0,
	"FX8 sci-fi",		1, -1,  0,
	"Sitar",		0, 55,  0,
	"Banjo",		0,  5,  0,
	"Shamisen",		0, 44,  0,
	"Koto",			0, 54,  0,
	"Kalimba",		0, 51,  0,
	"Bagpipe",		1, 19, 12,
	"Fiddle",		0, -1,  0,
	"Shanai",		0, 37,  0, /* Gamelon?? */
	"Tinkle Bell",		1, -1,  0,
	"Agogo Bells",		1, 31,  0, /* bottles?? */
	"Steel Drums",		1, 43,  0,
	"Woodblock",		1, 30,  0,
	"Taiko Drum",		1, -1,  0,
	"Melodic Tom",		1, 26,  0,
	"Synth Drum",		1, -1,  0,
	"Reverse Cymbal",	1, -1,  0,
	"Guitar Fret Noise",	1, -1,  0,
	"Breath Noise",		1, 40,  0,
	"Seashore",		1, -1,  0,
	"Bird Tweet",		1, -1,  0,
	"Telephone Ring",	1, -1,  0,
	"Helicopter Blade",	1, -1,  0,
	"Applause/Noise",	1, -1,  0,
	"Gunshot",		1, -1,  0
};
