/* more button pushing routines for the dx7 */
#include <libdx7.h>

dx7MemProtect(midi,channel,yesno,internal)
/*
** Turn cs{MEMORY PROTECT} in the dx7 on or off ('yesno? on : off');
** use 'internal=0' for cs{INTERNAL}, 'internal!=0' for cs{CARTRIDGE}.
** For instance, to turn internal memory protection `off`, do:
** .Cs
** dx7MemProtect(midi,channel,0,0);
** .Ce
*/
{
	int mem = internal? DX7mem_protect_cartridge:DX7mem_protect_internal;
	dx7ShiftPush(midi,channel,mem,dx7yes(yesno));
}

dx7MemSelect(midi,channel,internal)
/*
** Select dx7 internal (0) or cartridge (1) memory.
*/
{
	int but = internal? DX7mem_select_cartridge:DX7mem_select_internal;
	dx7Push(midi,channel,but);
}

dx7StoreVoice(midi,channel,where,internal)
/*
** Press cs{STORE+where} to save a loaded voice in internal or cartridge memory.
** Attempts to turn memory protection off first.
** Use 'internal=0' for cs{INTERNAL}, 'internal!=0' for cs{CARTRIDGE}.
*/
{
	int mem = internal? DX7mem_protect_cartridge:DX7mem_protect_internal;
	dx7MemProtect(midi,channel,0,internal);
	dx7MemSelect(midi,channel,internal);
	dx7ShiftPush(midi,channel,DX7store,where);
}
