#! /bin/sh
# expects style files to be just two bars repeated
# expects fills files to be 1 bar - 1 bar - 1 bar - 2 bars
# analyzes channels 12-15 and removes the others
if [ "$2" = "" -o "$3" != "" ]; then
	echo "Usage: $0 file-type style-num"
	echo "specially recognized file types are: style & fills"
	exit 2
fi
TYPE=$1
STYLE=$2
just -q96 -t2 <$TYPE$STYLE | chmap 12-15=12-15 >x1
txput -c15 -vedit=/u/psl/MIDI/lib/DX7/V.FUNK_BASS
grep "^$STYLE" styles
echo -n "Copy files over from yquem? "; read junk
if [ "$junk" = "y" ]; then
	COPY="rcp yquem:/tmp/$TYPE$STYLE.m ."
	echo "After the Ready prompt '$COPY' will be executed"
else
	COPY=""
	echo "Okay; no files will be copied from yquem."
fi
if [ "$TYPE" = "style" ]; then
	LIST="-f0~-l2"
	bars -f0 -l2 <x1 | play&
elif [ "$TYPE" = "fills" ]; then
	LIST="-f0~-l1 -f1~-l2 -f2~-l3 -f3~-l5"
	bars -f0 -l5 <x1 | play&
else
	LIST="-f0"
	play x1&
fi
for ARGS in $LIST; do
	ARGS=`echo $ARGS | tr "~" " "`
	bars -c $ARGS <x1 >x
	echo "$TYPE$STYLE $ARGS in x; current channel in xx; awk output in xxx"
	for i in 12 13 14 15; do
		chmap $i=$i <x >x2
		da -T x2 | awk -f m.awk | sort >x3
		echo -n "Ready for Chan $i? "; read junk
		if [ "$junk" = "break" ]; then break; fi
		mv x2 xx
		mv x3 xxx
		more xxx
	done
	echo -n "Ready? "; read junk
	if [ "$junk" = "continue" ]; then continue; fi
	$COPY
	mpp -s0-9 <$TYPE$STYLE.m | m2mpu | bars $ARGS >z
	play z "|mpuclean <x"
done
if [ "$TYPE" = "fills" ]; then
	echo "The whole thing"
	mpp -s0-9 <$TYPE$STYLE.m | m2mpu >z
	play z x1
fi

