#include "cs.h"                                       /*  SNDINFO.C  */
#include "soundio.h"

sndinfo(argc,argv)
     int argc;
     char **argv;
{
        char	*infilnam;
        int 	infd, openin();
	SOUNDIN *p;         /* space allocated here */
	HEADATA *hdr, *readheader();
extern  char    *retfilnam;

	sssfinit();

	while (--argc) {
	    infilnam = *++argv;
	    if ((infd = openin(infilnam)) < 0) {
	        printf("%s:\n\tcouldn't find\n", retfilnam);
		continue;
	    }
	    p = (SOUNDIN *) mcalloc((long)sizeof(SOUNDIN));
	    if ((hdr = readheader(infd, infilnam, p)) != NULL
	      && !hdr->readlong) {
	        long sframes = hdr->audsize / hdr->sampsize / hdr->nchnls;
		if (hdr->filetyp == TYP_AIFF) {
		    register AIFFDAT *adp;
		    printf("\tAIFF soundfile");
		    if ((adp = hdr->aiffdata) != NULL
		      && (adp->loopmode1 || adp->loopmode2))
		        printf(", looping with modes %d, %d",
			       adp->loopmode1, adp->loopmode2);
		    else printf(", no looping");
		    printf("\n");
		}
		else if (hdr->filetyp == TYP_WAV)
		    printf("\tWAVE soundfile\n");
		else printf("%s:\n", retfilnam);
		printf("\tsrate %ld, %s, %ld bit %s, %4.2f seconds\n",
		     hdr->sr,
		     hdr->nchnls==1 ? "monaural":hdr->nchnls==2 ? "stereo":"quad",
		     hdr->sampsize * 8, getstrformat(hdr->format),
		     (float)sframes / hdr->sr);
		printf("\theadersiz %ld, datasiz %ld (%ld sample frames)\n",
		     hdr->hdrsize, hdr->audsize, sframes);
	    }
	    else printf("%s:\n\tno recognizable soundfile header\n", retfilnam);
	    free((char *)p);
	    close(infd);
	}
	exit(0);
}



