/****************************************************************************** 
 *
 * File:        midiqueue.c
 * Version:     $Id: midiqueue.h,v 1.3 1995/07/12 02:19:29 burgaard Exp $
 *
 * Project:     MIDI/Sequencer library.
 *              Roland MIDI-401 Device driver.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *      This package is free software; you can redistribute it and/or modify it
 *      under the terms of the GNU General Public License as published by the
 *      Free Software Foundation; either version 2, or (at your option) any
 *      later version.
 *
 *      This package is distributed in the hope that it will be useful, but
 *      WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *      Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; see the file COPYING. If not, write to the Free
 *      Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************
 *
 * Compile and see ../doc/libmidifile.tex for documentation on this file.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MIDI_QUEUE_H
#define __MIDI_QUEUE_H

#include "miditypes.h"

/*** TYPEDEFS *****************************************************************/

enum MIDI_TYPE
{
  MIDI_TYP_VOICE,
  MIDI_TYP_SYSEX,
  MIDI_TYP_META
};

struct midi_event
{
  struct midi_event *prev;
  struct midi_event *next;
  enum MIDI_TYPE type;
  long time; /* not delta time! */
  word size;
  byte *data;
};
typedef struct midi_event midi_event;

struct midi_queue
{
  struct midi_event *head;
  struct midi_event *tail;
  long count;
  struct midi_event *current;
};
typedef struct midi_queue midi_queue;

/*** PROTOTYPES ***************************************************************/

/* USER DEFINED ROUTINES - MUST BE LINKED IN! */

extern midi_event *midi_event_alloc(void);
extern void midi_event_free(midi_event *event);

/* END OF USER DEFINED ROUTINES */

/* Event gets lowest position (rank) in queue if there is equal timed elements */
extern long midi_queue_put_least(midi_queue *queue, midi_event *event);
extern long midi_queue_put_least_event(midi_queue *q, byte tp, long tm, word sz, byte *dt);

/* Event gets highest position (rank) in queue if there is equal timed elements */
extern long midi_queue_put(midi_queue *queue, midi_event *event);
extern long midi_queue_put_event(midi_queue *q, byte tp, long tm, word sz, byte *dt);

extern long midi_queue_at_put(midi_queue *queue, midi_event *atevent, midi_event *event);
extern long midi_queue_at_put_event(midi_queue *q, midi_event *atevent, byte tp, long tm, word sz, byte *dt);

/* Get (detach) event with lowest time value */
extern midi_event *midi_queue_get(midi_queue *queue);

extern midi_event *midi_queue_get_highest(midi_queue *queue);

/* Remove event with lowest time value */
extern void midi_queue_remove(midi_queue *queue);

extern void midi_queue_remove_highest(midi_queue *queue);
extern void midi_queue_remove_event(midi_queue *queue, midi_event *event);

/* Peek at event with lowest time value */
extern midi_event *midi_queue_peek(midi_queue *queue);

extern midi_event *midi_queue_peek_highest(midi_queue *queue);

extern void midi_queue_swap(midi_queue *queue, midi_event *a, midi_event *b);

extern void midi_queue_reset(midi_queue *queue);
extern void midi_queue_flush(midi_queue *queue);

#endif /* __MIDI_QUEUE_H */

/*** End of File **************************************************************/
