  global ScenarioWindows
  set n [Unique]
  set win .scenario$n
  set ScenarioWindows [linsert $ScenarioWindows 0 $win]

  LinkWindow $head.scenario $win
  LinkWindow $win.head $head

# catch "destroy $win"
  toplevel $win -screen $display -borderwidth 2 -relief raised

  SetHelp $win Window

  wm title $win {Choose a City}
  wm iconname $win {Choose a City}
  wm geometry $win 415x480+440+5
  wm withdraw $win
  wm maxsize $win 2000 2000
  wm minsize $win 415 480
  wm protocol $win WM_DELETE_WINDOW "DeleteScenarioWindow $win"

  frame $win.scen\
    -borderwidth 0 -geometry 100x280

  label $win.scen.simcity\
    -bitmap "@images/simcityl.xpm"

  button $win.scen.newcity\
    -command "UIGenerateNewCity" \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scncty.xpm"

  button $win.scen.loadcity\
    -command "UILoadCity $head" \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/sclcty.xpm"

  button $win.scen.dullsville\
    -command {UILoadScenario 1} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scdull.xpm"

  button $win.scen.sanfrancisco\
    -command {UILoadScenario 2} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scsfo.xpm"

  button $win.scen.hamburg\
    -command {UILoadScenario 3} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scham.xpm"

  button $win.scen.bern\
    -command {UILoadScenario 4} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scbern.xpm"

  button $win.scen.tokyo\
    -command {UILoadScenario 5} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/sctkyo.xpm"

  button $win.scen.rio\
    -command {UILoadScenario 8} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scrio.xpm"

  button $win.scen.boston\
    -command {UILoadScenario 7} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scbos.xpm"

  button $win.scen.detroit\
    -command {UILoadScenario 6} \
    -relief flat \
    -borderwidth 0 \
    -bitmap "@images/scdet.xpm"

  message $win.scen.labeldullville\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Dullsville 1900
Boredom}

  message $win.scen.labelsanfrancisco\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {San Francisco 1906
Earthquake}

  message $win.scen.labelhamburg\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Hamburg 1944
Bombing}

  message $win.scen.labelbern\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Bern 1965
Traffic}

  message $win.scen.labeltokyo\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Tokyo 1957
Monster Attack}

  message $win.scen.labelrio\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Rio de Janeiro 2047
Coastal Flooding}

  message $win.scen.labelboston\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Boston 2010
Nuclear Meltdown}

  message $win.scen.labeldetroit\
    -aspect 1500\
    -font [Font $win Small] \
    -justify center \
    -text {Detroit 1972
Crime}

  place $win.scen.simcity -anchor n -x 205 -y 25
  place $win.scen.newcity -x 20 -y 10
  place $win.scen.loadcity -x 320 -y 10
  place $win.scen.dullsville -x 20 -y 80
  place $win.scen.sanfrancisco -x 120 -y 80
  place $win.scen.hamburg -x 220 -y 80
  place $win.scen.bern -x 320 -y 80
  place $win.scen.tokyo -x 20 -y 180
  place $win.scen.rio -x 120 -y 180
  place $win.scen.boston -x 220 -y 180
  place $win.scen.detroit -x 320 -y 180
  place $win.scen.labeldullville -anchor n -x 54 -y 140
  place $win.scen.labelsanfrancisco -anchor n -x 154 -y 140
  place $win.scen.labelhamburg -anchor n -x 254 -y 140
  place $win.scen.labelbern -anchor n -x 354 -y 140
  place $win.scen.labeltokyo -anchor n -x 54 -y 240
  place $win.scen.labelrio -anchor n -x 154 -y 240
  place $win.scen.labelboston -anchor n -x 254 -y 240
  place $win.scen.labeldetroit -anchor n -x 354 -y 240

  BindSimButton $win.scen.newcity
  BindSimButton $win.scen.loadcity
  BindSimButton $win.scen.dullsville
  BindSimButton $win.scen.sanfrancisco
  BindSimButton $win.scen.hamburg
  BindSimButton $win.scen.bern
  BindSimButton $win.scen.tokyo
  BindSimButton $win.scen.rio
  BindSimButton $win.scen.boston
  BindSimButton $win.scen.detroit

  frame $win.name \
    -borderwidth 4\
    -relief flat

  label $win.name.namelabel \
    -text {Name:} \
    -font [Font $win Text]

  entry $win.name.cityname \
    -text {}\
    -textvariable CityName \
    -insertbackground #0B0071 \
    -font [Font $win Text]
  bind $win.name.cityname <Return> "DoEnterCityName $win"
  bind $win.name.cityname <Any-Enter> {focus %W}
  LinkWindow $win.cityname $win.name.cityname

  pack append $win.name \
    $win.name.namelabel	{left frame e}\
    $win.name.cityname	{left frame e expand fillx}

  frame $win.level \
    -borderwidth 4\
    -relief flat

  label $win.level.levellabel \
    -text {Game Level:} \
    -font [Font $win Text]

  frame $win.level.radio \
    -borderwidth 0\
    -relief flat

  radiobutton $win.level.radio.easy \
    -text "Easy" -variable GameLevel -value 0 \
    -command "DoSetGameLevel 0" \
    -font [Font $win Large]

  radiobutton $win.level.radio.medium \
    -text "Medium" -variable GameLevel -value 1 \
    -command "DoSetGameLevel 1" \
    -font [Font $win Large]

  radiobutton $win.level.radio.hard \
    -text "Hard" -variable GameLevel -value 2 \
    -command "DoSetGameLevel 2" \
    -font [Font $win Large]

  pack append $win.level.radio \
    $win.level.radio.easy	{top frame e expand fillx}\
    $win.level.radio.medium	{top frame e expand fillx}\
    $win.level.radio.hard	{top frame e expand fillx}

  frame $win.level.label \
    -borderwidth 0\
    -relief flat

  label $win.level.label.easylabel \
    -text {Initial Funds: $20,000} \
    -font [Font $win Large] \
    -anchor w

  label $win.level.label.mediumlabel \
    -text {Initial Funds: $10,000} \
    -font [Font $win Large] \
    -anchor w

  label $win.level.label.hardlabel \
    -text {Initial Funds: $5,000} \
    -font [Font $win Large] \
    -anchor w

  pack append $win.level.label \
    $win.level.label.easylabel		{top frame e expand fillx} \
    $win.level.label.mediumlabel	{top frame e expand fillx} \
    $win.level.label.hardlabel		{top frame e expand fillx}

  pack append $win.level \
     $win.level.levellabel		{left frame ne} \
     $win.level.radio			{left frame ne} \
     $win.level.label			{left frame ne expand fillx}

  frame $win.buttons \
    -borderwidth 0\
    -relief flat -borderwidth 4

  button $win.buttons.last \
    -text {Previous Map}\
    -font [Font $win Large]\
    -command "PrevHistory"\
    -relief raised
  LinkWindow $win.last $win.buttons.last

  frame $win.buttons.voteframe \
    -borderwidth 0 \
    -relief raised
  LinkWindow $win.voteframe $win.buttons.voteframe

  button $win.buttons.voteframe.vote \
    -font [Font $win Large]\
    -text {    Use This Map    }\
    -command "DoVote $win UseThisMap UIUseThisMap {}"\
    -relief raised \
    -borderwidth 2
  LinkWindow $win.vote $win.buttons.voteframe.vote

  pack append $win.buttons.voteframe\
    $win.buttons.voteframe.vote	{top frame center}

  BindVotingButton $win $win.buttons.voteframe.vote UseThisMap

  button $win.buttons.next \
    -font [Font $win Large]\
    -text {Next Map}\
    -command "NextHistory"
  LinkWindow $win.next $win.buttons.next

  pack append $win.buttons\
    $win.buttons.last		{left frame e}\
    $win.buttons.next		{right frame w}\
    $win.buttons.voteframe	{top frame center}

  pack append $win\
    $win.scen		{top frame center fill}\
    $win.buttons	{top frame center fillx}\
    $win.name		{top frame center expand fill}\
    $win.level		{top frame center expand fill}\

  InitScenario $win

  update idletasks
  return $win
