/*
**                      Softwarepraktikum iMaze
**                              1993/94
**                Joerg Czeranski    Hans-Ulrich Kiel
**
** Datei: xv_ereignisse.c
**
** Kommentar:
**  Gibt bei Auftreten von Ereignissen audio-visuelle Signale aus
*/


#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>

#include "signale.h"
#include "ereignisse.h"
#include "einaus.h"
#include "xv_einaus.h"

static char sccsid[] = "@(#)xv_ereignisse.c	1.10 5/17/94";


static Window flash_window, beep_window;  /* Fenster in dem Signale
                                             ausgegeben werden sollen */


/*
** ereignisse_darstellen
**  fuehrt die Ausgabe der Signale aus
**
** Parameter:
**  ereignisse: Feld aller Ereignisse, in dem die auszugebenen gesetzt sind
*/
void ereignisse_darstellen(ereignisse)
char ereignisse[ERG_ANZ];
{
	/* Falls Spieler selbst abgeschossen wurde, wird das Fenster kurz
	   invertiert und ein Piep ausgegeben*/
	if (ereignisse[ABGESCHOSSEN_ERG])
		xv_set(flash_window,
			WIN_ALARM,
			0);

	/* Falls Spieler selbst getroffen wurde, wird ein Piep ausgegeben */
	else if (ereignisse[GETROFFEN_ERG])
		xv_set(beep_window,
			WIN_ALARM,
			0);

	/* Falls eine Aktion nicht moeglich war, wird ein Piep ausgegeben */
	else if (ereignisse[AKTION_FEHLER_ERG])
		xv_set(beep_window,
			WIN_ALARM,
			0);

	/* Falls Spieler vom Server aus dem Spiel genommen wurde, wird
	   ein Piep ausgegeben */
	else if (ereignisse[SUSPENDIERT_ERG])
		xv_set(beep_window,
			WIN_ALARM,
			0);
}


/*
** xv_ereignisse_init
**  Such nach xv-Objekten, in denen die Signale ausgegeben werden
**
** Parameter:
**  hauptframe: Fenster, von dem alle anderen Fenster abstammen
**  panel: Panel, in dem Buttons ergaenzt werden duerfen
**
** Seiteneffekte:
**  beep_window und flash_window werden gesetzt
*/
void xv_ereignisse_init(hauptframe, panel)
Frame hauptframe;
Panel panel;
{
	int i;
	Window subwindow;

	/* Pieps werden im Hauptfenster ausgeloest */
	beep_window = hauptframe;

	/* Suche nach einem Unterfenster vom Typ CANVAS */
	for (i = 1; (subwindow = xv_get(hauptframe,
		FRAME_NTH_SUBWINDOW, i)) != 0; i++)
		if ((Xv_pkg *)xv_get(subwindow, XV_TYPE) == CANVAS)
		{
			/* Das canvas_paint_window wird zum Invertieren
			   genommen */
			flash_window = canvas_paint_window(subwindow);
			return;
		}

	/* falls kein CANVAS gefunden */
	flash_window = beep_window;
}


/*
** xv_ereignisse_ende
**  Dummy-Routine fuer das Schliessen von Ausgabekanaelen etc.
*/
void xv_ereignisse_ende()
{
}
