/* C++ wrapper for assembler block copy routines */

#ifndef SPRITE_H
#define SPRITE_H

extern "C"{
	#include "btypes.h"
	#include <vga.h>
}

#include <SLList.h>
#include "animation.h"

class
Sprite : public Animation
{
private:
	void copy(const Sprite& s);
protected:
	byte *backmem, *maskmem, *blockmem;

	static byte *gmem;
	static SLList<Sprite*> vlist;

        uint32 width,height,ByteLength;
	int xp,yp,oldxp,oldyp;
	int deltax,deltay;		/* used to show size of Move */
	bool visibleflag;

	void MakeMask(byte maskcolour=0);
	void Transpaste( void );
	void CutBack( void );
public:
	Sprite();
	Sprite(const Sprite& s);
	~Sprite();
	Sprite& operator=(const Sprite& s);

	void Cut(uint32 x1, uint32 y1, uint32 xw, uint32 yw, int slot);
	void Paste(uint32 x1, uint32 y1);
	void Recut(uint32 x1, uint32 y2);
	void Update(){ Update(xp,yp); }
	void Update( int x1, int y1);
	void UpdateAll(void);
	void ReplaceAll(void);
	void PasteAll(void);
	void getAll(void);
	void hideAll(void);
	void Move( int x1, int y1){ xp=xp+x1;yp=yp+y1;}
	void Move( void){ xp=xp+deltax;yp=yp+deltay;}
	void getBack(uint32 x1, uint32 y1);
	void getBack(void){ getBack(xp,yp); }
	void fixBack( void );

	int getXp(void) const { return xp; }
	int getYp(void) const { return yp; }
	int getDeltaX(void) const { return deltax;}
	int getDeltaY(void) const { return deltay;}
	bool getVisible(void) const { return visibleflag;}
        int getHeight(void) const { return height;}
        int getWidth(void) const { return width;}

	void setSlot( int slot);
	void setVisible( bool v);
	void setDelta( int x1, int y1) { deltax=x1; deltay=y1;}
	void setPos( int x1, int y1) { xp=x1; yp=y1;}
        void setGraphMem( byte *gptr) { gmem=gptr; }

};

#endif
