/******************************************************************************
*									      *
*	(C) 1993,1994 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
**** Changelog: ***************************************************************
Sat Jan  1 19:47:06  1994
*/
/*
Vconfig allows flexible definition of configuration files and commandline
options. The allowed options are defined in an array of type vconfig_parms[]
and are evaluated by the function vconfig() which removes the options from
the commandline and sets the values for the options in the array.
First it evaluates the global configuration file located in VCONF_PREFIX,
than the local one in $HOME and last the commandline. An "--" on the command-
line prevents vconfig from evaluating everything following it.
By specifying a function of type VCONF_ERRFNCT, one can change the way errors
are processed, usually errfnct() should print the given message to stdout.

In global configuration file:

permit.local.OPTION	: permits OPTION in local config-file
forbid.local.OPTION	: forbids ...

permit.cline.OPTION	: permits OPTION on commandline
forbid.cline.OPTION	: forbids ...

Use the vconf_parm.string for OPTION, but the clstring on commandline.

*/

/* 	the following type defines where an option is allowed and if it is
	mandatory */
	
typedef enum 
	{	VCONF_LOCAL = 1,	/* in local file allowed */
		VCONF_GLOBAL = 2,	/* in global file allowed */
		VCONF_CLINE = 4,	/* on command_line allowed */
		VCONF_MANDATORY = 8,	/* is necessary */
		VCONF_PERMIT1 = 16,	/* only for errorcode, synt. err */
		VCONF_PERMIT2 = 32	/* only for errorcode, unkn. option */
	} vconf_type;

/*	the following struct defines the option
	It is used to pass this information to the vconf_parse() and
	is also used by it to store the values of the options.
*/
typedef struct
	{	char 		*string;	/* long name for config file,
						   including the dot */
		char		*clstring;	/* string for command line */
		vconf_type	type;		/* global/local/command line */
		vconf_type	set;		/* where set? */
		char 		*value;		/* for storage of value */
	} vconf_parameter;

typedef void *VCONF_ERRFNCT(char *mesg);

/******************************************************************************/

/* this variable determines where to look for the global configuration file */

extern char vconf_global_prefix[];	/* preset to:  "/usr/local/lib/" */

/******************************************************************************/

/*
**      This routine parses the files and the commandline
**      and returns 0 on success or an error code.
*/

extern
int	vconfig(char	*filename,		/* name of conffile without . */                vconf_parameter *vc_parm,       /* ptr to array of defs */
		int	*argc,			/* as usual */
		char	***argv,
		void 	*ptr);			/* function to print errormsg */
						/* or NULL to ignore */
/* returncode:
**	VCONF_LOCAL, ... etc set, if error occured, 0 on success 
*/
