/*
 *	Spider card bitmap drawing routines, modified for external use
 *      by Mike Yang, Silicon Graphics, mikey@sgi.com.
 *
 */

#include	<X11/Xlib.h>

#ifndef _ARGUMENTS
#if defined(FUNCPROTO) || defined(__STD__) || defined(__cplusplus) || defined(c_plusplus)
#define _ARGUMENTS(arglist) arglist
#else
#define _ARGUMENTS(arglist) ()
#endif
#endif

/* gfx defs */

typedef	char	Suit;
typedef	char	Rank;
typedef	char	Type;

#define	Spade	0
#define	Heart	1
#define	Diamond	2
#define	Club	3

#define	Ace	0
#define	Deuce	1
#define	Three	2
#define	Four	3
#define	Five	4
#define	Six	5
#define	Seven	6
#define	Eight	7
#define	Nine	8
#define	Ten	9
#define	Jack	10
#define	Queen	11
#define	King	12

#define	NUM_RANKS	13
#define	NUM_SUITS	4
#define	CARDS_PER_DECK	(NUM_RANKS * NUM_SUITS)

/* card info*/
#define	CARD_DELTA	30	

#define	CARD_HEIGHT	123
#define	CARD_WIDTH	79

#define	FACECARD_WIDTH	47
#define	FACECARD_HEIGHT	92

#define	RANK_WIDTH	9
#define	RANK_HEIGHT	14

#define	RANK_LOC_X	4
#define	RANK_LOC_Y	7

#define	SMALL_LOC_X	4
#define	SMALL_LOC_Y	(RANK_HEIGHT + RANK_LOC_Y + 3)

#define	MID_CARD_X	(CARD_WIDTH/2)
#define	MID_CARD_Y	(CARD_HEIGHT/2)

#define	CARD_COL1_X	(3 * CARD_WIDTH/10)
#define	CARD_COL2_X	(CARD_WIDTH/2)
#define	CARD_COL3_X	(7 * CARD_WIDTH/10)

/* 5 diff rows for the two main columns */
/* 1 and 5 are top and bottom, 3 is the middle */
/* 2 & 4 are for the 10 & 9 */
#define	CARD_ROW1_Y	(CARD_HEIGHT/5)
#define	CARD_ROW2_Y	(2 * CARD_HEIGHT/5)
#define	CARD_ROW3_Y	(CARD_HEIGHT/2)
#define	CARD_ROW4_Y	(CARD_HEIGHT - 2 * CARD_HEIGHT/5)
#define	CARD_ROW5_Y	(CARD_HEIGHT - CARD_HEIGHT/5)

/* between 1 & 3, 3 & 5 */
#define	CARD_SEVEN_Y	(7 * CARD_HEIGHT/20)
#define	CARD_EIGHT_Y	(CARD_HEIGHT - 7 * CARD_HEIGHT/20)

/* between rows 1 & 2, 4 & 5 */
#define	CARD_TEN_Y1	(3 * CARD_HEIGHT/10)
#define	CARD_TEN_Y2	(CARD_HEIGHT - 3 * CARD_HEIGHT/10)

/* card positioning */
#define	CARD_INSET_X	10
#define	CARD_INSET_Y	(CARD_HEIGHT/8)

#define STACK_SPACING	10
#define	STACK_WIDTH	(CARD_WIDTH + STACK_SPACING)

#ifdef NOTDEF
extern gfx_init _ARGUMENTS((Display *, int));
extern paint_card _ARGUMENTS((Window, int, int, Rank, Suit, int));
#else
extern gfx_init();
extern paint_card();
#endif
