#include "/sys/config.h"

/*
 * Function name:   creator_file
 * Description:     Gives the name of the creator of a file. This is a
 *                  direct function of the file_name().
 * Returns:         Name of the creator
 */
string creator_file(string str)
{
    string dom, wiz, residue;

    if (str[0] != '/')
	str = "/" + str;

    /* 
     * Domains: return the wizard name if the file is resident in
     * the directory of an active (not retired) wizard.
     * If the directory is "open" or "common", the domain is set 
     * to be the creator. Return the name of the Lord otherwize.
     */
    if (extract(str, 1, 2) == "d/") {
	if (sscanf(str, "/d/%s/%s/%s", dom, wiz, residue) == 1) {
	    sscanf(str, "/d/%s/%s", dom, residue);
	    wiz = 0;
	}

	if (wiz)
	    return wiz;
	else
	    return dom;

#if 0
	if (wiz && (wiz_domain(wiz) == dom))
	    return wiz;
	else
	    if (wiz == "open" || wiz == "common")
		return dom;
	    else
		return (string) call_other(this_object(),"domain_lord",dom);  /* Should be: domain_lord(dom) /Lars, det st}r call_other h{r f|r att typerna br}kar /Johan */
#endif
    }

    /*
     * Independent wizards: Return the name of the wizard.
     */
    if (extract(str, 1, 2) == "w/") {
	sscanf(str, "/w/%s/%s", wiz, residue);
	return wiz;
    }

    /* 
     * /secure/... return root uid.
     */
    if (sscanf(str, "/secure/%s", residue) == 1)
	return (string)MASTER_OB->get_root_uid();

    /*
     * No cloning or loading from /ftp or /open.
     */
    if (sscanf(str, "/ftp/%s", residue) || sscanf(str, "/open/%s", residue))
	return 0;

    /*
     * All else: return backbone uid.
     */
    return (string)MASTER_OB->get_bb_uid();
}
