/*
 * Return-Path: <pjd@cadillac.siemens.com>
 * Received: from cadillac.siemens.com by montebello.soest.hawaii.edu (4.1/montebello-MX-1.9)
 * 	id AA01487; Mon, 10 Aug 92 03:21:41 HST
 * Received: from kevin.siemens.com by cadillac.siemens.com (4.1/SMI-4.0)
 * 	id AA25847; Mon, 10 Aug 92 09:21:37 EDT
 * Date: Mon, 10 Aug 92 09:21:37 EDT
 * From: pjd@cadillac.siemens.com (paul j. drongowski)
 * Message-Id: <9208101321.AA25847@cadillac.siemens.com>
 * To: joe@montebello.soest.hawaii.edu
 * Status: RO
 *
 * This copy is slightly hacked by Joe Dellinger, August 1992
 * And some more... November 1992
 */

/*
 * Generate QSO
 */

/*
 * Author:  Paul J. Drongowski / N2OQT
 * Address: 1 Allen Court
 *          Plainsboro, New Jersey 08536
 * Date:    10 October 1991
 *
 * Copyright (c) 1991 Paul J. Drongowski
 */

/*
 * When run, this program generates a single QSO. The form of the
 * QSO is similar to QSO`s one would expect to hear at a code test.
 * It begins with a series of V's (commented out in this version),
 * callsigns of the receiver and
 * sender, followed by a few sentences about weather, name,
 * occupation, etc. The QSO ends with the callsigns of the receiver
 * and sender.
 *
 * All output is produced using "printf." This should make the
 * program easy to port. Output can be piped into another program
 * such as sparc-morse on the Sun or it can be redirected into
 * a file (without viewing the contents of course!)
 *
 * The program design is similar to a "random poetry generator"
 * or "mad-libs." Each QSO form is generated by its own C function,
 * such as "PutForm1." Each function calls other C functions to
 * produce the sentences in the QSO. The sentence forms are
 * selected somewhat randomly as well as any blanks to be filled.
 * Words and phrases are selected from several lists such as
 * "Transceiver," "Antenna," "Job," etc. Sometimes this scheme is
 * clever as in the formation of city names. Sometimes it is
 * stupidly simple-minded and grammatical agreement is lost.
 * By the way, the callsigns are real and were picked from
 * rec.radio.amateur.misc on USENET.
 *
 * The program was constructed in C for Sun workstations. It uses
 * the library function "drand48" in function "Roll" to produce
 * pseudo-random numbers. The library function "srand48" and "time"
 * in "main" are used to set the pseudo-random number seed.
 *
 * Known problems and caveats? Hey, it`s software! All Morse
 * training programs handle the procedural signs (e.g., AR, SK)
 * differently. The function "PutQSO" currently prints "+ @"
 * for the AR and SK at the end of the QSO. These may be ignored,
 * mapped into something else, or just plain cause your training
 * program to roll over and play dead. I don`t know. This is a
 * cheap hack.
 *
 * And speaking of cheap... The program will not generate all
 * characters and pro-signs that are found on an "official" code
 * test. This program is for practice only and should be supplemented
 * with lots of random code.
 *
 * Please note that I retain the copyright
 * to this program. You may use it for any non-commercial purposes.
 * This is roughly equivalent to "fair use."
 *
 * Always have fun!
 */


#include <sys/types.h>
#include <sys/time.h>

int NXCVR ;
char *Transceiver[] =

  {
  "Collins 75S=3",
  "Collins KWM=2",
  "Drake TR3",
  "Drake TR4",
  "Drake T=4XB",
  "Eico 753",
  "Hallicrafters SR150",
  "Hallicrafters SR160",
  "Hallicrafters SR400",
  "Hallicrafters SR500",
  "Hallicrafters SR2000",
  "Heathkit DX=660B",
  "Heathkit HG=10B",
  "Heathkit HR=10",
  "Heathkit HW12",
  "Heathkit HW22",
  "Heathkit HW32",
  "Heathkit HW12A",
  "Heathkit HW22A",
  "Heathkit HW32A",
  "Heathkit HW100",
  "Heathkit SB100",
  "Icom IC=275",
  "Icom IC=475",
  "Icom IC=575",
  "Icom IC=725",
  "Icom IC=726",
  "Icom IC=730",
  "Icom IC=735",
  "Icom IC=751",
  "Icom IC=765",
  "Icom IC=781",
  "Icom IC=1275",
  "Kenwood TS=77",
  "Kenwood TS=140",
  "Kenwood TS=440",
  "Kenwood TS=680",
  "Kenwood TS=711",
  "Kenwood TS=850",
  "Kenwood TR=450",
  "Kenwood TR=751",
  "Kenwood TR=850",
  "Kenwood TR=851",
  "National NCX3",
  "National NCX5",
  "National NCL 200",
  "Radio Shack HTX=100",
  "RS HTX=100",
  "Swan 120",
  "Swan 140",
  "Swan 180",
  "Swan 240",
  "Swan 350",
  "Ten Tec 585",
  "Ten Tec 562",
  "Ten Tec Delta",
  "Ten Tec Argonaut",
  "Ten Tec Omni",
  "Yaesu FT=101",
  "Yaesu FT=736",
  "Yaesu FT=747",
  "Yaesu FT=757",
  "Yaesu FT=767",
  "Yaesu FT=990",
  "Yaesu FT=1000",
  "Homebrew",
  0
  } ;

int NANTENNA ;
char *Antenna[] =

  {
  "beam",
  "delta loop",
  "dipole",
  "doublet zepp",
  "half wave dipole",
  "inverted V",
  "whip",
  "delta loop",
  "parasitic beam",
  "log periodic",
  "quad loop",
  "quad vertical",
  "quagi",
  "quarter wave vertical",
  "rhombic",
  "long=wire",
  "ground=plane",
  "trap doublet",
  "yagi",
  "zepp",
  "monobander",
  "tribander",
  "symmetrical delta loop",
  "3 element beam",
  "5 band vertical",
  "5 element loop",
  "10 meter dipole",
  "10 meter whip",
  "7 band beam",
  0
  } ;

int NUPFEET ;
char *UpFeet[] =

  {
  "10", "15", "20", "25", "30", "35", "40", "45",
  "50", "55", "60", "65", "70", "75", "80", "85",
  "90", "95", "100",
  0
  } ;

int NWX1 ;
char *Weather1[] =

  {
  "sunny",
  "rain",
  "freezing rain",
  "sleet",
  "snow",
  "cloudy",
  "partly cloudy",
  "partly sunny",
  "clear",
  0
  } ;

int NWX2 ;
char *Weather2[] =

  {
  "cold and windy",
  "raining",
  "snowing",
  "sunny",
  "hot",
  "windy and warm",
  "cloudy",
  "drizzling",
  "foggy",
  "wet/foggy",
  "fog/drizzle",
  "hot/muggy",
  "hot/dry",
  "cool/windy",
  "smoggy",
  "hot/smoggy",
  "cold/dry",
  "hot/humid",
  "warm",
  "windy",
  "very hot",
  "very cold",
  "very windy",
  "wet",
  "wet/windy",
  "humid",
  "hot and humid",
  0
  } ;

int NPOWER ;
char *Power[] =

  {
    "5",  "10",  "20",  "25",  "40",  "50",  "80", "100",
  "125", "140", "150", "170", "200", "250", "270", "300",
  0
  } ;

int NJOB ;
char *Job[] =

  {
  "engineer",
  "nurse",
  "fireman",
  "mechanic",
  "programmer",
  "carpenter",
  "electrician",
  "writer",
  "teacher",
  "doctor",
  "attorney",
  "lawyer",
  "clerk",
  "chemist",
  "librarian",
  "teller",
  "physician",
  "physicist",
  "chemist",
  "mathematician",
  "professor",
  "driver",
  "milkman",
  "gardener",
  "bricklayer",
  "guard",
  "dentist",
  "curator",
  "farmer",
  "stock broker",
  "letter carrier",
  "designer",
  "student",
  "college student",
  "high school student",
  "administrator",
  "police officer",
  "investment banker",
  "politician",
  "consultant",
  "systems analyst",
  "airline pilot",
  "semiotician",
  0
  } ;

int NNAME ;
char *Name[] =

  {
  "Al",
  "Alan",
  "Alice",
  "Allen",
  "Alex",
  "Alexeev",
  "Amber",
  "Anne",
  "Art",
  "Barbara",
  "Bart",
  "Betty",
  "Bea",
  "Bill",
  "Bob",
  "Bruce",
  "Bud",
  "Carl",
  "Carol",
  "Cathy",
  "Cheryl",
  "Chris",
  "Christy",
  "Chuck",
  "Dale",
  "Dave",
  "David",
  "Dennis",
  "Diane",
  "Dick",
  "Dan",
  "Don",
  "Ed",
  "Elaine",
  "Ellen",
  "Francie",
  "Fred",
  "Gary",
  "Helen",
  "Ingrid",
  "Frank",
  "George",
  "Gilda",
  "Gus",
  "Harry",
  "Henry",
  "Jack",
  "James",
  "Jane",
  "Janet",
  "Jeff",
  "Jessica",
  "Jill",
  "Jim",
  "Joan",
  "Joe",
  "John",
  "Jon",
  "Kathy",
  "Kevin",
  "Karen",
  "Karl",
  "Keith",
  "Ken",
  "Kent",
  "Kristen",
  "Kurt",
  "Larry",
  "Lauren",
  "Liholiho",
  "Linda",
  "Lou",
  "Lynda",
  "Lynn",
  "Marc",
  "Margaret",
  "Marv",
  "Maria",
  "Mark",
  "Marty",
  "Mary",
  "Mike",
  "Monica",
  "Nancy",
  "Neil",
  "Noelani",
  "Oliver",
  "Olivia",
  "Pat",
  "Patrick",
  "Paul",
  "Paula",
  "Peter",
  "Phil",
  "Ralph",
  "Ray",
  "Rex",
  "Rich",
  "Rick",
  "Roy",
  "Ron",
  "Sally",
  "Sam",
  "Scott",
  "Scottie",
  "Spencer",
  "Steve",
  "Stu",
  "Sue",
  "Terry",
  "Tim",
  "Todd",
  "Tom",
  "Tony",
  "Thomas",
  "Walt",
  "Wendy",
  "William",
  "Zelda",
  0
  } ;

int NCALLSIGN ;
char *Sender, *Receiver ;
char *CallSign[] =

  {
  "AA0ET",
  "AA4LR",
  "AA5BT",
  "AA6NP",
  "AA6YD",
  "AA9BK",
  "AB5AP",
  "AB6FI",
  "AC4HF",
  "G0GWA",
  "GM4ZNX",
  "KA0WCH",
  "KA1AXY",
  "KA1CV",
  "KA1UTU",
  "KA1ZGC",
  "KA6S",
  "KA2RAF",
  "KB0CY",
  "KB2NRH",
  "KB6CSP",
  "KB6JXT",
  "KC6SKV",
  "KC6SSS",
  "KC6TDR",
  "KC6VWV",
  "KD3FU",
  "KD4AUS",
  "KD4CPL",
  "KE2TP",
  "KE4ZV",
  "KF8NH",
  "KF6BZF",
  "KJ6NN",
  "KJ9U",
  "KK6JQ",
  "KM3T",
  "KT7H",
  "K2WK",
  "K5RC",
  "K6XO",
  "K6OCK",
  "K9ALD",
  "IK5AAX",
  "I5FLN",
  "JA1BLV",
  "N1AL",
  "N1JCX",
  "N4PBK",
  "N4VRN",
  "N5IAL",
  "N5OP",
  "N6BIS",
  "N6MWC",
  "N6TTO",
  "N8EMR",
  "N9MYI",
  "N9FZX",
  "N9JRV",
  "N9LFF",
  "NE3X",
  "NH6ZW",
  "NJ7E",
  "NR3Z",
  "NT1G",
  "OD5NG",
  "OH3BK",
  "OH8NUP",
  "TG9VT",
  "UT5RP",
  "VE6MGS",
  "VE7EMD",
  "VK2BQS",
  "VK2EG",
  "W0PBV",
  "W0RIJ",
  "W0RSB",
  "WA1UXA",
  "WA2AGE",
  "WA3EEC",
  "WA3TBL",
  "WA3UQV",
  "WA5RPF",
  "WA6DGX",
  "WA7VYJ",
  "WA8ZGO",
  "WB4JCM",
  "WB5FDP",
  "WB5FKH",
  "WB5NRN",
  "WB2CJL",
  "WB7CJO",
  "WB7EEL",
  "WB7TZA",
  "WB8EOH",
  "WB9IVR",
  "WD0EIB",
  "WX9T",
  "W2FG",
  "W2JGR",
  "W3GRG",
  "W3OTC",
  0
  } ;

int NLICENSE ;
char *License[] =

  {
  "Novice",
  "Technician",
  "Tech",
  "General",
  "Advanced",
  "Extra",
  0
  } ;

int NCITY ;
char *City[] =

  {
  "Aiea",
  "Alexander",
  "Asbury",
  "Baker",
  "Beckley",
  "Bedford",
  "Brunswick",
  "Burnsville",
  "Clarksville",
  "Cambridge",
  "Charleston",
  "Circleville",
  "Clarksburg",
  "Clear Lake",
  "Cleveland",
  "Crystal",
  "Duncanville",
  "Elizabeth",
  "Ewa",
  "Fairbanks",
  "Fairfield",
  "Flint",
  "Gahanna",
  "Grant",
  "Greensburg",
  "Harper",
  "Honolulu",
  "Hillsdale",
  "Jamestown",
  "Jefferson",
  "Kaaawa",
  "Kona",
  "Lawrenceville",
  "Lakewood",
  "Lincoln",
  "Litchfield",
  "London",
  "Long Branch",
  "Lyndhurst",
  "Lyndale",
  "Lynnville",
  "Mansfield",
  "Maple",
  "Meadows",
  "Mentor",
  "Mercer",
  "Mesquite",
  "Midland",
  "Milldale",
  "Milltown",
  "Moorestown",
  "Mountain View",
  "Murray",
  "Newfield",
  "Newport",
  "New London",
  "Olmstead",
  "Oak",
  "Oxnard",
  "Oxford",
  "Paradise",
  "Paris",
  "Perry",
  "Potter",
  "Pottsville",
  "Redwood",
  "Russellville",
  "Salem",
  "Sandy",
  "Saratoga",
  "Smithville",
  "Springdale",
  "Springfield",
  "Starkville",
  "Sunnyvale",
  "Tinker",
  "Trenton",
  "Walnut",
  "Warren",
  "Warsaw",
  "Washington",
  "Weston",
  "Wheatfield",
  "Williamson",
  "Worchester",
  "Zolton",
  0
  } ;

int NNEWCITY ;
char *NewCity[] =

  {
  "Albany",
  "Avalon",
  "Barnard",
  "Brunswick",
  "Bedford",
  "Chester",
  "Conway",
  "Dime Box",
  "Franklin",
  "Granville",
  "Hamilton",
  "Morris",
  "Oxford",
  "Salisbury",
  "Stafford",
  "Stanton",
  "Trenton",
  "Troy",
  "Walpole",
  "Warren",
  "Wilton",
  "Weston",
  "Windsor",
  "Zulch",
  0
  } ;

int NCITYHTS ;
char *CityHeights[] =

  {
  "Apple",
  "Ashford",
  "Baker",
  "Baldwin",
  "Banner",
  "Barnard",
  "Benton",
  "Carson",
  "Chester",
  "Conway",
  "Cornwall",
  "Crystal",
  "Fletcher",
  "Franklin",
  "Granite",
  "Grant",
  "Harper",
  "Jefferson",
  "Hamilton",
  "Hickory",
  "Lincoln",
  "Maple",
  "Mercer",
  "Morgan",
  "Morris",
  "Murray",
  "Oak",
  "Orwell",
  "Quail",
  "Perry",
  "Potter",
  "Salem",
  "Stafford",
  "Stone",
  "Tinker",
  "Walnut",
  "Warren",
  "Washington",
  "Weston",
  "Wilton",
  0
  } ;

int NNEW ;
char *New[] =

  {
  "New",
  "Old",
  "North",
  "South",
  "East",
  "West",
  0
  } ;

int NHEIGHTS ;
char *Heights[] =

  {
  "Castle",
  "Heights",
  "Island",
  "Valley",
  "City",
  "Creek",
  "Park",
  "Mill",
  "Neck",
  0
  } ;

int NSTATE ;
char *State[] =

  {
  "Alabama",
  "Alaska",
  "Arizona",
  "Arkansas",
  "California",
  "Colorado",
  "Connecticut",
  "Delaware",
  "Florida",
  "Gaum",
  "Georgia",
  "Hawaii",
  "Idaho",
  "Illinois",
  "Indiana",
  "Iowa",
  "Kansas",
  "Kentucky",
  "Louisiana",
  "Maine",
  "Maryland",
  "Massachusetts",
  "Michigan",
  "Midway",
  "Minnesota",
  "Mississippi",
  "Missouri",
  "Montana",
  "Nebraska",
  "Nevada",
  "New Hampshire",
  "New Jersey",
  "New Mexico",
  "New York",
  "North Carolina",
  "North Dakota",
  "Ohio",
  "Oklahoma",
  "Oregon",
  "Pennsylvania",
  "Puerto Rico",
  "Rhode Island",
  "Saipan",
  "American Samoa",
  "South Carolina",
  "South Dakota",
  "Tennessee",
  "Texas",
  "Utah",
  "Vermont",
  "Virginia",
  "Virgin Islands",
  "Wake Island",
  "Washington",
  "West Virginia",
  "Wisconsin",
  "Wyoming",
  0
  } ;

int NMISC ;
char *Miscellaneous[] =
  {
  "I sometimes work packet on vhf.",
  "I sometimes work packet on vhf.",
  "We are on vacation and I am mobile.",
  "We are on vacation and I am mobile.",
  "Your signal is chirpy.",
  "Lots of QRM.",
  "Lots of QRM.",
  "Should we QSY?",
  "Please QRS.",
  "Please QRS.",
  "Tnx for the report.",
  "Thanks for the call.",
  "Tnx for the call.",
  "Tnx for ur call.",
  "QRM",
  "QRM?",
  "QRS",
  "QRS?",
  "QSY?",
  "QSK?",
  "QRX?",
  "QTH?",
  "QTR?",
  "What is your QTH?",
  "Is it green there or brown?",
  "Where do you live?",
  "Where do you live?",
  "Where do you live now?",
  "How long have you been a radio amateur?",
  "How long have you been a radio amateur?",
  "What are your hobbies?",
  "What is your hobby?",
  "Must QRT for dinner.",
  "Must QRT for dinner.",
  "Must QRT for hot dinner.",
  "Must QRT for cold dinner.",
  "Must QRT for lunch.",
  "Must QRT for lunch.",
  "Must QRT for hot lunch.",
  "Must QRT for sleep.",
  "Must QRT for some sleep.",
  "Must QRT for bathroom break.",
  "Must QRT, lightning threatens.",
  "Must QRT, lightning storm has started.",
  "Must QRT, tornado sirens sounding.",
  "Must QRT, tsunami sirens sounding.",
  "Must QRT to hear news about approaching hurricane.",
  "Must QRT wind has blown door open again.",
  "Must QRT, weather radio warbling.",
  "Must QRT invading tanks making too much noise outside to hear you.",
  "Must QRT occupation forces knocking at door.",
  "Must QRT, nuclear attack?",
  "I am mobile and am going to the office.",
  "I am mobile and am going to work.",
  "I am mobile and driving to work.",
  "I am mobile, driving home from work.",
  "I am mobile, stuck in traffic.",
  "I am mobile, driving cross country.",
  "I am mobile, riding a Peruvian Paso horse.",
  "Ive fallen and I cant get up.",
  "How is my signal?",
  "Hows my signal?",
  "How copy so far?",
  "How copy so far?",
  "How copy?",
  "Copy?",
  "Copy?",
  "Cpy?",
  "Do you understand English?",
  "Do u understand English?",
  "Habla espanol?",
  "Sprechen Sie Deutsch?",
  "What is your job?",
  "Whats your job?",
  "Your job is?",
  "How is the weather?",
  "Hows the weather?",
  "How is the weather?",
  "So how is the weather?",
  "Are you using a linear amplifier?",
  "ru using linear amplifier?",
  "I am using a linear amplifier.",
  "am using a linear amplifier.",
  "Are you using a linear amplifier?",
  "You are using a nonlinear amplifier?",
  "Propagation is good.",
  "Propagation is good.",
  "Propagation is very good.",
  "Propagation is poor.",
  "Propagation is very poor.",
  "Are you on daylight savings time?",
  "Did you hear the news?",
  "Did you hear news?",
  "Is the bad news true?",
  "Sorry, stack of books just fell over.",
  "There is an eclipse of the moon right now.",
  "Do you recycle often?",
  "Do you prefer metric units?",
  "Aye, laddie, have you ever been to sea?",
  "Have you ever seen a computer virus?",
  "We just felt a small quake here.",
  "Whoa, we are having an earthquake here. A real roller.",
  "You are my first contact today.",
  "You are my second contact today.",
  "You are my last contact today.",
  "Are you married?",
  "Do you have a horse?",
  "Do you have a dog?",
  "Do you have a cat?",
  "Do you have a ferret?",
  "Do you have a gecko?",
  "Do you listen to the BBC?",
  "Do you listen to VOA?",
  "Do you listen to Radio Moscow?",
  "Do you listen to Radio Peace Peoples Republic of Korea?",
  "Do you listen to Radio New Zealand Intl?",
  "Do you listen to Radio Australia?",
  "Do you listen to Deutsche Welle?",
  "ewsqgbhjolpi oops cat on keyboard.",
  "9p0ojgbhnw23 oops cat on keyboard.",
  "8y67fvgb oops cat on keyboard.",
  "A clumsy gecko just fell on my hand.",
  "How old is your rig?",
  "How did you learn morse code?",
  "Do you know morse code?",
  "When did you start to learn morse code?",
  "Are you good at calculus? I have a question for you.",
  "Are you good at group theory? I have a question for you.",
  "Are you good at summing infinite series?",
  "Can you pick master locks? Those are supposed to be easy.",
  "Can you pick kryptonite locks? Those are tricky.",
  "QLF?",
  "There is a rainbow outside the window.",
  "I just saw a bolide.",
  "Do you know the word copacetic?",
  "Do you know the word garrulous?",
  "Do you know the word prosy?",
  "What time zone are you in?",
  "Have you ever been to the Chatham islands?",
  "Mele kelikimaka and hauoli makahiki hou 1994.",
  "Would you have given Morse a Nobel prize?",
  "Our neighbors have a horse named morse code.",
  "What is your elevation?",
  "What is the air pressure there?",
  "I live at 1620 Keeaumoku.",
  "I live at 1010 Springwood.",
  "I live at 61C Escondido.",
  "I live at 2500 Pennsylvania.",
  "I live at 10 Downing.",
  "I sometimes monitor ULF for earthquake precursors.",
  "Where is Parkfield, California anyway?",
  "Have you ever been to New Madrid, Missouri?",
  "Have you ever contacted Kalawao county, Molokai?",
  "Is your the state the one that has parishes instead of counties?",
  "Is your the state the one that has townships instead of counties?",
  "+@=x/,? 73 just testing you.",
  "@w=+/,? 73 just testing you.",
  ",?/=+9@ 73 just testing you.",
  ",?/=q+@ 73 just testing u.",
  "Your contest sequence no is 826.",
  "Your contest sequence no is 479.",
  "Your contest sequence no is 1035.",
  "Your contest sequence no is 12.",
  "Your contest sequence no is 73.",
  "Your contest sequence no is 7v.",
  "What is your sign? I am a fish.",
  "What is your sign? I am a cancer.",
  "What is your sign? I am a centaur.",
  "Do you like rock music?",
  "Do you like modern rock?",
  "Do you like country music?",
  "Do you like swing music?",
  "Do you like reggae music?",
  "Do you like jawaiian music?",
  "Do you like pop music?",
  "Do you like classical music?",
  "Do you like mozart?",
  "Do you like bach?",
  "Do you like bernstein?",
  "Do you watch STTNG?",
  "Do you watch Quantum Leap?",
  "Do you watch Simpsons?",
  "Can you think of something else interesting to say?",
  0
  };

int NRST ;
char *RST[] =
  {
  "555",
  "577",
  "578",
  "579",
  "588",
  "589",
  "599",
  "478",
  "354",
  "248",
  "126",
  0
  } ;

/*
 ********************
 * Utility routines *
 ********************
 */

int CountStrings(StringVector) char *StringVector[] ;

  /*
   * Count the number of string values in the supplied vector
   * of pointers. Start with the first pointer and stop when
   * NIL (0) is encountered.
   */

  {
  register char **SV ;
  register int Count ;

  Count = 0 ;

  for (SV = StringVector ; *SV ; SV++)
    {
    Count++ ;
    }
  return(Count) ;
  }

int Roll(Number) int Number ;

  {
  double drand48() ;
  return( (int)(drand48() * (Number/*-1*/)) ) ;
  }

char *Choose(Words, Number) char *Words[] ; int Number ;

  {
  return( Words[ Roll(Number) ] ) ;
  }

/*
 *************************************
 * Routines to put sentences/clauses *
 *************************************
 */

void PutMisc()

  {
  printf("%s\n", Choose(Miscellaneous, NMISC)) ;
  }

void PutThanks()

  {
  switch(Roll(6))
    {
    case 0:
      printf("Thanks for your call.\n") ;
      break ;
    case 1:
      printf("Tnx for ur call.\n") ;
      break ;
    case 2:
      printf("Tnx for the call.\n") ;
      break ;
    case 3:
      printf("Thanks for the call.\n") ;
      break ;
    default:
      printf("Thanks %s for the call.\n", Choose(Name, NNAME)) ;
      break ;
    }
  }

void PutName()

  {
  switch (Roll(4))
    {
    case 0:
      printf("Name is %s.\n", Choose(Name, NNAME)) ;
      break ;
    case 1:
      printf("This is %s.\n", Choose(Name, NNAME)) ;
      break ;
    case 2:
      printf("%s here.\n", Choose(Name, NNAME)) ;
      break ;
    default:
      printf("My name is %s.\n", Choose(Name, NNAME)) ;
      break ;
    }
  }

void PutJob()

  {
  switch(Roll(10))
    {
    case 0:
    case 1:
      printf("Occupation is %s.\n", Choose(Job, NJOB)) ;
      break ;
    case 2:
    case 3:
      printf("My occupation is %s.\n", Choose(Job, NJOB)) ;
      break ;
    case 4:
    case 5:
      printf("I work as a %s.\n",  Choose(Job, NJOB)) ;
      break ;
    case 6:
      printf("I was a %s, now unemployed.\n",  Choose(Job, NJOB)) ;
      break ;
    default:
      printf("I am a %s.\n", Choose(Job, NJOB)) ;
      break ;
    }
  }

void PutAge()

  {
  switch(Roll(3))
    {
    case 0:
      printf("I am %d years old.\n", Roll(60)+16) ;
      break ;
    case 1:
      printf("My age is %d.\n", Roll(60)+16) ;
      break ;
    default:
      printf("Age is %d.\n", Roll(60)+16) ;
      break ;
    }
  }

void PutLicense()

  {
  switch(Roll(4))
    {
    case 0:
      printf("I have a %s class license.\n", Choose(License, NLICENSE)) ;
      break ;
    case 1:
      printf("I am a %s class ham.\n", Choose(License, NLICENSE)) ;
      break ;
    case 2:
      printf("I have been licensed %d years as %s class.\n",
        Roll(20)+1, Choose(License, NLICENSE)) ;
      break ;
    default:
      printf("I have been a %s class ham for %d years.\n",
        Choose(License, NLICENSE), Roll(20)+1) ;
      break ;
    }
  }

void PutTemperature()

  {
  printf("Temperature is %d.\n", Roll(80) + 10) ;
  }

void PutWeather1()

  {
  switch (Roll(14))
    {
    case 0:
      printf("Weather here is %s.\n", Choose(Weather1, NWX1)) ;
      PutTemperature() ;
      break ;
    case 1:
      printf("Weather is %s.\n", Choose(Weather1, NWX1)) ;
      PutTemperature() ;
      break ;
    case 2:
      printf("WX is %s.\n", Choose(Weather1, NWX1)) ;
      PutTemperature() ;
      break ;
    case 3:
      printf("Weather here is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 4:
      printf("Weather is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 5:
      printf("WX is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 6:
      PutTemperature() ;
      printf("Weather here is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 7:
      PutTemperature() ;
      printf("Weather is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 8:
      PutTemperature() ;
      printf("WX is %s.\n", Choose(Weather1, NWX1)) ;
      break ;
    case 9:
      printf("Weather here is %s and temperature is %d.\n",
        Choose(Weather1, NWX1), Roll(80)+10) ;
      break ;
    case 10:
      printf("Weather is %s, temperature %d.\n",
        Choose(Weather1, NWX1), Roll(80)+10) ;
      break ;
    case 11:
      printf("WX is %d degrees and %s.\n",
        Roll(80)+10, Choose(Weather1, NWX1));
      break ;
    case 12:
      printf("The WX is %s and the temp is %d degrees.\n",
        Choose(Weather1, NWX1), Roll(80)+10) ;
      break ;
    default:
      printf("WX is %s and %d degrees.\n",
        Choose(Weather1, NWX1), Roll(80)+10);
    }
  }

void PutWeather2()

  {
  switch(Roll(5))
    {
    case 0:
      printf("It is %s.\n", Choose(Weather2, NWX2));
      break ;
    case 1:
      printf("It is %s and %d degrees.\n",
        Choose(Weather2, NWX2), Roll(80)+10) ;
      break ;
    case 2:
      printf("The WX is %s and the temp is %d degrees.\n",
        Choose(Weather2, NWX2), Roll(80)+10) ;
      break ;
    case 3:
      printf("WX is %s and the temp is %d degrees.\n",
        Choose(Weather2, NWX2), Roll(80)+10) ;
      break ;
    default:
      printf("It is %s here.\n", Choose(Weather2, NWX2));
      break ;
    }
  }

void PutWeather()

  {
  switch (Roll(2))
    {
    case 0:
      PutWeather1() ;
      break ;
    default:
      PutWeather2() ;
      break ;
    }
  }

void PutCityState()

  {
  switch(Roll(4))
    {
    case 0:
      printf("%s %s, ", Choose(New, NNEW), Choose(NewCity, NNEWCITY)) ;
      break ;
    case 1:
      printf("%s %s, ",
        Choose(CityHeights, NCITYHTS), Choose(Heights,NHEIGHTS)) ;
      break ;
    default:
      printf("%s, ", Choose(City, NCITY)) ;
      break ;
    }
  printf("%s.\n", Choose(State, NSTATE)) ;
  }

void PutLocation()

  {
  switch(Roll(3))
    {
    case 0:
      printf("My location is ");
      break ;
    case 1:
      printf("My QTH is ") ;
      break ;
    default:
      printf("QTH is ") ;
      break ;
    }
  PutCityState() ;
  }

void PutRig()

  {
  switch(Roll(5))
    {
    case 0:
      printf("My rig runs %s watts into a %s up %s feet.\n",
        Choose(Power, NPOWER), Choose(Antenna, NANTENNA),
        Choose(UpFeet, NUPFEET)) ;
      break ;
    case 1:
      printf("Rig is a %s watt %s and antenna is a %s.\n",
        Choose(Power, NPOWER), Choose(Transceiver, NXCVR),
        Choose(Antenna, NANTENNA)) ;
      break ;
    case 2:
      printf("My transceiver is a %s.\n", Choose(Transceiver, NXCVR)) ;
      printf("It runs %s watts into a %s.\n",
        Choose(Power, NPOWER), Choose(Antenna, NANTENNA)) ;
      break ;
    case 3:
      printf("The rig is a %s running %s watts.\n",
        Choose(Transceiver, NXCVR), Choose(Power, NPOWER)) ;
      printf("Antenna is a %s up %s feet.\n",
        Choose(Antenna, NANTENNA), Choose(UpFeet, NUPFEET)) ;
      break ;
    default:
      printf("Rig is a %s running %s watts into a %s up %s feet.\n",
        Choose(Transceiver, NXCVR), Choose(Power, NPOWER),
        Choose(Antenna, NANTENNA), Choose(UpFeet, NUPFEET)) ;
      break ;
    }
  }

void PutRST()

  {
  register char *TheRST ;

  TheRST = Choose(RST, NRST) ;

  switch(Roll(8))
    {
    case 0:
      printf("UR RST %s %s.\n", TheRST, TheRST) ;
      break ;
    case 1:
      printf("RST is %s %s.\n", TheRST, TheRST) ;
      break ;
    case 2:
      printf("RST %s%s.\n", TheRST, TheRST) ;
      break ;
    case 3:
      printf("Your RST %s %s.\n", TheRST, TheRST) ;
      break ;
    case 4:
      printf("Your RST is %s=%s.\n", TheRST, TheRST) ;
      break ;
    case 5:
      printf("Your signal is RST %s/%s.\n", TheRST, TheRST) ;
      break ;
    case 6:
      printf("UR signal is RST %s,%s.\n", TheRST, TheRST) ;
      break ;
    default:
      printf("Your RST is %s=%s.\n", TheRST, TheRST) ;
      break ;
    }
  }

void PutFirstCallsign()

  {
  Sender = Choose(CallSign, NCALLSIGN) ;
  Receiver = Choose(CallSign, NCALLSIGN) ;
  printf("%s de %s\n", Receiver, Sender) ;
  }

void PutLastCallsign()

  {
  printf("%s de %s\n", Receiver, Sender) ;
  }

void PutForm0()

  {
  PutRST() ;
  PutName() ;
  PutLocation() ;
  PutMisc() ;
  PutRig() ;
  PutWeather() ;
  PutJob() ;
  PutAge() ;
  PutMisc() ;
  PutLicense() ;
  }

void PutForm1()

  {
  PutLocation() ;
  PutRST() ;
  PutRig() ;
  PutWeather() ;
  PutMisc() ;
  PutName() ;
  PutLicense() ;
  PutMisc() ;
  PutAge() ;
  PutJob() ;
  }

void PutForm2()

  {
  PutThanks() ;
  PutRST() ;
  PutName() ;
  PutWeather() ;
  PutLocation() ;
  PutJob() ;
  PutLicense() ;
  PutRig() ;
  PutAge() ;
  }

void PutForm3()

  {
  PutLocation() ;
  PutRST() ;
  PutRig() ;
  PutMisc() ;
  PutName() ;
  PutMisc() ;
  PutAge() ;
  PutJob() ;
  PutLicense() ;
  PutMisc() ;
  PutWeather() ;
  PutMisc() ;
  }

void PutForm4()

  {
  PutThanks() ;
  PutRST() ;
  PutJob() ;
  PutMisc() ;
  PutMisc() ;
  PutName() ;
  PutAge() ;
  PutLicense() ;
  PutRig() ;
  PutLocation() ;
  PutWeather() ;
  PutMisc() ;
  }

void PutForm5()

  {
  PutLocation() ;
  PutRST() ;
  PutRig() ;
  PutName() ;
  PutJob() ;
  PutAge() ;
  PutMisc() ;
  PutLicense() ;
  PutWeather() ;
  PutMisc() ;
  }

PutQSO()

  {
/*  printf("VVV VVV\n") ; */
  PutFirstCallsign() ;
  switch(Roll(6))
    {
    case 0:  PutForm0() ; break ;
    case 1:  PutForm1() ; break ;
    case 2:  PutForm2() ; break ;
    case 3:  PutForm3() ; break ;
    case 4:  PutForm4() ; break ;
    default: PutForm5() ; break ;
    }
  printf("+ @\n") ;
  PutLastCallsign() ;
  printf("\n") ;
  }

main()

  {
  int i ;

  NXCVR     = CountStrings(Transceiver) ;
  NANTENNA  = CountStrings(Antenna) ;
  NUPFEET   = CountStrings(UpFeet) ;
  NPOWER    = CountStrings(Power) ;
  NRST      = CountStrings(RST) ;
  NWX1      = CountStrings(Weather1) ;
  NWX2      = CountStrings(Weather2) ;
  NJOB      = CountStrings(Job) ;
  NNAME     = CountStrings(Name) ;
  NSTATE    = CountStrings(State) ;
  NCITY     = CountStrings(City) ;
  NCITYHTS  = CountStrings(CityHeights) ;
  NNEW      = CountStrings(New) ;
  NHEIGHTS  = CountStrings(Heights) ;
  NNEWCITY  = CountStrings(NewCity) ;
  NLICENSE  = CountStrings(License) ;
  NMISC     = CountStrings(Miscellaneous) ;
  NCALLSIGN = CountStrings(CallSign) ;

  srand48((long) time(0)) ;

  PutQSO() ;
  }
