#include <stdio.h>
#include <fcntl.h>
#include "options.h"
#include "misc.h"
#include "var.h"
#include "ship.h"

struct shpstr all[MAX_SHIPS];

main()
{
    FILE    *fp, *fopen();
    int     shpf, x, numships;
    struct shpstr *sp;
    char    buf[80], *sprintf();

    if ((fp=fopen("ship.ascii", "w")) == (FILE *)0){
        fprintf(stderr,"Cannot write ship.ascii!\n");
        exit(-1);
    }

    shpf = open(sprintf(buf,"%s/ship",DATADIR), O_RDONLY, 0);

    if (shpf == -1){
        fprintf(stderr,"Cannot read %s/ship\n",DATADIR);
        exit(-1);
    }

    numships = (read(shpf, all, sizeof(all)))/sizeof(struct shpstr);
    close(shpf);

    fprintf(fp,"%d\n",numships);

    sp = all;
    for(x=0;x<numships;x++,sp++)
        write_shp(sp, fp);

    fclose(fp);
}

write_shp(sp, fp)
struct shpstr *sp;
FILE *fp;
{
    int x, y, relate, reject, shift;

    fprintf(fp,"%d ",sp->shp_x);
    fprintf(fp,"%d ",sp->shp_y);
    fprintf(fp,"%d ",sp->shp_own);
    fprintf(fp,"%d ",sp->shp_type);
    fprintf(fp,"%d ",sp->shp_effic);
    fprintf(fp,"%d ",sp->shp_mobil);
    fprintf(fp,"%d ",sp->shp_sell);
    fprintf(fp,"%d ",sp->shp_tech);
    fprintf(fp,"%d ",sp->shp_uid);
    fprintf(fp,"%d ",sp->shp_fleet);
    fprintf(fp,"%d ",sp->shp_nplane);
#ifdef AUTONAV
    fprintf(fp,"%d ",sp->shp_destx[0]);
    fprintf(fp,"%d ",sp->shp_destx[1]);
    fprintf(fp,"%d ",sp->shp_desty[0]);
    fprintf(fp,"%d ",sp->shp_desty[1]);
    fprintf(fp,"%d ",sp->shp_trdtype[0]);
    fprintf(fp,"%d ",sp->shp_trdtype[1]);
    fprintf(fp,"%d ",sp->shp_autonav);
#endif /* AUTONAV */
    fprintf(fp,"%d ",sp->shp_spare);
    fprintf(fp,"%d ",sp->shp_nv);

    for(x=0;x<MAXSHPV;x++)
        fprintf(fp,"%d ",sp->shp_vtype[x]);

    for(x=0;x<MAXSHPV;x++)
        fprintf(fp,"%d ",sp->shp_vamt[x]);

#ifdef SAIL
    fprintf(fp,"%d ",sp->shp_mobquota);

    for(x=0;x<MAXSHPPATH;x++)
        fprintf(fp,"%d ",sp->shp_path[x]);

    fprintf(fp,"%d ",sp->shp_follow);
#endif /* SAIL */

#ifdef SHIPNAMES
    for(x=0;x<MAXSHPNAMLEN;x++)
        fprintf(fp,"%d ",sp->shp_name[x]);
#endif /* SHIPNAMES */

    fprintf(fp,"\n");
}
