#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/SUBS/RCS/sect.c,v 1.2 89/05/28 18:12:44 emp-src Exp $";
#endif

/*
 * sect.c
 *
 * post-read and pre-write sector data massage
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#ifdef EASY_BRIDGES
#include "plane.h"
#endif /* EASY_BRIDGES */

/*ARGSUSED*/
int
sct_postread(id, ptr)
	int	id;
	char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	owner = (god || sp->sct_own == cnum);
	return 1;
}

/*ARGSUSED*/
int
sct_prewrite(id, ptr)
	int	id;
	char	*ptr;
{
	register struct sctstr *sp = (struct sctstr *) ptr;
	int	mines;
#ifdef EASY_BRIDGES
        register struct plnstr *pp;
        struct  plnstr p2;
        int     n,old=sp->sct_own;
#endif /* EASY_BRIDGES */

	if (sp->sct_type == SCT_BSPAN && sp->sct_effic < 20) {
		sp->sct_type = SCT_WATER;
		sp->sct_newtype = SCT_WATER;
		sp->sct_own = 0;
		sp->sct_oldown = 0;
		pr(fmt("A bridge span at %s has collapsed\n",
			xyas((int)sp->sct_x, (int)sp->sct_y, cnum)));
#ifdef EASY_BRIDGES
                wu(0, old, fmt("Crumble... SCREEEECH!  Splash! Bridge falls at %s!\n", xyas(sp->sct_x, sp->sct_y, old)));

		pp = &p2;
		for (n=0; ef_read(EF_PLANE, n, pp); n++) {
			if(pp->pln_x != sp->sct_x || pp->pln_y != sp->sct_y)
				continue;
			wu(0, old, fmt("     \007AARGH! Plane #%d tumbles to its doom!\n", pp->pln_uid));
			pp->pln_own = 0;
			putplane(n, pp);
		}
#endif /* EASY_BRIDGES */
		/*
		 * save only the mines; zero the rest of the
		 * commodities.
		 */
		mines = getvar(V_MINE, (caddr_t)sp, EF_SECTOR);
		sp->sct_nv = 0;
		if (mines > 0)
			(void) putvar(V_MINE, mines, (caddr_t)sp, EF_SECTOR);
	}
	if (sp->sct_own != 0 && !getvar(V_CIVIL, ptr, EF_SECTOR))
		sp->sct_work = 100;

	if (sp->sct_own != 0 && !getvar(V_CIVIL, ptr, EF_SECTOR) &&
	    !getvar(V_MILIT, ptr, EF_SECTOR)) {
		/* more cruft! */
		if (sp->sct_type == SCT_CAPIT)
			caploss(sp, sp->sct_own, "");
		sp->sct_own = 0;
		sp->sct_oldown = 0;
	}
	return 1;
}
