/******************************************************************************
*									      *
*	(C) 1993 by K. Ballueder					      *
*									      *
*	See README and COPYING for details.				      *
*									      *
*	Please feel free to contact me:					      *
*		kballued@charon.physik.uni-osnabrueck.de		      *
*		kballued@jupiter.rz.uni-osnabrueck.de			      *
*									      *
******************************************************************************/


/******

  sound_dos.c  : Soundroutinen fuer BDASH
  		 Hardwarenaher Teil fuer DOS-Systeme

******/
#include "bdash.h"

#ifdef OS_DOS

#include <dos.h>
#include <alloc.h>
#include <stdio.h>
#include "sound.h"
#include "io.h"

#define PLAY        0
#define MAGIC       0x7746
#define CHECK_INST  0x8201
#define RESPLAY     0x2f
#define SETUP       0x8210
#define PLAYER      0x8200
#define SUCESS      0x1000
#define FAILED      0x2000
#define SAMPLE      1



static int do_it (int,int,int,unsigned int,unsigned int,unsigned int,unsigned int);


static int do_it(  int mode, int device, int speed,
	unsigned int st_msb, unsigned int st_lsb,
	unsigned int len_msb, unsigned int len_lsb)
{
	 union REGS inregs,outregs;

	 inregs.x.ax = SETUP; 		  inregs.h.cl = mode;
	 inregs.h.bl = device;            inregs.h.bh = speed/250;
	 int86(RESPLAY,&inregs,&outregs);
	 if (outregs.x.ax==SUCESS)
	 {
		 inregs.x.dx = st_msb;      inregs.x.di = st_lsb;
		 inregs.x.cx = len_msb;     inregs.x.bx = len_lsb;
		 inregs.x.ax = PLAYER;
		 int86(RESPLAY,&inregs,&outregs);
	 }
	 return (outregs.x.ax == SUCESS);
}
/*---------------------------------------------------------------*/

int init_snd_dev(void)
{
  union REGS registers;

  registers.x.ax = CHECK_INST;
  int86(RESPLAY,&registers,&registers);
  if(registers.x.ax != MAGIC) /* nicht installiert */
  { puts("\aSorry, couldn't find RESPLAY. You have to play without sounds.\n   ...press any key...");
    getch();
    return 0;
  }
  puts("successfully detected RESPLAY.");
  return 1;
}
#endif
