#! /bin/perl -w
#
# load a NIS+ domain from files
#
# Nistool is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# Nistool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with the NIS+ Server; see the file COPYING.  If
# not, write to the Free Software Foundation, Inc., 675 Mass Ave,
# Cambridge, MA 02139, USA.
#
# Version: 0.1alpha
# Author: Ralf Lehmann <ralfl@darwin.muc.de>
#

use Nisplus;
use strict;

my $DOM;
my $DIR; 
my $T;
my $F;
my $RETSTR;
my $append=0;
my $merge=0;
my $replace=0;
my $opt="";

## Tables that can be loaded with nisaddent
my $STANDARD = "aliases bootparams ethers group hosts netgroup netid netmasks networks passwd protocols rpc services shadow timezone";


if ($#ARGV < 1 || $#ARGV > 2 ) {usage();}
if ($ARGV[0] =~ /^-.*/) {
	$_ = shift @ARGV;
	$replace=1 if /r/;
	$append=1 if /a/;
	$merge=1 if /m/;
}
if($replace){$opt='-r';}
if($append){$opt='-a';}
if($merge){$opt='-m';}
$DOM = shift @ARGV;
$DIR = shift @ARGV;

if (!($DOM =~ /.*\.$/)) {
	$!=1;
	die "Error: Domainname must be fully qualified.\n";
}
if (-e $DIR && !(-d $DIR)){ 
	$!=1;
	die "Error: $DIR exists but is not a directory.\n";
}
my $o = Nisplus->new($DOM);
$o->getattr();
if ($RETSTR = $o->get_error()){
	$!=1;
	die "Error: $RETSTR\n";
}
if ($o->{'Type'} ne 'DIRECTORY') {
	$!=1;
	die "Error: $DOM is not a domain\n";
}
loaddomain();
print `nisping org_dir.$DOM`;
print `nisping groups_dir.$DOM`;
exit 0;

##
## load the domain from files
##
sub loaddomain{
	my $t;
	my $org_dir = Nisplus->new("org_dir.$DOM");
	$org_dir->getattr();
	if ($RETSTR = $org_dir->get_error()){
		$!=1;
		die "Error: $RETSTR\n";
	}
	my @list=$org_dir->list();
	foreach $t (@list){
		$T = $t;
		$F = Nisplus::get_first($T);
		$F = $DIR . '/' . $F;
		if (!(-e $F && -f $F)){
			warn "can't fill table $T, no source file $F\n";
			next;
		}
		print "Loading table $T from file $F\n";
		`./load_table.pl $T $F`;
		if (Nisplus::get_first($T) eq 'passwd'){
			$F = $DIR . '/shadow';
			$T = 'shadow.' . Nisplus::strip_first($T);
		print "Loading table $T from file $F\n";
			`./load_table.pl $T $F`;
		}
	}
}


##
## find an error in th eoutput string
##
sub find_error {
	my $RET;
	foreach (@_){
		if (/Error/ || /error/ || /cannot/ || /can't/) { 
			if (defined($RET)) {$RET .= $_ ; }
			else { $RET=$_;}
		}
	}
	return $RET;
}


sub usage {
	print STDERR "usage: $0 [-cma] table sourcefile\n";
	exit 1;
}
