#ifndef XPLAY
#define XPLAY

/* Include file for the X-interface */

/* Include files required for all toolkit programs */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Include files required for this program */

#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Toggle.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Dialog.h>
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/MenuButton.h>
#include <X11/Xaw3d/SmeBSB.h>
#include <X11/Xaw3d/SmeLine.h>

#include "title.bit"
#include "stop.bit"
#include "play.bit"
#include "record.bit"
#include "zoom_out.bit"
#include "zoom_in.bit"

#include "play.h"

#define MW XtVaCreateManagedWidget
#define SPEED_LEN 6
#define LIMIT_LEN 6
#define NAME_LEN 31
#define GRAPH_HEIGHT 200
#define GRAPH_WIDTH 490

typedef struct {
   Widget main_form;
   Widget quit_btn;
   Widget play_btn, record_btn, stop_btn;
   Widget zoom_out_btn, zoom_in_btn;
   Widget stereo_btn, mono_btn;
   Widget radio_box2, radio_box3;
   Widget eight_bit_btn, twelve_bit_btn, sixteen_bit_btn;
   Widget bit_label;
   Widget song_title, title_label;
   Widget speed, graph;
   Widget speed_label, limit_label, limit;
   Widget menu_box, file_menu_btn, file_menu;
   Widget load_btn, save_btn, quit_menu_btn, nothing;
   Widget effects_menu_btn, effects_menu;
   Widget echo_btn;
} widget_structure;

extern widget_structure ww;

typedef struct {
   GC graph_GC, line_GC, delete_line_GC;
} graph_ctx;

/* Prototypes for all functions used */
void quit_question(Widget w, XtPointer client_data, XtPointer call_data);
void quit_application();
void stop_playing(Widget w, XtPointer client_cata, XtPointer call_data);
void play_sample(Widget w, XtPointer client_data, XtPointer call_data);
void get_changeable_options();
void record_question(Widget w, XtPointer client_data, XtPointer call_data);
void record_sample();
void zoom_out(Widget w, XtPointer client_data, XtPointer call_data);
void zoom_in(Widget w, XtPointer client_data, XtPointer call_data);
void open_dialog(Widget w, XtPointer client_data, XtPointer call_data);
void calculate_echo(Widget w, XtPointer client_data, XtPointer call_data);
void save_file();
void load_file();
void update_display();
void set_limit_borders_action(Widget w, XEvent *event, String *params, 
                              Cardinal *num_params);
void calculate_limit_borders();
void draw_limit_borders(int x1, int x2);
void popup_file_dialog(Widget w, String str, String def_fn, void (*func)() );
void popup_centered(Widget w);
void popdown_file_dialog_action(Widget w, XEvent *event, String *params, 
                                Cardinal *num_params);
void popdown_file_dialog(Widget w, XtPointer client_data, XtPointer call_data);
void close_error(Widget w, XtPointer client_data, XtPointer call_data);
void discard_question(int flag);
void discard_answer(Widget w, XtPointer client_data, XtPointer call_data);
void create_GC(graph_ctx *g_ctx);
void create_widget_hierarchy(Widget top_level, 
                             char *speed_buf, char *limit_buf, 
                             char *song_name_buf, graph_ctx *g_ctx);
int define_color(Widget w, char *color);
void expose_graph_action(Widget w, XEvent *event, String *params, 
                                Cardinal *num_params);

#endif
