/*
 *  Project   : tin - a threaded Netnews reader
 *  Module    : extern.h
 *  Author    : I.Lea
 *  Created   : 01-04-91
 *  Updated   : 20-06-92
 *  Notes     :
 *  Copyright : (c) Copyright 1991-92 by Iain Lea
 *              You may  freely  copy or  redistribute  this software,
 *              so  long as there is no profit made from its use, sale
 *              trade or  reproduction.  You may not change this copy-
 *              right notice, and it must be included in any copy made
 */

/*
 * Library prototypes
 */

#if defined(__GNUC__) && defined(DEBUG)

extern unsigned int alarm (unsigned int seconds);
extern int close (int fildes);
extern int fork (void);
extern int getpid (void);
extern char *getcwd (char *buf, int size);
#ifndef DGUX
extern unsigned short getuid (void);
extern unsigned short getegid (void);
extern unsigned short geteuid (void);
#endif /* DGUX */
extern int getopt (int argc, char **argv, char *optstring);
extern int kill (int pid, int sig);
extern int link (char *path1, char *path2);
extern int open (char *path, int oflag);
extern FILE *popen (char *command, char *type);
extern int pclose (FILE *stream);
extern int read (int fildes, char *buf, unsigned int nbyte);
extern int setgid (int gid);
extern int setuid (int uid);
extern int tgetent (char *bp, char *name);
extern int tputs (register char *cp, int count, int (*outc)());
extern int unlink (char *path);

#ifndef sony
#	ifndef DGUX
extern unsigned short getgid (void);
#	endif /* DGUX */
extern void setpgrp (void);
extern unsigned int sleep (unsigned int seconds);
#endif

#endif

#if !defined(__STDC__)
extern char *getenv ();
#endif

extern int optind;
extern char *optarg;

/*
 * Local variables
 */
 
extern char *help_group[];
extern char *help_page[];
extern char *help_select[];
extern char *help_spooldir[];
extern char *help_thread[];
extern char active_file[PATH_LEN];
extern char add_addr[LEN];
extern char default_art_search[LEN];
extern char article[PATH_LEN];
extern char default_author_search[LEN];
extern char bug_addr[LEN];
extern char cvers[LEN];
extern char dead_article[PATH_LEN];
extern char default_crosspost_group[LEN];
extern char default_mail_address[LEN];
extern char default_pipe_command[LEN];
extern char default_post_subject[LEN];
extern char default_regex_pattern[LEN];
extern char default_save_file[PATH_LEN];
extern char default_select_pattern[LEN];
extern char default_shell_command[LEN];
extern char delgroups[LEN];
extern char default_goto_group[LEN];
extern char default_group_search[LEN];
extern char default_maildir[PATH_LEN];
extern char homedir[PATH_LEN];
extern char indexdir[PATH_LEN];
extern char killfile[PATH_LEN];
extern char killfrom[LEN];
extern char killsubj[LEN];
extern char mail_news_user[LEN];
extern char mailbox[PATH_LEN];
extern char mailer[PATH_LEN];
extern char msg[LEN];
extern char my_distribution[LEN];
extern char my_org[LEN];
extern char newsgroups_file[PATH_LEN];
extern char newnewsrc[PATH_LEN];
extern char newsrc[PATH_LEN];
extern char nntp_server[LEN];
extern char page_header[LEN];
extern char postfile[PATH_LEN];
extern char printer[LEN];
extern char cmd_line_printer[LEN];
extern char proc_ch_default;				/* set in change_rcfile () */
extern char progname[PATH_LEN];
extern char rcdir[PATH_LEN];
extern char rcfile[PATH_LEN];
extern char redirect_output[LEN];
extern char reply_to[LEN];
extern char default_savedir[PATH_LEN];
extern char default_sigfile[PATH_LEN];
extern char default_signature[PATH_LEN];
extern char spooldir[PATH_LEN];
extern char spooldir_alias[PATH_LEN];
extern char default_subject_search[LEN];
extern char subscriptions_file[PATH_LEN];
extern char txt_help_bug_report[LEN];
extern char unthreadfile[PATH_LEN];
extern char userid[LEN];

extern char txt_1_resp[];
extern char txt_active_file_is_empty[];
extern char txt_added_groups[];
extern char txt_append_to_file[];
extern char txt_art[];
extern char txt_art_cancelled[];
extern char txt_art_cannot_cancel[];
extern char txt_art_marked_as_unread[];
extern char txt_art_not_saved[];
extern char txt_art_pager_com[];
extern char txt_art_posted[];
extern char txt_art_rejected[];
extern char txt_art_saved_to[];
extern char txt_art_thread_regex_tag[];
extern char txt_art_unavailable[];
extern char txt_author_search_backwards[];
extern char txt_author_search_forwards[];
extern char txt_bad_active_file[];
extern char txt_bad_command[];
extern char txt_begin_of_art[];
extern char txt_cancelling[];
extern char txt_cannot_find_base_art[];
extern char txt_cannot_get_nntp_server_name[];
extern char txt_cannot_open[];
extern char txt_cannot_open_active_file[];
extern char txt_cannot_open_art[];
extern char txt_cannot_post[];
extern char txt_checking[];
extern char txt_checking_active_file[];
extern char txt_checking_for_news[];
extern char txt_checksum_of_file[];
extern char txt_command_failed[];
extern char txt_command_failed_s[];
extern char txt_connecting[];
extern char txt_connection_to_server_broken[];
extern char txt_continue[];
extern char txt_corrupt_index[];
extern char txt_corrupt_kill_file[];
extern char txt_creating_newsrc[];
extern char txt_crosspost_an_article[];
extern char txt_crosspost_group[];
extern char txt_del_group_in_newsrc[];
extern char txt_delete_bogus_group[];
extern char txt_deleting[];
extern char txt_deleting_from_newsrc[];
extern char txt_delete_processed_files[];
extern char txt_end_of_arts[];
extern char txt_end_of_groups[];
extern char txt_end_of_thread[];
extern char txt_extracting_archive[];
extern char txt_extracting_shar[];
extern char txt_failed_to_connect_to_server[];
extern char txt_feed_pattern[];
extern char txt_group[];
extern char txt_group_deleted[];
extern char txt_group_select_com[];
extern char txt_select_pattern[];
extern char txt_spooldir_com[];
extern char txt_group_selection[];
extern char txt_group_undeleted[];
extern char txt_help_4[];
extern char txt_help_C[];
extern char txt_help_I[];
extern char txt_help_K[];
extern char txt_help_M[];
extern char txt_help_S[];
extern char txt_help_T[];
extern char txt_help_U[];
extern char txt_help_W[];
extern char txt_help_X[];
extern char txt_help_a[];
extern char txt_help_autosave[];
extern char txt_help_b[];
extern char txt_help_bug[];
extern char txt_help_c[];
extern char txt_help_ck[];
extern char txt_help_cr[];
extern char txt_help_catchup_groups[];
extern char txt_help_i_coma[];
extern char txt_help_confirm_action[];
extern char txt_help_ctrl_d[];
extern char txt_help_ctrl_f[];
extern char txt_help_ctrl_h[];
extern char txt_help_ctrl_k[];
extern char txt_help_ctrl_l[];
extern char txt_help_d[];
extern char txt_help_dash[];
extern char txt_help_draw_arrow[];
extern char txt_help_equal[];
extern char txt_help_g[];
extern char txt_help_g_4[];
extern char txt_help_g_c[];
extern char txt_help_g_cr[];
extern char txt_help_cr[];
extern char txt_help_g_ctrl_k[];
extern char txt_help_g_ctrl_r[];
extern char txt_help_g_l[];
extern char txt_help_g_q[];
extern char txt_help_g_search[];
extern char txt_help_g_tab[];
extern char txt_help_g_y[];
extern char txt_help_g_z[];
extern char txt_help_h[];
extern char txt_help_i[];
extern char txt_help_i_4[];
extern char txt_help_i_coma[];
extern char txt_help_i_cr[];
extern char txt_help_i_dot[];
extern char txt_help_i_n[];
extern char txt_help_i_p[];
extern char txt_help_i_search[];
extern char txt_help_i_star[];
extern char txt_help_i_tab[];
extern char txt_help_i_tilda[];
extern char txt_help_j[];
extern char txt_help_kill_from[];
extern char txt_help_kill_group[];
extern char txt_help_kill_how[];
extern char txt_help_kill_subject[];
extern char txt_help_kill_text[];
extern char txt_help_kill_text_type[];
extern char txt_help_l[];
extern char txt_help_m[];
extern char txt_help_maildir[];
extern char txt_help_mark_saved_read[];
extern char txt_help_n[];
extern char txt_help_o[];
extern char txt_help_p_0[];
extern char txt_help_p_4[];
extern char txt_help_p_coma[];
extern char txt_help_p_cr[];
extern char txt_help_p_ctrl_r[];
extern char txt_help_p_d[];
extern char txt_help_p_dot[];
extern char txt_help_p_f[];
extern char txt_help_p_g[];
extern char txt_help_p_k[];
extern char txt_help_p_m[];
extern char txt_help_p_n[];
extern char txt_help_p_p[];
extern char txt_help_p_r[];
extern char txt_help_p_s[];
extern char txt_help_p_search[];
extern char txt_help_p_star[];
extern char txt_help_p_tab[];
extern char txt_help_p_tilda[];
extern char txt_help_p_z[];
extern char txt_help_page_scroll[];
extern char txt_help_pipe[];
extern char txt_help_plus[];
extern char txt_help_pos_first_unread[];
extern char txt_help_post_proc_type[];
extern char txt_help_print_header[];
extern char txt_help_printer[];
extern char txt_help_q[];
extern char txt_help_r[];
extern char txt_help_s[];
extern char txt_help_savedir[];
extern char txt_help_sel_c[];
extern char txt_help_semicolon[];
#ifndef NO_SHELL_ESCAPE
extern char txt_help_shell[];
#endif
extern char txt_help_show_author[];
extern char txt_help_show_description[];
extern char txt_help_show_only_unread[];
extern char txt_help_sort_type[];
extern char txt_help_start_editor_offset[];
extern char txt_help_t[];
extern char txt_help_t_0[];
extern char txt_help_t_4[];
extern char txt_help_t_K[];
extern char txt_help_t_cr[];
extern char txt_help_t_tab[];
extern char txt_help_thread[];
extern char txt_help_thread_arts[];
extern char txt_help_u[];
extern char txt_help_v[];
extern char txt_help_w[];
extern char txt_help_x[];
extern char txt_help_y[];
extern char txt_hit_any_key[];
extern char txt_hit_space_for_more[];
extern char txt_in_art_you_write[];
extern char txt_index_page_com[];
extern char txt_indexing[];
extern char txt_indexing_num[];
extern char txt_inverse_off[];
extern char txt_inverse_on[];
extern char txt_kill_from[];
extern char txt_kill_group[];
extern char txt_kill_how[];
extern char txt_kill_menu[];
extern char txt_kill_subject[];
extern char txt_kill_text[];
extern char txt_kill_text_type[];
extern char txt_killing_arts[];
extern char txt_last_resp[];
extern char txt_listing_archive[];
extern char txt_mail_art_to[];
extern char txt_mail_bug_report[];
extern char txt_mail_bug_report_confirm[];
extern char txt_mailed[];
extern char txt_mailing_to[];
extern char txt_mark_all_read[];
extern char txt_mark_thread_read[];
extern char txt_mark_group_read[];
extern char txt_more[];
extern char txt_more_percent[];
extern char txt_moving[];
extern char txt_newsgroup[];
extern char txt_newsgroup_position[];
extern char txt_next_resp[];
extern char txt_nntp_to_fd_cannot_reopen[];
extern char txt_nntp_to_fp_cannot_reopen[];
extern char txt_no_arts[];
extern char txt_no_arts_posted[];
extern char txt_no_blank_line[];
extern char txt_no_command[];
extern char txt_no_filename[];
extern char txt_no_group[];
extern char txt_no_groups[];
extern char txt_no_groups_to_delete[];
extern char txt_no_groups_to_read[];
extern char txt_no_groups_to_yank_in[];
extern char txt_no_last_message[];
extern char txt_no_mail_address[];
extern char txt_no_match[];
extern char txt_no_more_groups[];
extern char txt_no_next_unread_art[];
extern char txt_no_prev_group[];
extern char txt_no_prev_unread_art[];
extern char txt_no_resp[];
extern char txt_no_resps_in_thread[];
extern char txt_no_search_string[];
extern char txt_no_subject[];
extern char txt_not_active_newsfeed[];
extern char txt_not_in_active_file[];
extern char txt_opt_autosave[];
extern char txt_opt_catchup_groups[];
extern char txt_opt_confirm_action[];
extern char txt_opt_draw_arrow[];
extern char txt_opt_maildir[];
extern char txt_opt_mark_saved_read[];
extern char txt_opt_page_scroll[];
extern char txt_opt_pos_first_unread[];
extern char txt_opt_post_process[];
extern char txt_opt_print_header[];
extern char txt_opt_printer[];
extern char txt_opt_process_type[];
extern char txt_opt_savedir[];
extern char txt_opt_show_author[];
extern char txt_opt_show_description[];
extern char txt_opt_show_only_unread[];
extern char txt_opt_sort_type[];
extern char txt_opt_start_editor_offset[];
extern char txt_opt_thread_arts[];
extern char txt_option_not_enabled[];
extern char txt_options_menu[];
extern char txt_out_of_memory[];
extern char txt_pipe_to_command[];
extern char txt_piping[];
extern char txt_plural[];
extern char txt_post_a_followup[];
extern char txt_post_an_article[];
extern char txt_post_history_menu[];
extern char txt_post_newsgroup[];
extern char txt_post_process_none[];
extern char txt_post_process_sh[];
extern char txt_post_process_type[];
extern char txt_post_process_uud_ext_zoo[];
extern char txt_post_process_uud_lst_zoo[];
extern char txt_post_process_uudecode[];
extern char txt_post_processing[];
extern char txt_post_processing_failed[];
extern char txt_post_processing_finished[];
extern char txt_post_subject[];
extern char txt_posting[];
extern char txt_printed[];
extern char txt_printing[];
extern char txt_quit[];
extern char txt_quit_edit_cancel[];
extern char txt_quit_edit_post[];
extern char txt_quit_edit_xpost[];
extern char txt_quit_edit_save_killfile[];
extern char txt_quit_edit_send[];
extern char txt_read_art[];
extern char txt_read_resp[];
extern char txt_reading_active_file[];
extern char txt_reading_newsgroups_file[];
extern char txt_rejected_by_nntpserver[];
extern char txt_rename_error[];
extern char txt_reply_to_author[];
extern char txt_reset_newsrc[];
extern char txt_resizing_window[];
extern char txt_resp_redirect[];
extern char txt_resp_to_poster[];
extern char txt_resp_x_of_n[];
extern char txt_s_at_s[];
extern char txt_save_filename[];
extern char txt_save_pattern[];
extern char txt_saved[];
extern char txt_saved_pattern_to[];
extern char txt_saved_to_mailbox[];
extern char txt_saving[];
extern char txt_screen_init_failed[];
extern char txt_search_backwards[];
extern char txt_search_forwards[];
extern char txt_searching[];
extern char txt_select_group[];
extern char txt_select_rcfile_option[];
extern char txt_select_spooldir[];
extern char txt_server_name_in_file_env_var[];
extern char txt_shell_escape[];
extern char txt_show_from_addr[];
extern char txt_show_from_both[];
extern char txt_show_from_name[];
extern char txt_show_from_none[];
extern char txt_spooldir_selection[];
extern char txt_sort_by_date_ascend[];
extern char txt_sort_by_date_descend[];
extern char txt_sort_by_from_ascend[];
extern char txt_sort_by_from_descend[];
extern char txt_sort_by_nothing[];
extern char txt_sort_by_subj_ascend[];
extern char txt_sort_by_subj_descend[];
extern char txt_stuff_nntp_cannot_open[];
extern char txt_subscribe_pattern[];
extern char txt_subscribe_to_new_group[];
extern char txt_subscribed_num_groups[];
extern char txt_subscribed_to[];
extern char txt_subscribing[];
extern char txt_subscribing_to[];
extern char txt_suspended_message[];
extern char txt_tagged_art[];
extern char txt_there_is_no_news[];
extern char txt_threading_arts[];
extern char txt_thread_com[];
extern char txt_thread_marked_as_unread[];
extern char txt_thread_not_saved[];
extern char txt_thread_page[];
extern char txt_thread_resp_page[];
extern char txt_thread_saved_to[];
extern char txt_thread_saved_to_many[];
extern char txt_thread_x_of_n[];
extern char txt_toggled_rot13[];
extern char txt_type_h_for_help[];
extern char txt_unkilling_arts[];
extern char txt_unsubscribe_pattern[];
extern char txt_unsubscribed_num_groups[];
extern char txt_unsubscribed_to[];
extern char txt_unsubscribing[];
extern char txt_unsubscribing_from[];
extern char txt_untagged_art[];
extern char txt_unthreading_arts[];
extern char txt_uudecoding[];
extern char txt_writes[];
extern char txt_writes_name[];
extern char txt_x_resp[];
extern char txt_yanking_all_groups[];
extern char txt_yanking_sub_groups[];
extern char txt_you_have_mail[];

extern int LINES, COLS;
extern int MORE_POS;
extern int NOTESLINES;
extern int RIGHT_POS;
extern int *my_group;
extern int *unread;
extern int can_post;
extern int catchup;
extern int catchup_read_groups;
extern int cmd_line;
extern int compiled_with_nntp;
extern int confirm_action;
extern int created_rcdir;
extern int debug;
extern int default_move_group;
extern int default_printer;
extern int default_show_author;
#ifdef SIGTSTP
extern int do_sigtstp;
#endif
extern int draw_arrow_mark;
extern int full_page_scroll;
extern int group_hash[TABLE_SIZE];
extern int group_top;
extern int groupname_len;
extern int index_file_killed;
extern int inn_nntp_server;
extern int inverse_okay;
extern int killed_articles;
extern int kill_level;
extern int kill_num;
extern int local_index;
extern int mail_news;
extern int mark_saved_read;
extern int max_active;
extern int max_art;
extern int max_from;
extern int max_subj;
extern int max_kill;
extern int max_save;
extern int nntp_codeno;
extern int num_active;
extern int num_of_hot_arts;
extern int num_of_killed_arts;
extern int num_of_tagged_arts;
extern int pos_first_unread;
extern int post_proc_type;
extern int print_header;
extern int process_id;
extern int read_news_via_nntp;
extern int real_gid;
extern int real_uid;
extern int real_umask;
extern int reread_active_file;
extern int save_archive_name;
extern int save_news;
extern int save_num;
extern int show_author;
extern int show_description;
extern int show_only_unread;
extern int sort_art_type;
extern int space_mode;
extern int spooldir_is_active;
extern int start_editor_offset;
extern int start_line_offset;
extern int system_status;
extern int thread_arts;
extern int tin_gid;
extern int tin_uid;
extern int top;
extern int top_base;
extern int unlink_article;
extern int update;
extern int verbose;
extern int update_fork;
extern int check_any_unread;
extern int start_any_unread;
extern int notify_new_groups;
extern int xindex_supported;
extern int xuser_supported;
extern int xspooldir_supported;

extern long *base;

extern struct passwd *myentry;
extern struct article_t *arts;
extern struct group_t *active;
extern struct kill_t *killf;
extern struct posted_t *posted;
extern struct save_t *save;
extern struct screen_t *screen;

#ifdef POSIX_JOB_CONTROL
extern struct sigaction art_act;
extern struct sigaction group_act;
extern struct sigaction kill_act;
extern struct sigaction main_act;
extern struct sigaction old_act;
extern struct sigaction page_act;
extern struct sigaction rcfile_act;
extern struct sigaction select_act;
extern struct sigaction thread_act;
#endif
