/* Library for CX100 frame grabber for Linux */

#include "cx100.h"

#ifndef _CXLIB_H_
#define _CXLIB_H_

#define DEFAULT_DEVICE_FILE		"/dev/cx100"

void cx_init(int fd);
/* It should not normally be necessary to call this function, 
	as cx_open() calls it automatically.  It's here mainly for
	completness.
*/

int cx_open(char *str);
/* Opens the cx100 device file and calls cx_init().  If *str is a
	NULL pointer, default is to open "/dev/cx100".
	cx_open() returns a file descriptor, which is used in most of
	the cx_...() functions.  Or the value of open() on error */

int cx_close(int cxfd);
/* Turns off the frame grabber, and closes the file */
/* Returns value of close() */

int cx_nopen(char *str);
/* Opens the cx100 device file.  If *str is a NULL pointer, 
	default is to open "/dev/cx100".
	cx_nopen() returns a file descriptor, which is used in most of
	the cx_...() functions.
	Returns value of open() */

int cx_nclose(int cxfd);
/* Closes the file without turning off the frame grabber */

int cx_getframe(int cxfd, char *buff, int nbytes);
/* Does a frame grab and places the captured frame in buff.  Will only
	copy nbytes bytes to this buffer.
	cx_getframe() returns the number of bytes required for the entire
	buffer (even if *buff is a NULL pointer).  Or value of read() on
	error.
	Note: If you just want to do a frame grab, but don't care about the
		contents, you can call this function with a NULL pointer or
		nbytes equal to zero.
*/

int cx_getpixel(int cxfd, int x, int y);
/* Returns the value of a single pixel in the frame grabber */
/* Note: If doing a lot of these, you might be better off doing a
	cx_getframe() and doing this manually, as this function makes
	several system calls. */

int cx_getresolution(int cxfd);
/* Returns the current resolution the CX100 is in */

int cx_setresolution(int cxfd, int state);
/* Set's the resolution to state.  1 is high, 0 is low. */
/* Returns the new resolution the CX100 is in */

int cx_imagewidth(int cxfd);
/* Returns the width of grabbed data for the current resolution */

int cx_imageheight(int cxfd);
/* Returns the height of grabbed data for the current resolution */

#endif /* _CXLIB_H_ */
