/* lowlev.C : wolf 9/95
   access to ports and direct memory 
*/
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/mman.h>

void test_mem(int mem_fd) {    
  int i,adr;
  unsigned char buff[100];
  for (adr = 0xa0000; adr < 0x100000; adr+= 0x1000) {
    lseek(mem_fd,adr,0); printf("%x",adr);
    read(mem_fd,buff,20);
    for (i=0; i < 20; i++) printf(" %2x", buff[i]);
    printf("\n");
  }
} 

#define PAGE_SIZE 0x1000

/* bildet einen Bereich physikalischen Speicher ab "base" auf logischen mem ab
   returns pointer der Abbildung
*/

void *pmem_map(unsigned base, unsigned buf_size) {
  void *buf;
  unsigned off;
#ifdef SPARC
  printf("This program must be compiled and executed on PC only ! %c\n",7);
  exit(-1);
#endif
  int mem_fd = open("/dev/mem", O_RDWR);
  if (mem_fd < 0) {
    printf("cannot open /dev/mem\n");
    printf("program must run with root permissions !\n");
    exit(-1);
  }

  if ((buf = malloc(buf_size + (PAGE_SIZE-1))) == NULL) {
    printf("cannot malloc\n");
    exit(-1);
  }
  off = (unsigned long) buf % PAGE_SIZE;
  if (off) buf += PAGE_SIZE - off;
  buf = mmap( (caddr_t) buf, buf_size, PROT_READ | PROT_WRITE,
		  MAP_SHARED | MAP_FIXED, mem_fd, base);
  if (buf == (void*) -1) printf("mem mapping error \n");
  /*  test_mem(mem_fd); */
  close (mem_fd);
  return buf;
}
