// image-view.c : standalone program for view of pictures from saved files
//   a part of PMS-grabber package
// the "GNU Public Lincense" policy applies to all programs of this package
// (c) Wolfgang Koehler, wolf@first.gmd.de, Dec. 1994
//     Kiefernring 15
//     14478 Potsdam, Germany
//     0331-863238

#include "window.h"
#include "ximage.h"
#include "evaluation.h"
#include "view.h"

// needed here because defined in view.h, but not used
void fast_capture(unsigned short *dst, int width, int ystretch, int) {}

menu_bar *menub; 
main_window *mw;

// specialized main_window to handle resize events to set resolution
// and handle possibly actions from radio_menu
class resize_window : public main_window {
public:
  resize_window(char *Name, int w, int h) : main_window(Name,w,h) { }
  // set resolution, only resize grab_window

  virtual void resize(int w, int h) {  
    if ((w != width) || (h != height)) {
      width = w; height = h;     
      biWidth = w; 
      biHeight = h - 40 ;  // - display-line - menu_bar
      create_buffers(biWidth,biHeight);
      grab_wi->resize(biWidth,biHeight); // room for menu_bar
      menub->resize(w,20);
    }
  }
  // from radio menu called :
  virtual void action(char * menu, char *val) { }
};

struct but_cb pal_list[] = 
   { {"set standard palette", std_coltab555 }, 
     {"grey scale palette", grey_coltab555 }, 
     {"set to last captured", set_auto_pal555 } };

struct but_cb file_list[] = 
   { { "save image.pix", save_pix },
     { "load image.pix", load_pix_interactive },
     { "save capture", save_capture },
     { "load capture", load_capture_interactive }, 
     { "save palette", save_palette },
     { "load palette", load_palette_interactive },
     { "save ppm", save_ppm }
   };

main(int argc, char *argv[]) { 
  get_visual(); // init vars about visual
  biWidth = 340; biHeight = 255;
  int ww = biWidth+2 ,wh = biHeight + 40, bh = 20;

  mw = new resize_window(argv[0],ww,wh);
  menub = new menu_bar(*mw,ww,bh,0,0,30);
  if (! True_Color) {
    make_pulldown_menu(*menub,"set palette",3, pal_list);
    new callback_button(*menub, "evaluate", make_eval_popup);
  }
  make_pulldown_menu(*menub,"file", 7, file_list);
  new quit_button(*menub);
  info_window *infw = new info_window(*mw,ww,20,0,wh-20); // bottom
  grab_wi = new view_window(*mw,0,20,infw);

  max_cols = 0;
  long unsigned plane_mask; 
  if (! True_Color) {
    while // allocate all available color cells to array pixtab[] !!
      (XAllocColorCells(display,def_cmap,True,&plane_mask,0,
			&pixtab[max_cols],1)) 
	max_cols++; // number of color cells
    printf("allocated %d color cells\n",max_cols);
    std_coltab555();  
  }

  FILE *fload = fopen("franzi.pix","r");  // start up with nice image
  load_pix_file(fload); fclose(fload);
  mw->main_loop();
  if (act_image) delete act_image; // free SHM descriptors !!
}

