#ifndef _DEFS_H
#define _DEFS_H

#include "mytypes.h"
#include "list.h"
#include "debug.h"

class World;
class Graphics;
class TransTable;
class WDisplay;
class Player;
struct PieceMove;

extern Graphics *screen;

extern World *world;
extern int sock; // socket to communicate with server

extern int numPlayers;
extern Player **players;

extern int playerId;
extern char *myName;
extern char *serverName; // only used in windows

extern int currTurn;

extern TransTable *trans; // translation table

extern WDisplay *display;

extern char *names[]; // names of units and other things which we produce
extern char **cityNames, *initCityNames[];

// this is the list of current moves we have made
// gets sent to all the other players at the end of our turn
class MsgQ;
extern MsgQ *moveQ;

extern int savedGame; // true if this is a saved game

const int CURSOR_TIMER = 0;
const int DATA_SEND_TIMER = 1;

#ifndef MS_WIN
#define FAR
#endif

#endif
