#include "defs.h"
#include "debug.h"
#include <string.h>
#include <stdio.h>

char *debugFlags = NULL;

#ifndef MS_WIN

#include <stdarg.h>

void Debug(int flag, char *format, ...)
{
  va_list ap;
  va_start(ap, format);
  if (debugFlags != NULL && (strchr(debugFlags, flag) != NULL ||
			     *debugFlags == '+'))
    vfprintf(stderr, format, ap);
  va_end(ap);
}

#else

static FILE *debug = NULL;

void Debug(int flag, char *format, ...)
{
  if (debug == NULL)
    debug = fopen(myName, "w");
  va_list ap;
  va_start(ap, format);
  vfprintf(debug, format, ap);
  va_end(ap);
  fflush(debug);
}

#endif
