// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#ifndef __FastMath__
#define __FastMath__

#include <math.h>

typedef long int Integer;

// make no bigger than 65536 (size sqrt table returns 'char' )
#define SQRTSIZE 10000

class FastMath {
    public:

	static double cos(int d) 
			{ 
			return (d<0) ? Vcos[ 360-((-d)%360) ] : Vcos[d%360]; 
			}
	static double sin(int d) 
			{
			return (d<0) ? Vsin[ 360-((-d)%360) ] : Vsin[d%360]; 
			}
	static void   init();
	
	static int    intSqrt(int d)
			{
			return (d>=SQRTSIZE) ? VintSqrt[SQRTSIZE-1] : VintSqrt[d];
			}
	
    private:
    	static double Vcos[360], Vsin[360];
    	static unsigned char VintSqrt[SQRTSIZE];
    };

#endif
