// Code copied or derived from xasteroids Copyright Phil Goetz.
// See the file README.xast, which is the README file from the xasteroids
// distribution.
//
// All other code Copyright 1994 Brad Pitzel   pitzel@cs.sfu.ca
// Feel free to use/distribute/modify as long as credit/copyrights
// are included.
//
//
// sasteroids	Version 1.0 for Linux  (and linux only :)
// 		Released Feb 14/94
//		Requires svgalib v1.01 (super-vga graphics library)
//		earlier versions of svgalib might work, i haven't tested it
//		Developed with gcc 2.4.5


#include <stdio.h>
#include <vga.h>
#include <vgagl.h>
#include <math.h>
#include <iostream.h>

#include "bitmap.h"		// bitmaps for asteroids, etc
#include "titleScn.h"		// bitmap for title screen
#include "backScn.h"		// bitmap for high scores backdrop
#include "Timer.h"
#include "sasteroids.h"
#include "HiScore.h"
#include "Obj.h"		// game objects
#include "Ui.h"

#define FPS	20		// frames per second for the animation
				// play with this if you like

// I thought of changing from xasteroids method of putting objects in
// an array to using a nice C++ linked list, but I think that would only
// slow things down, so the bit following bit is straight from xasteroids
// source code. (BJP)

// Indexes for 1st dimension of obj	
// The order they are in is important	
#define	AST	0
#define	ENEMY	96
#define ENEMYBUL 97
#define	FBUL	98
#define	LASTBUL	102
#define	SHIP	103
#define LASTOBJ 103	// Must be ship!  See makeasts().	


// Shapes	
// Order is important!  See collide().	
#define	ASTSHAPE1	0
#define ASTSHAPE2	1
#define ASTSHAPE3	2
#define ENBULSH		3
#define	BULSHAPE	4
#define	SHIPSHAPE	5
#define SHIPTHRSHAPE	6
#define	ENEMYSHAPE	7
#define LASTSHAPE	7


// The following define 'masses' for the game objects.  From xasteroids
// source, this allows the cool bouncing/collision routines
// to work the way they do..
 
// Masses	
#define M_BIG	8.0
#define M_MED	4.0
#define M_SMALL	1.0
#define M_SHIP	1.5
#define M_ENEMY	1.0
#define M_BULLET 0.1

#define BMAX		200	// Max particles in a "boom" + 1	
#define START_DIST 70


// all of the 'boom' code from xasteroids, done by Peter Phillips 
typedef struct _Boom *Boom;
struct _Boom {Boom next; int dur, part; double bcoord[BMAX][2], bvec[BMAX][2];};

typedef struct {double x, y, mag;} Vector;

// Global variables:	
typedef ObjType *ObjPtr;
ObjPtr	obj[SHIP+1];

// The player ship is an instance of the ship object, eh?
Ship	playerShip( SHIPSHAPE, M_SHIP, ship0 );

Boom	blist = NULL;


// I've got to finish C++'ing this program and hide the rest
// of these global vars.
int	ships, score,
	level,
	nextbul = FBUL,			// Obj# of next bullet fired	
	numasts, oldscore;


// I got lazy and didn't draw a bitmap for the smallest asteroid.
// Instead, I scale the medium sized asteroid down. The bitmap.[ch] files
// contain the bitmaps that I did drawings for.  Since smallast wasn't
// drawn, we'll define it here. ('cause bitmap.[ch] is code-generated
// from the bitmap files)
Bitmap smallast(10,10);


// do some work to get a few bitmaps ready for the game.
void setBits()
{

// make the small asteroid a scaled down version of the medium one.
smallast.copy( medast, 10, 10 );

if (smallast.map()==NULL) {
	cerr << "can't create small asteroid bitmap.\n";
	exit(-1);
	}

// use the rotate function of the bitmap object to create
// ship bitmaps for each of the 16 rotated positions.
ship[0].copy( ship0 );
ship[1].copy( ship0 ); ship[1].rot(M_PI/8.0);
ship[2].copy( ship0 ); ship[2].rot(M_PI/4.0);
ship[3].copy( ship0 ); ship[3].rot(3.0*M_PI/8.0);

ship[4].copy( ship[0] ); ship[4].rotc90();
ship[5].copy( ship[1] ); ship[5].rotc90();
ship[6].copy( ship[2] ); ship[6].rotc90();
ship[7].copy( ship[3] ); ship[7].rotc90();

ship[8].copy( ship[4] ); ship[8].rotc90();
ship[9].copy( ship[5] ); ship[9].rotc90();
ship[10].copy( ship[6] ); ship[10].rotc90();
ship[11].copy( ship[7] ); ship[11].rotc90();

ship[12].copy( ship[8] ); ship[12].rotc90();
ship[13].copy( ship[9] ); ship[13].rotc90();
ship[14].copy( ship[10] ); ship[14].rotc90();
ship[15].copy( ship[11] ); ship[15].rotc90();

shipThr[0].copy( ship1 );
shipThr[1].copy( ship1 ); shipThr[1].rot(M_PI/8.0);
shipThr[2].copy( ship1 ); shipThr[2].rot(M_PI/4.0);
shipThr[3].copy( ship1 ); shipThr[3].rot(3.0*M_PI/8.0);

shipThr[4].copy( shipThr[0] ); shipThr[4].rotc90();
shipThr[5].copy( shipThr[1] ); shipThr[5].rotc90();
shipThr[6].copy( shipThr[2] ); shipThr[6].rotc90();
shipThr[7].copy( shipThr[3] ); shipThr[7].rotc90();

shipThr[8].copy( shipThr[4] ); shipThr[8].rotc90();
shipThr[9].copy( shipThr[5] ); shipThr[9].rotc90();
shipThr[10].copy( shipThr[6] ); shipThr[10].rotc90();
shipThr[11].copy( shipThr[7] ); shipThr[11].rotc90();

shipThr[12].copy( shipThr[8] ); shipThr[12].rotc90();
shipThr[13].copy( shipThr[9] ); shipThr[13].rotc90();
shipThr[14].copy( shipThr[10] ); shipThr[14].rotc90();
shipThr[15].copy( shipThr[11] ); shipThr[15].rotc90();

}

// ugly hack hack hack.  for convience, define wihte and red colors
// into the bitmap's color palette.
#define WHITE 255
#define RED   254
void setBPcolormap() {
    bitmap.color[RED].red = 63;
    bitmap.color[RED].green = 0;
    bitmap.color[RED].blue = 0;
    		
    gl_setpalette(&bitmap);
}

// set up the array of game objects.
void initObjArray()
{	int i;
	for (i = 0; i < ENEMY; i++)
		{	
		obj[i] = new ObjType( ASTSHAPE1, M_BIG, bigast );
		}

	obj[SHIP] = &playerShip;
	obj[SHIP]->setBitmap(ship0);
		
	obj[ENEMY] = new ObjType( ENEMYSHAPE, M_ENEMY, enemy );
	
	obj[ENEMYBUL] = new ObjType( ENBULSH, M_BULLET, bullet );
	
	for (i = FBUL; i < LASTBUL+1; i++)
		{	
		obj[i] = new ObjType( BULSHAPE, M_BULLET, bullet );
		}	
}

// return distince in pixels between 2 objects (from center to center)
inline int dist( ObjType& o1, ObjType& o2 )
	{
	double dx = (o1.x-o2.x);
	double dy = (o1.y-o2.y);
	return (int)( sqrt( dx*dx + dy*dy ));
	}
	

// create asteroids for beginning of each level/game
// makeasts - modified from xasteroids
void makeasts()
{	int i;
	unsigned char bRand;
	unsigned int  iRand;

	for (i = 0; i < SHIP; i++)
		obj[i]->alive = 0; // Erase objs from last level except ship 
		
	for (i = 0; i < ((level > 10) ? 12 : level+2); i++) // Asteroids
	{	
		obj[i]->shape = ASTSHAPE1;

		iRand = rand() >> 5;
		obj[i]->x = (double)(iRand%WIDTH);
		
		iRand = rand() >> 5;
		obj[i]->y = (double)(iRand%HEIGHT);
		
		// make sure new ast is not near player's ship
		if (dist(*obj[i], playerShip) > START_DIST)
			{
			bRand = rand();
			obj[i]->xvel = cos((double) bRand);
			obj[i]->yvel = sin((double) bRand);
			obj[i]->setBitmap(bigast);
			obj[i]->mass = M_BIG;
			obj[i]->alive = 1;
			}
		else	i--;	// ast too close to player, try again
	}
	numasts = i;
}

// makeenemy - from xasteroids
void makeenemy()	// Start an enemy ship	
{	
	unsigned char c;

	obj[ENEMY]->alive = 1;
	obj[ENEMY]->x = 0;
	obj[ENEMY]->y = (double) HEIGHT/4;
	c = rand(); obj[ENEMY]->y += (double) c; // May put enemy outside window	
	obj[ENEMY]->xvel = .4 + ((double) level)/3.;
	obj[ENEMY]->yvel = 0;
}

// nextast - from xasteroids
int nextast()	// Find next unused asteroid object
{	
	int i;
	for (i = 0; obj[i]->alive; i++);	// guaranteed to find one
	return i;
}


// greatly simplified/dumb collision alg.  the original xasteroids used
// line intersection methods since the game used line graphics.
int collide(int i, int j)	// Returns non-zero if i collided with j
{	
	if ( dist(*obj[i],*obj[j]) < (obj[i]->size() + obj[j]->size()) )
		{   
		// round objects approximation
		//cout << "collide: " << obj[i]->size() << "," << obj[j]->size() << "," << diff << endl;
		return 1;
		}

	return 0;
}

void blastpair(int i, int j)		// Generate random velocity vector v.	
	// Add v to i, -v to j.			
{
	
	unsigned char c;	// for rand	
	double vx, vy;
	c = rand();
//	c = 4 - c>>5;	if you need angles from -3 to 4		

	vx = cos((double) c); vy = sin((double) c);
	obj[i]->xvel = obj[i]->xvel + vx;
	obj[i]->yvel = obj[i]->yvel + vy;
	obj[j]->xvel = obj[j]->xvel - vx;
	obj[j]->yvel = obj[j]->yvel - vy;
}

// dot product of 2 vectors	
#define dot(i,j)	(i.x*j.x + i.y*j.y)

// rotational inertia (constant eliminated) of obj. i	
#define rotinert(i)	(double) (obj[i]->mass*obj[i]->size()*obj[i]->size())

// bounce - from xasteroids
// cause two objects to collide elastically	
void bounce(int i, int j )
{
double	temp;
Vector	vi, vj,		// velocity of objs i, j		
	ij,		// vector from center of i to center of j 
	vi_ij, vj_ij,	// velocity of obj along vector ij	
	vipij, vjpij,	// velocity perpendicular to ij		
	vi_ijf, vj_ijf;	// post-collision velocity along ij	

vi.x = obj[i]->xvel; vi.y = obj[i]->yvel;
vj.x = obj[j]->xvel; vj.y = obj[j]->yvel;
ij.x = obj[j]->x - obj[i]->x; ij.y = obj[j]->y - obj[i]->y;
ij.mag = sqrt(ij.x*ij.x + ij.y*ij.y);
/*
Calculate velocities projected onto ij;
	vi_ij = vi*cos(a) = (vi dot ij) / |ij|		*/
vi_ij.mag = dot(vi, ij) / ij.mag;
vi_ij.x = (ij.x * vi_ij.mag) / ij.mag;
vi_ij.y = (ij.y * vi_ij.mag) / ij.mag;
vj_ij.mag = dot(vj, ij) / ij.mag;
vj_ij.x = (ij.x * vj_ij.mag) / ij.mag;
vj_ij.y = (ij.y * vj_ij.mag) / ij.mag;
if (vi_ij.mag - vj_ij.mag < 0)	/* Objs moving away from each other -
	Since objs are round (at least when bouncing), this means
	they are moving away from each other already.	*/
	return;
/*
Calculate component of velocities perpendicular to ij:
	|vipij| = |vi|*sin(a) = |vi x ij| / |ij|
Same as
	|vipij| = |vi|*cos(M_PI/2 - a) = (vi dot (perp. to ij)) / |ij|	*/
temp = vi.y*ij.x - vi.x*ij.y;	// - (cross product when 3rd coord is 0)
temp /= (ij.mag*ij.mag);
vipij.x = -ij.y*temp; vipij.y = ij.x*temp;
temp = (vj.x*ij.y - vj.y*ij.x) / (ij.mag*ij.mag);
vjpij.x = -ij.y*temp; vjpij.y = ij.x*temp;
/*
Calculate the linear elastic collision along ij:
	mass(i)*vi_ij + mass(j)*vj_ij = mass(i)*vi_ijf + mass(j)*vj_ijf
	vi_ij + vi_ijf = vj_ij + vj_ijf	(derived by dividing equation
	for conservation of kinetic energy
	 by eq. for cons. of momentum) */
temp = obj[i]->mass/obj[j]->mass;
vj_ijf.x = (temp * (2*vi_ij.x - vj_ij.x) + vj_ij.x) / (1 + temp);
vj_ijf.y = (temp * (2*vi_ij.y - vj_ij.y) + vj_ij.y) / (1 + temp);
vi_ijf.x = vj_ijf.x + vj_ij.x - vi_ij.x;
vi_ijf.y = vj_ijf.y + vj_ij.y - vi_ij.y;
/*
Now, given vi_ijf and vj_ijf, add them to the perpendicular
	components to get final velocity vectors		*/
obj[i]->xvel = vi_ijf.x + vipij.x;
obj[i]->yvel = vi_ijf.y + vipij.y;
obj[j]->xvel = vj_ijf.x + vjpij.x;
obj[j]->yvel = vj_ijf.y + vjpij.y;

}


// botline - modified from xasteroids
void botline() 
{	
	char text[70];
	int	y;
	
	y = HEIGHT-Ui::fontHeight();

	// new ship every 10000 points, weeee...
	if (score/10000 > oldscore/10000)
		{
		ships++;
		oldscore = score;
		}
	
	sprintf(text, "Ships:%2d   Score:%6d   Shield:", ships, score );

	gl_setwritemode(WRITEMODE_MASKED);
	gl_write(0, y, text);
	gl_setwritemode(WRITEMODE_OVERWRITE);
	
	// show shield energy level if shield is on
	if (playerShip.shielded())
		{
		int l;
		l = (int)(30.0*playerShip.shieldPercent());
		
		gl_line( 262, y+3, 292   ,y+3, 254);
		gl_line( 262, y+4, 262+l ,y+4, 255);
		gl_line( 262, y+5, 262+l ,y+5, 255);
		gl_line( 262, y+6, 292   ,y+6, 254);
		}
}

void printss() {};

// upscore - from xasteroids
void upscore(int killer, int up)	// Only award score for things the player shot 
{	
	if (killer != ENEMYBUL && killer != SHIP)
		score = score + up;
}

// All boom code straight from xasteroids
// boom, movebooms, drawbooms all by Peter Phillips 
void boom(int ob, int particles, int duration)
{
  int i;
  unsigned int r1, r2;
  Boom b;
  double x, y;
  double angle, length;

  b = (Boom) malloc(sizeof(struct _Boom));
  b->dur = duration;
  b->part = particles;
  x = obj[ob]->x;
  y = obj[ob]->y;
  for (i = 0; i < particles; i++) {
    r1 = (rand() >> 2) % 100;
    r2 = (rand() >> 2) % 7;

    b->bcoord[i][0] = x;
    b->bcoord[i][1] = y;
    angle = r1 * M_PI / 50.0;
    length = 3 + r2;
    b->bvec[i][0] = cos(angle) * length + obj[ob]->xvel;
    b->bvec[i][1] = sin(angle) * length + obj[ob]->yvel;
  }
  b->next = blist;
  blist = b;
}

// move the various booms that are active 
void movebooms()
{
  int i;
  Boom b, prevb;

  prevb = NULL;
  b = blist;
  while (b != NULL) {
    b->dur--;
    if (b->dur < 0) { // delete this boom 
      Boom temp;

      temp = b;
      if (prevb == NULL) {
        blist = b->next;
      } else {
        prevb->next = b->next;
      }
      b = b->next;
      free(temp);
    } else {  // move boom, advance list 
      for (i = 0; i < b->part; i++) {
        b->bcoord[i][0] += b->bvec[i][0];
        b->bcoord[i][1] += b->bvec[i][1];
      }
      prevb = b;
      b = b->next;
    }
  }
}

// Draw the various booms 
void drawbooms()
{
  int i;
  Boom b;

  b = blist;
  while (b != NULL) {
    for (i = 0; i < b->part; i++) {
      gl_setpixel( (int) b->bcoord[i][0],(int) b->bcoord[i][1] , RED );
    }
    b = b->next;
  }
}

void deletebooms()	// delete all booms 
{	Boom b;

	b = blist;
	while (b != NULL)
	{	b->dur = 0;
		b = b->next;
}	}

// killast - modified from xasteroids
void killast(int killer, int i)
	// i = Asteroid # to kill	
{	

	int k=0, na=0, oldna=0;

	if (obj[i]->shape == ASTSHAPE1)
	{	na = nextast();		// Could put 6 lines in a sub 
		obj[na]->x = obj[i]->x;
		obj[na]->y = obj[i]->y;
		obj[na]->xvel = obj[i]->xvel;
		obj[na]->yvel = obj[i]->yvel;
		obj[na]->alive++;
		obj[na]->shape = ASTSHAPE2;
		obj[na]->setBitmap(medast);
		obj[na]->mass = M_MED;
		
		obj[i]->shape = ASTSHAPE2;
		obj[i]->setBitmap(medast);
		obj[i]->mass = M_MED;
		blastpair(i, na);
		boom(i, 30, 12);
		numasts++;
		if (numasts == 2)	// Big asteroid was last remaining 
			upscore(killer, 25+level*2000);
		else	upscore(killer, 25);
	}
	else if (obj[i]->shape == ASTSHAPE2)
	{
		for (k = 0; k < 3; k++)
		{	oldna = na;
			na = nextast();
			obj[na]->x = obj[i]->x;
			obj[na]->y = obj[i]->y;
			obj[na]->xvel = obj[i]->xvel;
			obj[na]->yvel = obj[i]->yvel;
			obj[na]->alive++;
			obj[na]->shape = ASTSHAPE3;
			obj[na]->setBitmap(smallast);
			obj[na]->mass = M_SMALL;
			if (k == 1) blastpair(oldna,na);
		}
		obj[i]->shape = ASTSHAPE3;
		obj[i]->setBitmap(smallast);
		obj[i]->mass = M_SMALL;
		blastpair(na, i);
		boom(i, 20, 10);
		if (numasts == 1) upscore(killer, 500*level);
		numasts = numasts + 3;
		upscore(killer, 50);
	}
	else if (obj[i]->shape == ASTSHAPE3)
	{	boom(i, 10, 8);
		obj[i]->alive = 0; numasts--; upscore(killer, 100);}
	else	// enemy {ship or bullet}	
	{	boom(i, 9, 7);
		obj[i]->alive = 0; upscore(killer, 500);}
}

// moveobjs - modified from xasteroids
int moveobjs()
{	
	int i, j, crash=0;	// Indexes

	movebooms();

	// tell each object to pass 1 frame of time

	for (i = 0; i < LASTOBJ+1; i++)
		if (obj[i]->alive)
			obj[i]->tick();

	// check for collisions			
	
	for (i = 0; i < FBUL; i++)
	    if (obj[i]->alive)
	    {
		if (playerShip.alive && collide(i, SHIP))
		{	if (playerShip.shielded()) bounce(SHIP, i);
			else
			{	crash = 2;
				ships--; playerShip.alive = 0;
				killast(SHIP, i);
				continue;
		}	}
		for (j = ENEMYBUL; j < LASTBUL+1; j++)
			if (obj[j]->alive && collide(i, j) &&
			   (j != ENEMYBUL || (i != ENEMYBUL && i != ENEMY)))
			{	obj[j]->alive = 0;	// Kill the bullet 
				// Don't have 2 bullets kill same asteroid
				if (obj[i]->alive) killast(j,i);
			}
	    }
	 
return crash;
}

// fire - modified from xasteroids
void fire()
{	
	double *shiprot, cosrot, sinrot;

	obj[nextbul]->alive++;
	shiprot = &playerShip.rot;
	cosrot = cos(*shiprot); sinrot = sin(*shiprot);
	obj[nextbul]->x = playerShip.x + 10 * cosrot;
	obj[nextbul]->y = playerShip.y + 10 * sinrot;
	obj[nextbul]->xvel = playerShip.xvel + 10 * cosrot;
	obj[nextbul]->yvel = playerShip.yvel + 10 * sinrot;
	obj[nextbul]->rot = *shiprot;
	obj[nextbul]->setTime(WIDTH/11);	// loops before bullet expires	
	nextbul++; if (nextbul == LASTBUL+1) nextbul = FBUL;
}

// hyper - modified from xasteroids
void hyper()
{	
	unsigned char c;
	unsigned int i;

	c = rand(); i = c; i<<=2;	// 0 - 1024	
	while (i > WIDTH) i -= WIDTH;
	playerShip.x = (double) i;
	c = rand(); i = c; i<<=2;	// 0 - 1024	
	while (i > HEIGHT) i -= HEIGHT;
	playerShip.y = (double) i;
}


// return 1=easy, 4=medium, 8=hard
int selectLevel()
{
	Ui::drawToPhysical();
	gl_clearscreen(0);

	gl_write(24,25, "Please select starting skill level:");
	gl_write(128,80,"1 - Easy");
	gl_write(128,90,"2 - Medium");
	gl_write(128,100,"3 - Hard");
	
	while (1)
		switch (getchar()) {
			case '1': return 1;
			case '2': return 5;
			case '3': return 10;
			case 'q': return 0;
			case 'Q': return 0;
			}
return 0;
}

void showInfo() 
{
Ui::drawToPhysical();
gl_clearscreen(0);
gl_setpalette(&backScn);
back.put(0,0);

gl_setwritemode(WRITEMODE_MASKED);

gl_write(120,0,"Sasteroids");

gl_write(10,20,"Playing the game:");
gl_write(10,30,"");
gl_write(10,40,"   Key               Action");
gl_write(10,50,"  -----    --------------------------");
gl_write(10,60,"    z      turn ship left");
gl_write(10,70,"    x      turn ship right");
gl_write(10,80,"    m      fire");
gl_write(10,90,"    n      thrust");
gl_write(10,100,"    b      shield on, once per ship");
gl_write(10,110,"  SPACE    Hyperspace, zap to another");
gl_write(10,120,"           part of the screen.");
gl_write(10,130,"    p      pause/resume");
gl_write(10,140,"    q      quit game");
gl_write(6,160,"Send bug reports, patches, sounds");
gl_write(6,170,"or cool bitmaps to pitzel@cs.sfu.ca");

gl_write(104,190,"(Press any key)");
gl_setwritemode(WRITEMODE_OVERWRITE);

};

void showTitle()
{
	Ui::drawToPhysical();

	gl_clearscreen(0);
	gl_setpalette(&titleScn);
	title.put(0,0);

	gl_setwritemode(WRITEMODE_MASKED);

	gl_write(110,105,"'i' for information");
	gl_write(110,115,"'h' for high scores");
	gl_write(110,125,"'s' to start game");
	gl_write(110,135,"'q' to quit");
	gl_setwritemode(WRITEMODE_OVERWRITE);
}


// get name for high scores list
String getHighScoreName()
{
char buf[21];

for(int i=0; i<21; i++) buf[i]=' ';    

Ui::drawToPhysical();

gl_clearscreen(0);

gl_write( 20, 30, "Whooohoo!");
gl_write( 20, 40, "You made the high score list.");

gl_write( 20, 60, "Please enter you name :" );

Ui::input( 20, 80, buf, 20 );

return String(buf);
}


// show high scores screen
void showScores( HiScore &s )
{
int i;
char buf[10];
String line;

Ui::drawToPhysical();
gl_clearscreen(0);
gl_setpalette(&backScn);
back.put(0,0);

gl_setwritemode(WRITEMODE_MASKED);
gl_write(120,0,"HIGH SCORES");

for(i=0; i<HiScoreListSize; i++)
	{
	sprintf(buf,"%d.",i+1);
	gl_write(40,40+15*i,buf);
	
	line = s[i];
	gl_write(70,40+15*i, (char *)(const char*)line );
	}

gl_write(104,190,"(Press any key)");
gl_setwritemode(WRITEMODE_OVERWRITE);
}


// game over - keep animation going for either 5 secs or user hits 'q'
void gameOverLoop()
{
const int loops = 10 * FPS;
int i,j;

gl_setwritemode(WRITEMODE_MASKED);

for(j=0; j<loops; j++)
	{
	if ( (vga_getkey()!=0) && (j>FPS) ) return;
	
	moveobjs();

	//	Draw objects
	for (i = 0; i <= LASTOBJ; i++)
	if (obj[i]->alive)
		{
		obj[i]->draw();
		}
		
	drawbooms();

	gl_write(120,100,"Game  Over");
	botline();
	
	Ui::updateScreen();
	gl_clearscreen(0);
	Timer::sync();
	}

gl_setwritemode(WRITEMODE_OVERWRITE);
}

	
// play a game..
void playGame()
{
	int	keyHit,showTimings=0;	    	
	char	text[70];		// for showTimings mode
		
	double  dx, dy, dist;

	int pause = 0, 
	    enemycount,
	    i;

	char GameOver = 0;
	
	deletebooms();
	ships = 3;
	score = 0; oldscore = -1;

	level = selectLevel();

	numasts = 0;
		
	unsigned char c=0;
	playerShip.newShip(WIDTH/2,HEIGHT/2);
	
        setBPcolormap(); // set palette to game bitmaps' colors 

	        
        //gl_setcontext(&physicalscreen);
        //gl_setclippingwindow(0,0,WIDTH-1,HEIGHT-1);
        //gl_enableclipping();

	// all drawing takes place on the virtual screen 
	Ui::drawToVirtual();
	gl_clearscreen(0);
		
	Timer::init();	// get animation timer ready
	
	while (!GameOver)
	    {   
	    if (numasts==0) 
		{
		if (level<15) level++;
		makeasts();
		}

	    playerShip.alive = (ships > 0);
	    enemycount = 20;
	    
	    
	    while ( (numasts) && (!GameOver) )
	    {	
		keyHit = vga_getkey();
	 
		    switch (keyHit)
			    {	
				case 'z':
				case 'Z': // TURN COUNTER CLOCK WISE
				    playerShip.rotLeft();
				    break;

				case 'x':
				case 'X': // TURN CLOCK WISE
				    playerShip.rotRight();
				    break;

				case 'n':  // THRUST
				case 'N':
				    playerShip.thrust();
				    break;
				    
				case 'm':  // FIRE
				case 'M':
				    if (playerShip.alive) 
				    	fire(); 
				    break;
				    
				case ' ': // POOF!
				    if (playerShip.alive)
				       {
				       hyper();
				       }
				    break;

				case 'b': // Shield on
				case 'B':
				    	playerShip.shield();
					break;
					
				case 'p': // Pause
				case 'P':
				    pause = 1 - pause; 
				    break;
				    
				case 't': // toggle show timings mode
				case 'T':
				    showTimings = 1 - showTimings; 
				    break;
				    
				case '+':   // cheat
				    ships++; 
				    break;
				    
				case 'q':  // quit
				case 'Q':
				    if (Ui::yesNo("End This Game"))
				    	{
				    	GameOver = 1;
				    	}
				    break;
				    
				case 's':	// start new ship 
				    if (!playerShip.alive)
					if (ships < 1) GameOver=1;
					else playerShip.newShip(WIDTH/2,HEIGHT/2);
				    break;
			    }

		if (!pause)
		   {   
		   // returns non-zero if player has crashed/been shot
		   if (moveobjs())
			{   
			boom(SHIP, BMAX-1, 70);
			}
		    
		   if ( (ships) && (score>0) ) score--;	// timer effect	
		   
		   
		   if (!ships) {
		   	GameOver = 1;
		   	gameOverLoop();
		   	}
		   
			
		    //	Draw objects
		    for (i = 0; i <= LASTOBJ; i++)
		    if (obj[i]->alive)
		    		{
				obj[i]->draw();
				}
		
		   drawbooms();

		   }
		    i = (rand()>>8) & 255;
		    if (!obj[ENEMY]->alive)
			{   if (i < level)
			    {	c = rand();
				if (c < level * 10) makeenemy();
			}   }
		    else
		    {	i += (playerShip.y > obj[ENEMY]->y)
				? level>>1 : -(level>>1);
			obj[ENEMY]->yvel += (i>128+6*obj[ENEMY]->yvel) ? .5 : -.5;
		    }

		    enemycount--; if (!enemycount)
		    {	enemycount = 100;
			if (obj[ENEMY]->alive)
			{   obj[ENEMYBUL]->alive++;
			    obj[ENEMYBUL]->x = obj[ENEMY]->x;
			    obj[ENEMYBUL]->y = obj[ENEMY]->y;
			    dx = playerShip.x - obj[ENEMY]->x;
			    dy = playerShip.y - obj[ENEMY]->y;
			    dist = sqrt(dx*dx + dy*dy);
			    obj[ENEMYBUL]->xvel = 3*dx/dist;
			    obj[ENEMYBUL]->yvel = 3*dy/dist;
			}
			else	obj[ENEMYBUL]->alive = 0;
		    }

		    if (!playerShip.alive)
		    	{
		    	gl_setwritemode(WRITEMODE_MASKED);

		    	gl_write( (WIDTH>>1) - 8*11,
		    	           HEIGHT>>1,
		    	           "Press 's' for next ship");
			gl_setwritemode(WRITEMODE_OVERWRITE);
			}
		
		
		// Comment out these three lines if you uncomment the
		// three lines further below to show frame timings     
		if (!showTimings)
			{
			botline();
			Ui::updateScreen(); gl_clearscreen(0);
			Timer::sync();   
			}
		else
			{
			// time how long to create one frame of animation
			Ui::updateScreen(); gl_clearscreen(0);
			sprintf(text,"usec per frame: %d",  Timer::sync() );
			gl_write(0, HEIGHT-Ui::fontHeight(), text);
			}


		} //while (numasts)
	} //for(level..
}


int main(int argc, char **argv)
{	
	HiScore	scores(".SastScores");
	
	Ui::init();	// init vga, ui stuff

	// randomize using timer
	srand( (unsigned int) time(NULL) );

	titleScnInit();	 // define title screen bitmaps, color map
	bitmapInit();	 // define bitmaps, color map 
	backScnInit();
	setBits();	 // scale asteroid bitmap for small asteroids,
			 // create rotated ship bitmaps

	initObjArray();

	Timer::setFrameRate( FPS );

	int done=0;
	
	showTitle();
	
    while(!done)
        {
	switch(getchar())
		{
		case 'h':
		case 'H': 
			showScores(scores);
			getchar();
			showTitle();
			break;
			
		case 'i':
		case 'I':
			showInfo();
			getchar();
			showTitle();
			break;
			
		case 's':
		case 'S':
			playGame();
			
        		// if score was good enough, add to high score list
        		if (scores.isHigh(score) != -1)
        			{
        			scores.add( getHighScoreName() , score );
        			showScores(scores);
				getchar();
				showTitle();
        			}
        		else	showTitle();
			break;
			
		case 'q':
		case 'Q':
			if (Ui::yesNo("Do you wish to quit"))
	   			done=1;
	   		else	showTitle();
	   		break;
	   	}	
	}
	
	// shutdown & restore text mode
	Ui::restore();	

return 0;
}
