/*
   sigs.cc

   This file is part of LuxMan.
   
   Copyright (C) 1994,1995 Frank McIngvale (frankm@nuance.com)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <signal.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>
#include <rawkey/rawkey.h>
#include <gtools/gr.h>
#include "globals.h"
#include "sndclient.h"

void do_sig( char *fmt, ... )
{
  va_list list;

  snd_close_server();
  kill( gb_pid_sndserver, SIGTERM );

  va_start( list, fmt );
  
  rawmode_exit();
  gr_close();

  printf("*****************************************************************************\n");
  vprintf( fmt, list );
  printf("*****************************************************************************\n");

  exit(1);
}
  
void sig_kill( int i )
{
  do_sig( "Got SIGKILL\n");
}

void sig_int( int i )
{
  do_sig( "Got SIGINT\n");
}

void sig_quit( int i )
{
  do_sig( "Got SIGQUIT\n");
}

void sig_ill( int i )
{
  do_sig( "Got SIGILL\n");
}

void sig_trap( int i )
{
  do_sig( "Got SIGTRAP\n");
}

void sig_abrt( int i )
{
  do_sig( "Got SIGABRT\n");
}

void sig_iot( int i )
{
  do_sig( "Got SIGIOT\n");
}

void sig_bus( int i )
{
  do_sig( "Got SIGBUS\n");
}

void sig_fpe( int i )
{
  do_sig( "Oops! Floating point error.\n");
}

void sig_segv( int i )
{
  do_sig( "Oops! A segment violation has occurred. See if you can\n\
reproduce this and please report it to the author. Thanks.\n");
}

void sig_alrm( int i )
{
  do_sig( "Oops! The program has apparently become stuck in\n\
an infinite loop. See if you can reproduce what happened and\n\
report this to the author. Thanks.\n");
}

void sig_term( int i )
{
  do_sig( "Got SIGTERM\n");
}

void set_sig_handlers()
{
  signal( SIGKILL, sig_kill );
  signal( SIGINT, sig_int );
  signal( SIGQUIT, sig_quit );
  signal( SIGILL, sig_ill );
  signal( SIGTRAP, sig_trap );
  signal( SIGABRT, sig_abrt );
  signal( SIGIOT, sig_iot );
  signal( SIGBUS, sig_bus );
  signal( SIGFPE, sig_fpe );
  signal( SIGKILL, sig_kill );
  signal( SIGSEGV, sig_segv );
  signal( SIGALRM, sig_alrm );
  signal( SIGTERM, sig_term );
}

