/*
   mkfont.cc

   Utility to make a libgtools font set from bitmaps.
   
   Copyright (C) 1994,1995 Frank McIngvale (frankm@nuance.com)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <gtools/font.h>

/*
 * Usage:
 *
 * 	mkfont fontfile template_file
 *
 * mkfont reads in (up to) 255 seperate bitmap files and
 * creates a font file from them.
 *
 * mkfont takes as its input a file of the form (the `template_file'):
 *
 * 0:	zero.map
 * 1:	one.map
 * .
 * .
 * 254:	f254.map
 * 255:	f255.map
 *
 * i.e., a file with (up to) 255 tagged lines specifying what
 * bitmap to use for that character.
 *
 * The tags do not have to be in order, and they do not all have
 * to be present.
 *
 * If tags are repeated, later ones override earlier ones.
 */

char *gb_library_path = ".";

#include <stdarg.h>
void fatal( char *fmt, ... )
{
  va_list ap;

  va_start( ap, fmt );
  vprintf( fmt, ap );
  exit(1);
}

/*
 * int parse_tag_number( int *tag, char *linebuf )
 *
 * Expects a line of the form:
 *
 * tag:	value
 *
 * Returns the numeric value of `tag' in *tag.
 *
 * Returns 0 on success, -1 on failure (parse error).
 */
int parse_tag_number( int *tag, char *linebuf )
{
  char *p;
  
  p = strchr( linebuf, ':' );
  if ( !p )
	return -1;

  *p = 0;
  *tag = atoi( linebuf );
  *p = ':';		/* Replace zapped : */

  return 0;
}

/*
 * int parse_tag_value( char *val, char *linebuf )
 *
 * Expects `linebuf' to contain a line of the form:
 *
 * tag:	value
 *
 * Copies the text of `value' into `val'.
 * Skips leading/trailing whitespace.
 *
 * Returns 0 on success, -1 on failure (parse error).
 *
 * Note: Empty value strings are considered valid.
 */
int parse_tag_value( char *val, char *linebuf )
{
  char *p, *e;
  char c;
  
  p = strchr( linebuf, ':' );
  if ( !p )
	return -1;

  ++p;

  /* Skip leading ws */
  while( *p && strchr( " \t", *p ) )
	++p;

  /* Empty value string? */
  if ( !*p || strchr( "\r\n", *p ) )
	{
	  /* Yes */
	  val[0] = 0;
	  return 0;
	}

  e = p;

  /* Find end of string */
  while( *e && !strchr( " \t\r\n", *e ) )
	++e;

  c = *e;
  *e = 0;
  strcpy( val, p );
  *e = c;		/* Restore zapped char */

  return 0;
}

#if 0
int is_comment( char *linebuf )
{}

int is_empty( char *linebuf )
{}
#endif	/* 0 */

int main( int argc, char *argv[] )
{
  FILE *fp;
  Font font;
  char linebuf[300], name[300];
  int i, tag;
  
  if ( argc < 3 )
	{
	  printf("Usage: mkfont font_file template_file\n");
	  return -1;
	}

  fp = fopen( argv[2], "r" );
  if ( !fp )
	{
	  printf("Error: Can't open template `%s'\n", argv[2] );
	  return -1;
	}

  /* Init font with 0x0 maps */
  for( i=0; i<255; ++i )
	font.map[i] = new Bitmap( 0,0 );

  /* Read all lines from template file */
  while( fgets( linebuf, 299, fp ) != NULL )
	{
	  if ( parse_tag_number( &tag, linebuf ) != 0 ||
		  parse_tag_value( name, linebuf ) != 0 )
		{
		  printf("Error: Can't parse line `%s'\n", linebuf );
		  return -1;
		}

	  if ( tag < 0 || tag > 255 )
		{
		  printf("Error: Bad tag value `%d'\n", tag );
		  return -1;
		}
	  
	  /* Delete current map entry */
	  delete font.map[tag];

	  /* Read new map entry */
	  font.map[tag] = new Bitmap( name );
	}

  fclose( fp );

  fp = fopen( argv[1], "r" );
  if ( !fp )
	{
	  printf("Error: Can't create font file `%s'\n", argv[1] );
	  return -1;
	}

  font_write( fp, &font );
  fclose( fp );

  return 0;
}


  



