/*
 * Solitaire game (name unknown)
 *
 * Copyright (C) Evan Harris, 1991, 1994
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

#define QUIT			-1
#define NEWGAME			-2
#define RESTART			-3
#define SAVE			-4
#define OPEN			-5
#define UNDO			-6

#define NEW			0
#define LAST			1

#define POSN(col, row)		((col) * 100 + (row))
#define ROW(pos)		((pos) % 100)
#define COL(pos)		((pos) / 100)
#define NOPOSN			-1


#define CARD(suit, type)	((suit) * 13 + (type))
#define NOCARD			255
#define SUIT(card)		((card) / 13)
#define TYPE(card)		((card) % 13)
#define ISCARD(card)		((card) >= 0 && (card) < 52)


#define NUMCARDS		52
#define COLUMNS			7


#define SPADES			0
#define CLUBS			1
#define HEARTS			2
#define DIAMONDS		3

#define ACE			0
#define TWO			1
#define THREE			2
#define FOUR			3
#define FIVE			4
#define SIX			5
#define SEVEN			6
#define EIGHT			7
#define NINE			8
#define TEN			9
#define JACK			10
#define QUEEN			11
#define KING			12


extern unsigned char	column[COLUMNS];	/* First card of column */
extern short		cards[NUMCARDS];	/* Positions of cards */
extern unsigned char	next[NUMCARDS];		/* Card underneath */
extern unsigned char	hidden[NUMCARDS];	/* Cards which are face down */


void	main(int, char **);
void	exit(int);

void	Abort(char *);
void	InitDisplay(int, char **);
void	EndDisplay(void);
void	DisplayColumn(short);

void	InitRandom(unsigned char);
long	Random(long);
void	Deal(void);

short	GetCmd(void);
short	FindDest(unsigned char);
void	MakeMove(unsigned char, short);

void	AddUndo(unsigned char, unsigned char, short);
void	Undo(void);
void	UndoMove(unsigned char, short, unsigned char);
