/* $Id: opensock.c,v 30000.22 1993/05/25 01:04:48 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

/*
 * Fugue socket opener
 *
 * Used by socket.c or tf.connect.c to find
 * find the host and open a socket to it.
 */

#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#ifdef WINS
# include <sys/in.h>
# include <sys/inet.h>
#else
# include <netinet/in.h>
#endif
#include "port.h"
#include "tf.h"
#include "tf.connect.h"

#ifndef INADDR_NONE
# define INADDR_NONE 0xffffffff        /* should be in <netinet/in.h> */
#endif

static int FDECL(get_host_address,(char *name, struct in_addr *addr));
int FDECL(open_sock,(char *host, char *port, struct sockaddr_in *addr, int *tfcerrnop));

static int get_host_address(name, addr)
    char *name;
    struct in_addr *addr;
{
    struct hostent *host;

    if ((addr->s_addr = inet_addr(name)) == INADDR_NONE) {
        /* Numeric format failed.  Try name format. */
        if (!(host = gethostbyname(name))) return 0;
        memcpy(addr, host->h_addr, sizeof(struct in_addr));
    }
    return 1;
}

int open_sock(name, port, addr, tfcerrnop)
    char *name, *port;
    struct sockaddr_in *addr;
    int *tfcerrnop;
{
    int fd;
    struct servent *service;

    *tfcerrnop = TFC_OK;
    addr->sin_family = AF_INET;

    if (isdigit(*port)) {
        addr->sin_port = htons(atoi(port));
    } else if ((service = getservbyname(port, "tcp"))) {
        addr->sin_port = service->s_port;
    } else {
        *tfcerrnop = TFC_SERVICE;
        return -1;
    }
    if (!get_host_address(name, &addr->sin_addr)) {
        *tfcerrnop = TFC_CANT_FIND;
        return -1;
    }
    if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        *tfcerrnop = TFC_ESOCKET;
    }
    return fd;
}
