/* $Id: dstring.h,v 30000.22 1993/05/21 08:48:09 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef DSTRING_H
#define DSTRING_H

#ifdef USE_STRING_H
# include <string.h>
#endif
#ifdef USE_STRINGS_H
# include <strings.h>
#endif

#ifndef HAVE_STRCHR
# ifdef HAVE_INDEX
#  define strchr(s, c) index((s), (c))
# endif
#endif

#ifndef HAVE_MEMCPY
# ifdef HAVE_BCPY
#  define memcpy(dst, src, len) bcopy((src), (dst), (len))
# endif
#endif

typedef struct String {
    char *s;
    unsigned int len, maxlen;
} String, Stringp[1];          /* Stretchybuffer */

#ifdef DMALLOC
#define Stringinit(str) dStringinit(str, __FILE__, __LINE__)
#endif

/* This saves time, but make sure function it is used in cannot call
 * itself, or overwriting may occur.
 */
#define STATIC_BUFFER(name) \
    static Stringp (name); \
    static int buffer_inited = FALSE; \
    if (!buffer_inited) { \
        Stringinit((name)); \
        buffer_inited = TRUE; \
    }


#ifdef DMALLOC
extern String *FDECL(dStringinit,(Stringp str, char *file, int line));
#else
extern String *FDECL(Stringinit,(Stringp str));
#endif
extern void    FDECL(Stringfree,(Stringp str));
extern String *FDECL(Stringadd,(Stringp str, int c));
extern String *FDECL(Stringnadd,(Stringp str, int c, unsigned int n));
extern String *FDECL(Stringterm,(Stringp str, unsigned int len));
extern String *FDECL(Stringcpy,(Stringp dest, char *src));
extern String *FDECL(SStringcpy,(Stringp dest, Stringp src));
extern String *FDECL(Stringncpy,(Stringp dest, char *src, unsigned int len));
extern String *FDECL(Stringcat,(Stringp dest, char *src));
extern String *FDECL(SStringcat,(Stringp dest, Stringp src));
extern String *FDECL(Stringncat,(Stringp dest, char *src, unsigned int len));
extern char   *FDECL(getword,(Stringp str, char *line));
extern String *FDECL(stripString,(Stringp str));
extern String *FDECL(newline_package,(Stringp buffer, unsigned int n));

#endif /* DSTRING_H */
