;;; relog - recall into a log
; syntax:  /relog <file> <recall_arguments>
; Starts logging, and silently performs a /recall into the log file.

/def relog = \
    /def -hprocess -1 -agG =\
        /def -h"kill %%1" -1 -agG%%;\
        /def -hlog -1 -ag = \
            /echo %%%% Recalling to log file %1%%;\
        /log %1%;\
    /quote -0 /_relog %1 #%-1%;\

/def _relog = \
    /def -hprocess -1 -agG = \
        /def -h"kill %%1" -1 -agG%%;\
        /unset _ARG%;\
    /setenv _ARG=%-1%;\
    /quote -0 !echo "$$_ARG" >> %1

