/* config.h */

#ifndef __CONFIG_H
#define __CONFIG_H

#include "copyright.h"
#include "version.h"

/* *********** READ THIS BEFORE YOU MODIFY ANYTHING IN THIS FILE *********** */
/* WARNING:  All options in this file have the ability to signifigantly change
 * the look and feel and sometimes even internal behavior of the program.
 * The ones shipped as the default have been extensively tested.  Others have
 * been tested to a (usually) lesser degree, and therefore might still have
 * latent bugs.  If you change any of them from the default, PLEASE check
 * to make sure that you know the full effects of what you are changing. And
 * if you encounter any errors or compile time problems with any options
 * other than the default settings, PLEASE inform lwl@eniac.seas.upenn.edu
 * immediately, so that they can be fixed.  The same goes for any other bug
 * you might find in using this software.  All efforts will be made to fix
 * errors encountered, but unless given a FULL description of the error,
 * (IE telling me that logging in doesn't work is insufficient.  telling
 * me that logging in with WCREAT undefined still gives you the registration
 * message is a lot better.  MOST effective would be a full dbx trace, or a
 * patch for the bug.)  Enjoy using the program.
 */
/* ************************************************************************* */

/* Uncomment this if on a Xenix System. Please note that the xenix code
 * has not been touched for _ages_ and you'll have to hack it yourself.
 * (As of 1.50.p5, this code is no longer in the distribution. FTP an
 * older version if you MUST have it.)
 */
/* #define XENIX */

/* Uncomment this if on a Xenix system with Xsockets. Once again note that
 * the code is ancient and will need to be hacked. See note for XENIX.
 */
/* #define XSOCKET */

/* Uncomment this if on a SysV machine */
#ifndef i386      /* Already defined under linux */
#define i386
#endif

/* Uncomment this if on a HP-UX or AIX system.
 * Note: some of the HP-UX changes apply to other SystemV-derived
 * UNIX flavors. If you are trying to compile on an IRIX, box or
 * similar system, you may want to try defining this.
 */
/* #define HPUX */

/* Uncomment this if you are on a machine running SunOS or some other
 * system which has a similar mix of BSD and SysV-isms. If this is not
 * defined, certain functions (like strdup()) will be provided (since
 * Ultrix machines, NeXTs, and most other systems don't have them).
 */
/* #define SUN_OS */

/* Uncomment this if you want to use the Virus (Robert Hood) Concentrator
 * package.  A must if you want to have more than fifty-odd (depending
 * on your system) users at once.
 * As of 1.50.p5, this code is no longer included in the distribution,
 * since it has not been updated in the past year. If you really want to
 * hack at it, ftp an earlier patchlevel.
 */
/* #define CONCENTRATOR */

/* Define this if you want to limit the maximum number of logins to the
 * MUSH. This is useful if you know that you have a certain peak number
 * before the MUSH freezes (which happens if you run out of file descriptors)
 * or if you're running under a max-number-of-players restriction.
 */
/* #define LOGIN_LIMIT */

/* Uncomment this if you want the machine to return a name instead of an
 * IP number.  The code without this defined looks screwy, so I would leave
 * it defined unless you feel like fixing it.
 */
#define HOST_NAME

/* Define this if you want the ability to lock out certain sites.  This code
 * will take wildcards. Sites to lock out should be put in lockout.txt
 * Sites to put on registration status should be in sites.txt
 * If you define this, you will also need to define WCREAT.
 */
#define LOCKOUT

/* Define this if you want to enable registration commands. If LOCKOUT
 * is defined, this should be too. Running with both this and LOCKOUT
 * defined will allow you to register certain sites. Running with this
 * but not LOCKOUT puts all sites on registration status.
 */
#define WCREAT

/* Define this if you are running 24 hours a day and wish to autorestart 
 * WARNING: You must have an autorestart script in order to use this! One 
 * isn't provided here. If you know how to write one, chances are that you 
 * can read C well enough to figure out how this works.
 */
/* #define AUTORESTART */

/* Define this if you want an "official" guest character. A guest character
 * may not change his name or password, and may not build. You may wish to
 * describe and @atrlock the guest. You will probably want this option if
 * you use WCREAT.
 */
#define GUEST_RESTRICT

/* This should only be defined if your machine does not have toupper and
 * memcpy already defined.
 */
/* #define BRAIN_DAMAGE */

/* Define this if you wish to allow objects to be recycled.
 * As of version 1.19 of this code, using PennMUSH without this 
 * defined is no longer supported.
 */
#define DESTROY

/* Define this if you wish to allow players to steal money from each other */
/* #define ROBBERS */

/* One method of slowing bloat.  This method requires all builders to have
 * a builder bit to build.
 */
#define RESTRICTED_BUILDING

/* Define the following if you wish to allow object building.  Only useful
 * if RESTRICTED_BUILDING is defined.
 */
#define FREE_OBJECTS

/* An alternate method of slowing bloat.  This allows builders only X objects
 * period.  Wizards can check and set quotas on players.  If used in
 * conjunction with RESTRICTED_BUILDING, expect VERY slow growth.
 */
/* #define QUOTA */

/* Define this ONLY if you have a small maximum database size, and are
 * about to reach it. This will limit the number of objects allowed to
 * whatever number you set as DBTOP_MAX (defined later in this file).
 * Even wizards are subject to this maximum.
 */
/* #define BUILDING_LIMIT */
 
/* Defining this adds a simple tracking allocator of allocs and frees that
 * keeps ref counts of what sort of memory is allocated, and how many.
 * Good for testing for Memory leaks. Don't, however, define this unless
 * 1. It's really necessary.  2. You know what you're doing.
 */
/* #define MEM_CHECK */

/* This configuration option should normally be turned on, unless you have
 * something on your MUSH which creates and destroys objects very quickly,
 * thus causing the MUSH to scream about free list corruption very frequently.
 */
#define REPORT_TRACES

/* Define the following if you want the database stored in compressed format
 * via the compress system command.  If this is enabled PANIC saves will NOT
 * be compressed, so you will need to compress them before restarting if they
 * are good saves.
 */
#define DBCOMP

/* Define the following if you are running on a machine so small that you
 * cannnot fork a process off to do the save.
 */
/* #define NO_FORK */

/* This is the message that will be shown to players when the game dumps,
 * if forking is disabled.
 */
#define DUMP_NOFORK_MESSAGE   \
   "GAME: Dumping. The game will freeze for a few minutes."

#ifndef NO_FORK
/* Define this if you wish to use vfork() instead of fork() */
/* #define USE_VFORK */
#endif

/* Defining the following will show an expanded flag name list when you 
 * examine an object
 */
#define FLAGS_ON_EXAMINE

/* Defining this will cause passwords to be stored as straight text rather
 * that encrypted via the unix crypt() command.
 */
/* #define NOCRYPT */

/* Boolexp_debugging should only be defined if you are testing new boolexp
 * locks, etc.  otherwise, leave it undefined.
 */
/* #define BOOLEXP_DEBUGGING */

/* Define the following for increased wizard invisibility.  If it's enabled,
 * says and poses by DARK wizards will show up as 'Someone ....'
 * pages are not affected.
 */
#define FULL_INVIS

/*  Define this if you want @listen/@ahear/@aahear/@amhear to work on
 *  players as well as objects.
 */
#define PLAYER_LISTEN

/* Define this if you do not want @pemit to notify the person doing the
 * @pemitting (2.0-style).
 */
/* #define SILENT_PEMIT */

/* Define the following if you wish to have a TinyTIM like @doing command.
 */
#define AT_DOING

/*
 * Define the following to enable the ROYALTY flag.  Players with
 * this flag set have limited wiz powers: ie, they can look, examine,
 * and @tel like wizards, but may not change things like wizards.
 */
#define ROYALTY_FLAG

/* Define the following to enable @whereis commands, and loc() on players
 * by other players.  Both of these commands are modified by the effect
 * of the PLAYER_UNFIND flag.
 */
#define PLAYER_LOCATE

/* Comment this out if you don't wish to use the built-in mail system. 
 * The @mail command provides a flexible hardcoded mail system, which
 * uses its own database to store messages. 
 */
#define USE_MAILER

/* Define the following if you wish to enable global exits and commands.
 * Exits in the Master Room are considered global, as are user-defined
 * $commands on objects in the Master Room.
 */
#define DO_GLOBALS

/* If this is defined, the zone of a player's location will be checked for
 * an ACONNECT/ADISCONNECT attribute when the player connects/disconnects.
 * If DO_GLOBALS is also defined, the master room will also be checked
 * for an ACONNECT/ADISCONNECT.
 */
#define GLOBAL_CONNECTS

/*  The chat channels system allows players to talk cross-MUSH to each
 *  other, without needing to be in the same room. Whether or not you
 *  want this depends on what type of MUSH you want. Set the value of
 *  CHAT_SYSTEM to one of the following, depending on what you want:
 *    0  -- do not use chat system, use database without chat field
 *    1  -- do not use chat system, use database with chat field
 *    2  -- use chat system, convert database to use chat
 *    3  -- use chat system, use database that already has chat field
 *  NOTE: Once you add chat to the database, you can't get rid of it!
 */
#define CHAT_SYSTEM 0

/* Comment this out if you wish to run without the INHERIT flag. This
 * flag prevents objects without it from @forcing, @setting, or
 * @triggering objects with the flag, or with a wizbit. This makes doing
 * secure objects much easier. However, it can make programming certain
 * objects somewhat clumsy, and may cause some initial confusion and
 * frustration when first used on a MUSH not used to it.
 */
#define INHERIT_FLAG

/* If this is defined, another file similar to News and Help can be used
 * to store text, retrieved with "events <whatever>". This is useful if
 * your newsfile is starting to get huge and kludgy.
 */
/* #define EVENTS */

/* If this is defined, the clock will be displayed in 24-hour "military time"
 * format. Otherwise, some functions (such as the idle message for 'page')
 * will return 12-hour time.
 */
#define MILITARY_TIME

/* Define this if you want NOSPOOF notification to show both the name of
 * the spoofing object and its object number. If this option is not
 * defined, nospoof notification will only show the name of the spoofer.
 */
/* #define PARANOID_NOSPOOF */

/* Define the following if you want an inactivity timeout - the game
 * will automatically boot players who idle too long.
 */
/* #define IDLE_TIMEOUT */

/* Define this if you wish to be able to send and receive pages from
 * other MUSHes. This will not endanger the MUSH's network at all.
 */
/* #define ALLOW_RPAGE */

/* Define the following if you are converting an older datatabase
 * (PernMUSH 1.15 and earlier) to this version of code. This modifies the 
 * database for use/page and enter/teleport locks. Compile and start the 
 * game with this option the first time, then do an immediate @shutdown, 
 * recompile with this undefined, and restart. Warning: if you do not 
 * remember to recompile, any enter or page locks will be lost.
 */
/* #define ADD_LOCKS */

/* Define the following if you need to modify the database to use
 * zones. You must do this the first time you convert an existing
 * database that is version PernMUSH 1.16 or earlier.
 */
/* #define ADD_ZONES */

/* Define this if you are converting a 1.18 or earlier database. This
 * adds the STARTUP flag to objects which need it. Compile, start up
 * the MUSH, @shutdown, and then compile without this option and restart
 * again, to add the STARTUP flag.
 */
/* #define ADD_STARTUP_FLAG */

/* Define this if you're converting from version 1.19 or earlier.
 * This option sets up the database to deal with parent objects.
 */
/* #define ADD_PARENTS */

/* Objects which are NO_COMMAND are not checked for $commands. You can
 * speed up your server somewhat this way. If you want to make the best
 * use of this flag, define this option, which will automatically set
 * the NO_COMMAND flag on all rooms and players in your current database.
 */
/* #define ADD_NO_COMMAND_FLAG */

/* This option uses the old method of coping with newlines. 
 * If you're converting from a database that might have hard newlines,
 * load with this defined and do a "@dump/paranoid". Otherwise, ignore it.
 */
/* #define OLD_NEWLINES */

#ifdef USE_SMALLOC
/* Define the following ONLY if using SMALLOC.C, and if you want accurate
 * malloc stats.
 */
/* #define SLOW_STATISTICS */
#endif /* USE_SMALLOC */

/* Define the following to get extra debug info into the log file */
/* #define DEBUG */

#ifdef CONCENTRATOR
/* 
 * Define the following if you want consistancy checking while using
 * the Virus concentrator code.
 */
#define CHECKC
#endif

/*----- default files -----*/

/* The format for the three following files is one site or name per
 * line in the file. These files may be modified at any time, including
 * while the MUSH is running.
 */

#ifdef LOCKOUT
/* sites in the lockout file will have connections shut down immediately
 * with no message. Sites in the register file will not be able to
 * create new players. Wildcards are allowed.
 */
#define LOCKOUT_FILE "lockout.conf"      
#define REGISTER_FILE "sites.conf"       
#endif                          /* LOCKOUT */

/* these names may not be used as player names. Wildcards are not allowed. */
#define NAMES_FILE "names.conf"

/*----- log files -----*/

/* The primary log file for the MUSH is defined in the restart script.
 * Checkpoints are written to a separate log, as are connects and
 * disconnects from the game, commands used by wizards, report traces,
 * and player commands. The defaults are listed below.
 */

#define CHECKLOG  "log/checkpt.log"
#define CONNLOG   "log/connect.log"
#define WIZLOG    "log/wizard.log"
#define TRACELOG  "log/trace.log"
#define CMDLOG    "log/command.log"

/*----- Costs, dbref definitions, etc. -----*/

/* Uber-wizard */
#define GOD ((dbref) 1)
#define God(x) ((x) == GOD)

/* minimum cost to create various things */
#define OBJECT_COST 10
#define EXIT_COST 1
#define LINK_COST 1
#define ROOM_COST 10
#define QUEUE_COST 10		/* deposit on commands in the queue */
#define QUOTA_COST 1		/* quota cost of building an object */

/* cost for various special commands */
#define FIND_COST 100
#define PAGE_COST 0

/* costs of kill command */
#define KILL_BASE_COST 100      /* prob = expenditure/KILL_BASE_COST */
#define KILL_MIN_COST 10
#define KILL_BONUS 50           /* paid to victim */
#define MAX_ARG 100             /* maximum comma's arguments to function
				 * (like @switch) */

#define QUEUE_LOSS 63		/* one command in 16 will cost one penny */
                                /* must be a power of two minus 1 */

#ifdef QUOTA
#define START_QUOTA "20"	/* starting building quota for new players */
#endif /* QUOTA */

#ifdef BUILDING_LIMIT
#define DBTOP_MAX  20000        /* max number of objects in the database */
#endif /* BUILDING_LIMIT */

/* limit on player name length */
#define PLAYER_NAME_LIMIT 16

/* magic cookies */
#define LOOKUP_TOKEN '*'
#define NUMBER_TOKEN '#'
#define ARG_DELIMITER '='

/* magic command cookies */
#define SAY_TOKEN '"'
#define POSE_TOKEN ':'
#define SEMI_POSE_TOKEN ';'
#define CHAT_TOKEN '+'

/* delimiter for lists of exit aliases */
#define EXIT_DELIMITER ';'

/* amount of object endowment, based on cost */
#define MAX_OBJECT_ENDOWMENT 100
/* max value a wiz can put on an object */
#define MAX_WIZ_OBJECT_ENDOWMENT 2000

#define OBJECT_ENDOWMENT(cost) (((cost)-5)/5)

/* !!! added for recycling, return value of object */
#ifdef DESTROY
#define OBJECT_DEPOSIT(pennies) ((pennies)*5+5)
#endif /* DESTROY */

/* amount at which temple stops being so profitable */
#define MAX_PENNIES 100000

/* How deep can indirect locks go? */
#define MAX_DEPTH 10

/* How many generations back can parents go? */
#define MAX_PARENTS 10

#ifdef CONCENTRATOR
/* port used if the virus concentrator is installed */
#define INTERNAL_PORT 7372
#endif /* CONCENTRATOR */

#define QUIT_COMMAND "QUIT"
#define WHO_COMMAND "WHO"
#define LOGOUT_COMMAND "LOGOUT"

#ifdef AT_DOING
#define DOING_COMMAND "DOING"
#endif

#ifdef RWHO_SEND
#ifdef FULL_RWHO
#define RWHO_COMMAND "RWHO"
#endif 
#endif

#define PREFIX_COMMAND "OUTPUTPREFIX"
#define SUFFIX_COMMAND "OUTPUTSUFFIX"

/*----- timer.c defines -----*/

/* Note: Don't make times multiples of each other
 * otherwise players will have to wait a long time when
 * two or more events coincide
 */

/* time is in seconds */
#define FIXUP_INTERVAL 601	/* fixup free list every 10 minutes */

#define GARBAGE_CHUNK 3		/* recopy 3 objetcs/sec */

/*----- interface.c stuff -----*/

#ifdef XENIX
#define MAX_INPUT 4096		/* only used in xenix.c */
#endif
#define MAX_OUTPUT 16384
#define COMMAND_TIME_MSEC 1000	/* time slice length in milliseconds */
#define COMMAND_BURST_SIZE 100	/* commands allowed per user in a burst */
#define COMMANDS_PER_TIME 1	/* commands per time slice after burst */

/* If this is a xenix system redefine srandom and random */
#ifdef XENIX
#define random rand
#define srandom srand
#endif

#ifdef i386			/* if SYSV */
#define srand srandom
#define rand random
#endif

#ifdef HPUX
#define random rand
#define srandom srand
#endif                          /* HPUX */

#ifdef BRAIN_DAMAGE		/* a kludge to get it to work on a mutant
				 * DENIX system */
#undef toupper
#endif

/* ---  DO NOT CHANGE ANYTHING BELOW THIS LINE --- */

/* now to kludge around new-style config directives */

typedef struct options_table OPTTAB;

struct options_table {
  char mud_name[128];
  int port;
  char input_db[256];
  char output_db[256];
  char crash_db[256];	
  int guest_player;
  int player_start;
  int master_room;
  int idle_timeout;
  int dump_interval;
  int dump_counter;
  int max_logins;
  int paycheck;
  int starting_money;
  int player_queue_limit;
  char money_singular[32];
  char money_plural[32];
  char help_file[256];
  char help_index[256];
  char news_file[256];
  char news_index[256];
  char events_file[256];
  char events_index[256];
  char connect_file[256];
  char motd_file[256];
  char wizmotd_file[256];
  char newuser_file[256];
  char register_file[256];
  char quit_file[256];
  char down_file[256];
  int log_commands;
  int log_huhs;
  int log_forces;
  int login_allow;
  int daytime;
  int player_flags;
  int room_flags;
  int exit_flags;
  int thing_flags;
#ifdef RWHO_SEND
  int rwho_interval;
  int rwho_counter;
  int rwho_port;
  char rwho_host[64];
  char rwho_pass[64];
#endif
};

extern OPTTAB options;

#define DUMP_INTERVAL       (options.dump_interval)
#define INACTIVITY_LIMIT    (options.idle_timeout)

#ifdef LOGIN_LIMIT
#define MAX_LOGINS      (options.max_logins)
#endif

#define  HELPTEXT	(options.help_file)
#define  HELPINDX	(options.help_index)

#define  NEWS_FILE      (options.news_file)
#define  NEWSINDX       (options.news_index)

#define NEW_CONNECT_MSG_FILE  (options.newuser_file)
#define WELCOME_MSG_FILE      (options.connect_file)
#define CONNECT_MSG_FILE      (options.motd_file)
#define WIZARD_MSG_FILE       (options.wizmotd_file)
#define REGISTER_MSG_FILE     (options.register_file)
#define LEAVE_MSG_FILE        (options.quit_file)
#define DISABLE_MSG_FILE      (options.down_file)

#ifdef EVENTS
#define EVENT_FILE            (options.events_file)
#define EVENTINDX             (options.events_index)
#endif

/* dbrefs are in the conf file */

#ifndef GUEST_RESTRICT
#define Guest(x) (0)
#else
#define GUEST_PLAYER   (options.guest_player)
#define Guest(x) ((x) == GUEST_PLAYER)
#endif

#define TINYPORT         (options.port)
#define PLAYER_START     (options.player_start)
#define MASTER_ROOM      (options.master_room)
#define MONEY            (options.money_singular)
#define MONIES           (options.money_plural)

#define START_BONUS      (options.starting_money)
#define PAY_CHECK        (options.paycheck)

#define QUEUE_QUOTA      (options.player_queue_limit)

#define MUDNAME          (options.mud_name)
#define DEF_DB_IN	 (options.input_db)
#define DEF_DB_OUT	 (options.output_db)

#ifdef RWHO_SEND
#define RWHO_INTERVAL    (options.rwho_interval)
#define RWHOSERV         (options.rwho_host)
#define RWHOPORT         (options.rwho_port)
#define RWHOPASS         (options.rwho_pass)
#endif

#endif /* __CONFIG_H */
