#include <stats.h>
#include <config.h>

inherit "/complex/room";

object tmp;

void reset() {
    if (!tmp || environment(tmp) != this_object()) {
	tmp = clone_object("/obj/weapon");
	tmp->set_id( ({"knife"}));
	tmp->set_value(10);
	tmp->set_short("A knife");
	tmp->set_long("A sharp knife.\n");
	tmp->move(this_object());
	tmp->set_encumbrance(5);
	tmp->set_max_damage(3, 20);
	tmp->init_weapon_data(({ "skill", "offensive", "sharp", "knife" }),
			      ({ STAT_STR, STAT_DEX, STAT_DEX, STAT_INT }),
			      3, 20, LEARNING_1);
    }
}

void create() {
    set_short("A green lawn");
    set_long("You are standing on a big green lawn.\n" +
	     "There is a hedge to the east and south.\n");
    set_exits(({ "/room/start3", "/room/start2" }),
	      ({ "north", "west" }) );
    set_light(1);
    set_item_descriptions(({"hedge", "lawn"}),
			  ({"The hedge looks dense.\n",
			    "Well... It look green.\n"}));
    reset();
}
