inherit "/basic/container";

#include "config.h"

int x, y;	/* The coordinates of this room */

/*
 * Decode our coordinates.
 */
void init_koordinates() {
    if (sscanf(file_name(this_object()), "/room/map/m%d_%d", x, y) != 2) {
	write("init_koordinates bad file name: " +
	      file_name(this_object()) + "\n");
	throw("Bad argument to init_koordinates: " +
	      file_name(this_object()));
    }
}

string query_short() {
    return (string)MAP_OB->get_terrain_string(x, y);
}

string query_long(string str) {
    return "You are standing in a terrain type of " + query_short() +
	".\n";
}

/*
 * Allow movements to other map objects.
 */
void init() {
    add_action("move_map", "west");
    add_action("move_map", "south");
    add_action("move_map", "north");
    add_action("move_map", "east");
}

int move_map(string arg) {
    int x1, y1;

    if (arg)
	return 0;
    x1 = x; y1 = y;
    if (query_verb() == "west")
	x1--;
    else if (query_verb() == "east")
	x1++;
    else if (query_verb() == "north")
	y1++;
    else if (query_verb() == "south")
	y1--;
    this_player()->move_player("/room/map/m" + x1 + "_" + y1);
    return 1;
}

void create() {
    if (file_name(this_object()) == "/room/map/base")
	return;
    init_koordinates();
    set_max_internal_encumbrance(10000);
    set_light(1);
}

/*
 * This room in the map will self-destruct at next clean_up if nothing
 * is left inside this object. If it returns 1, then clean_up will be called
 * again at a later time.
 */
int clean_up() {
    if (file_name(this_object()) == "/room/map/base")
	return 0;
    if (first_inventory(this_object()))
	return 1;
    destruct(this_object());
    return 0;
}

/*
 * This tells the game driver to remove this file after loading.
 */
int volatile() {
    return 1;
}
