#include <config.h>
#include <stats.h>

private int *stats;

static void init_stats() {
    int i;

    stats = allocate(STAT_NUMBER);
    for (i=0; i < STAT_NUMBER; i++)
	stats[i] = 1;
}

int query_stat(int stat) {
    return EXP_TO_PERCENT(stats[stat]);
}

/*
 * For now, we simply allow being forced.
 */
void force_me(string cmd) {
    command(cmd);
}

void reward_stat(int stat, int points) {
    int i, old;

    old = stats[stat];
    stats[stat] += points;
    if (EXP_TO_PERCENT(old) < EXP_TO_PERCENT(stats[stat]))
	write("You now have a better stat in " + STAT_NAMES[stat] + ".\n");
}
