inherit "/basic/id";
inherit "/basic/move";
inherit "/basic/description";
inherit "/basic/value";
inherit "/basic/weapon_logic";

string query_short() {
    if (query_wield())
	return description::query_short() + " (wielded)";
    else
	return description::query_short();
}

string query_long(string str) {
    if (query_wield())
	return description::query_long(str) + "It is wielded.\n";
    else
	return description::query_long(str);
}

/*
 * Redefine the move function, so that wielded weapons can be marked as
 * no longer wielded.
 */
int move(mixed dest) {
    if (query_wield()) {
	/* Tell the player object it is no longer wielded. */
	this_player()->unwield(this_object());
	/* Update local logic, that we are no longer wielded. */
	stop_wield();
    }
    return move::move(dest);
}
