#include "config.h"

/*
 * Used for save and restore a player.
 * It is not possible to immediately call save_object and restore_object,
 * because the player will not have the rights to do so. Therefore,
 * functions will be called in the master object, that will give the
 * player object temporary priviledges.
 */

private string save_file_name(string name) {
    return "/players/" + extract(name, 0, 0) + "/" + name;
}

/*
 * This one is called at login, to restore player data from saved file.
 * Return 0 for no save file, which means a new player.
 * Otherwise, restore player variables and return 1.
 */
int restore_player(string name) {
    int res;

    seteuid(0);		/* Allow the master object to give us another uid */
    res = (int)MASTER_OB->load_player_from_file(name, this_object());
    /* The restore has now been done. */
    seteuid(name);	/* Set back the usual euid. */
    return res;
}

/*
 * This one will be called from the master object, which will grant us
 * uid "root" temporarily.
 */
nomask int
actually_restore_player(string name) {
    int res;
    seteuid((string)MASTER_OB->get_root_uid());
    res = restore_object(save_file_name(name));
    seteuid(0);		/* We will get back the original uid */
    return res;
}

void save_player(string name) {
    seteuid(0);
    MASTER_OB->save_player_to_file(name, this_object());
    seteuid(name);
}

void assure_save_dir_exists(string file) {
    string *elems;
    string path;
    int i;

    elems = explode(file, "/");
    path = "";
    for (i=0; i < sizeof(elems) - 1; i++) {
	path += "/" + elems[i];
	if (file_size(path) == -1) {
	    write("Make dir " + path + "\n");
	    mkdir(path);
	}
    }
}

/*
 * This one will be called from the master object, which will grant us
 * uid "root" temporarily.
 */
nomask void
actually_save_player(string name) {
    string tmp;

    seteuid((string)MASTER_OB->get_root_uid());
    assure_save_dir_exists(save_file_name(name));
    save_object(save_file_name(name));
    seteuid(0);
}
