#include "config.h"
#include "move_failure.h"

/*
 * Enable moving of this object.
 */

private int encumbrance;

/*
 * The argument 'dest' is either a string or an object.
 */
int move(mixed dest) {
    object ob;

    if (stringp(dest)) {
	if (MAP_OBJECT(dest)) {
	    ob = (object)MASTER_OB->create_map_object(dest);
	} else {
	    call_other(dest, "??");
	    ob = find_object(dest);
	}
    } else
	ob = dest;

    if (!dest->receive_objects())
	return MOVE_NOT_ALLOWED;

    if ((int)dest->exit(this_object()))
	return MOVE_NOT_ALLOWED;

    if (living(this_object()) && living(ob))
	return MOVE_NOT_ALLOWED;

    if (!dest->add_encumbrance(encumbrance))
	return MOVE_NO_ROOM;

    if (environment(this_object()))
	environment(this_object())->add_encumbrance(-encumbrance);
    move_object(this_object(), ob);
    return MOVE_OK;
}

void set_encumbrance(int enc) {
    encumbrance = enc;
}

int query_encumbrance() {
    return encumbrance;
}

/*
 * To destruct objects, call 'remove()' in the object. The default here
 * is to allow destruction and update encumbrance.
 * All objects inside this object is also moved to the "outside" (if any).
 */
void remove() {
    object super;
    int i;
    object *ob_list;

    super = environment(this_object());
    if (super) {
	super->add_encumbrance(-encumbrance);
	ob_list = all_inventory(this_object());
	for (i=0; i < sizeof(ob_list); i++)
	    ob_list[i]->move(super);
    }
    destruct(this_object());
}
