# module.tcl --
#
#	Loads, initializes, and reloads modules.
#

namespace eval NSModule {

variable ModulePriv

proc AddModule {module source} {

	variable ModulePriv

	set ModulePriv(loaded,$module) 0
	set ModulePriv(source,$module) $source
}

proc LoadIfNeeded module {

	variable ModulePriv

	# Already been loaded
	if $ModulePriv(loaded,$module) {
		return 0
	}

	# Source the file
	uplevel #0 source $ModulePriv(source,$module)

	# Init the module
	${module}::InitModule

	# Okay, it's loaded
	set ModulePriv(loaded,$module) 1

	return 1
}

proc RebootModule module {

	variable ModulePriv

	# Already been loaded
	if $ModulePriv(loaded,$module) {

		namespace delete ::$module
		set ModulePriv(loaded,$module) 0
	}

	# Load the module
	LoadIfNeeded $module
}

# namespace eval NSModule
}
