/* File: tables.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	5	/* 18/210-18/219 */,
	5	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	2	/* 9 */,
	2	/* 10 */,
	2	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	16	/* 18/200-18/209 */,
	16	/* 18/210-18/219 */,
	16	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99	/* 3 */,
	99	/* 4 */,
	99	/* 5 */,
	99	/* 6 */,
	99	/* 7 */,
	50	/* 8 */,
	30	/* 9 */,
	20	/* 10 */,
	15	/* 11 */,
	12	/* 12 */,
	11	/* 13 */,
	10	/* 14 */,
	9	/* 15 */,
	8	/* 16 */,
	7	/* 17 */,
	6	/* 18/00-18/09 */,
	6	/* 18/10-18/19 */,
	5	/* 18/20-18/29 */,
	5	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	3	/* 18/100-18/109 */,
	2	/* 18/110-18/119 */,
	2	/* 18/120-18/129 */,
	2	/* 18/130-18/139 */,
	2	/* 18/140-18/149 */,
	1	/* 18/150-18/159 */,
	1	/* 18/160-18/169 */,
	1	/* 18/170-18/179 */,
	1	/* 18/180-18/189 */,
	1	/* 18/190-18/199 */,
	0	/* 18/200-18/209 */,
	0	/* 18/210-18/219 */,
	0	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130	/* 3 */,
	125	/* 4 */,
	122	/* 5 */,
	120	/* 6 */,
	118	/* 7 */,
	116	/* 8 */,
	114	/* 9 */,
	112	/* 10 */,
	110	/* 11 */,
	108	/* 12 */,
	106	/* 13 */,
	104	/* 14 */,
	103	/* 15 */,
	102	/* 16 */,
	101	/* 17 */,
	100	/* 18/00-18/09 */,
	99	/* 18/10-18/19 */,
	98	/* 18/20-18/29 */,
	97	/* 18/30-18/39 */,
	96	/* 18/40-18/49 */,
	95	/* 18/50-18/59 */,
	94	/* 18/60-18/69 */,
	93	/* 18/70-18/79 */,
	92	/* 18/80-18/89 */,
	91	/* 18/90-18/99 */,
	90	/* 18/100-18/109 */,
	89	/* 18/110-18/119 */,
	88	/* 18/120-18/129 */,
	87	/* 18/130-18/139 */,
	86	/* 18/140-18/149 */,
	85	/* 18/150-18/159 */,
	84	/* 18/160-18/169 */,
	83	/* 18/170-18/179 */,
	82	/* 18/180-18/189 */,
	81	/* 18/190-18/199 */,
	80	/* 18/200-18/209 */,
	80	/* 18/210-18/219 */,
	80	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- pet summoning table
 * This also doubles as a pet charming table for sacred monsters.
 */
byte adj_chr_pet_summon[] =
{
  0	/* 3 */,
  0	/* 4 */,
  0	/* 5 */,
  1	/* 6 */,
  1	/* 7 */,
  1	/* 8 */,
  2	/* 9 */,
  2	/* 10 */,
  2	/* 11 */,
  3	/* 12 */,
  3	/* 13 */,
  3	/* 14 */,
  4	/* 15 */,
  4	/* 16 */,
  4	/* 17 */,
  5	/* 18/00-18/09 */,
  6	/* 18/10-18/19 */,
  7	/* 18/20-18/29 */,
  8	/* 18/30-18/39 */,
  9	/* 18/40-18/49 */,
  10	/* 18/50-18/59 */,
  11	/* 18/60-18/69 */,
  12	/* 18/70-18/79 */,
  13	/* 18/80-18/89 */,
  14	/* 18/90-18/99 */,
  14	/* 18/100-18/109 */,
  14	/* 18/110-18/119 */,
  15	/* 18/120-18/129 */,
  15	/* 18/130-18/139 */,
  15	/* 18/140-18/149 */,
  16	/* 18/150-18/159 */,
  16	/* 18/160-18/169 */,
  16	/* 18/170-18/179 */,
  17	/* 18/180-18/189 */,
  17	/* 18/190-18/199 */,
  17	/* 18/200-18/209 */,
  18	/* 18/210-18/219 */,
  19	/* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	7	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	9	/* 18/110-18/119 */,
	10	/* 18/120-18/129 */,
	11	/* 18/130-18/139 */,
	12	/* 18/140-18/149 */,
	13	/* 18/150-18/159 */,
	14	/* 18/160-18/169 */,
	15	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	17	/* 18/190-18/199 */,
	18	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	3	/* 18/30-18/39 */,
	3	/* 18/40-18/49 */,
	4	/* 18/50-18/59 */,
	4	/* 18/60-18/69 */,
	5	/* 18/70-18/79 */,
	5	/* 18/80-18/89 */,
	6	/* 18/90-18/99 */,
	7	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	9	/* 18/120-18/129 */,
	10	/* 18/130-18/139 */,
	11	/* 18/140-18/149 */,
	12	/* 18/150-18/159 */,
	13	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	15	/* 18/180-18/189 */,
	16	/* 18/190-18/199 */,
	17	/* 18/200-18/209 */,
	18	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	4	/* 18/00-18/09 */,
	4	/* 18/10-18/19 */,
	4	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	5	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	5	/* 18/60-18/69 */,
	6	/* 18/70-18/79 */,
	6	/* 18/80-18/89 */,
	7	/* 18/90-18/99 */,
	8	/* 18/100-18/109 */,
	8	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	8	/* 18/130-18/139 */,
	8	/* 18/140-18/149 */,
	9	/* 18/150-18/159 */,
	9	/* 18/160-18/169 */,
	9	/* 18/170-18/179 */,
	9	/* 18/180-18/189 */,
	9	/* 18/190-18/199 */,
	10	/* 18/200-18/209 */,
	10	/* 18/210-18/219 */,
	10	/* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	3	/* 18/00-18/09 */,
	3	/* 18/10-18/19 */,
	3	/* 18/20-18/29 */,
	4	/* 18/30-18/39 */,
	4	/* 18/40-18/49 */,
	5	/* 18/50-18/59 */,
	6	/* 18/60-18/69 */,
	7	/* 18/70-18/79 */,
	8	/* 18/80-18/89 */,
	9	/* 18/90-18/99 */,
	10	/* 18/100-18/109 */,
	10	/* 18/110-18/119 */,
	11	/* 18/120-18/129 */,
	12	/* 18/130-18/139 */,
	13	/* 18/140-18/149 */,
	14	/* 18/150-18/159 */,
	15	/* 18/160-18/169 */,
	16	/* 18/170-18/179 */,
	17	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	19	/* 18/200-18/209 */,
	19	/* 18/210-18/219 */,
	19	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 1	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 2	/* 18/20-18/29 */,
	128 + 2	/* 18/30-18/39 */,
	128 + 2	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 3	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 2	/* 18/00-18/09 */,
	128 + 2	/* 18/10-18/19 */,
	128 + 3	/* 18/20-18/29 */,
	128 + 3	/* 18/30-18/39 */,
	128 + 3	/* 18/40-18/49 */,
	128 + 3	/* 18/50-18/59 */,
	128 + 3	/* 18/60-18/69 */,
	128 + 4	/* 18/70-18/79 */,
	128 + 5	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 10	/* 18/140-18/149 */,
	128 + 11	/* 18/150-18/159 */,
	128 + 12	/* 18/160-18/169 */,
	128 + 13	/* 18/170-18/179 */,
	128 + 14	/* 18/180-18/189 */,
	128 + 15	/* 18/190-18/199 */,
	128 + 16	/* 18/200-18/209 */,
	128 + 18	/* 18/210-18/219 */,
	128 + 20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 3	/* 18/10-18/19 */,
	128 + 3	/* 18/20-18/29 */,
	128 + 3	/* 18/30-18/39 */,
	128 + 3	/* 18/40-18/49 */,
	128 + 4	/* 18/50-18/59 */,
	128 + 4	/* 18/60-18/69 */,
	128 + 4	/* 18/70-18/79 */,
	128 + 4	/* 18/80-18/89 */,
	128 + 5	/* 18/90-18/99 */,
	128 + 6	/* 18/100-18/109 */,
	128 + 7	/* 18/110-18/119 */,
	128 + 8	/* 18/120-18/129 */,
	128 + 9	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3	/* 3 */,
	128 + -2	/* 4 */,
	128 + -1	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 0	/* 15 */,
	128 + 0	/* 16 */,
	128 + 0	/* 17 */,
	128 + 1	/* 18/00-18/09 */,
	128 + 1	/* 18/10-18/19 */,
	128 + 1	/* 18/20-18/29 */,
	128 + 1	/* 18/30-18/39 */,
	128 + 1	/* 18/40-18/49 */,
	128 + 1	/* 18/50-18/59 */,
	128 + 1	/* 18/60-18/69 */,
	128 + 2	/* 18/70-18/79 */,
	128 + 3	/* 18/80-18/89 */,
	128 + 4	/* 18/90-18/99 */,
	128 + 5	/* 18/100-18/109 */,
	128 + 6	/* 18/110-18/119 */,
	128 + 7	/* 18/120-18/129 */,
	128 + 8	/* 18/130-18/139 */,
	128 + 9	/* 18/140-18/149 */,
	128 + 10	/* 18/150-18/159 */,
	128 + 11	/* 18/160-18/169 */,
	128 + 12	/* 18/170-18/179 */,
	128 + 13	/* 18/180-18/189 */,
	128 + 14	/* 18/190-18/199 */,
	128 + 15	/* 18/200-18/209 */,
	128 + 15	/* 18/210-18/219 */,
	128 + 15	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5	/* 3 */,
	6	/* 4 */,
	7	/* 5 */,
	8	/* 6 */,
	9	/* 7 */,
	10	/* 8 */,
	11	/* 9 */,
	12	/* 10 */,
	13	/* 11 */,
	14	/* 12 */,
	15	/* 13 */,
	16	/* 14 */,
	17	/* 15 */,
	18	/* 16 */,
	19	/* 17 */,
	20	/* 18/00-18/09 */,
	22	/* 18/10-18/19 */,
	24	/* 18/20-18/29 */,
	26	/* 18/30-18/39 */,
	28	/* 18/40-18/49 */,
	30	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	30	/* 18/70-18/79 */,
	30	/* 18/80-18/89 */,
	30	/* 18/90-18/99 */,
	30	/* 18/100-18/109 */,
	30	/* 18/110-18/119 */,
	30	/* 18/120-18/129 */,
	30	/* 18/130-18/139 */,
	30	/* 18/140-18/149 */,
	30	/* 18/150-18/159 */,
	30	/* 18/160-18/169 */,
	30	/* 18/170-18/179 */,
	30	/* 18/180-18/189 */,
	30	/* 18/190-18/199 */,
	30	/* 18/200-18/209 */,
	30	/* 18/210-18/219 */,
	30	/* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4	/* 3 */,
	5	/* 4 */,
	6	/* 5 */,
	7	/* 6 */,
	8	/* 7 */,
	10	/* 8 */,
	12	/* 9 */,
	14	/* 10 */,
	16	/* 11 */,
	18	/* 12 */,
	20	/* 13 */,
	22	/* 14 */,
	24	/* 15 */,
	26	/* 16 */,
	28	/* 17 */,
	30	/* 18/00-18/09 */,
	30	/* 18/10-18/19 */,
	35	/* 18/20-18/29 */,
	40	/* 18/30-18/39 */,
	45	/* 18/40-18/49 */,
	50	/* 18/50-18/59 */,
	55	/* 18/60-18/69 */,
	60	/* 18/70-18/79 */,
	65	/* 18/80-18/89 */,
	70	/* 18/90-18/99 */,
	80	/* 18/100-18/109 */,
	80	/* 18/110-18/119 */,
	80	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	80	/* 18/140-18/149 */,
	90	/* 18/150-18/159 */,
	90	/* 18/160-18/169 */,
	90	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	90	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0	/* 3 */,
	0	/* 4 */,
	1	/* 5 */,
	2	/* 6 */,
	3	/* 7 */,
	4	/* 8 */,
	4	/* 9 */,
	5	/* 10 */,
	5	/* 11 */,
	6	/* 12 */,
	6	/* 13 */,
	7	/* 14 */,
	7	/* 15 */,
	8	/* 16 */,
	8	/* 17 */,
	9	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	12	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	55	/* 18/110-18/119 */,
	60	/* 18/120-18/129 */,
	65	/* 18/130-18/139 */,
	70	/* 18/140-18/149 */,
	75	/* 18/150-18/159 */,
	80	/* 18/160-18/169 */,
	85	/* 18/170-18/179 */,
	90	/* 18/180-18/189 */,
	95	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3	/* 3 */,
	4	/* 4 */,
	5	/* 5 */,
	6	/* 6 */,
	7	/* 7 */,
	8	/* 8 */,
	9	/* 9 */,
	10	/* 10 */,
	11	/* 11 */,
	12	/* 12 */,
	13	/* 13 */,
	14	/* 14 */,
	15	/* 15 */,
	16	/* 16 */,
	17	/* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	1	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	4	/* 18/70-18/79 */,
	4	/* 18/80-18/89 */,
	5	/* 18/90-18/99 */,
	6	/* 18/100-18/109 */,
	7	/* 18/110-18/119 */,
	8	/* 18/120-18/129 */,
	9	/* 18/130-18/139 */,
	10	/* 18/140-18/149 */,
	11	/* 18/150-18/159 */,
	12	/* 18/160-18/169 */,
	14	/* 18/170-18/179 */,
	16	/* 18/180-18/189 */,
	18	/* 18/190-18/199 */,
	20	/* 18/200-18/209 */,
	20	/* 18/210-18/219 */,
	20	/* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0	/* 3 */,
	1	/* 4 */,
	2	/* 5 */,
	3	/* 6 */,
	4	/* 7 */,
	5	/* 8 */,
	5	/* 9 */,
	6	/* 10 */,
	6	/* 11 */,
	7	/* 12 */,
	7	/* 13 */,
	8	/* 14 */,
	8	/* 15 */,
	9	/* 16 */,
	9	/* 17 */,
	10	/* 18/00-18/09 */,
	10	/* 18/10-18/19 */,
	15	/* 18/20-18/29 */,
	15	/* 18/30-18/39 */,
	20	/* 18/40-18/49 */,
	25	/* 18/50-18/59 */,
	30	/* 18/60-18/69 */,
	35	/* 18/70-18/79 */,
	40	/* 18/80-18/89 */,
	45	/* 18/90-18/99 */,
	50	/* 18/100-18/109 */,
	60	/* 18/110-18/119 */,
	70	/* 18/120-18/129 */,
	80	/* 18/130-18/139 */,
	90	/* 18/140-18/149 */,
	100	/* 18/150-18/159 */,
	100	/* 18/160-18/169 */,
	100	/* 18/170-18/179 */,
	100	/* 18/180-18/189 */,
	100	/* 18/190-18/199 */,
	100	/* 18/200-18/209 */,
	100	/* 18/210-18/219 */,
	100	/* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	0	/* 8 */,
	0	/* 9 */,
	0	/* 10 */,
	0	/* 11 */,
	0	/* 12 */,
	0	/* 13 */,
	1	/* 14 */,
	1	/* 15 */,
	1	/* 16 */,
	1	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	3	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	6	/* 18/130-18/139 */,
	6	/* 18/140-18/149 */,
	7	/* 18/150-18/159 */,
	7	/* 18/160-18/169 */,
	8	/* 18/170-18/179 */,
	8	/* 18/180-18/189 */,
	8	/* 18/190-18/199 */,
	9	/* 18/200-18/209 */,
	9	/* 18/210-18/219 */,
	9	/* 18/220+ */
};


/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -5	/* 3 */,
	128 + -3	/* 4 */,
	128 + -2	/* 5 */,
	128 + -1	/* 6 */,
	128 + 0	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 0	/* 14 */,
	128 + 1	/* 15 */,
	128 + 1	/* 16 */,
	128 + 2	/* 17 */,
	128 + 3	/* 18/00-18/09 */,
	128 + 4	/* 18/10-18/19 */,
	128 + 4	/* 18/20-18/29 */,
	128 + 4	/* 18/30-18/39 */,
	128 + 4	/* 18/40-18/49 */,
	128 + 5	/* 18/50-18/59 */,
	128 + 6	/* 18/60-18/69 */,
	128 + 7	/* 18/70-18/79 */,
	128 + 8	/* 18/80-18/89 */,
	128 + 9	/* 18/90-18/99 */,
	128 + 10	/* 18/100-18/109 */,
	128 + 11	/* 18/110-18/119 */,
	128 + 12	/* 18/120-18/129 */,
	128 + 13	/* 18/130-18/139 */,
	128 + 14	/* 18/140-18/149 */,
	128 + 15	/* 18/150-18/159 */,
	128 + 16	/* 18/160-18/169 */,
	128 + 18	/* 18/170-18/179 */,
	128 + 20	/* 18/180-18/189 */,
	128 + 22	/* 18/190-18/199 */,
	128 + 25	/* 18/200-18/209 */,
	128 + 25	/* 18/210-18/219 */,
	128 + 25	/* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * This has been modified by GJW and -KMW- to balance spellcasters in melee combat
 *    Lycanth/Beastmaster/
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 3; div = 2* MAX(35, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(40, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Illusionist --> num = 4; mul = 3; div = 2 * MAX(35, weapon_weight); -KMW-
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   2 },

	/* 1  */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   3 },

	/* 2  */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   4,   4,   4 },

	/* 3  */
	{  1,   2,   2,   3,   3,   4,   4,   4,   4,   5,   5,   5 },

	/* 4  */
	{  1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },

	/* 5  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 6  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 7  */
	{  2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 8  */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 9  */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 10 */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6 },

	/* 11+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   6,   6,   6,   6 },
};


#if 0

/*
 * This is the "old" table used to calculate multiple blows.
 *
 * Note that this table used a different indexing scheme to determine "P"
 */

byte old_blows_table[11][12] =
{
	/* P/D */
	/* 3,  10, /01, /50, /90,/100,/101,/110,/120,/130,/140,/150 */

	/* 0+ */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3},

	/* 2+ */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   3,   3,   4},

	/* 3+ */
	{  1,   1,   1,   2,   2,   3,   4,   4,   4,   4,   4,   5},

	/* 4+ */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5},

	/* 6+ */
	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5},

	/* 8+ */
	{  1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   5},

	/* 10+ */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},

	/* 13+ */
	{  2,   3,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6},

	/* 15+ */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},

	/* 18+ */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6},

	/* 20+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6}
};

#endif


/* 
 * New, revamped arena, thanks to prfnoff@aol.com.
 */

s16b arena_monsters[MAX_ARENAS][MAX_ARENA_MONS] = {
  /* -KMW- */
  { 
    25,   /* Kobold */
    36,   /* Novice rogue */
    91,   /* Novice rogue */
    57,   /* Black naga */
    96,   /* Snaga */
    98,   /* Cave orc */
    121,  /* Bandit */
    150,  /* Brigand */
    120,  /* Hill orc */
    82,   /* Large kobold */
    35,   /* Novice warrior */
    90,   /* Novice warrior */
    102,  /* Pink naga */
    214,  /* Forest troll */
    246,  /* Dark elven lord */ 
    174,  /* Ogre */
    78,   /* Green naga */
    278,  /* Stone troll */
    178,  /* Black orc */
    195,  /* Half-orc */
    293,  /* Algoroth */
    335,  /* Half-troll */
    338,  /* Giant skeleton troll */
    348,  /* Water troll */
    168,  /* Swordsman */
    190,  /* Black ogre */
    192,  /* Guardian naga */
    226,  /* Uruk */
    261,  /* Hardened warrior */
    199,  /* Frost giant */
    309,  /* Ice troll */
    184,  /* Hill giant */
    363,  /* Olog */
    206,  /* Orc captain */
    334,  /* Cave troll */
    420,  /* Eldrak */
    209,  /* Fire giant */
    432,  /* Spirit troll */
    230,  /* Stone giant */
    247,  /* Cloud giant */
    287,  /* Cave ogre */
    331,  /* Ninja */
    421,  /* Ettin */
    263,  /* Master rogue */
    364,  /* Dagashi */
    354,  /* Master thief */
    441   /* Minotaur */
  },

  { 
    44,   /* White harpy */
    113,  /* Brown yeek */
    147,  /* Wolf */
    17,   /* Giant yellow centipede */
    49,   /* Large yellow snake */
    99,   /* Wood spider */
    51,   /* Wild cat */
    141,  /* Giant white tick */
    87,   /* Copperhead snake */
    104,  /* Giant pink frog */
    132,  /* Giant pink ant */
    72,   /* Creeping copper coins */
    156,  /* White wolf */
    186,  /* Warg */
    97,   /* Rattlesnake */
    125,  /* Black harpy */
    122,  /* Yeti */
    109,  /* Night lizard */
    95,   /* Creeping silver coins */
    134,  /* King cobra */
    155,  /* Black mamba */
    146,  /* Creeping gold coins */
    175,  /* Creeping mithril coins */
    149,  /* Panther */
    166,  /* Tiger */
    152,  /* Hippogriff */
    245,  /* Werewolf */
    280,  /* Wereworm */
    281,  /* Carrion crawler */
    200,  /* Griffon */
    196,  /* Giant tarantula */
    198,  /* Mirkwood spider */
    135,  /* Giant spider */
    310,  /* Giant purple worm */
    169,  /* Stegocentipede */
    205,  /* Umber hulk */
    373,  /* Mumak */
    244,  /* Sasquatch */
    285,  /* Displacer beast */
    240,  /* Sabre-tooth tiger */
    327,  /* Death watch beetle */
    312,  /* Catoblepas */
    292,  /* Creeping adamantite coins */
    374,  /* Giant red ant */
    325,  /* Killer slicer beetle */
    308,  /* Basilisk */
    439   /* Giant roc */
  },

  { 
    83,   /* Skeleton kobold */
    106,  /* Zombified kobold */
    100,  /* Manes */
    119,  /* Lemure */
    164,  /* Skeleton human */
    165,  /* Zombified human */
    105,  /* Green icky thing */
    117,  /* Skeleton orc */
    185,  /* Flesh golem */
    201,  /* Homonculous */
    153,  /* Zombiefied orc */
    232,  /* Stone golem */
    204,  /* Clay golem */
    256,  /* Mummified orc */
    271,  /* Mummified human */
    219,  /* Earth spirit */
    217,  /* Water spirit */
    220,  /* Fire spirit */
    376,  /* Xorn */
    394,  /* Mummified troll */
    320,  /* Skeleton troll */
    193,  /* Light hound */
    194,  /* Dark hound */
    221,  /* Fire hound */
    222,  /* Cold hound */
    238,  /* Earth hound */
    272,  /* Vampire bat */
    349,  /* Fire elemental */
    351,  /* Water elemental */
    359,  /* Earth elemental */
    360,  /* Air elemental */
    260,  /* Black ooze */
    207,  /* Geleatinous cube */
    398,  /* Black pudding */
    179,  /* Ochre jelly */
    370,  /* Ooze elemental */
    371,  /* Smoke elemental */
    366,  /* Acidic cytoplasm */
    438,  /* Xaren */
    276,  /* Pukelman */
    300,  /* Colbran */
    390,  /* Ice elemental */
    397,  /* Magma elemental */
    318,  /* Mithril golem */
    427,  /* Night mare */
    362,  /* Eog golem */
    381   /* Colossus */
  }

};

/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store */
		{ "Bilbo the Friendly",		200,	170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",	200,	175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",		300,	170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",		300,	165, 107,  6, 18, RACE_ELF},
	},
	{
		/* Armoury */
		{ "Kon-Dar the Ugly",		5000,	210, 115,  5,  7, RACE_HALF_ORC},
		{ "Darg-Low the Grim",		10000,	190, 111,  4,  9, RACE_HUMAN},
		{ "Decado the Handsome",	25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Mauglin the Grumpy",		30000,	200, 112,  4,  5, RACE_DWARF},
	},
	{
		/* Weapon Smith */
		{ "Ithyl-Mak the Beastly",	5000,	210, 115,  6,  6, RACE_HALF_TROLL},
		{ "Arndal Beast-Slayer",	10000,	185, 110,  5,  9, RACE_HALF_ELF},
		{ "Tarl Beast-Master",		25000,	190, 115,  5,  7, RACE_HOBBIT},
		{ "Oglign Dragon-Slayer",	30000,	195, 112,  4,  8, RACE_DWARF},
	},
	{
		/* Temple */
		{ "Ludwig the Humble",		5000,	175, 109,  6, 15, RACE_HUMAN},
		{ "Gunnar the Paladin",		10000,	185, 110,  5, 23, RACE_HUMAN},
		{ "Delilah the Pure",		25000,	180, 107,  6, 20, RACE_ELF},
		{ "Bosk the Wise",			30000,	185, 109,  5, 15, RACE_DWARF},
	},
	{
		/* Alchemist */
		{ "Mauser the Chemist",		10000,	190, 111,  5,  8, RACE_HALF_ELF},
		{ "Wizzle the Chaotic",		10000,	190, 110,  6,  8, RACE_HOBBIT},
		{ "Ga-nat the Greedy",		15000,	200, 116,  6,  9, RACE_GNOME},
		{ "Sasha the Slender",		15000,	220, 111,  4,  9, RACE_ELF},
	},
	{
		/* Magic Shop */
		{ "Ariel the Sorceress",	20000,	200, 110,  7,  8, RACE_HALF_ELF},
		{ "Buggerby the Great",		20000,	215, 113,  6, 10, RACE_GNOME},
		{ "Inglorian the Mage",		30000,	200, 110,  7, 10, RACE_HUMAN},
		{ "Luthien Starshine",		30000,	175, 110,  5, 11, RACE_HIGH_ELF},
	},
	{
		/* Black Market */
		{ "Lo-Hak the Awful",		20000,	250, 150, 10,  5, RACE_HALF_TROLL},
		{ "Histor the Goblin",		20000,	250, 150, 10,  5, RACE_HALF_ORC},
		{ "Durwin the Blue",		25000,	250, 150, 10,  5, RACE_KOBOLD},
		{ "Drago the Fair",			30000,	250, 150, 10,  5, RACE_ELF},
	},
	{
		/* Home */
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99},
		{ "Your home",				0,      100, 100,  0, 99, 99}
	}
};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};







/*
 * Base experience levels, may be adjusted up for race and/or class
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	10,
	25,
	45,
	70,
	100,
	140,
	200,
	280,
	380,
	500,
	650,
	850,
	1100,
	1400,
	1800,
	2300,
	2900,
	3600,
	4400,
	5400,
	6800,
	8400,
	10200,
	12500,
	17500,
	25000,
	35000L,
	50000L,
	75000L,
	100000L,
	150000L,
	200000L,
	275000L,
	350000L,
	450000L,
	550000L,
	700000L,
	850000L,
	1000000L,
	1250000L,
	1500000L,
	1800000L,
	2100000L,
	2400000L,
	2700000L,
	3000000L,
	3500000L,
	4000000L,
	4500000L,
	5000000L
};


/*
 * Player Sexes
 *
 *	Title,
 *	Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"Queen"
	},

	{
		"Male",
		"King"
	},
	
	{ "Neuter", "Ruler" }
};


/*
 * Player Races
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_thn, r_thb,
 *      ------------------------------------------------------
 *      Meaning:
 *
 *      disarm, device, saving throw, stealth, search ability, 
 *      search frequency, melee, long-range
 *
 *	hitdie, exp base,
 *	Age (Base, Mod),
 *	Male (Hgt, Wgt),
 *	Female (Hgt, Wgt)
 *	infra,
 *	class-choices (Modified to include illusionist -KMW-)
 *
 *      Special race color. (attribute) 0 for default.
 *      Special race character. 0 for default.
 *
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,
		10,  100,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		0x7F,

		0,
		0
	},

	{
		"Half-Elf",
		{ -1,  1,  0,  1, -1,  1 },
		2,  3,  3,  1, 6,  11, -1,  5,
		9,  110,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		0x3F,

		0,
		0
	},

	{
		"Elf",
		{ -1,  2,  1,  1, -2,  1 },
		5,  6,  6,  1, 8,  12, -5, 15,
		8,  120,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		0x1F,

		0,
		'h'
	},

	{
		"Hobbit",
		{ -2,  2,  1,  3,  2,  1 },
		15, 18, 18, 4, 12,  15, -10, 20,
		7,  110,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		0x0B,

		TERM_UMBER,
		'h'
	},

	{
		"Gnome",
		{ -1,  2,  0,  2,  1, -2 },
		10, 12, 12,  3, 6,  13, -8, 12,
		8,  125,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		0x0F,

		TERM_L_BLUE,
		'h'
	},

	{
		"Dwarf",
		{  2, -3,  2, -2,  2, -3 },
		2,  9,  9,  -1,  7,  10, 15,  0,
		11,  120,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		0x05,

		TERM_L_DARK,
		'h'
	},

	{
		"Half-Orc",
		{  2, -1,  0,  0,  1, -4 },
		-3, -3, -3,  -1,  0, 7, 12, -5,
		10,  110,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		0x0D,

		TERM_SLATE,
		'o'
	},

	{
		"Half-Troll",
		{ 4, -4, -2, -4,  3, -6 },
		-5, -8, -8, -2,  -1, 5, 20, -10,
		12,  120,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		0x05,

		TERM_SLATE,
		'T'
	},

	{
		"Dunadan",
		{  1,  2,  2,  2,  3,  2 },
		4,  5,  5,  2, 3, 13, 15, 10,
		10,  180,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		0x3F,

		TERM_GREEN,
		0
	},

	{
		"High-Elf",
		{  1,  3, -1,  3,  1,  5 },
		4,  20, 20,  3,  3, 14, 10, 25,
		10,  200,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		0x1F,
		
		TERM_YELLOW,
		'h'
	},

	{ /* Added by GJW -KMW- */
		"Kobold",
		{ -2, -1, 0, +2, +2, -1 },
		10, 5, 10, 4, 15, 15, -5, 15,
		9, 115,
		15, 10,
		38, 4, 70, 5,
		36, 3, 60, 4,
		5,
		0x0D,

		TERM_YELLOW,
		'k'

	},

	{ /* XXX */
	  "Mutant",
	  { -5, 5, 4, -1, -3, -5 },
	  10, 15, 15, 5, 5, 5, -15, -15, 
	  8, 100,
	  14,  6,
	  72,  6, 180, 25,
	  66,  4, 150, 20,
	  5,
	  0x80,

	  TERM_VIOLET,
	  'Q'
	},

	{ 
	  "Ghost",
	  { 2, 2, 3, 3, 2, -15 },
	  4,  20, 20,  3,  3, 14, 10, 25,
	  10, 200,
	  200,  250,
	  72,  6, 180, 25,
	  66,  4, 150, 20,
	  10,
	  0x77F,

	  TERM_SLATE,
	  'G'
	},

	{
	  "Munchkin",
	  { 15, 15, 15, 15, 15, 15 },
	  25, 25, 25, 25, 25, 25, 25, 25,
	  30, 50,
	  200, 250,
	  72, 6, 180, 25, 
	  66, 4, 150, 20,
	  10,
	  0x7FF,

	  TERM_RED,
	  'Q'
	},

	{
	  "Golem",
	  { 20, 0, -10, -10, 10, 0 },
	  5, 25, 0, -5, 5, 5, 25, 25,
	  13, 120,
	  50, 250,
	  72, 6, 180, 25, 
	  72, 6, 180, 25,
	  0,
	  0x77F,

	  TERM_L_RED,
	  'g'
	},

	{
	  "Leprechaun",
	  { -20, 0, 6, 20, -10, -10 },
	  25, 20, 5, 20, 15, 15, -25, -25,
	  9, 115,
	  100, 5,
	  42,  3, 90,  6,
	  39,  3, 75,  3,
	  4,
	  0x77F,

	  TERM_L_GREEN,
	  'h'
	},

	{
	  "Death Mold",
	  { 20, 20, 20, 20, 20, 20 },
	  15, -5, 15, 25, 0, 10, 25, 25,
	  15, 100,
	  5, 15,
	  10, 1, 50, 1,
	  10, 1, 50, 1,
	  10,
	  0x77F,

	  TERM_SLATE,
	  'm'
	}
};


/*
 * Player Classes
 *
 *	Title,
 *	{STR,INT,WIS,DEX,CON,CHR},
 *	c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_thn, c_thb,
 *	x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_thn, x_thb,
 *	HD, Exp,
 *
 *      Magic book,
 *      Uses Magic?, Magic Innate?,
 *      Which stat is used for magic,
 *      Weight allowance
 */
player_class class_info[MAX_CLASS] =
{
	{
		"Warrior",
		{ 5, -2, -2, 2, 2, -1},
		25, 18, 18, 1,  14, 2, 70, 55,
		10, 7,  10, 0,  0,  0,  45, 45,
		9,  0,

		0,
		FALSE, FALSE,
		A_INT,
		0
	},

	{
		"Mage",
		{-5, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  13, 9,  0,  0,  0,  15, 15,
		0, 30,

		SV_SPELLBOOK_MAGE,
		TRUE, FALSE,
		A_INT,
		300
	},

	{
		"Priest",
		{-1, -3, 3, -1, 0, 2},
		25, 30, 32, 2,  16, 8, 48, 35,
		7,  10, 12, 0,  0,  0, 20, 20,
		2, 20,

		SV_SPELLBOOK_PRIEST,
		TRUE, FALSE,
		A_WIS,
		350
	},

	{
		"Rogue",
		{ 2, 1, -2, 3, 1, -1},
		45, 32, 28, 5, 32, 24, 60, 66,
		15, 10, 10, 0,  0,  0, 40, 30,
		6, 25,

		SV_SPELLBOOK_ROGUE,
		TRUE, FALSE,
		A_INT,
		350
	},

	{
		"Ranger",
		{ 2, 2, 0, 1, 1, 1},
		30, 32, 28, 3,  24, 16, 56, 72,
		8,  10, 10, 0,  0,  0,  30, 45,
		4, 30,

		SV_SPELLBOOK_RANGER,
		TRUE, FALSE,
		A_INT,
		400
	},

	{
		"Paladin",
		{ 3, -3, 1, 0, 2, 2},
		20, 24, 25, 1,  12, 2, 68, 40,
		7,  10, 11, 0,  0,  0,  35, 30,
		6, 35,

		SV_SPELLBOOK_PRIEST,
		TRUE, FALSE,
		A_WIS,
		400
	},

	{ /* Added -KMW- */
		"Illusionist",
		{-5, 3, 0, 1, -2, 1},
		30, 36, 30, 2,  16, 20, 34, 20,
		7,  13, 9,  0,  0,  0,  15, 15,
		0, 30,

		SV_SPELLBOOK_ILLUSIONIST,
		TRUE, FALSE,
		A_INT,
		300
	},

	{ /* XXX */
	  "Corrupted",
	  {-5, 5, 5, -5, -10, -5},
	  30, 36, 30, 2,  16, 20, 30, 15,
	  7,  13, 9,  0,  0,  0,  0, 0,
	  0, 35,

	  0,
	  TRUE, TRUE,
	  A_INT,
	  25
	},

	{ 
	  "Beastmaster",
	  {0, -10, 5, 5, 0, 5},
	  2, 2, 45, 15, 25, 25, 45, 55,
	  0, 0, 10, 5,  5,  5, 10, 45,
	  9, 25,

	  0,
	  FALSE, FALSE,
	  A_INT,
	  0
	},

	{
	  "Lycanthrope",
	  {10, -10, -10, 10, 5, -10},
	  2, 2, 45, 45, 25, 25, 70, 55,
	  0, 0, 10, 10, 5, 5, 45, 45,
	  9, 25,

	  0,
	  FALSE, FALSE,
	  A_INT,
	  0
	},


	/* Hack -- uses ``TV_MIMIC_BOOK'' to encode shape-shifting ability */

	{
	  "Mimic",
	  { -6, 0, 3, 1, -3, 2 },
	  30, 36, 30, 2, 16, 20, 60, 66,
	  7, 13, 9, 0, 0, 0, 40, 30,
	  0, 30,

	  TV_MIMIC_BOOK,
	  FALSE, FALSE,
	  A_INT,
	  0
	}
};


/*
* Names of the spells (mage spells then priest spells
 * followed by illusionist spells -KMW-)
 */
cptr spell_names[3][64] =
{
	/*** Mage Spells ***/

	{
		/* Magic for Beginners (sval 0) */
		"Magic Missile",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Treasure Detection",
		"Cure Light Wounds",
		"Object Detection",
		"Find Hidden Traps/Doors",
		"Stinking Cloud",

		/* Conjurings and Tricks (sval 1) */
		"Confuse Monster",
		"Lightning Bolt",
		"Trap/Door Destruction",
		"Sleep I",
		"Cure Poison",
		"Teleport Self",
		"Spear of Light",
		"Frost Bolt",
		"Turn Stone to Mud",

		/* Incantations and Illusions (sval 2) */
		"Satisfy Hunger",
		"Recharge Item I",
		"Sleep II",
		"Polymorph Other",
		"Identify",
		"Sleep III",
		"Fire Bolt",
		"Slow Monster",

		/* Sorcery and Evocations (sval 3) */
		"Frost Ball",
		"Recharge Item II",
		"Teleport Other",
		"Haste Self",
		"Fire Ball",
		"Word of Destruction",
		"Genocide",

		/* Mordenkainen's Escapes (sval 5) */
		"Door Creation",
		"Stair Creation",
		"Teleport Level",
		"Earthquake",
		"Word of Recall",

		/* Raal's Tome of Destruction (sval 8) */
		"Acid Bolt",
		"Cloud Kill",
		"Acid Ball",
		"Ice Storm",
		"Meteor Swarm",
		"Mana Storm",

		/* Kelek's Grimoire of Power (sval 6) */
		"Detect Evil",
		"Detect Enchantment",
		"Recharge Item III",
		"Genocide",
		"Mass Genocide",

		/* Resistance of Scarabtarices (sval 4) */
		"Resist Fire",
		"Resist Cold",
		"Resist Acid",
		"Resist Poison",
		"Resistance",

		/* Tenser's transformations... (sval 7) */
		"Heroism",
		"Shield",
		"Berserker",
		"Essence of Speed",
		"Globe of Invulnerability",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},


	/*** Priest Spells ***/

	{
		/* Beginners Handbook (sval 0) */
		"Detect Evil",
		"Cure Light Wounds",
		"Bless",
		"Remove Fear",
		"Call Light",
		"Find Traps",
		"Detect Doors/Stairs",
		"Slow Poison",

		/* Words of Wisdom (sval 1) */
		"Scare Monster",
		"Portal",
		"Cure Serious Wounds",
		"Chant",
		"Sanctuary",
		"Satisfy Hunger",
		"Remove Curse",
		"Resist Heat and Cold",

		/* Chants and Blessings (sval 2) */
		"Neutralize Poison",
		"Orb of Draining",
		"Cure Critical Wounds",
		"Sense Invisible",
		"Protection from Evil",
		"Earthquake",
		"Sense Surroundings",
		"Cure Mortal Wounds",
		"Turn Undead",

		/* Exorcism and Dispelling (sval 3) */
		"Prayer",
		"Dispel Undead",
		"Heal",
		"Dispel Evil",
		"Glyph of Warding",
		"Holy Word",

		/* Godly Insights... (sval 5) */
		"Detect Monsters",
		"Detection",
		"Perception",
		"Probing",
		"Clairvoyance",

		/* Purifications and Healing (sval 6) */
		"Cure Serious Wounds",
		"Cure Mortal Wounds",
		"Healing",
		"Restoration",
		"Remembrance",

		/* Wrath of God (sval 8) */
		"Dispel Undead",
		"Dispel Evil",
		"Banishment",
		"Word of Destruction",
		"Annihilation",

		/* Holy Infusions (sval 7) */
		"Unbarring Ways",
		"Recharging",
		"Dispel Curse",
		"Enchant Weapon",
		"Enchant Armour",
		"Elemental Brand",

		/* Ethereal openings (sval 4) */
		"Blink",
		"Teleport Self",
		"Teleport Other",
		"Teleport Level",
		"Word of Recall",
		"Alter Reality",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	},

	/*** Illusionist Spells ***/
	/* Added by -KMW- */

	{
		/* Illusions for Beginners (sval 0) */
		"Confusion",
		"Detect Monsters",
		"Phase Door",
		"Light Area",
		"Treasure Detection",
		"Paranoia",
		"Object Detection",
		"Find Hidden Traps/Doors",
		"Poisonous Orb",

		/* Tricks and Visions (sval 1) */
		"Infravision",
		"Sleep",
		"Trap/Door Destruction",
		"Fog Cloud",
		"Fear",
		"Remove Curse",
		"Shadow Door",
		"Shadow Monster",
		"Turn Stone to Mud",

		/* Phantasms and Illusions (sval 2) */
		"Detect Invisible",
		"Recharge Item I",
		"Hypnosis",
		"Cure Body & Mind",
		"Chaos",
		"Resist Heat & Cold",
		"True Sight",
		"Slow Monster",

		/* Shadows and Prisms (sval 3) */
		"Shadow Ball",
		"Terror",
		"Resist Poison & Acid",
		"Shadow Dust",
		"Prismatic Wall",
		"Prismatic Spray",
		"Chromatic Shield",

		/* Knowledge of Kenault (sval 5) */
		"Detect Doors & Stairs",
		"Detect Treasure",
		"Detect Monsters",
		"Detect Enchantment",
		"Probing",

		/* Bigby's Handbook (sval 8) */
		"Bigby's Interposing Hand",
		"Bigby's Phantom Hand",
		"Bigby's Forceful Hand",
		"Bigby's Grasping Hand",
		"Bigby's Clenched Fist",
		"Bigby's Crushing Hand",

		/* Otiluke's Spheres (sval 6) */
		"Sphere of Light",
		"Sphere of Dark",
		"Sphere of Confusion",
		"Sphere of Chaos",
		"Sphere of Sound",

		/* Serten's Immunities (sval 4) */
		"Protection from Fire",
		"Protection from Cold",
		"Protection from Acid",
		"Protection from Poison",
		"Protection from Evil",

		/* Boccob's Book of Shadows (sval 7) */
		"Shadow Doors",
		"Shadow Monsters",
		"Shadow Ball",
		"Shadow Dust",
		"Shadow Gate",

		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)",
		"(blank)"
	}
};


/* Short names for the ingredients. */

cptr ingr_short_names[16] = {
  "Ebony",
  "Salt",
  "Graphite",
  "Flint",
  "Blood",
  "Slime",
  "Sapphire",
  "Amber",
  "Obsidian",
  "Crystal",
  "Silk",
  "Sulfur",
  "Quartz",
  "Emerald",
  "Water",
  "Mud"
};

/* Recipe info */
/* Format: { FL_<TYPE> | ... , k_index for item } */

recipe recipe_info[MAX_RECIPES] = {
  // Mush res. con. 11
  { FL_FLINT | FL_SULFUR | FL_EBONY, 11},
  // Mush restore 12
  { FL_SULFUR | FL_EBONY | FL_SILK | FL_SALT, 12},
  // Mush res. str. 18
  { FL_BLOOD | FL_SULFUR | FL_EBONY, 18},
  // Ration of food 21
  { FL_BLOOD | FL_WATER, 21},
  // Hard Buiscuit 22
  { FL_SALT | FL_WATER, 22},
  // Beef Jerky 23
  { FL_BLOOD | FL_SALT, 23},
  // Waybread 25
  { FL_WATER | FL_CRYSTAL, 25},
  // Blade of Chaos 36
  { FL_OBSIDIAN | FL_SILK | FL_SLIME, 36},
  // Executioner's Sword 40
  { FL_OBSIDIAN | FL_SLIME | FL_BLOOD, 40},
  // Mace of Disruption 57
  { FL_SLIME | FL_MUD | FL_BLOOD, 57},
  // Scythe Slicing 72
  { FL_SLIME | FL_CRYSTAL | FL_QUARTZ, 72},
  // Seeker Arrow 79
  { FL_GRAPHITE | FL_SLIME | FL_QUARTZ, 79},
  // Seeker Bolt 81
  { FL_GRAPHITE | FL_SLIME | FL_SLIME, 81},
  // Gnomish shovel 85
  { FL_MUD | FL_CRYSTAL | FL_SAPPHIRE, 85},
  // Dwarven shovel 86
  { FL_MUD | FL_BLOOD | FL_EMERALD, 86},
  // Orcish pick 88
  { FL_MUD | FL_SLIME | FL_OBSIDIAN, 88},
  // Dwarven pick 89
  { FL_MUD | FL_BLOOD | FL_SAPPHIRE, 89},
  // Mithril Plate 119
  { FL_AMBER | FL_SALT | FL_CRYSTAL | FL_EMERALD, 119},
  // Mithril Chain 120
  { FL_AMBER | FL_SALT | FL_CRYSTAL | FL_SAPPHIRE, 120},
  // Shield of Deflection 122
  { FL_EBONY | FL_AMBER | FL_SALT | FL_OBSIDIAN, 122},
  // Shadow Cloak 124
  { FL_SILK | FL_SULFUR | FL_AMBER | FL_MUD, 124},
  // Ring Str 132
  { FL_OBSIDIAN | FL_BLOOD | FL_MUD, 132},
  // Ring Dex 133
  { FL_OBSIDIAN | FL_SALT | FL_MUD, 133},
  // Ring Con 134
  { FL_OBSIDIAN | FL_AMBER | FL_MUD, 134},
  // Ring Int 135
  { FL_OBSIDIAN | FL_CRYSTAL | FL_MUD, 135},
  // Ring Speed 136
  { FL_OBSIDIAN | FL_SULFUR | FL_QUARTZ | FL_SAPPHIRE, 136},
  // Ring Srch 137
  { FL_OBSIDIAN | FL_QUARTZ | FL_AMBER, 137},
  // Ring Slow-Dig 139
  { FL_OBSIDIAN | FL_CRYSTAL | FL_SALT, 139},
  // Ring Res-fire 140
  { FL_OBSIDIAN | FL_BLOOD | FL_AMBER, 140},
  // Ring Res-cold 141
  { FL_OBSIDIAN | FL_SALT | FL_AMBER, 141},
  // Ring feather-fall 142
  { FL_OBSIDIAN | FL_SILK | FL_FLINT, 142},
  // Ring Res-pois 143
  { FL_OBSIDIAN | FL_FLINT | FL_MUD, 143},
  // Ring Free action 144
  { FL_OBSIDIAN | FL_SULFUR | FL_QUARTZ, 144},
  // Ring Flames 146
  { FL_OBSIDIAN | FL_BLOOD | FL_SILK, 146},
  // Ring Acid 147
  { FL_OBSIDIAN | FL_SALT | FL_SLIME, 147},
  // Ring Ice 148
  { FL_OBSIDIAN | FL_EBONY | FL_SALT, 148},
  // Ring Accuracy 152
  { FL_OBSIDIAN | FL_WATER | FL_SALT, 152},
  // Ring Prot 153
  { FL_OBSIDIAN | FL_EMERALD | FL_FLINT, 153},
  // Ring see-inv 155
  { FL_OBSIDIAN | FL_SULFUR | FL_CRYSTAL, 155},
  // Ring sust-str 156
  { FL_OBSIDIAN | FL_GRAPHITE | FL_BLOOD, 156},
  // Ring sust-int 157
  { FL_OBSIDIAN | FL_GRAPHITE | FL_CRYSTAL, 157},
  // Ring sust-wis 158
  { FL_OBSIDIAN | FL_GRAPHITE | FL_QUARTZ, 158},
  // Ring sust-con 159
  { FL_OBSIDIAN | FL_GRAPHITE | FL_FLINT, 159},
  // Ring sust-dex 160
  { FL_OBSIDIAN | FL_GRAPHITE | FL_SALT, 160},
  // Ring sust-cha 161
  { FL_OBSIDIAN | FL_GRAPHITE | FL_SILK, 161},
  // Ring slaying 162
  { FL_OBSIDIAN | FL_GRAPHITE | FL_BLOOD | FL_MUD, 162},
  // Scroll ench-weap-hit 173
  { FL_SILK | FL_OBSIDIAN | FL_CRYSTAL, 173},
  // Scroll ench-weap-dam 174
  { FL_SILK | FL_OBSIDIAN | FL_SALT, 174},
  // Scroll ench-armr 175
  { FL_SILK | FL_MUD | FL_CRYSTAL, 175},
  // Scroll Summon Pet
  { FL_SILK | FL_FLINT | FL_WATER, 182},
  // Scroll Ident 176
  { FL_SILK | FL_CRYSTAL | FL_SAPPHIRE, 176},
  // Scroll *Ident* 177
  { FL_SILK | FL_CRYSTAL | FL_SAPPHIRE | FL_EMERALD, 177},
  // Scroll Rem.Curse 180
  { FL_SILK | FL_FLINT | FL_MUD, 180},
  // Scroll tele-lev 187
  { FL_SILK | FL_EBONY | FL_QUARTZ, 187},
  // Scroll mapping 189
  { FL_SILK | FL_QUARTZ | FL_SULFUR, 189},
  // Scroll rune-prot 190
  { FL_SILK | FL_OBSIDIAN | FL_MUD, 190},
  // Scroll *Rem.Curse* 191
  { FL_SILK | FL_FLINT | FL_MUD | FL_EMERALD, 191},
  // Scroll Aquire 199
  { FL_SILK | FL_CRYSTAL | FL_BLOOD | FL_FLINT, 199},
  // Scroll Mass Gen 200
  { FL_SILK | FL_BLOOD | FL_EBONY | FL_SALT, 200},
  // Scroll Recharge 206
  { FL_SILK | FL_SALT | FL_AMBER, 206},
  // Scroll Gen 207
  { FL_SILK | FL_AMBER | FL_SLIME | FL_BLOOD, 207},
  // Scroll *Ench. Weap.* 212
  { FL_SILK | FL_OBSIDIAN | FL_CRYSTAL | FL_AMBER, 212},
  // Scroll *Ench. Armr.* 214
  { FL_SILK | FL_MUD | FL_CRYSTAL | FL_AMBER, 214},
  // Scroll *Destruct* 221
  { FL_SILK | FL_CRYSTAL | FL_BLOOD | FL_SLIME, 221},
  // Pot. Str. 225
  { FL_WATER | FL_BLOOD | FL_MUD, 225},
  // Pot. Res. Str. 227
  { FL_WATER | FL_SALT | FL_BLOOD, 227},
  // Pot. Int. 228
  { FL_WATER | FL_CRYSTAL | FL_MUD, 228},
  // Pot. Res. Int. 230
  { FL_WATER | FL_GRAPHITE | FL_BLOOD, 230},
  // Pot. Wis. 231
  { FL_WATER | FL_QUARTZ | FL_MUD, 231},
  // Pot. Res. Wis. 233
  { FL_WATER | FL_GRAPHITE | FL_QUARTZ, 233},
  // Pot. Cha. 234
  { FL_WATER | FL_SILK | FL_MUD, 234},
  // Pot. Res. Cha. 236
  { FL_WATER | FL_GRAPHITE | FL_SILK, 236},
  // Pot. CCW 241
  { FL_WATER | FL_BLOOD | FL_EBONY, 241},
  // Pot. Heal 242
  { FL_WATER | FL_MUD | FL_AMBER, 242},
  // Pot. Con. 243
  { FL_WATER | FL_FLINT | FL_MUD, 243},
  // Pot. Exp. 244
  { FL_WATER | FL_GRAPHITE | FL_MUD | FL_QUARTZ, 244},
  // Pot. Speed 249
  { FL_WATER | FL_SULFUR | FL_QUARTZ | FL_SAPPHIRE, 249},
  // Pot. Dex. 251
  { FL_WATER | FL_MUD | FL_SALT, 251},
  // Pot. Res. Dex. 252
  { FL_WATER | FL_GRAPHITE | FL_SALT, 252},
  // Pot. Res. Con. 253
  { FL_WATER | FL_GRAPHITE | FL_FLINT, 253},
  // Pot. Enlight 256
  { FL_WATER | FL_GRAPHITE | FL_EMERALD | FL_SAPPHIRE, 256},
  // Pot. Berserk 258
  { FL_WATER | FL_BLOOD | FL_AMBER, 258},
  // Pot. Res. Life Lev. 260
  { FL_WATER | FL_GRAPHITE | FL_BLOOD | FL_QUARTZ, 260},
  // Pot. Res. Mana 266
  { FL_WATER | FL_GRAPHITE | FL_CRYSTAL | FL_QUARTZ, 266},
  // Wand lightning bolt 270
  { FL_AMBER | FL_SAPPHIRE | FL_CRYSTAL, 270},
  // Wand frost bolt 271
  { FL_AMBER | FL_SALT | FL_CRYSTAL, 271},
  // Wand fire bolt 272
  { FL_AMBER | FL_EBONY | FL_BLOOD, 272},
  // Wand morph 274
  { FL_AMBER | FL_SAPPHIRE | FL_EMERALD, 274},
  // Wand drain life 280
  { FL_AMBER | FL_SULFUR | FL_QUARTZ, 280},
  // Wand lightning balls 287
  { FL_AMBER | FL_QUARTZ | FL_SLIME, 287},
  // Wand cold balls 288
  { FL_AMBER | FL_SLIME | FL_CRYSTAL, 288},
  // Wand fire balls 289
  { FL_AMBER | FL_SLIME | FL_BLOOD, 289},
  // Wand acid balls 291
  { FL_AMBER | FL_SLIME | FL_SALT, 291},
  // Wand wonder 292
  { FL_AMBER | FL_WATER | FL_QUARTZ, 292},
  // Wand dragon flame 295
  { FL_AMBER | FL_SLIME | FL_BLOOD | FL_WATER, 295},
  // Wand dragon frost 296
  { FL_AMBER | FL_SLIME | FL_CRYSTAL | FL_WATER, 296},
  // Wand dragon breath 297
  { FL_AMBER | FL_SLIME | FL_SALT | FL_WATER, 297},
  // Wand anihilate 298
  { FL_AMBER | FL_SLIME | FL_QUARTZ | FL_EMERALD, 298},
  // Staff tele 303
  { FL_FLINT | FL_WATER | FL_BLOOD, 303},
  // Staff quake 304
  { FL_FLINT | FL_OBSIDIAN | FL_CRYSTAL, 304},
  // Staff summon 305
  { FL_FLINT | FL_BLOOD | FL_SLIME, 305},
  // Staff *Destr* 307
  { FL_FLINT | FL_BLOOD | FL_SLIME | FL_SALT, 307},
  // Staff speed 314
  { FL_FLINT | FL_SULFUR | FL_QUARTZ | FL_SAPPHIRE, 314},
  // Staff rem. curse 317
  { FL_FLINT | FL_MUD | FL_EBONY, 317},
  // Staff curing 319
  { FL_FLINT | FL_MUD | FL_AMBER, 319},
  // Staff geno 323
  { FL_FLINT | FL_AMBER | FL_SLIME | FL_MUD, 323},
  // Staff power 324
  { FL_FLINT | FL_BLOOD | FL_SALT | FL_WATER, 324},
  // Staff the Magi 325
  { FL_FLINT | FL_SULFUR | FL_CRYSTAL | FL_EBONY, 325},
  // Staff Perception 326
  { FL_FLINT | FL_AMBER | FL_GRAPHITE, 326},
  // Staff enlight 328
  { FL_FLINT | FL_AMBER | FL_GRAPHITE | FL_SAPPHIRE, 328},
  // Staff Heal 329
  { FL_FLINT | FL_EMERALD | FL_SAPPHIRE, 329},
  // Torch 346
  { FL_FLINT | FL_MUD, 346},
  // Lantern 347
  { FL_FLINT | FL_CRYSTAL, 347},
  // Flask 348
  { FL_WATER | FL_SULFUR, 348},
  // Rod probe 353
  { FL_SULFUR | FL_WATER | FL_GRAPHITE, 353},
  // Rod recall 354
  { FL_SULFUR | FL_WATER | FL_EMERALD, 354},
  // Rod lightning bolts 357
  { FL_SULFUR | FL_SAPPHIRE | FL_CRYSTAL, 357},
  // Rod frost bolts 358
  { FL_SULFUR | FL_SALT | FL_CRYSTAL, 358},
  // Rod fire bolts 359
  { FL_SULFUR | FL_AMBER | FL_BLOOD, 359},
  // Rod morph 360
  { FL_SULFUR | FL_EBONY | FL_EMERALD, 360},
  // Rod drain life 363
  { FL_SULFUR | FL_QUARTZ | FL_SALT, 363},
  // Rod port other 364
  { FL_SULFUR | FL_WATER | FL_SAPPHIRE, 364},
  // Rod lightning balls 366
  { FL_SULFUR | FL_QUARTZ | FL_SLIME, 366},
  // Rod cold balls 367
  { FL_SULFUR | FL_CRYSTAL | FL_SLIME, 367},
  // Rod fire balls 368
  { FL_SULFUR | FL_BLOOD | FL_SLIME, 368},
  // Rod acid balls 369
  { FL_SULFUR | FL_SALT | FL_SLIME, 369},
  // Rod acid bolts 370
  { FL_SULFUR | FL_SALT | FL_WATER, 370},
  // Rod enlight 371
  { FL_SULFUR | FL_AMBER | FL_GRAPHITE | FL_SAPPHIRE, 371},
  // Rod percept 372
  { FL_SULFUR | FL_AMBER | FL_GRAPHITE, 372},
  // Rod curing 373
  { FL_SULFUR | FL_MUD | FL_AMBER, 373},
  // Rod Healing 374
  { FL_SULFUR | FL_EMERALD | FL_SAPPHIRE, 374},
  // Rod detect 375
  { FL_SULFUR | FL_CRYSTAL | FL_BLOOD, 375},
  // Rod restore 376
  { FL_SULFUR | FL_EBONY | FL_SILK | FL_AMBER, 376},
  // Rod speed 377
  { FL_SULFUR | FL_SULFUR | FL_QUARTZ | FL_SAPPHIRE, 377}
};


/*
 * Textual translation of your god's "niceness".
 */

cptr deity_niceness[10] = {
  "caring",
  "friendly",
  "easygoing",
  "forgiving",
  "uncaring",
  "wary",
  "unforgiving",
  "wrathfull",
  "hatefull",
  "extremely evil"
};


/*
 * Textual translation of your standing with your god.
 */

cptr deity_standing[11] = {
  "cursed",
  "persecuted",
  "punished",
  "despised",
  "disliked",
  "watched",
  "unnoticed",
  "noticed",
  "rewarded",
  "favored",
  "championed"
};

/* 
 * Explain moonster affiliations for gods.
 */

cptr deity_affiliation[13] = {
  "those monsters who are immune or breathe cold, those who breathe "
  "darkness, those who don't sleep, and those who are hurt by light",

  "those monsters who are hurt by cold, and those who breathe electricity "
  "and light",

  "those monsters who are orcs, trolls, giants, dragons, and those who "
  "are invisible",

  "those monsters who are hurt by cold, those who breathe or are immune to "
  "fire, and demons",

  "those monsters who multiply, regenerate, or summon other monsters",

  "those monsters who are animals, stupid, or have strange minds",

  "those monsters who breathe or resist water, and aquatic monsters",


  "those monsters who breathe shards or gravity, those who paralyze, "
  "and those who are hurt by wall-to-mud",

  "those monsters who are evil, undead, demons, those who breathe or "
  "resist nexus and nether, and those who summon undead",

  "those monsters who blind, scare, confuse, those who are immune "
  "to fear or confusion, and those who summon angels",

  "those monsters who breathe chaos or plasma, drain mana, brain smash, "
  "teleport, and cause amnesia",

  "those monsters who have powerfull breath, those who can steal, "
  "those who can fire arrows, and those who breathe sound",

  "those who are smart, those who can cast ``cause wounds'', those "
  "who can heal, those who can create traps, and those who can cast "
  "magic missile"
};

/*
 * Information on gods.
 * { "name", "god_of", grace_deduction, alignment, opposition }
 */

deity deity_info[MAX_GODS] = {
  { "Chernobog", "Night",   5, GA_NIGHT,  GA_DAY },
  { "Belobog",   "Day",     3, GA_DAY,    GA_NIGHT },
  { "Melkor",    "Shadow",  6, GA_SHADOW,  GA_GOOD },
  { "Svarog",    "Fire",    4, GA_FIRE,   GA_WATER },
  { "Chthon",    "Blood",   7, GA_FLESH,  GA_STONE },
  { "Mokosh",    "Nature",  2, GA_NATURE, GA_SMARTS },
  { "Naunet",    "Water",   3, GA_WATER,  GA_FIRE },
  { "Voltumna",  "Stone",   1, GA_STONE,  GA_FLESH },
  { "Shaitan",   "Evil",    9, GA_EVIL,   GA_GOOD },
  { "Amon-Ras",  "Good",    2, GA_GOOD,   GA_EVIL },
  { "Apep",      "Chaos",   4, GA_CHAOS,  GA_NATURE },
  { "Radogast",  "Sun",     3, GA_DAY,    GA_EVIL },
  { "Herovit",   "Rage",    8, GA_FLESH,  GA_SMARTS },
  { "Veles",     "Beasts",  4, GA_NATURE, GA_STONE },
  { "Stribog",   "Winds",   5, GA_AIR,  GA_FIRE },
  { "Chenti",    "Spheres", 4, GA_SMARTS, GA_NATURE }
};

/* 
 * Information on shape-shifting
 * {"name", "message_when_on", "message_when_off", duration, attr, char}
 */

shape shape_info[MAX_SHAPES] = {
  {"abomination", "Your skin melts off your body!", "Your skin is restored.",
   700, TERM_SLATE, 'Q'},

  {"wolf", "You sprout fur all over your body!", "Your fur falls off.", 
    200, TERM_L_DARK, 'C' },

  {"ghost", "You turn into a ghost.", "Your body rematerializes.",
   25, TERM_L_DARK, 'G'},

  {"insect", "You turn into a tiny insect.", "Your body is restored to "
   "it's former size.", 150, TERM_GREEN, 'I'},

  {"goat", "You grow horns.", "Your horns fall off.", 250, TERM_WHITE, 'q'},

  {"ape", "Your arms become very long.", "Your arms return to their "
   "former size.", 300, TERM_SLATE, 'P'},

  {"statue", "You solidify into stone.", "You return to flesh.", 150, 
   TERM_L_RED, '#'},

  {"chaos cloud", "Your body disintegrates!", "Your body returns to "
   "corporeal shape.", 250, TERM_VIOLET, '*'},

  {"sparrow", "You turn into a tiny bird!", "Your body returns to it's "
   "former shape.", 200, TERM_L_BLUE, 'B'},

  {"kobold", "You turn into an ugly dog-man!", "Your body return to it's "
   "former shape.", 250, TERM_YELLOW, 'k'},

  {"fire cloud", "Your body turns into a glowing mist!", "Your body returns "
   "to corporeal shape.", 150, TERM_RED, 'E'},

  {"cold cloud", "Your body turns into a frigid mist!", "Your body returns "
   "to corporeal shape.", 150, TERM_BLUE, 'E'},
  
  {"dragon", "You grow a scaly hide!", "Your scales fall off.", 200, TERM_RED,
   'D'},

  {"demon", "You grow gigantic horns and a gaping maw!", 
   "Your horns fall off.", 100, TERM_RED, 'U'},

  {"hound", "Your arms turn into legs!", "Your legs return to being arms.",
   150, TERM_SLATE, 'Z'},

  {"vampire", "You grow two long canines.", 
   "Your teeth return to normal shape.", 200, TERM_VIOLET, 'V'},

  {"quylthulg", "You turn into a disgusting mound of flesh!", 
   "You return to normal shape.", 250, TERM_WHITE, 'Q'},

  {"angel", "You turn into a winged denizen of light!",
   "You return to normal shape.", 100, TERM_WHITE, 'A'},

  {"serpent", "You turn into a slithering reptile.", "You regrow your "
   "arms and legs.", 200, TERM_GREEN, 'J'},

  {"mana ball", "You turn into a sizzling ball of pure magic!", 
   "Your body rematerializes.", 250, TERM_UMBER, '*'},

  {"giant", "You turn into a towering humanoid.", "You return to your "
   "former size.", 300, TERM_ORANGE, 'P'},

  {"spider", "You grow eight slimy legs.", "Your extra legs fall off.",
   250, TERM_SLATE, 'S'},

  {"mold", "You turn into a disgusting mold.", "You return to your "
   "former shape.", 200, TERM_YELLOW, 'm'},

  {"zombie", "You turn into a disgusting animated corpse.", "You return "
   "to your former shape.", 200, TERM_L_WHITE, 'z'},

  {"deity", "You gain phenomenal Godly powers!", 
   "You feel insignificant again.", 10, TERM_RED, '&'}
};


/*
 * This list hold the names and descriptions of mutations.
 */

cptr mutation_names[MAX_MUTS][3] = {
  { "Genius",               "You grow a giant, pulsing brain.",
    "Your brain returns to normal size." },

  { "Bulging muscle",       "You grow thick, ropey muscles.",
    "Your muscles return to normal size." },

  { "Double heart",         "You grow a second heart in your chest.",
    "Your second heart shrivels away." },

  { "Mystical awareness",   "You are aware of other dimensions.",
    "You lose awareness of other dimensions." },

  { "Hypnotic gaze",        "Your gaze is hypnotic.",
    "Your gaze is not nypnotic anymore." },

  { "Expanded nervous system",  "Your reactions are now much quicker.",
    "Your reactions are not as quick as they used to be..." },

  { "Second set of legs",   "You grow a second set of legs.",
    "Your second set of legs shrivels away." },

  { "Sound distortion",     "You now move more stealthily.",
    "You don't move as stealthily as you used to." },

  { "Distortion field",     "You are protected.",
    "Your distortion field disappears." },

  { "Telepathy",            "You sense intelligent life.",
    "You lose telepathy." },

  { "Lunimescence",         "Your skin starts to glow.",
    "Your skin stops glowing." },

  { "Shadow-form",          "You turn into a ghost-like being.",
    "You regain corporeal form." },

  { "Wings",                "You grow small wings.",
    "Your wings shrivel away." },

  { "Life leech",           "You gain vampiric abilities.",
    "You lose your life-leeching abilities." },

  { "Chaos funnel",         "You start channeling wild magic.",
    "You stop channeling wild magic." },

  { "Bird's eye view","You can sense the geography of the land around you.",
    "You lose your superiour eye-sight." },

  { "Fiery essence",        "You are immune to fire.",
    "You lose your fiery essence." },

  { "Electrical essence",   "You are immune to electricity.",
    "You lose your electrical essence." },

  { "Corrosive essence",    "You are immune to acids.",
    "You lose your corrosive essence." },

  { "Frigid essence",       "You are immune to cold.",
    "You lose your frigid essence." },
  
  { "See invisible",        "You start sensing invisible creatures.",
    "You stop sensing invisible creatures." },

  { "Quicksilver",          "You are immune to paralysis.",
    "You are not immune to paralysis." },

  { "Metabolic balance",    "You start controlling you metabolism better.",
    "You can't control your metabolism as well as you used to..." },

  { "Regeneration",         "You start regenerating.",
    "You stop regenerating." },

  { "Weightless",           "You start weighing next to nothing.",
    "You regain your weight." },

  { "Anti-life leech",      "You are protected against leeching attacks.",
    "You lose your protection against leeching attacks." },

  { "Echolocation",         "You can sense your surroundings without light.",
    "You lose your echolocation abilities." },

  { "Fearless",             "You are fearless.",
    "You stop being fearless." },

  { "Clear-mindedness",     "You are protected against confusion.",
    "You lose protection against confusion." },

  { "Heightened immunity",  "You are protected against poisons.",
    "You lose protection against poisons." },

  { "Resist acid",          "You resist acid.",
    "You stop resisting acid." },

  { "Resist electricity",   "You resist electricity.",
    "You stop resisting electricity." },

  { "Resist fire",          "You resist fire.",
    "You stop resisting fire." },

  { "Resist light",         "You resist light.",
    "You stop resisting light." },

  { "Resist darkness",      "You resist darkness.",
    "You stop resisting darkness." },

  { "Resist sound",         "You resist sound.",
    "You stop resisting sound." },

  { "Resist chaos",         "You resist chaos.",
    "You stop resisting chaos." },

  { "Resist disenchant",    "You resist disenchantment.",
    "You stop resisting disenchantment." },

  { "Resist shards",        "You resist shards.",
    "You stop resisting shards." },

  { "Resist nexus",         "You resist nexus.",
    "You stop resisting nexus." },

  { "Resist nether",        "You resist nether.",
    "You stop resisting nether." },

  /*-*-*/
  
  { "Retardation",          "Your brain shrivels!",
    "You regain normal intelligence." },

  { "Atrophied musculature","Your muscles are atrophied!",
    "You regain normal strength." },

  { "Artheosclerosis",      "Your veins become blocked!",
    "Your veins become unblocked." },

  { "Closed-mindedness",    "You become very closed-minded!",
    "You stop being closed-minded." },

  { "Skin infection",       "Your skin becomes infected!",
    "Your skin infection is cured." },

  { "Shrunken nervous system",  "Your reactions are now much slower!",
    "Your nervous system regains former size." },

  { "Stubby legs",          "Your legs become short and stubby!",
    "Your legs return to former size." },

  { "Flatulence",           "You can't control your bodily fluids anymore!",
    "You regain control of bodily fluids." },

  { "Magnetic field",       "Your skin attracts sharp metal objects!",
    "Your magnetic field disappears." },

  { "Legless",              "Your legs fall off!",
    "You regrow your legs." },

  { "Blindness",            "You are permanently blind!",
    "You can see again!" },

  { "Cowardice",            "You become extremely cowardly!",
    "Your cowardice is cured." },

  { "Hallucination",        "You start randomly hallucinating!",
    "Your hallucinations are cured." },

  { "Immune deficiency",    "You are extremely vulnerable to disease!",
    "Your immune deficiency is cured." },

  { "Confused",             "You're disoriented!",
    "Your disorientation is cured." },

  { "Epilepsy",             "You are epileptic!",
    "Your epilepsy is cured." },

  { "Hemophelia",           "Your blood doesn't clot anymore!",
    "Your hemophelia is cured." },

  { "Tapeworms",            "You grow parasitic worms in your stomach!",
    "Your tapeworms die off." },

  { "Concussions",          "You are frequently stunned.",
    "Your concussions are cured." },

  { "Space discontinuum",   "You feel lost!",
    "You are now firmly grounded." },

  { "Time discontinuum",    "You memories fade...",
    "You regain your memories." },

  { "Mechanical stupidity", "You lose proficiency with devices!",
    "You regain proficiency with devices." },

  { "Mana magnet",          "You are defenceless against magical attacks!",
    "You regain your magical defences." },

  { "Odor",                 "You start letting out a disgusting smell!",
    "Your disgusting smell goes away." },

  { "Stunted fingers","You're not as good with weapons as you used to be...",
    "Your stunted fingers return to normal size." }

};

/*
 * Names for random artifact activations.
 */

cptr t_act_names[MAX_T_ACT] = {
  "death",
  "ruination",
  "destruction",
  "stupidity",
  "weakness",
  "unhealth",
  "ugliness",
  "clumsiness",
  "naivete",
  "stat loss",
  "huge stat loss",
  "experience loss",
  "huge experience loss",
  "teleportation",
  "monster summoning",
  "paralyzation",
  "hallucination",
  "poisoning",
  "hunger",
  "stun",
  "cuts",
  "paranoia",
  "confusion",
  "blindness",
  "pet summoning",
  "cure paralyzation",
  "cure hallucination",
  "cure poison",
  "cure hunger",
  "cure stun",
  "cure cut",
  "cure fear",
  "cure confusion",
  "cure blindness",
  "cure light wounds",
  "cure serious wounds",
  "cure critical wounds",
  "curing",
  "genocide",
  "mass genocide",
  "restoration",
  "light",
  "darkness",
  "teleportation",
  "level teleportation",
  "acquirement",
  "something weird",
  "aggravation",
  "mutation",
  "cure insanity",
  "cure mutation"
};

/*
 * Costs for the random artifact activations.
 */

u32b t_act_costs[MAX_T_ACT] = {
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1000,
  5,
  0,
  100,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  5000,
  1000,
  1000,
  1000,
  1000,
  1000,
  1000,
  1000,
  1000,
  1000,
  500,
  750,
  1000,
  1100,
  10000,
  20000,
  2000,
  1000,
  0,
  1000,
  500,
  30000,
  50,
  0,
  100,
  2000,
  2000
};

/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,					/* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),			/* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),			/* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),			/* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),	/* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),	/* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),	/* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};








/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL/5] =
{
	/* Warrior */
	{
		"Rookie",
		"Soldier",
		"Mercenary",
		"Veteran",
		"Swordsman",
		"Champion",
		"Hero",
		"Baron",
		"Duke",
		"Lord",
	},

	/* Mage */
	{
		"Novice",
		"Apprentice",
		"Evoker",
		"Conjurer",
		"Enchanter",
		"Warlock",
		"Sorcerer",
		"Mage",
		"Wizard",
		"Wizard Lord",
	},

	/* Priest */
	{
		"Believer",
		"Acolyte",
		"Adept",
		"Curate",
		"Canon",
		"Lama",
		"Patriarch",
		"Priest",
		"High Priest",
		"Priest Lord",
	},

	/* Rogues */
	{
		"Vagabond",
		"Cutpurse",
		"Robber",
		"Burglar",
		"Filcher",
		"Sharper",
		"Low Thief",
		"High Thief",
		"Master Thief",
		"Assassin",
	},

	/* Rangers */
	{
		"Runner",
		"Strider",
		"Scout",
		"Courser",
		"Tracker",
		"Guide",
		"Pathfinder",
		"Low Ranger",
		"High Ranger",
		"Ranger Lord",
	},

	/* Paladins */
	{
		"Gallant",
		"Keeper",
		"Protector",
		"Defender",
		"Warder",
		"Knight",
		"Guardian",
		"Low Paladin",
		"High Paladin",
		"Paladin Lord",
	},

	/* Illusionist -KMW- */
	{
		"Novice",
		"Apprentice",
		"Trickster",
		"Cabalist",
		"Visionist",
		"Phantasmist",
		"Spellbinder",
		"Illusionist",
		"Shadow",
		"Shadow Lord",
	},

	/* XXX - Corrupted */
	{
	  "Chaos Slave",
	  "Chaos Serf",
	  "Chaos Novice",
	  "Chaos Caster",
	  "Chaos Wielder",
	  "Chaos Lord",
	  "Chaos Master",
	  "Chaos Fiend",
	  "Corrupted",
	  "Corrupter",
	},

	{ /* Beastmaster */
	  "Beastmaster",
	  "Beastmaster",        
	  "Beastmaster",
	  "Beastmaster",
	  "Beastmaster",
	  "Rabblerouser",
	  "Leader",
	  "Commander",
	  "Centurion",
	  "Hordemaster",
	},

	{ /* Lycanthrope */
	  "Wereworm",
	  "Wererat",
	  "Werejacal",
	  "Werewolf",
	  "Wereboar",
	  "Wereogre",
	  "Weretroll",
	  "Werehound",
	  "Weregiant",
	  "Weredragon",
	},

	{
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]",
	  "[???]"
	}
};



/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[6] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: "
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[6] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: "
};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 */
cptr window_flag_desc[32] =
{
	"Display inven/equip",
	"Display equip/inven",
	"Display player flags",
	"Display player screen",
	NULL,
	NULL,
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	NULL,
	"Display snap-shot",
	NULL,
	NULL,
	"Display borg messages",
	"Display borg status",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Options -- textual names (where defined)
 */
cptr option_text[OPT_MAX] =
{
 	"rogue_like_commands",		/* OPT_rogue_like_commands */
	"quick_messages",			/* OPT_quick_messages */
	"other_query_flag",			/* OPT_other_query_flag */
	"carry_query_flag",			/* OPT_carry_query_flag */
	"use_old_target",			/* OPT_use_old_target */
	"always_pickup",			/* OPT_always_pickup */
	"always_repeat",			/* OPT_always_repeat */
	"depth_in_feet",			/* OPT_depth_in_feet */
	"stack_force_notes",		/* OPT_stack_force_notes */
	"stack_force_costs",		/* OPT_stack_force_costs */
	"show_labels",				/* OPT_show_labels */
	"show_weights",				/* OPT_show_weights */
	"show_choices",				/* OPT_show_choices */
	"show_details",				/* OPT_show_details */
	"ring_bell",				/* OPT_ring_bell */
	"inventory_colors",			/* OPT_inventory_colors */
	"run_ignore_stairs",		/* OPT_run_ignore_stairs */
	"run_ignore_doors",			/* OPT_run_ignore_doors */
	"run_cut_corners",			/* OPT_run_cut_corners */
	"run_use_corners",			/* OPT_run_use_corners */
	"disturb_move",				/* OPT_disturb_move */
	"disturb_near",				/* OPT_disturb_near */
	"disturb_panel",			/* OPT_disturb_panel */
	"disturb_state",			/* OPT_disturb_state */
	"disturb_minor",			/* OPT_disturb_minor */
	"disturb_other",			/* OPT_disturb_other */
	"alert_hitpoint",			/* OPT_alert_hitpoint */
	"alert_failure",			/* OPT_alert_failure */
	"show_pet_messages",                    /* OPT_show_pet_messages */
	"race_chars",		 	        /* OPT_race_chars */
	"confirm_blasphemy",            /* OPT_confirm_blasphemy */
	"allow_open_levels",	        /* OPT_allow_open_levels */
	"auto_haggle",				/* OPT_auto_haggle */
	"auto_scum",				/* OPT_auto_scum */
	"testing_stack",			/* OPT_testing_stack */
	"testing_carry",			/* OPT_testing_carry */
	"expand_look",				/* OPT_expand_look */
	"expand_list",				/* OPT_expand_list */
	"view_perma_grids",			/* OPT_view_perma_grids */
	"view_torch_grids",			/* OPT_view_torch_grids */
	"dungeon_align",			/* OPT_dungeon_align */
	"dungeon_stair",			/* OPT_dungeon_stair */
	"flow_by_sound",			/* OPT_flow_by_sound */
	"flow_by_smell",			/* OPT_flow_by_smell */
	"track_follow",				/* OPT_track_follow */
	"track_target",				/* OPT_track_target */
	"smart_learn",				/* OPT_smart_learn */
	"smart_cheat",				/* OPT_smart_cheat */
	"view_reduce_lite",			/* OPT_view_reduce_lite */
	"view_reduce_view",			/* OPT_view_reduce_view */
	"avoid_abort",				/* OPT_avoid_abort */
	"avoid_other",				/* OPT_avoid_other */
	"flush_failure",			/* OPT_flush_failure */
	"flush_disturb",			/* OPT_flush_disturb */
	"flush_command",			/* OPT_flush_command */
	"fresh_before",				/* OPT_fresh_before */
	"fresh_after",				/* OPT_fresh_after */
	"fresh_message",			/* OPT_fresh_message */
	"compress_savefile",		/* OPT_compress_savefile */
	"hilite_player",			/* OPT_hilite_player */
	"view_yellow_lite",			/* OPT_view_yellow_lite */
	"view_bright_lite",			/* OPT_view_bright_lite */
	"view_granite_lite",		/* OPT_view_granite_lite */
	"view_special_lite",			/* OPT_view_special_lite */
 	"cripple_pets",          /* OPT_cripple_pets */
	"allow_theme_vaults",    /* OPT_theme_vaults */
	"weirdness_is_rare",     /* OPT_weirdness_is_rare */
	"named_monsters",        /* OPT_named_monsters */
	"flavored_attacks",      /* OPT_flavored_attacks */
	"confirm_prayers"        /* OPT_confirm_prayers */
};


/*
 * Options -- descriptions (where defined)
 */
cptr option_desc[OPT_MAX] =
{
	"Rogue-like commands",						/* OPT_rogue_like_commands */
	"Activate quick messages",					/* OPT_quick_messages */
	"Prompt for floor item selection",			/* OPT_other_query_flag */
	"Prompt before picking things up",			/* OPT_carry_query_flag */
	"Use old target by default",				/* OPT_use_old_target */
	"Pick things up by default",				/* OPT_always_pickup */
	"Repeat obvious commands",					/* OPT_always_repeat */
	"Show dungeon level in feet",				/* OPT_depth_in_feet */
	"Merge inscriptions when stacking",			/* OPT_stack_force_notes */
	"Merge discounts when stacking",			/* OPT_stack_force_costs */
	"Show labels in object listings",			/* OPT_show_labels */
	"Show weights in object listings",			/* OPT_show_weights */
	"Show choices in certain sub-windows",		/* OPT_show_choices */
	"Show details in certain sub-windows",		/* OPT_show_details */
	"Audible bell (on errors, etc)",			/* OPT_ring_bell */
	"Use color for inventory listings",			/* OPT_inventory_colors */
	"When running, ignore stairs",				/* OPT_run_ignore_stairs */
	"When running, ignore doors",				/* OPT_run_ignore_doors */
	"When running, cut corners",				/* OPT_run_cut_corners */
	"When running, use corners",				/* OPT_run_use_corners */
	"Disturb whenever any monster moves",		/* OPT_disturb_move */
	"Disturb whenever viewable monster moves",	/* OPT_disturb_near */
	"Disturb whenever map panel changes",		/* OPT_disturb_panel */
	"Disturb whenever player state changes",	/* OPT_disturb_state */
	"Disturb whenever boring things happen",	/* OPT_disturb_minor */
	"Disturb whenever various things happen",	/* OPT_disturb_other */
	"Alert user to critical hitpoints",			/* OPT_alert_hitpoint */
	"Alert user to various failures",			/* OPT_alert_failure */
	"Show messages when pets fight",    /* OPT_show_pet_messages */
	"Show player races as different symbols",	  /* OPT_race_chars */
	"Confirm when attacking sacred monsters", /* OPT_confirm_blasphemy */
	"Allow open (arena) levels",     /* OPT_allow_open_levels */
	"Auto-haggle in stores",					/* OPT_auto_haggle */
	"Auto-scum for good levels",				/* OPT_auto_scum */
	"Allow objects to stack on floor (beta)",	/* OPT_testing_stack */
	"Allow monsters to carry objects (beta)",	/* OPT_testing_carry */
	"Expand the power of the look command",		/* OPT_expand_look */
	"Expand the power of the list commands",	/* OPT_expand_list */
	"Map remembers all perma-lit grids",		/* OPT_view_perma_grids */
	"Map remembers all torch-lit grids",		/* OPT_view_torch_grids */
	"Generate dungeons with aligned rooms",		/* OPT_dungeon_align */
	"Generate dungeons with connected stairs",	/* OPT_dungeon_stair */
	"Monsters chase current location (v.slow)",	/* OPT_flow_by_sound */
	"Monsters chase recent locations (v.slow)",	/* OPT_flow_by_smell */
	"Monsters follow the player (broken)",		/* OPT_track_follow */
	"Monsters target the player (broken)",		/* OPT_track_target */
	"Monsters learn from their mistakes",		/* OPT_smart_learn */
	"Monsters exploit players weaknesses",		/* OPT_smart_cheat */
	"Reduce lite-radius when running",			/* OPT_view_reduce_lite */
	"Reduce view-radius in town",				/* OPT_view_reduce_view */
	"Avoid checking for user abort",			/* OPT_avoid_abort */
	"Avoid processing special colors",			/* OPT_avoid_other */
	"Flush input on various failures",			/* OPT_flush_failure */
	"Flush input whenever disturbed",			/* OPT_flush_disturb */
	"Flush input before every command",			/* OPT_flush_command */
	"Flush output before every command",		/* OPT_fresh_before */
	"Flush output after every command",			/* OPT_fresh_after */
	"Flush output after every message",			/* OPT_fresh_message */
	"Compress messages in savefiles",			/* OPT_compress_savefile */
	"Hilite the player with the cursor",		/* OPT_hilite_player */
	"Use special colors for torch-lit grids",	/* OPT_view_yellow_lite */
	"Use special colors for 'viewable' grids",	/* OPT_view_bright_lite */
	"Use special colors for wall grids (slow)",	/* OPT_view_granite_lite */
	"Use special colors for floor grids (slow)",	/* OPT_view_special_lite */
        "Disallow summoning uniques as pets",     /* OPT_cripple_pets */
	"Allow themed vaults to be generated", /* OPT_allow_theme_vaults */
	"Theme vaults and open levels are rare", /* OPT_weirdness_is_rare */
	"Give humanoids names",     /* OPT_named_monsters */
	"Show silly messages when fighting",  /* OPT_flavored_attacks */
	"Ask for confirmation when praying",  /* OPT_confirm_prayers */
};


/*
 * Options -- normal values
 * Changed these to Kangband defaults -KMW-
 * Changed these to Kamband defaults. :)
 */
bool option_norm[OPT_MAX] =
{
	FALSE,		/* OPT_rogue_like_commands */
	TRUE,		/* OPT_quick_messages */
	TRUE,		/* OPT_other_query_flag */
	FALSE,		/* OPT_carry_query_flag */
	TRUE,		/* OPT_use_old_target */
	FALSE,		/* OPT_always_pickup */
	TRUE,		/* OPT_always_repeat */
	FALSE,		/* OPT_depth_in_feet */
	TRUE,		/* OPT_stack_force_notes */
	TRUE,		/* OPT_stack_force_costs */
	TRUE,		/* OPT_show_labels */
	TRUE,		/* OPT_show_weights */
	TRUE,		/* OPT_show_choices */
	TRUE,		/* OPT_show_details */
	TRUE,		/* OPT_ring_bell */
	TRUE,		/* OPT_inventory_colors */
	FALSE,		/* OPT_run_ignore_stairs */
	TRUE,		/* OPT_run_ignore_doors */
	TRUE,		/* OPT_run_cut_corners */
	TRUE,		/* OPT_run_use_corners */
	TRUE,		/* OPT_disturb_move */
	TRUE,		/* OPT_disturb_near */
	TRUE,		/* OPT_disturb_panel */
	TRUE,		/* OPT_disturb_state */
	TRUE,		/* OPT_disturb_minor */
	TRUE,		/* OPT_disturb_other */
	TRUE,		/* OPT_alert_hitpoint */
	TRUE,		/* OPT_alert_failure */
	TRUE,           /* OPT_show_pet_messages */
	TRUE,		/* OPT_race_chars */
	TRUE,           /* OPT_confirm_blasphemy */
	TRUE,		/* OPT_allow_open_levels */
	TRUE,		/* OPT_auto_haggle */
	TRUE,		/* OPT_auto_scum */
	TRUE,		/* OPT_testing_stack */
	TRUE,		/* OPT_testing_carry */
	TRUE,		/* OPT_expand_look */
	TRUE,		/* OPT_expand_list */
	TRUE,		/* OPT_view_perma_grids */
	TRUE,		/* OPT_view_torch_grids */
	TRUE,		/* OPT_dungeon_align */
	TRUE,		/* OPT_dungeon_stair */
	TRUE,		/* OPT_flow_by_sound */
	TRUE,		/* OPT_flow_by_smell */
	FALSE,		/* OPT_track_follow */
	FALSE,		/* OPT_track_target */
	TRUE,		/* OPT_smart_learn */
	FALSE,		/* OPT_smart_cheat */
	FALSE,		/* OPT_view_reduce_lite */
	FALSE,		/* OPT_view_reduce_view */
	FALSE,		/* OPT_avoid_abort */
	FALSE,		/* OPT_avoid_other */
	TRUE,		/* OPT_flush_failure */
	FALSE,		/* OPT_flush_disturb */
	FALSE,		/* OPT_flush_command */
	TRUE,		/* OPT_fresh_before */
	FALSE,		/* OPT_fresh_after */
	FALSE,		/* OPT_fresh_message */
	TRUE,		/* OPT_compress_savefile */
	FALSE,		/* OPT_hilite_player */
	TRUE,		/* OPT_view_yellow_lite */
	TRUE,		/* OPT_view_bright_lite */
	TRUE,		/* OPT_view_granite_lite */
	TRUE,		/* OPT_view_special_lite */
	FALSE,          /* OPT_cripple_pets */
	TRUE,           /* OPT_allow_theme_vaults */
	FALSE,          /* OPT_weirdness_is_rare */
	TRUE,           /* OPT_named_monsters */
	TRUE,           /* OPT_flavored_attacks */
	TRUE,           /* OPT_confirm_prayers */
};


/*
 * Option screen interface
 */
byte option_page[4][20] =
{
	/*** User-Interface ***/

	{
		OPT_rogue_like_commands,
		OPT_quick_messages,
		OPT_other_query_flag,
		OPT_carry_query_flag,
		OPT_use_old_target,
		OPT_always_pickup,
		OPT_always_repeat,
		OPT_depth_in_feet,
		OPT_stack_force_notes,
		OPT_stack_force_costs,
		OPT_show_labels,
		OPT_show_weights,
		OPT_show_choices,
		OPT_show_details,
		OPT_ring_bell,
		OPT_inventory_colors,
		OPT_race_chars,
		OPT_named_monsters,
		255,
		255
 	},

	/*** Disturbance ***/

	{
 		OPT_run_ignore_stairs,
		OPT_run_ignore_doors,
		OPT_run_cut_corners,
		OPT_run_use_corners,
		OPT_disturb_move,
		OPT_disturb_near,
		OPT_disturb_panel,
		OPT_disturb_state,
		OPT_disturb_minor,
		OPT_disturb_other,
		OPT_alert_hitpoint,
		OPT_alert_failure,
		OPT_show_pet_messages,
		OPT_confirm_blasphemy,
		OPT_flavored_attacks,
		OPT_confirm_prayers,
		255,
		255,
		255,
		255
	},

	/*** Game-Play ***/

	{
 		OPT_auto_haggle,
		OPT_auto_scum,
		OPT_testing_stack,
		OPT_testing_carry,
		OPT_expand_look,
		OPT_expand_list,
		OPT_view_perma_grids,
		OPT_view_torch_grids,
		OPT_dungeon_align,
		OPT_dungeon_stair,
		OPT_flow_by_sound,
		OPT_flow_by_smell,
		OPT_track_follow,
		OPT_track_target,
		OPT_smart_learn,
		OPT_smart_cheat,
		OPT_allow_open_levels,
		OPT_allow_theme_vaults,
		OPT_weirdness_is_rare,
		OPT_cripple_pets
	},

	/*** Efficiency ***/

	{
 		OPT_view_reduce_lite,
		OPT_view_reduce_view,
		OPT_avoid_abort,
		OPT_avoid_other,
		OPT_flush_failure,
		OPT_flush_disturb,
		OPT_flush_command,
		OPT_fresh_before,
		OPT_fresh_after,
		OPT_fresh_message,
		OPT_compress_savefile,
		OPT_hilite_player,
		OPT_view_yellow_lite,
		OPT_view_bright_lite,
		OPT_view_granite_lite,
		OPT_view_special_lite,
		255,
		255,
		255,
		255
	}
};

/* These are the recognized CLI commands, and their descriptions */

cli_comm cli_info[MAX_COMMANDS] = {
  {"wear", NULL,            "Wear or wield something", do_cmd_wield},
  {"take-off", NULL,        "Take something off", do_cmd_takeoff},
  {"drop", NULL,            "Drop something", do_cmd_drop},
  {"kill", "destroy",       "Destroy an item", do_cmd_destroy},
  {"equipment", NULL,       "Show what's equipped", do_cmd_equip},
  {"inventory", NULL,       "Show your inventory", do_cmd_inven},
  {"item-info", "identify", "Identify a special item", do_cmd_observe},
  {"alter", NULL,           "Alter terrain", do_cmd_alter},
  {"tunnel", "dig",         "Dig a tunnel", do_cmd_tunnel},
  {"walk", NULL,            "Take a walk", do_cmd_walk},
  {"jump", NULL,            "Jump", do_cmd_jump},
  {"run", NULL,             "Run", do_cmd_run},
  {"stand", "stay",         "Hold still", do_cmd_hold},
  {"get", NULL,             "Stay still, picking up items", do_cmd_stay},
  {"rest", "sleep",         "Restore hitpoints and mana", do_cmd_rest},
  {"search", NULL,          "Search for traps and doors", do_cmd_search},
  {"toggle-search", NULL,   "Toggle search mode", do_cmd_toggle_search},
  {"enter-store", NULL,     "Enter a store", do_cmd_store},
  {"enter-building", NULL,  "Enter a building", do_cmd_bldg},
  {"enter-quest", NULL,     "Enter a quest level", do_cmd_quest},
  {"up", "stair-up",        "Go upstairs", do_cmd_go_up},
  {"down", "stair-down",    "Go downstairs", do_cmd_go_down},
  {"open", NULL,            "Open a door or chest", do_cmd_open},
  {"close", NULL,           "Close a door", do_cmd_close},
  {"jam", "spike",          "Jam a door with spikes", do_cmd_spike},
  {"bash", NULL,            "Bash a door or an altar", do_cmd_bash},
  {"disarm", NULL,          "Disarm a trap", do_cmd_disarm},
  {"gain-spells", "learn",  "Learn a new spell", do_cmd_gain_helper},
  {"browse", "read-book",   "Read a book", do_cmd_browse},
  {"cast", "sumomon",       "Cast a spell or summon pets", do_cmd_cast_helper},
  {"inscribe", NULL,        "Inscribe an object", do_cmd_inscribe},
  {"uninscribe", NULL,      "Uninscribe an object", do_cmd_uninscribe},
  {"activate", NULL,        "Activate an item", do_cmd_activate},
  {"eat", NULL,             "Eat something", do_cmd_eat_food},
  {"refuel", "fuel",        "Refuel your light source", do_cmd_refill},
  {"fire", NULL,            "Fire something from a launcher", do_cmd_fire},
  {"throw", NULL,           "Throw something", do_cmd_throw},
  {"aim", "wand",           "Aim a wand", do_cmd_aim_wand},
  {"zap", "rod",            "Zap a rod", do_cmd_zap_rod},
  {"quaff", "drink",        "Drink a potion", do_cmd_quaff_potion},
  {"scroll", "read-scroll", "Read a scroll", do_cmd_read_scroll},
  {"use-staff", "staff",    "Use a staff", do_cmd_use_staff},
  {"map", NULL,             "Full dungeon map", do_cmd_view_map},
  {"look-around", NULL,     "Look around the dungeon", do_cmd_locate},
  {"look", NULL,            "Describe object around you", do_cmd_look},
  {"target", NULL,          "Target a monster", do_cmd_target},
  {"angband-help", NULL,    "Main angband help", do_cmd_help},
  {"help", "?",             "You're reading it now", do_cmd_command_help},
  {"symbol", NULL,          "Explain a symbol", do_cmd_query_symbol},
  {"char-describe", NULL,   "Describe your character", do_cmd_change_name},
  {"macros", NULL,          "Interact with macros", do_cmd_macros},
  {"visuals", NULL,         "Interact with visuals", do_cmd_visuals},
  {"colors", NULL,          "Interact with colors", do_cmd_colors},
  {"set-options", "options","Set options", do_cmd_options},
  {"take-notes", "notes",   "Take notes", do_cmd_note},
  {"version", NULL,         "Version info", do_cmd_version},
  {"feeling", NULL,         "Repeat level feeling", do_cmd_feeling},
  {"one-prev-message", NULL,"Show one previous message", do_cmd_message_one},
  {"all-prev-messages",NULL,"Show all previous messages", do_cmd_messages},
  {"redraw", NULL,          "Redraw the screen", do_cmd_redraw},
#ifndef VERIFY_SAVEFILE
  {"save-game", "save",     "Save and don't quit", do_cmd_save_game},
#endif
  {"save-quit", NULL,       "Save and quit", do_cmd_save_quit},
  {"suicide", NULL,         "Commit suicide", do_cmd_suicide},
  {"knowledge", NULL,       "Check knowledge", do_cmd_knowledge},
  {"load-dump", NULL,       "Load screen dump", do_cmd_load_screen},
  {"save-dump", NULL,       "Save a screen dump", do_cmd_save_screen},
  {"brew", "alchemy",       "Brew something using alchemy", do_cmd_brew_stuff},
  {"shout","call-pets",    "Toggle shouting (Calling pets)",call_pets_toggle},
  {"sacrifice", "god-info", "Sacrifice something", do_cmd_sacrifice},
  {"pray", NULL,            "Pray to your god", do_cmd_pray},
  {NULL, NULL, NULL}
};
