/* "@(#)patchlevel.h 1.10 93/04/19 */

#define SSPKG_PATCHLEVEL 4
#define SSPKG_VERSION 2.0

/*
 * Patch 1 fixes a bug with editable drawtext objects and adds a new
 * attribute.
 *
 * The bug: When an editable drawtext loses focus, it destroys the panel
 * and the panel text item that are used to edit the text.  Unfortunately,
 * this happens far too often in normal use.  Additionally, this is
 * annoying behavior for users too, because the editing window doesn't
 * stick around when you move the mouse out and in to the window.
 *
 * The additional attribute (DRAWTEXT_NOTIFY_PROC) has been added mostly
 * because it is very difficult to get notification of all the
 * circumstances where the drawtext string changes.  This also makes it
 * unnecessary to use trap the single click proc for editable drawtext
 * objects and use the drawtext_start_edit() and drawtext_finish_edit()
 * functions.
 *
 * This attribute is a function of the form:
 * 	void callback(drawtext)
 * 		Drawtext drawtext;
 * and it is called when the user presses return or when the caret is
 * removed from the edited object.  It takes one argument, drawtext, that 
 * is the object that has been changed by the edit.  Inside this callback,
 * you can find out what the new string is by using DRAWTEXT_STRING
 * on the drawtext.
 * 
 * An update to sspkg2.0/examples/drawtext/drawtext.c is part of patch 1.
 * The patched example program demonstrates the use of the new attribute.
 *
 * Source files affected by patch 1 are:
 * 	sspkg2.0/src/drawtext.c
 *	sspkg2.0/src/drawicon.c
 *	sspkg2.0/src/dtext_impl.h
 *	sspkg2.0/include/sspkg/drawobj.h
 *	sspkg2.0/include/sspkg/patchlevel.h
 *	sspkg2.0/examples/drawtext/drawtext.c
 *
 * ---------------------------------------------------------------------
 *
 * Patch 2, new features:
 *
 * GRIP_RUBBER_LINE.
 *
 * 	This is a new value for GRIP_RUBBER_STYLE.  This value makes the
 *	grip draw a line from the begining of the drag to the current 
 *	position.  The demo examples/grip/gripdemo demonstrates the
 *	use of the attribute.
 *
 * --
 * RECTOBJ_MENU_CLIENT.
 *
 *	You can use this attribute to get the rectobj that the mouse
 *	was positioned over when menu_show() was called. Usage:
 *	        rectobj = (Rectobj) xv_get(menu, RECTOBJ_MENU_CLIENT);
 *
 *	This is not necessarily the same as the rectobj that had the
 *	menu attached to it via RECTOBJ_MENU, because the menu
 *	may be attached to an ancestor of the rectobj.
 *	
 *	Because this attribute is set when xview's menu_show() function is
 *	called, this is not recommended for use if the menu is pinned.
 *
 * ---------------------------------------------------------------------
 * 
 * Patch2, bug fixes:
 * 
 * Fixed a potential memory leak with the allocation of a GC in
 * the drawtext.
 * --
 * Changed the order in which an object was marked as selected and 
 * the invocation of the selection callback.  This permits the application
 * to manipulate the selection status from its selection proc.
 * --
 * The grip was not reporting x and y positions in GRIP_DONE_PROC when
 * the GRIP_RUBBER_STYLE was GRIP_RUBBER_NONE.  Two assignment
 * statements were added to fix this up.
 * --
 * The CANVAS_SHELL_DROP_SITE was being improperly maintained due
 * to a typo.
 * --
 * The size of the paint windows wasn't being tracked correctly
 * when the paint window dimensions was not the same as the 
 * canvas dimensions.  This caused problem with events not getting
 * delivered, and regions not getting painted.
 * --
 * VFlush() was causing a core dump.  This only happened when
 * VSetColor() commands were previously used.
 * --
 * There was a core dump when destroying an object that had its
 * XV_OWNER or RECTOBJ_PARENT set to NULL.
 * --
 * Also, a warning:  some implementations of SunPro's math library
 * contain bogus implementations of sincos.  The symptoms can
 * be seen if the clockobj's hands don't look anything like the
 * picture in the documentation.  If you have this problem, 
 * define NO_SINCOS and recompile the library.
 * ---------------------------------------------------------------------
 *
 * Patch 3, new features:
 *
 * DRAWICON_LAYOUT_CENTER
 *
 *	Setting this attribute to TRUE causes the drawicon to attempt
 * 	to center itself when the image or text is resized.  This
 *	avoids confusing the user when the drawicon's text has changed
 *	size after editing.  This will not have a visible effect if the
 *	drawicon's parent is an array_tile, tree, etc. but it will if
 * 	it is a canvas_shell or bag.
 *	The default is FALSE, and the behavior is as before.
 *	examples/grip/temp_grip.c has been changed to demonstrate the
 *	feature.
 *
 * ---------------------------------------------------------------------
 * 
 * Patch3, bug fixes:
 * 
 * Icons drawn with DDrawImage() could be erroneously selected due to a
 * typo in Dmapimage().
 * --
 * The drawicon's geometry manager was not correctly calculating
 * geometries when only the size of the text changed.
 * --
 * Added ranlib to makefile install target.
 * ---------------------------------------------------------------------
 * Patch 4, new features:
 *
 * Three new demos have been added to the examples directories:
 *	examples/thermo	- a program that uses the drawarea to render
 *		a thermometer.  It is constructed so that you can
 *		rip out the thermometer portion and include it
 *		in another program easily.
 *
 *	examples/color/choose - a program that creates an array of
 *		colored drawrects, the user can select a color by
 *		clicking on the appropriate drawrect.  This code is
 *		written so it is easy to reuse in another program.
 *		
 *	examples/color/dndchoose - this is similar to the color chooser
 *		example, but also handles drag and drop of the colors.
 *
 * Patch 4, bug fixes:
 * 
 * Setting CANVAS_SHELL_BATCH_REPAINT to TRUE on creation did not
 * always immediately turn on repaint batching.
 * --
 * Children of a drawarea were not get repainted when their size or 
 * position changed.
 * --
 * Setting RECTOBJ_SELECTED to TRUE on an object that is marked as exclusive
 * select did not clear the other selections.
 * --
 * The drawicon was not centering either the text or the image when a
 * size change did not effect the size of the drawicon itself.
 */


