#ifndef _RULES_H
#define _RULES_H

#include "mytypes.h"
#include "list.h"
#include "hash.h"

enum {
  COPERNICUS, BANK, COLOSSUS, TEMPLE, COURTHOUSE, UNITEDNATIONS,
  SETIPROGRAM, AQUEDUCT, COLOSSEUM, MARKETPLACE, HYDROPLANT,
  HOOVERDAM, CUREFORCANCER, FACTORY, WOMENSSUFFRAGE, GREATLIBRARY,
  LIGHTHOUSE, PALACE, CITYWALLS, PYRAMIDS, GREATWALL, MASSTRANSIT,
  SHAKESPEARE, ORACLE, MAGELLEN, MANHATTAN, GRANARY, HANGINGGARDENS,
  DARWIN, RECYCLINGCTR, POWERPLANT, CATHEDRAL, MICHELANGELO,
  JSBACH, MFGPLANT, SDIDEFENSE, ISAACNEWTON, UNIVERSITY,
  LIBRARY
  };

class StrKey;

struct Science
{
  char *name;
  List<charp> need;
  List<charp> canBuild;
  // each player sets a bit in here if he's discovered it
  char *wonderObsolete; // which wonder we make obsolete
  ulong discovered;
};

struct BuildObject
{
  char *name;
  int type;
  uchar unit; // true if it is a unit
  uchar wonder; // true if wonder
  ushort prodCost;
  uchar maint;
  uchar built; // if its a wonder has it been built or not
  uchar isObsolete; // if its a wonder, is it obsolete
  List<charp> neededObj;
  char *obsolete; // thing which we make obsolete
};

extern HashTable<Science, StrKey> sciences;
extern HashTable<BuildObject, StrKey> buildObjects;

// call this after the world is set up
void InitializeRules();

void InitialScience(int player, List<charp> &discovered,
		    List<charp> &canDiscover, List<charp> &canBuild);

void Discover(int player, char *science, List<charp> &discovered,
	      List <charp> &canDiscover, List<charp> &canBuild);

int Discovered(int player, char *science);

int WonderObsolete(BuildObject *wonder, int player);

void SaveRules();
void RestoreRules();
	      
#endif
